#ifndef ITRCSTRT_H
#define ITRCSTRT_H


/* Basic header declaration */
struct InsEventHeader {
	unsigned long event;
	unsigned long vmID;
};

/* Event types */
struct InsEventTypeMethod {
	unsigned long methodEventFlags;
	unsigned long stackDepth;
	unsigned long receiver;
	char *methodName;
	unsigned long methodNameSize;
	char *className;
	unsigned long classNameSize;
};
struct InsEventTypeOIDRename {
	unsigned long source;
	unsigned long destination;
};
struct InsEventTypeOIDRangeRename {
	unsigned long sourceStart;
	unsigned long sourceEnd;
	unsigned long destination;
};
struct InsEventTypeOIDDelete {
	unsigned long oid;
};
struct InsEventTypeOIDRangeDelete {
	unsigned long start;
	unsigned long end;
};
struct InsEventTypeAllocObj { /* Private */
	unsigned long allocEventFlags;
	char *className;
	unsigned long classNameSize;
};
struct InsEventTypeAllocArrObj { /* Private */
	char *className;
	unsigned long classNameSize;
	unsigned long arity;
};
struct InsEventTypeAllocate {
	unsigned long oid;
	unsigned long sizeInLongs;
	unsigned long arrayFlag;
	union {
		struct InsEventTypeAllocObj object;
		struct InsEventTypeAllocArrObj array;
	} allocBody;
};
struct InsEventTypeStartFieldReport {
	unsigned long oid;
	unsigned long type;
	unsigned long reportEventFlags;
	char *className;
	unsigned long classNameSize;
};
struct InsEventTypeFieldReport {
	unsigned long oid;
};
struct InsEventTypeUserEvent {
	unsigned long msgEventFlags;
	char *msg;
	unsigned long msgSize;
};

struct InsEventInfo {
	struct InsEventHeader header;
	union {
		struct InsEventTypeMethod method;
		struct InsEventTypeOIDRename oidRename;
		struct InsEventTypeOIDRangeRename oidRangeRename;
		struct InsEventTypeOIDDelete oidDelete;
		struct InsEventTypeOIDRangeDelete oidRangeDelete;
		struct InsEventTypeAllocate allocate;
		struct InsEventTypeStartFieldReport startFieldReport;
		struct InsEventTypeFieldReport fieldReport;
		struct InsEventTypeUserEvent user;
	} body;
};


#endif /* ITRCSTRT_H */
