/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import sunw.demo.classfile.ClassFile;
import sunw.demo.classfile.ConstantPoolEntry;
import sunw.demo.classfile.UTF8Constant;

class ClassConstant
extends ConstantPoolEntry {
    private UTF8Constant name;

    ClassConstant(String string, ClassFile classFile) {
        super((byte)7, classFile);
        this.name = classFile.addUTF8Constant(ClassFile.fullyQualifiedForm(string));
        this.addToConstantPool();
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        if (ConstantPoolEntry.debug()) {
            System.err.println(String.valueOf(this.getConstantPoolIndex()) + " CLASS: " + this.name.getConstantPoolIndex());
        }
        dataOutputStream.writeByte(this.getTag());
        dataOutputStream.writeShort(this.name.getConstantPoolIndex());
    }

    String getClassName() {
        return this.name.getString();
    }

    Class getClassObject() throws ClassNotFoundException {
        return Class.forName(this.name.getString());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof ClassConstant) {
            ClassConstant classConstant = (ClassConstant)object;
            return this.name.equals(classConstant.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.getString().hashCode();
    }
}

