/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jos.lap;

import com.ibm.jos.lap.LAPManager;
import com.ibm.jos.lap.LAPPanel;
import com.ibm.jos.lap.LAPResources;
import com.ibm.jos.lap.LAPStatus;
import com.ibm.jos.lap.License;
import com.ibm.jos.lap.SupportedLanguages;
import com.ibm.jos.lap.TextPrinter;
import java.awt.Font;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LicenseAcceptanceProcess {
    private String laPath;
    private String mPath;
    private String statusPath;
    private URL laURLBase;
    private LAPManager lapMan;
    private LAPStatus lapStatus;
    private boolean noExportLA = false;
    private SupportedLanguages supportedLangs;
    private LAPResources lapResources;
    private License license;
    private boolean isApplet;
    private Locale currentLocale;
    private Locale preferredLocale;
    private Locale defaultLocale;
    private LAPPanel lapPanel;
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. YEAR     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public LicenseAcceptanceProcess(LAPManager lapMan, String laPath, String mPath, String statusPath) {
        this.lapMan = lapMan;
        this.laPath = laPath;
        this.mPath = mPath;
        this.statusPath = statusPath;
        this.isApplet = false;
        this.initialize();
    }

    public LicenseAcceptanceProcess(LAPManager lapMan, URL laURLBase) {
        this.lapMan = lapMan;
        this.isApplet = true;
        this.laURLBase = laURLBase;
        this.initialize();
    }

    private void accept() {
        String licensePath = this.getExportPathName();
        if (this.isApplet) {
            this.lapMan.statusChanged(9);
        } else {
            this.createExportDir();
            if (!this.noExportLA) {
                License.writeLicense(this.laPath, licensePath, "com.ibm.jos.lap.Encoding");
            }
            try {
                LAPStatus.putStatus(licensePath, 9);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.notifyLAPManager(15);
            }
            try {
                LAPStatus.putStatus(this.mPath, 9);
            }
            catch (IOException iOException) {}
            this.notifyLAPManager(9);
        }
    }

    void changePreferredLocale() {
        if (!this.license.isLicenseAvailable(this.preferredLocale)) {
            this.currentLocale = this.preferredLocale = this.defaultLocale;
        }
    }

    private void createExportDir() {
        File dir = new File(this.getExportPathName());
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    private void decline() {
        if (this.isApplet) {
            this.lapMan.statusChanged(3);
        } else {
            this.notifyLAPManager(3);
        }
    }

    public Locale getCurrentLocale() {
        return this.currentLocale;
    }

    public String getExportPathName() {
        return String.valueOf(this.statusPath) + File.separator + "license";
    }

    public LAPPanel getLAPPanel() {
        if (this.lapPanel == null) {
            this.lapPanel = new LAPPanel(this);
            if (this.isApplet) {
                this.lapPanel.setAsApplet();
            }
            if (!this.isFocusTraversable()) {
                this.lapPanel.setFocusTraversable(false);
            }
        }
        return this.lapPanel;
    }

    public LAPResources getLAPResources() {
        if (this.lapResources == null) {
            this.lapResources = this.laPath != null ? new LAPResources(this.laPath) : new LAPResources(this.laURLBase);
        }
        return this.lapResources;
    }

    public License getLicense() {
        return this.license;
    }

    public String[] getLicenseAgreement() {
        return this.getLicenseAgreement(this.currentLocale);
    }

    public String[] getLicenseAgreement(Locale targetLocale) {
        String[] licenseAgreement = null;
        try {
            licenseAgreement = this.license.getLicense(targetLocale);
        }
        catch (MalformedURLException malformedURLException) {
            this.notifyLAPManager(14);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.notifyLAPManager(11);
        }
        catch (IOException iOException) {
            this.notifyLAPManager(11);
        }
        if (licenseAgreement == null) {
            this.notifyLAPManager(11);
        }
        return licenseAgreement;
    }

    public Locale getNextLocale() {
        if (this.currentLocale.equals(this.defaultLocale)) {
            return this.preferredLocale;
        }
        return this.defaultLocale;
    }

    public static Locale getOSLocale() {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            osName = "";
        } else {
            osName = osName.replace(' ', '_').toLowerCase();
            osName = osName.replace('/', '_');
        }
        return new Locale(osName, "");
    }

    public int getStatus() {
        String licensePath = this.getExportPathName();
        int masterStatus = 1;
        if (this.mPath != null) {
            try {
                masterStatus = LAPStatus.getStatus(this.mPath);
            }
            catch (IOException iOException) {}
            if (masterStatus == 9) {
                this.createExportDir();
                if (!this.noExportLA) {
                    License.writeLicense(this.laPath, licensePath, "com.ibm.jos.lap.Encoding");
                }
                try {
                    LAPStatus.copyStatus(this.mPath, licensePath);
                    return 9;
                }
                catch (IOException iOException) {
                    System.out.println("Warning. One or more of the license agreement files may not be properly created.");
                    return 9;
                }
            }
        }
        int localStatus = 1;
        try {
            localStatus = LAPStatus.getStatus(licensePath);
        }
        catch (IOException iOException) {}
        if (localStatus == 9) {
            return 9;
        }
        return Math.max(masterStatus, localStatus);
    }

    public SupportedLanguages getSupportedLanguages() {
        if (this.supportedLangs == null) {
            try {
                new SupportedLanguages();
            }
            catch (Exception exception) {
                System.out.println("Warning: language resource is missing. Using default.");
            }
        }
        return this.supportedLangs;
    }

    private void initApp() {
        this.license = new License(this.laPath);
        this.setResources(new LAPResources(this.laPath));
    }

    private void initApplet() {
        this.license = new License(this.laURLBase);
        this.setResources(new LAPResources(this.laURLBase));
    }

    private void initialize() {
        if (this.isApplet) {
            this.initApplet();
        } else {
            this.initApp();
        }
        try {
            this.supportedLangs = new SupportedLanguages();
        }
        catch (Exception exception) {}
        this.preferredLocale = this.supportedLangs.getSupportedLocale(Locale.getDefault());
        this.defaultLocale = SupportedLanguages.DEFAULT_LANGUAGE;
        this.currentLocale = this.preferredLocale;
        this.changePreferredLocale();
        this.lapResources.setLocale(this.currentLocale);
    }

    public boolean isFocusTraversable() {
        Locale osLoc = new Locale("", "");
        String value = null;
        ResourceBundle bundle = null;
        osLoc = LicenseAcceptanceProcess.getOSLocale();
        try {
            bundle = ResourceBundle.getBundle("com.ibm.jos.lap.OSInfo", osLoc);
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
            System.out.println("Error: Missing encoding bundle. Aborted.");
            System.exit(0);
        }
        value = bundle.getString("focus_traversable_key");
        return !value.equals("false");
    }

    public boolean isMultiLanguage() {
        return !this.preferredLocale.equals(this.defaultLocale);
    }

    public Locale nextLocale() {
        this.currentLocale = this.currentLocale.equals(this.defaultLocale) ? this.preferredLocale : this.defaultLocale;
        return this.currentLocale;
    }

    private void notifyLAPManager(int code) {
        this.lapMan.statusChanged(code);
    }

    public void printLicense(Font font) {
        TextPrinter lapv = new TextPrinter(this.getLicenseAgreement());
        lapv.setMargin(1.0, 1.0, 1.0, 1.0);
        lapv.setFont(font);
        lapv.print();
    }

    public void setLicense(License license) {
        this.license = license;
        this.changePreferredLocale();
    }

    public void setNoExportLA() {
        this.noExportLA = true;
    }

    public void setResources(LAPResources lapResources) {
        this.lapResources = lapResources;
    }

    public void setStatus(int status) {
        switch (status) {
            case 9: {
                this.accept();
                break;
            }
            case 3: {
                this.decline();
                break;
            }
            default: {
                this.notifyLAPManager(status);
            }
        }
    }

    public void setSupportedLanguages(SupportedLanguages supportedLanguages) {
        this.supportedLangs = supportedLanguages;
    }
}

