/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jos.lap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class LAPStatus {
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. YEAR     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    private LAPStatus() {
    }

    public static void copyStatus(String current, String destination) throws FileNotFoundException, IOException {
        int howmany;
        FileReader in = new FileReader(String.valueOf(current) + File.separator + "status.dat");
        FileWriter out = new FileWriter(String.valueOf(destination) + File.separator + "status.dat");
        char[] buf = new char[512];
        while ((howmany = in.read(buf)) >= 0) {
            out.write(buf, 0, howmany);
        }
        out.close();
        in.close();
    }

    public static boolean deleteStatus(String current) throws SecurityException {
        File statusFile = new File(String.valueOf(current) + File.separator + "status.dat");
        return statusFile.delete();
    }

    public static int getStatus(String filePath) throws IOException {
        String value = LAPStatus.getValue(filePath, "Status");
        if (value != null) {
            try {
                int result = Integer.parseInt(value);
                return result;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        LAPStatus.deleteStatus(filePath);
        return 1;
    }

    private static String getValue(String filePath, String property) throws IOException {
        String status_val = null;
        Properties prop_list = new Properties();
        FileInputStream in = new FileInputStream(String.valueOf(filePath) + File.separator + "status.dat");
        prop_list.load(in);
        status_val = prop_list.getProperty(property);
        in.close();
        return status_val;
    }

    public static void putStatus(String filePath, int status) throws IOException {
        switch (status) {
            case 9: {
                LAPStatus.writeAccept(filePath);
                break;
            }
            case 3: {
                LAPStatus.writeDecline(filePath);
                break;
            }
            case 5: {
                LAPStatus.writeBypass(filePath);
                break;
            }
        }
    }

    private static void putValue(String filePath, String property, String value) throws IOException {
        Properties prop_list = new Properties();
        try {
            FileInputStream in = new FileInputStream(String.valueOf(filePath) + File.separator + "status.dat");
            prop_list.load(in);
            in.close();
        }
        catch (FileNotFoundException fileNotFoundException) {}
        ((Hashtable)prop_list).put(property, value);
        FileOutputStream out = new FileOutputStream(String.valueOf(filePath) + File.separator + "status.dat");
        prop_list.save(out, null);
        out.close();
    }

    private static void writeAccept(String filePath) throws IOException {
        LAPStatus.putValue(filePath, "Status", Integer.toString(9));
    }

    private static void writeBypass(String filePath) throws IOException {
        LAPStatus.putValue(filePath, "Status", Integer.toString(5));
    }

    private static void writeDecline(String filePath) throws IOException {
        LAPStatus.putValue(filePath, "Status", Integer.toString(3));
    }
}

