/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jos.lap;

import com.ibm.jos.lap.SupportedLanguages;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public class LAPResources {
    private String laPath;
    private URL laURL;
    private Locale locale;
    private ResourceBundle resBundle;
    public static final int TITLE = 0;
    public static final int HEADING = 1;
    public static final int FOOTING = 2;
    public static final int LICENSE = 3;
    public static final int LANGUAGE = 12;
    public static final int ACCEPT = 13;
    public static final int DECLINE = 14;
    public static final int PRINT = 15;
    public static final int YES = 16;
    public static final int NO = 17;
    public static final int ACCEPTED_URL = 20;
    public static final int DECLINED_URL = 21;
    public static final int CONFIRM_MESSAGE = 31;
    static final String TITLE_KEY = "title";
    static final String HEADING_KEY = "heading";
    static final String FOOTING_KEY = "footing";
    static final String ACCEPT_KEY = "accept";
    static final String DECLINE_KEY = "decline";
    static final String PRINT_KEY = "print";
    static final String YES_KEY = "yes";
    static final String NO_KEY = "no";
    static final String ACCEPTED_URL_KEY = "url.accepted";
    static final String DECLINED_URL_KEY = "url.declined";
    static final String FONT_SIZE_KEY = "fontSize";
    static final String CONFIRM_MESSAGE_KEY = "declinedMessage";
    static final String CONFIRM_MSG_A_KEY = "declinedMsgA";
    static final String CONFIRM_MSG_B_KEY = "declinedMsgB";
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. YEAR     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public LAPResources(String basePath) {
        this.laPath = basePath;
        this.init();
    }

    public LAPResources(URL baseURL) {
        this.laURL = baseURL;
        this.init();
    }

    public int getFontSize() {
        return Integer.parseInt(this.getText(FONT_SIZE_KEY));
    }

    public Image getImage(String imageFileName) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = null;
        try {
            if (this.laPath != null) {
                String imageFile = String.valueOf(this.laPath) + File.separator + imageFileName;
                image = toolkit.getImage(imageFile);
            } else if (this.laURL != null) {
                URL imageURL = new URL(this.laURL, imageFileName);
                image = toolkit.getImage(imageURL);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    public Image getImage(String imageFileName, ImageObserver imageObserver) {
        Image image = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            if (this.laPath != null) {
                String imageFile = String.valueOf(this.laPath) + File.separator + imageFileName;
                image = toolkit.getImage(imageFile);
                toolkit.prepareImage(image, -1, -1, imageObserver);
            } else if (this.laURL != null) {
                URL imageURL = new URL(this.laURL, imageFileName);
                image = toolkit.getImage(imageURL);
                toolkit.prepareImage(image, -1, -1, imageObserver);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String[] getMessage(int MsgId) {
        switch (MsgId) {
            case 31: {
                return this.getTexts(CONFIRM_MESSAGE_KEY);
            }
        }
        return null;
    }

    public String getText(int textId) {
        switch (textId) {
            case 0: {
                return this.getText(TITLE_KEY);
            }
            case 1: {
                return this.getText(HEADING_KEY);
            }
            case 2: {
                return this.getText(FOOTING_KEY);
            }
            case 13: {
                return this.getText(ACCEPT_KEY);
            }
            case 14: {
                return this.getText(DECLINE_KEY);
            }
            case 15: {
                return this.getText(PRINT_KEY);
            }
            case 16: {
                return this.getText(YES_KEY);
            }
            case 17: {
                return this.getText(NO_KEY);
            }
        }
        return null;
    }

    private String getText(String textName) {
        if (this.resBundle == null) {
            this.resBundle = ResourceBundle.getBundle("com.ibm.jos.lap.Resource", this.locale);
        }
        return this.resBundle.getString(textName);
    }

    private String[] getTexts(String textName) {
        if (textName.equals(CONFIRM_MESSAGE_KEY)) {
            String[] declinedMsg = new String[]{this.getText(CONFIRM_MSG_A_KEY), "", this.getText(CONFIRM_MSG_B_KEY)};
            return declinedMsg;
        }
        return null;
    }

    public URL getURL(int name) {
        URL url = null;
        switch (name) {
            case 20: {
                url = this.getURL(ACCEPTED_URL_KEY);
                break;
            }
            case 21: {
                url = this.getURL(DECLINED_URL_KEY);
                break;
            }
            default: {
                url = null;
            }
        }
        return url;
    }

    private URL getURL(String urlName) {
        Properties lapProp = null;
        try {
            if (lapProp == null) {
                if (this.laURL == null) {
                    return null;
                }
                URL urls = new URL(this.laURL, "url.properties");
                lapProp = new Properties();
                lapProp.load(urls.openStream());
            }
            return new URL(this.laURL, lapProp.getProperty(urlName));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void init() {
        this.locale = SupportedLanguages.DEFAULT_LANGUAGE;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.resBundle = null;
    }
}

