/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jos.lap;

import com.ibm.jos.lap.LAPManager;
import com.ibm.jos.lap.LAPPanel;
import com.ibm.jos.lap.LAPResources;
import com.ibm.jos.lap.License;
import com.ibm.jos.lap.LicenseAcceptanceProcess;
import com.ibm.jos.lap.SupportedLanguages;
import java.awt.Font;
import java.awt.Image;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LAPFacade {
    private String laPath;
    private String mPath;
    private String statusPath;
    private URL laURLBase;
    private boolean isApplet;
    private boolean noExportLA = false;
    private boolean noPrintLA = false;
    private LAPManager lapMan;
    private SupportedLanguages supportedLangs;
    private LAPPanel lapPanel;
    private LAPResources lapResources;
    private License license;
    private String[] licenseAgreement;
    private LicenseAcceptanceProcess licenseAcceptanceProcess;
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. YEAR     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public LAPFacade(LAPManager lapMan, String laPath, String mPath, String statusPath) {
        this.lapMan = lapMan;
        this.laPath = laPath;
        this.mPath = mPath;
        this.statusPath = statusPath;
        this.isApplet = false;
    }

    public LAPFacade(LAPManager lapMan, URL laURLBase) {
        this.lapMan = lapMan;
        this.laURLBase = laURLBase;
        this.isApplet = true;
    }

    public URL getAcceptedURL() {
        return this.getLAPResources().getURL(20);
    }

    public URL getDeclinedURL() {
        return this.getLAPResources().getURL(21);
    }

    public Image getImage(String imageFileName) {
        return this.getLAPResources().getImage(imageFileName);
    }

    public LAPPanel getLAPPanel() {
        LAPPanel lapPanel = this.getLicenseAcceptanceProcess().getLAPPanel();
        lapPanel.setFocusTraversable(this.isFocusTraversable());
        lapPanel.setTextAreaReusable(this.isTextAreaReusable());
        return lapPanel;
    }

    private LAPResources getLAPResources() {
        return this.getLicenseAcceptanceProcess().getLAPResources();
    }

    public String getLAPTitle() {
        return this.getLAPResources().getText(0);
    }

    private License getLicense() {
        return this.getLicenseAcceptanceProcess().getLicense();
    }

    public LicenseAcceptanceProcess getLicenseAcceptanceProcess() {
        if (this.licenseAcceptanceProcess == null) {
            this.licenseAcceptanceProcess = this.isApplet ? new LicenseAcceptanceProcess(this.lapMan, this.laURLBase) : new LicenseAcceptanceProcess(this.lapMan, this.laPath, this.mPath, this.statusPath);
            if (this.noExportLA) {
                this.licenseAcceptanceProcess.setNoExportLA();
            }
        }
        return this.licenseAcceptanceProcess;
    }

    public String[] getLicenseAgreement(Locale targetLocale) {
        return this.getLicenseAcceptanceProcess().getLicenseAgreement(targetLocale);
    }

    public String getNextLanguage() {
        return this.getLicenseAcceptanceProcess().getNextLocale().getDisplayLanguage(SupportedLanguages.DEFAULT_LANGUAGE);
    }

    public int getStatus() {
        return this.getLicenseAcceptanceProcess().getStatus();
    }

    private SupportedLanguages getSupportedLanguages() {
        return this.getLicenseAcceptanceProcess().getSupportedLanguages();
    }

    public String getText(int textId) {
        return this.getLAPResources().getText(textId);
    }

    public boolean isFocusTraversable() {
        Locale osLoc = new Locale("", "");
        String value = null;
        ResourceBundle bundle = null;
        this.getLicenseAcceptanceProcess();
        osLoc = LicenseAcceptanceProcess.getOSLocale();
        try {
            bundle = ResourceBundle.getBundle("com.ibm.jos.lap.OSInfo", osLoc);
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
            System.out.println("Error: Missing encoding bundle. Aborted.");
            System.exit(0);
        }
        value = bundle.getString("focus_traversable_key");
        return value.equals("true");
    }

    public boolean isMultiLanguage() {
        return this.getLicenseAcceptanceProcess().isMultiLanguage();
    }

    public boolean isTextAreaReusable() {
        Locale osLoc = new Locale("", "");
        String value = null;
        ResourceBundle bundle = null;
        osLoc = LicenseAcceptanceProcess.getOSLocale();
        try {
            bundle = ResourceBundle.getBundle("com.ibm.jos.lap.OSInfo", osLoc);
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
            System.out.println("Error: Missing encoding bundle. Aborted.");
            System.exit(0);
        }
        value = bundle.getString("make_new_textarea_object");
        return !value.equals("false");
    }

    public boolean licenseIsValid() {
        return this.getLicense().licenseExists(this.getSupportedLanguages().getSupportedLocales());
    }

    public void printLicense(Font font) {
        this.getLicenseAcceptanceProcess().printLicense(font);
    }

    public void setExportLA(boolean state) {
        this.noExportLA = !state;
    }

    public void setStatus(int status) {
        this.getLicenseAcceptanceProcess().setStatus(status);
    }
}

