/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.sort;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import sunw.demo.sort.SortAlgorithm;

public class SortItem
extends Applet
implements Runnable,
MouseListener {
    private transient Thread kicker;
    transient int[] arr;
    transient int h1 = -1;
    transient int h2 = -1;
    String algName = "BubbleSort";
    transient SortAlgorithm algorithm;
    private transient int width;
    private transient int height;

    public SortItem() {
        this.resize(100, 100);
        this.addMouseListener(this);
    }

    void scramble() {
        this.width = this.getSize().width;
        this.height = 2 * (this.getSize().height / 2);
        int[] nArray = new int[this.height / 2];
        double d = (double)this.width / (double)nArray.length;
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = (int)((double)n * d);
        }
        int n2 = nArray.length;
        while (--n2 >= 0) {
            int n3 = (int)((double)n2 * Math.random());
            int n4 = nArray[n2];
            nArray[n2] = nArray[n3];
            nArray[n3] = n4;
        }
        this.arr = nArray;
    }

    void pause() {
        this.pause(-1, -1);
    }

    void pause(int n) {
        this.pause(n, -1);
    }

    void pause(int n, int n2) {
        this.h1 = n;
        this.h2 = n2;
        if (this.kicker != null) {
            this.repaint();
        }
        try {
            Thread.sleep(20L);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void init() {
        this.algName = this.getParameter("alg");
        if (this.algName == null) {
            this.algName = "BubbleSort";
        }
    }

    public void start() {
        this.scramble();
    }

    public void paint(Graphics graphics) {
        int[] nArray = this.arr;
        int n = this.height - 1;
        if (nArray == null) {
            return;
        }
        graphics.setColor(this.getBackground());
        int n2 = nArray.length;
        while (--n2 >= 0) {
            graphics.drawLine(this.arr[n2], n, this.width, n);
            n -= 2;
        }
        graphics.setColor(Color.black);
        n = this.height - 1;
        int n3 = nArray.length;
        while (--n3 >= 0) {
            graphics.drawLine(0, n, this.arr[n3], n);
            n -= 2;
        }
        if (this.h1 >= 0) {
            graphics.setColor(Color.red);
            n = this.h1 * 2 + 1;
            graphics.drawLine(0, n, this.width, n);
        }
        if (this.h2 >= 0) {
            graphics.setColor(Color.blue);
            n = this.h2 * 2 + 1;
            graphics.drawLine(0, n, this.width, n);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void run() {
        try {
            if (this.algorithm == null) {
                String string = "sunw.demo.sort." + this.algName + "Algorithm";
                this.algorithm = (SortAlgorithm)Class.forName(string).newInstance();
                this.algorithm.setParent(this);
            }
            this.algorithm.init();
            this.algorithm.sort(this.arr);
            return;
        }
        catch (Exception exception) {
            System.err.println("SortItem.run " + exception);
            exception.printStackTrace(System.err);
            return;
        }
    }

    public synchronized void stop() {
        if (this.kicker != null) {
            try {
                this.kicker.stop();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
            this.kicker = null;
        }
        if (this.algorithm != null) {
            try {
                this.algorithm.stop();
                return;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return;
            }
        }
    }

    private synchronized void startSort() {
        if (this.kicker == null || !this.kicker.isAlive()) {
            this.scramble();
            this.repaint();
            this.kicker = new Thread(this);
            this.kicker.start();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            this.startSort();
            return;
        }
        catch (Throwable throwable) {
            System.err.println("SortItem.mouseClicked " + throwable);
            throwable.printStackTrace();
            return;
        }
    }

    public synchronized void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public String getAlgorithm() {
        return this.algName;
    }

    public void setAlgorithm(String string) {
        this.algName = string;
        this.algorithm = null;
    }
}

