/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.db.uibeans;

import com.ibm.db.DataEvent;
import com.ibm.db.DataException;
import com.ibm.db.DataRuntimeException;
import com.ibm.db.DatabaseConnection;
import com.ibm.db.DatabaseConnectionAfterListener;
import com.ibm.db.DatabaseConnectionBeforeListener;
import com.ibm.db.StatementAfterListener;
import com.ibm.db.StatementBeforeListener;
import com.ibm.db.StatementMetaData;
import com.ibm.ivj.db.uibeans.DataAfterEventMulticaster;
import com.ibm.ivj.db.uibeans.DataAfterListener;
import com.ibm.ivj.db.uibeans.DataBeforeEventMulticaster;
import com.ibm.ivj.db.uibeans.DataBeforeListener;
import com.ibm.ivj.db.uibeans.IBMIVJDBMessages;
import com.ibm.ivj.db.uibeans.Utilities;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public abstract class Statement
implements Serializable,
DatabaseConnectionAfterListener,
DatabaseConnectionBeforeListener,
StatementAfterListener,
StatementBeforeListener,
PropertyChangeListener {
    DatabaseConnection fieldDatabaseConnection = null;
    protected transient DataAfterListener aDataAfterListener = null;
    protected transient DataBeforeListener aDataBeforeListener = null;
    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    static final long serialVersionUID = -3287923394434029799L;
    private static final String copyright = "Licensed Material - Property of IBM\nIBM(R) VisualAge(TM) for Java(TM) Version 3.0\n(C) Copyright IBM Corp. 1998, 1999 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public Statement() {
        try {
            this.setDatabaseConnection(new DatabaseConnection());
        }
        catch (Throwable throwable) {
            String string = Utilities.logMessage(IBMIVJDBMessages.noConnection);
            throw new DataRuntimeException(string);
        }
    }

    public void aboutToClose(DataEvent dataEvent) {
        this.fireAboutToClose(new DataEvent(this));
    }

    public void aboutToCommit(DataEvent dataEvent) {
        this.fireAboutToCommit(new DataEvent(this));
    }

    public void aboutToConnect(DataEvent dataEvent) {
        this.fireAboutToConnect(new DataEvent(this));
    }

    public void aboutToDisconnect(DataEvent dataEvent) {
        this.fireAboutToDisconnect(new DataEvent(this));
    }

    public void aboutToExecute(DataEvent dataEvent) {
        this.fireAboutToExecute(new DataEvent(this));
    }

    public void aboutToRollback(DataEvent dataEvent) {
        this.fireAboutToRollback(new DataEvent(this));
    }

    public void addDataAfterListener(DataAfterListener dataAfterListener) {
        this.aDataAfterListener = DataAfterEventMulticaster.add(this.aDataAfterListener, dataAfterListener);
    }

    public void addDataBeforeListener(DataBeforeListener dataBeforeListener) {
        this.aDataBeforeListener = DataBeforeEventMulticaster.add(this.aDataBeforeListener, dataBeforeListener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChange.addPropertyChangeListener(propertyChangeListener);
    }

    public void cacheResultsChanged(DataEvent dataEvent) {
    }

    public abstract void cancelAction() throws DataException;

    public void closed(DataEvent dataEvent) {
        this.fireClosed(new DataEvent(this));
    }

    public void committed(DataEvent dataEvent) {
        this.fireCommitted(new DataEvent(this));
    }

    public void connected(DataEvent dataEvent) {
        this.fireConnected(new DataEvent(this));
    }

    public void disconnected(DataEvent dataEvent) {
        this.fireDisconnected(new DataEvent(this));
    }

    public abstract void execute() throws DataException;

    public void executed(DataEvent dataEvent) {
        this.fireExecuted(new DataEvent(this));
    }

    protected void fireAboutToClose(DataEvent dataEvent) {
        if (this.aDataBeforeListener == null) {
            return;
        }
        this.aDataBeforeListener.aboutToClose(dataEvent);
    }

    protected void fireAboutToCommit(DataEvent dataEvent) {
        if (this.aDataBeforeListener == null) {
            return;
        }
        this.aDataBeforeListener.aboutToCommit(dataEvent);
    }

    protected void fireAboutToConnect(DataEvent dataEvent) {
        if (this.aDataBeforeListener == null) {
            return;
        }
        this.aDataBeforeListener.aboutToConnect(dataEvent);
    }

    protected void fireAboutToDisconnect(DataEvent dataEvent) {
        if (this.aDataBeforeListener == null) {
            return;
        }
        this.aDataBeforeListener.aboutToDisconnect(dataEvent);
    }

    protected void fireAboutToExecute(DataEvent dataEvent) {
        if (this.aDataBeforeListener == null) {
            return;
        }
        this.aDataBeforeListener.aboutToExecute(dataEvent);
    }

    protected void fireAboutToRollback(DataEvent dataEvent) {
        if (this.aDataBeforeListener == null) {
            return;
        }
        this.aDataBeforeListener.aboutToRollback(dataEvent);
    }

    protected void fireClosed(DataEvent dataEvent) {
        if (this.aDataAfterListener == null) {
            return;
        }
        this.aDataAfterListener.closed(dataEvent);
    }

    protected void fireCommitted(DataEvent dataEvent) {
        if (this.aDataAfterListener == null) {
            return;
        }
        this.aDataAfterListener.committed(dataEvent);
    }

    protected void fireConnected(DataEvent dataEvent) {
        if (this.aDataAfterListener == null) {
            return;
        }
        this.aDataAfterListener.connected(dataEvent);
    }

    protected void fireDisconnected(DataEvent dataEvent) {
        if (this.aDataAfterListener == null) {
            return;
        }
        this.aDataAfterListener.disconnected(dataEvent);
    }

    protected void fireExecuted(DataEvent dataEvent) {
        if (this.aDataAfterListener != null) {
            this.aDataAfterListener.executed(dataEvent);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChange.firePropertyChange(string, object, object2);
    }

    protected void fireRolledBack(DataEvent dataEvent) {
        if (this.aDataAfterListener == null) {
            return;
        }
        this.aDataAfterListener.rolledBack(dataEvent);
    }

    public DatabaseConnection getDatabaseConnection() {
        if (this.fieldDatabaseConnection == null) {
            try {
                this.fieldDatabaseConnection = new DatabaseConnection();
            }
            catch (Throwable throwable) {
                String string = Utilities.logMessage(IBMIVJDBMessages.noConnection);
                throw new DataRuntimeException(string);
            }
        }
        return this.fieldDatabaseConnection;
    }

    public abstract Object getParameter(int var1) throws DataException;

    public abstract Object getParameter(String var1) throws DataException;

    public abstract String getParameterToString(int var1) throws DataException;

    public abstract String getParameterToString(String var1) throws DataException;

    public abstract StatementMetaData getStatementMetaData();

    public abstract int getTimeout();

    public boolean isConnected() throws DataException {
        if (this.fieldDatabaseConnection != null) {
            return this.fieldDatabaseConnection.isConnected();
        }
        return false;
    }

    public void removeDataAfterListener(DataAfterListener dataAfterListener) {
        this.aDataAfterListener = DataAfterEventMulticaster.remove(this.aDataAfterListener, dataAfterListener);
    }

    public void removeDataBeforeListener(DataBeforeListener dataBeforeListener) {
        this.aDataBeforeListener = DataBeforeEventMulticaster.remove(this.aDataBeforeListener, dataBeforeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChange.removePropertyChangeListener(propertyChangeListener);
    }

    public void rolledBack(DataEvent dataEvent) {
        this.fireRolledBack(new DataEvent(this));
    }

    public void setDatabaseConnection(DatabaseConnection databaseConnection) {
        if (this.fieldDatabaseConnection != null) {
            this.fieldDatabaseConnection.removeDatabaseConnectionAfterListener(this);
            this.fieldDatabaseConnection.removeDatabaseConnectionBeforeListener(this);
        }
        this.fieldDatabaseConnection = databaseConnection;
        if (this.fieldDatabaseConnection != null) {
            this.fieldDatabaseConnection.addDatabaseConnectionAfterListener(this);
            this.fieldDatabaseConnection.addDatabaseConnectionBeforeListener(this);
        }
    }

    public abstract void setParameter(int var1, Object var2) throws DataException;

    public abstract void setParameter(String var1, Object var2) throws DataException;

    public abstract void setParameterFromString(int var1, String var2) throws DataException;

    public abstract void setParameterFromString(String var1, String var2) throws DataException;

    public abstract void setStatementMetaData(StatementMetaData var1);

    public abstract void setTimeout(int var1);

    public abstract void propertyChange(PropertyChangeEvent var1);
}

