/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db.selector;

import com.ibm.db.selector.IBMSelectorMessages;
import com.ibm.db.selector.SelectionInfo;
import com.ibm.db.selector.Selector;
import com.ibm.db.selector.SelectorException;
import com.ibm.db.selector.Utilities;
import com.sun.java.swing.ComboBoxModel;
import com.sun.java.swing.event.ListDataEvent;
import com.sun.java.swing.event.ListDataListener;
import com.sun.java.swing.event.TableModelEvent;
import com.sun.java.swing.table.TableModel;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Vector;

public class RowSelector
extends Selector
implements ComboBoxModel {
    static final String PROPERTY_START_COLUMN_NUMBER = "startColumnNumber";
    static final String PROPERTY_MAXIMUM_COLUMNS = "maximumColumns";
    static final String PROPERTY_ROW_NUMBER = "rowNumber";
    private int fStartColumnNumber = 0;
    private int fMaximumColumns = Integer.MIN_VALUE;
    private int fRowNumber = 0;
    private transient Vector fListDataListeners;
    private Object fSelectedItem = null;
    static final long serialVersionUID = -2006562354261502555L;

    public RowSelector() {
    }

    public RowSelector(TableModel tableModel) {
        super(tableModel);
    }

    public void addListDataListener(ListDataListener listDataListener) {
        if (!this.fListDataListeners.contains(listDataListener)) {
            this.fListDataListeners.addElement(listDataListener);
        }
    }

    boolean checkReady() {
        boolean bl = true;
        if (!this.fCheckReadyDone && (bl = super.checkReady())) {
            TableModel tableModel = this.getModel();
            int n = this.getActualStartColumnNumber();
            if (n < 0 || n >= tableModel.getColumnCount()) {
                Integer n2 = new Integer(this.getStartColumnNumber());
                this.setStartColumnNumber(n < 0 ? 0 : tableModel.getColumnCount() - 1, true);
                throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_SColNumber, new Object[]{n2}), 204);
            }
            if (this.fMaximumColumns != Integer.MIN_VALUE && this.fMaximumColumns < 0) {
                Integer n3 = new Integer(this.fMaximumColumns);
                this.fMaximumColumns = Integer.MIN_VALUE;
                throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_MaxCols___, new Object[]{n3}), 205);
            }
            int n4 = this.getActualRowNumber();
            if (n4 < 0 || n4 >= tableModel.getRowCount()) {
                Integer n5 = new Integer(this.getRowNumber());
                this.setRowNumber(n4 < 0 ? 0 : tableModel.getRowCount() - 1, true);
                throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_RowNumber_, new Object[]{n5}), 206);
            }
            this.fCheckReadyDone = true;
        }
        return bl;
    }

    private static String copyright() {
        return "\n\n(c) Copyright IBM Corporation 1999 (1998).\n\n";
    }

    private void fireListDataEvent(ListDataEvent listDataEvent) {
        Enumeration enumeration = ((Vector)this.fListDataListeners.clone()).elements();
        int n = listDataEvent.getType();
        while (enumeration.hasMoreElements()) {
            if (n == 0) {
                ((ListDataListener)enumeration.nextElement()).contentsChanged(listDataEvent);
                continue;
            }
            if (n == 1) {
                ((ListDataListener)enumeration.nextElement()).intervalAdded(listDataEvent);
                continue;
            }
            if (n != 2) continue;
            ((ListDataListener)enumeration.nextElement()).intervalRemoved(listDataEvent);
        }
    }

    private int getActualEndColumnNumber(int n) {
        int n2 = this.getColumns() - 1;
        int n3 = n == Integer.MIN_VALUE ? n2 : Math.min(n2, n + this.fStartColumnNumber - 1);
        return n3;
    }

    int getActualRowNumber() {
        return this.fRowNumber;
    }

    int getActualStartColumnNumber() {
        return this.fStartColumnNumber;
    }

    public BigDecimal[] getBigDecimal() {
        return Selector.getBigDecimal(this);
    }

    public BigInteger[] getBigInteger() {
        return Selector.getBigInteger(this);
    }

    public boolean[] getBoolean() {
        return Selector.getBoolean(this);
    }

    public byte[] getByte() {
        return Selector.getByte(this);
    }

    public byte[][] getByteArray() {
        return Selector.getByteArray(this);
    }

    public String[] getColumnNames() {
        return this.getSelectionInfo().fColumnNames;
    }

    public Date[] getDate() {
        return Selector.getDate(this);
    }

    public double[] getDouble() {
        return Selector.getDouble(this);
    }

    public Object getElementAt(int n) {
        this.checkReady();
        return this.getModel().getValueAt(this.fRowNumber, this.fStartColumnNumber + n);
    }

    public float[] getFloat() {
        return Selector.getFloat(this);
    }

    public int[] getInt() {
        return Selector.getInt(this);
    }

    public long[] getLong() {
        return Selector.getLong(this);
    }

    public int getMaximumColumns() {
        return this.fMaximumColumns;
    }

    public Object[] getObject() {
        return Selector.getObject(this);
    }

    public int getRowNumber() {
        return this.getIndexFromOne() ? this.fRowNumber + 1 : this.fRowNumber;
    }

    public Object getSelectedItem() {
        Object[] objectArray;
        if (this.fSelectedItem == null && this.getModel() != null && this.checkReady() && (objectArray = this.getObject()).length > 0) {
            this.fSelectedItem = objectArray[0];
        }
        return this.fSelectedItem;
    }

    SelectionInfo getSelectionInfo() {
        this.checkReady();
        SelectionInfo selectionInfo = null;
        TableModel tableModel = this.getModel();
        int n = this.getActualEndColumnNumber(this.fMaximumColumns);
        if (this.fStartColumnNumber >= 0 && this.fStartColumnNumber <= n && this.fRowNumber >= 0 && this.fRowNumber < this.getRows()) {
            selectionInfo = new SelectionInfo();
            selectionInfo.fTableModel = tableModel;
            selectionInfo.fColumns = n - this.fStartColumnNumber + 1;
            selectionInfo.fRowNumber = this.fRowNumber;
            selectionInfo.fStartColumnNumber = this.fStartColumnNumber;
            selectionInfo.fEndColumnNumber = n;
            selectionInfo.fVectorContentType = this.getVectorContentType();
            selectionInfo.fColumnNames = new String[selectionInfo.fColumns];
            int n2 = 0;
            int n3 = this.fStartColumnNumber;
            while (n3 <= n) {
                selectionInfo.fColumnNames[n2++] = tableModel.getColumnName(n3);
                ++n3;
            }
        }
        return selectionInfo;
    }

    public short[] getShort() {
        return Selector.getShort(this);
    }

    public int getSize() {
        int n = 0;
        if (this.getModel() != null && this.checkReady()) {
            n = this.getActualEndColumnNumber(this.fMaximumColumns) - this.fStartColumnNumber + 1;
        }
        return n;
    }

    public int getStartColumnNumber() {
        return this.getIndexFromOne() ? this.fStartColumnNumber + 1 : this.fStartColumnNumber;
    }

    public String[] getString() {
        return Selector.getString(this);
    }

    com.sun.java.swing.event.TableModelListener getTableModelListener() {
        return new TableModelListener(this);
    }

    public Time[] getTime() {
        return Selector.getTime(this);
    }

    public Timestamp[] getTimestamp() {
        return Selector.getTimestamp(this);
    }

    public Vector getVector() {
        return Selector.getVector(this);
    }

    void initialise() {
        super.initialise();
        this.fListDataListeners = new Vector(1, 1);
    }

    public boolean isCellEditable(int n) {
        boolean bl = false;
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            bl = tableModel.isCellEditable(this.fRowNumber, this.fStartColumnNumber + n);
        }
        return bl;
    }

    void notifyBigDecimal() {
        this.getPropertyChangeSupport().firePropertyChange("bigDecimal", null, this.getBigDecimal());
    }

    void notifyBigInteger() {
        this.getPropertyChangeSupport().firePropertyChange("bigInteger", null, this.getBigInteger());
    }

    void notifyBoolean() {
        this.getPropertyChangeSupport().firePropertyChange("boolean", null, this.getBoolean());
    }

    void notifyByte() {
        this.getPropertyChangeSupport().firePropertyChange("byte", null, this.getByte());
    }

    void notifyByteArray() {
        this.getPropertyChangeSupport().firePropertyChange("byteArray", null, this.getByteArray());
    }

    void notifyDate() {
        this.getPropertyChangeSupport().firePropertyChange("date", null, this.getDate());
    }

    void notifyDouble() {
        this.getPropertyChangeSupport().firePropertyChange("double", null, this.getDouble());
    }

    void notifyFloat() {
        this.getPropertyChangeSupport().firePropertyChange("float", null, this.getFloat());
    }

    void notifyInt() {
        this.getPropertyChangeSupport().firePropertyChange("int", null, this.getInt());
    }

    void notifyLong() {
        this.getPropertyChangeSupport().firePropertyChange("long", null, this.getLong());
    }

    void notifyObject() {
        this.getPropertyChangeSupport().firePropertyChange("object", null, this.getObject());
    }

    void notifyShort() {
        this.getPropertyChangeSupport().firePropertyChange("short", null, this.getShort());
    }

    void notifyString() {
        this.getPropertyChangeSupport().firePropertyChange("string", null, this.getString());
    }

    void notifyTime() {
        this.getPropertyChangeSupport().firePropertyChange("time", null, this.getTime());
    }

    void notifyTimestamp() {
        this.getPropertyChangeSupport().firePropertyChange("timestamp", null, this.getTimestamp());
    }

    void notifyVector() {
        this.getPropertyChangeSupport().firePropertyChange("vector", null, this.getVector());
    }

    void notifyVectorArray() {
    }

    void notifyVectorOfVectors() {
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.fListDataListeners.removeElement(listDataListener);
    }

    public void setBigDecimal(BigDecimal[] bigDecimalArray) {
        this.setValues(bigDecimalArray);
    }

    public void setBigInteger(BigInteger[] bigIntegerArray) {
        this.setValues(bigIntegerArray);
    }

    public void setBoolean(boolean[] blArray) {
        if (blArray != null) {
            int n = Math.min(blArray.length, this.getSize());
            int n2 = 0;
            while (n2 < n) {
                this.setValue(new Boolean(blArray[n2]), n2);
                ++n2;
            }
        }
    }

    public void setByte(byte[] byArray) {
        if (byArray != null) {
            int n = Math.min(byArray.length, this.getSize());
            int n2 = 0;
            while (n2 < n) {
                this.setValue(new Byte(byArray[n2]), n2);
                ++n2;
            }
        }
    }

    public void setByteArray(byte[][] byArray) {
        this.setValues((Object[])byArray);
    }

    public void setDate(Date[] dateArray) {
        this.setValues(dateArray);
    }

    public void setDouble(double[] dArray) {
        if (dArray != null) {
            int n = Math.min(dArray.length, this.getSize());
            int n2 = 0;
            while (n2 < n) {
                this.setValue(new Double(dArray[n2]), n2);
                ++n2;
            }
        }
    }

    public void setFloat(float[] fArray) {
        if (fArray != null) {
            int n = Math.min(fArray.length, this.getSize());
            int n2 = 0;
            while (n2 < n) {
                this.setValue(new Float(fArray[n2]), n2);
                ++n2;
            }
        }
    }

    public void setInt(int[] nArray) {
        if (nArray != null) {
            int n = Math.min(nArray.length, this.getSize());
            int n2 = 0;
            while (n2 < n) {
                this.setValue(new Integer(nArray[n2]), n2);
                ++n2;
            }
        }
    }

    public void setLong(long[] lArray) {
        if (lArray != null) {
            int n = Math.min(lArray.length, this.getSize());
            int n2 = 0;
            while (n2 < n) {
                this.setValue(new Long(lArray[n2]), n2);
                ++n2;
            }
        }
    }

    public void setMaximumColumns(int n) {
        this.setMaximumColumns(n, true);
    }

    private void setMaximumColumns(int n, boolean bl) {
        if (this.fMaximumColumns != n) {
            int n2;
            int n3;
            this.fCheckReadyDone = false;
            int n4 = this.fMaximumColumns;
            this.fMaximumColumns = n;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_MAXIMUM_COLUMNS, new Integer(n4), new Integer(this.fMaximumColumns));
            if (bl && (n3 = this.getActualEndColumnNumber(this.fMaximumColumns) - this.fStartColumnNumber) != (n2 = this.getActualEndColumnNumber(n4) - this.fStartColumnNumber)) {
                this.notifyData();
                if (n3 > n2) {
                    this.fireListDataEvent(new ListDataEvent((Object)this, 1, n2 + 1, n3));
                } else {
                    this.fireListDataEvent(new ListDataEvent((Object)this, 2, n3 + 1, n2));
                }
            }
        }
    }

    public void setObject(Object[] objectArray) {
        this.setValues(objectArray);
    }

    public void setRowNumber(int n) {
        if (this.getIndexFromOne()) {
            --n;
        }
        this.setRowNumber(n, true);
    }

    private void setRowNumber(int n, boolean bl) {
        if (this.fRowNumber != n) {
            this.fCheckReadyDone = false;
            int n2 = this.fRowNumber;
            this.fRowNumber = n;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ROW_NUMBER, new Integer(n2), new Integer(this.fRowNumber));
            if (bl) {
                this.notifyData();
                this.fireListDataEvent(new ListDataEvent((Object)this, 0, 0, this.getSize() - 1));
            }
        }
    }

    public void setSelectedItem(Object object) {
        this.fSelectedItem = object;
        this.fireListDataEvent(new ListDataEvent((Object)this, 0, -1, -1));
    }

    public void setShort(short[] sArray) {
        if (sArray != null) {
            int n = Math.min(sArray.length, this.getSize());
            int n2 = 0;
            while (n2 < n) {
                this.setValue(new Short(sArray[n2]), n2);
                ++n2;
            }
        }
    }

    public void setStartColumnNumber(int n) {
        if (this.getIndexFromOne()) {
            --n;
        }
        this.setStartColumnNumber(n, true);
    }

    private void setStartColumnNumber(int n, boolean bl) {
        if (this.fStartColumnNumber != n) {
            this.fCheckReadyDone = false;
            int n2 = this.fStartColumnNumber;
            this.fStartColumnNumber = n;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_START_COLUMN_NUMBER, new Integer(n2), new Integer(this.fStartColumnNumber));
            if (bl) {
                this.notifyData();
                int n3 = this.fStartColumnNumber - n2;
                if (n3 < 0) {
                    this.fireListDataEvent(new ListDataEvent((Object)this, 2, 0, -n3));
                } else {
                    this.fireListDataEvent(new ListDataEvent((Object)this, 1, 0, n3));
                }
            }
        }
    }

    public void setString(String[] stringArray) {
        this.setValues(stringArray);
    }

    public void setTime(Time[] timeArray) {
        this.setValues(timeArray);
    }

    public void setTimestamp(Timestamp[] timestampArray) {
        this.setValues(timestampArray);
    }

    private void setValue(Object object, int n) {
        this.checkReady();
        TableModel tableModel = this.getModel();
        int n2 = this.fStartColumnNumber + n;
        tableModel.setValueAt(Selector.coerce(object, tableModel.getColumnClass(n2), true), this.fRowNumber, n2);
    }

    private void setValues(Object[] objectArray) {
        if (objectArray != null) {
            int n = Math.min(objectArray.length, this.getSize());
            int n2 = 0;
            while (n2 < n) {
                this.setValue(objectArray[n2], n2);
                ++n2;
            }
        }
    }

    private void setValues(Vector vector) {
        if (vector != null) {
            int n = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.setValue(enumeration.nextElement(), n++);
            }
        }
    }

    public void setVector(Vector vector) {
        this.setValues(vector);
    }

    static void access$fireListDataEvent(RowSelector rowSelector, ListDataEvent listDataEvent) {
        rowSelector.fireListDataEvent(listDataEvent);
    }

    static int access$getActualEndColumnNumber(RowSelector rowSelector, int n) {
        return rowSelector.getActualEndColumnNumber(n);
    }

    static void access$setRowNumber(RowSelector rowSelector, int n, boolean bl) {
        rowSelector.setRowNumber(n, bl);
    }

    private class TableModelListener
    implements com.sun.java.swing.event.TableModelListener {
        /* synthetic */ RowSelector this$0;

        public void tableChanged(TableModelEvent tableModelEvent) {
            int n = this.this$0.getActualStartColumnNumber();
            int n2 = this.this$0.getMaximumColumns();
            int n3 = RowSelector.access$getActualEndColumnNumber(this.this$0, n2);
            int n4 = this.this$0.getActualRowNumber();
            TableModel tableModel = (TableModel)tableModelEvent.getSource();
            int n5 = tableModel.getRowCount();
            tableModel.getColumnCount();
            if (tableModelEvent.getFirstRow() == -1) {
                this.this$0.fCheckReadyDone = false;
                this.this$0.checkNotifyData(true);
                RowSelector.access$fireListDataEvent(this.this$0, new ListDataEvent((Object)this.this$0, 0, 0, n3 - n));
            } else {
                int n6 = tableModelEvent.getColumn();
                int n7 = tableModelEvent.getFirstRow();
                int n8 = tableModelEvent.getLastRow();
                int n9 = n8 - n7 + 1;
                switch (tableModelEvent.getType()) {
                    case 1: {
                        if (n7 > n4) break;
                        RowSelector.access$setRowNumber(this.this$0, n4 + n9, false);
                        break;
                    }
                    case -1: {
                        if (n8 < n4) {
                            RowSelector.access$setRowNumber(this.this$0, n4 - n9, false);
                            break;
                        }
                        if (n7 > n4 || n8 < n4) break;
                        RowSelector.access$setRowNumber(this.this$0, Math.min(n4, n5 - 1), false);
                        this.this$0.checkNotifyData(true);
                        RowSelector.access$fireListDataEvent(this.this$0, new ListDataEvent((Object)this.this$0, 0, 0, n3 - n));
                        break;
                    }
                    case 0: {
                        if (n7 > n4 || n8 < n4 || (n6 < n || n6 > n3) && n6 != -1) break;
                        this.this$0.checkNotifyData(true);
                        if (n6 == -1) {
                            RowSelector.access$fireListDataEvent(this.this$0, new ListDataEvent((Object)this.this$0, 0, 0, n3 - n));
                            break;
                        }
                        RowSelector.access$fireListDataEvent(this.this$0, new ListDataEvent((Object)this.this$0, 0, n6 - n, n6 - n));
                        break;
                    }
                }
            }
        }

        /* synthetic */ TableModelListener(RowSelector rowSelector) {
            this.this$0 = rowSelector;
        }
    }
}

