/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db.selector;

import com.ibm.db.selector.IBMSelectorMessages;
import com.ibm.db.selector.SelectionInfo;
import com.ibm.db.selector.Selector;
import com.ibm.db.selector.SelectorException;
import com.ibm.db.selector.SingleColumnSelector;
import com.ibm.db.selector.Utilities;
import com.sun.java.swing.ComboBoxModel;
import com.sun.java.swing.event.ListDataEvent;
import com.sun.java.swing.event.ListDataListener;
import com.sun.java.swing.event.TableModelEvent;
import com.sun.java.swing.table.TableModel;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Vector;

public class ColumnSelector
extends SingleColumnSelector
implements ComboBoxModel {
    static final String PROPERTY_START_ROW_NUMBER = "startRowNumber";
    static final String PROPERTY_MAXIMUM_ROWS = "maximumRows";
    static final String PROPERTY_INCLUDE_COLUMN_NAME = "includeColumnName";
    private int fStartRowNumber = 0;
    private int fMaximumRows = Integer.MIN_VALUE;
    private boolean fIncludeColumnName = false;
    private transient Vector fListDataListeners;
    private Object fSelectedItem = null;
    static final long serialVersionUID = -5504492589065504106L;

    public ColumnSelector() {
    }

    public ColumnSelector(TableModel tableModel) {
        super(tableModel);
    }

    public void addListDataListener(ListDataListener listDataListener) {
        if (!this.fListDataListeners.contains(listDataListener)) {
            this.fListDataListeners.addElement(listDataListener);
        }
    }

    boolean checkReady() {
        boolean bl = true;
        if (!this.fCheckReadyDone && (bl = super.checkReady())) {
            TableModel tableModel = this.getModel();
            int n = this.getActualStartRowNumber();
            if (n < 0 || n >= tableModel.getRowCount()) {
                Integer n2 = new Integer(this.getStartRowNumber());
                this.setStartRowNumber(n < 0 ? 0 : tableModel.getRowCount() - 1, true);
                throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_SRowNumber, new Object[]{n2}), 207);
            }
            if (this.fMaximumRows != Integer.MIN_VALUE && this.fMaximumRows < 0) {
                Integer n3 = new Integer(this.fMaximumRows);
                this.fMaximumRows = Integer.MIN_VALUE;
                throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_MaxRows___, new Object[]{n3}), 208);
            }
            this.fCheckReadyDone = true;
        }
        return bl;
    }

    private static String copyright() {
        return "\n\n(c) Copyright IBM Corporation 1999 (1998).\n\n";
    }

    void fireListDataEvent(ListDataEvent listDataEvent) {
        Enumeration enumeration = ((Vector)this.fListDataListeners.clone()).elements();
        int n = listDataEvent.getType();
        while (enumeration.hasMoreElements()) {
            if (n == 0) {
                ((ListDataListener)enumeration.nextElement()).contentsChanged(listDataEvent);
                continue;
            }
            if (n == 1) {
                ((ListDataListener)enumeration.nextElement()).intervalAdded(listDataEvent);
                continue;
            }
            if (n != 2) continue;
            ((ListDataListener)enumeration.nextElement()).intervalRemoved(listDataEvent);
        }
    }

    private int getActualEndRowNumber(int n) {
        int n2 = this.getRows() - 1;
        int n3 = n == Integer.MIN_VALUE ? n2 : Math.min(n2, n + this.fStartRowNumber - 1);
        return n3;
    }

    int getActualStartRowNumber() {
        return this.fStartRowNumber;
    }

    public BigDecimal[] getBigDecimal() {
        return Selector.getBigDecimal(this);
    }

    public BigInteger[] getBigInteger() {
        return Selector.getBigInteger(this);
    }

    public boolean[] getBoolean() {
        return Selector.getBoolean(this);
    }

    public byte[] getByte() {
        return Selector.getByte(this);
    }

    public byte[][] getByteArray() {
        return Selector.getByteArray(this);
    }

    public Date[] getDate() {
        return Selector.getDate(this);
    }

    public double[] getDouble() {
        return Selector.getDouble(this);
    }

    public Object getElementAt(int n) {
        this.checkReady();
        return this.getModel().getValueAt(this.fStartRowNumber + n, this.getActualColumnNumber());
    }

    public float[] getFloat() {
        return Selector.getFloat(this);
    }

    public boolean getIncludeColumnName() {
        return this.fIncludeColumnName;
    }

    public int[] getInt() {
        return Selector.getInt(this);
    }

    public long[] getLong() {
        return Selector.getLong(this);
    }

    public int getMaximumRows() {
        return this.fMaximumRows;
    }

    public Object[] getObject() {
        return Selector.getObject(this);
    }

    public Object getSelectedItem() {
        Object[] objectArray;
        if (this.fSelectedItem == null && this.getModel() != null && this.checkReady() && (objectArray = this.getObject()).length > 0) {
            this.fSelectedItem = objectArray[0];
        }
        return this.fSelectedItem;
    }

    SelectionInfo getSelectionInfo() {
        this.checkReady();
        SelectionInfo selectionInfo = null;
        TableModel tableModel = this.getModel();
        int n = this.getActualEndRowNumber(this.fMaximumRows);
        int n2 = this.getActualColumnNumber();
        if (this.fStartRowNumber >= 0 && this.fStartRowNumber <= n && n2 >= 0 && n2 < this.getColumns()) {
            selectionInfo = new SelectionInfo();
            selectionInfo.fTableModel = tableModel;
            selectionInfo.fRows = n - this.fStartRowNumber + 1;
            selectionInfo.fColumnNumber = n2;
            selectionInfo.fStartRowNumber = this.fStartRowNumber;
            selectionInfo.fEndRowNumber = n;
            selectionInfo.fVectorContentType = this.getVectorContentType();
            selectionInfo.fIncludeColumnName = this.fIncludeColumnName;
            selectionInfo.fColumnName = tableModel.getColumnName(n2);
        }
        return selectionInfo;
    }

    public short[] getShort() {
        return Selector.getShort(this);
    }

    public int getSize() {
        int n = 0;
        if (this.getModel() != null && this.checkReady()) {
            n = this.getActualEndRowNumber(this.fMaximumRows) - this.fStartRowNumber + 1;
        }
        return n;
    }

    public int getStartRowNumber() {
        return this.getIndexFromOne() ? this.fStartRowNumber + 1 : this.fStartRowNumber;
    }

    public String[] getString() {
        return Selector.getString(this);
    }

    com.sun.java.swing.event.TableModelListener getTableModelListener() {
        return new TableModelListener(this);
    }

    public Time[] getTime() {
        return Selector.getTime(this);
    }

    public Timestamp[] getTimestamp() {
        return Selector.getTimestamp(this);
    }

    public Vector getVector() {
        return Selector.getVector(this);
    }

    void initialise() {
        super.initialise();
        this.fListDataListeners = new Vector(1, 1);
    }

    public boolean isCellEditable(int n) {
        this.checkReady();
        return this.getModel().isCellEditable(this.fStartRowNumber + n, this.getActualColumnNumber());
    }

    void notifyBigDecimal() {
        this.getPropertyChangeSupport().firePropertyChange("bigDecimal", null, this.getBigDecimal());
    }

    void notifyBigInteger() {
        this.getPropertyChangeSupport().firePropertyChange("bigInteger", null, this.getBigInteger());
    }

    void notifyBoolean() {
        this.getPropertyChangeSupport().firePropertyChange("boolean", null, this.getBoolean());
    }

    void notifyByte() {
        this.getPropertyChangeSupport().firePropertyChange("byte", null, this.getByte());
    }

    void notifyByteArray() {
        this.getPropertyChangeSupport().firePropertyChange("byteArray", null, this.getByteArray());
    }

    void notifyDate() {
        this.getPropertyChangeSupport().firePropertyChange("date", null, this.getDate());
    }

    void notifyDouble() {
        this.getPropertyChangeSupport().firePropertyChange("double", null, this.getDouble());
    }

    void notifyFloat() {
        this.getPropertyChangeSupport().firePropertyChange("float", null, this.getFloat());
    }

    void notifyInt() {
        this.getPropertyChangeSupport().firePropertyChange("int", null, this.getInt());
    }

    void notifyLong() {
        this.getPropertyChangeSupport().firePropertyChange("long", null, this.getLong());
    }

    void notifyObject() {
        this.getPropertyChangeSupport().firePropertyChange("object", null, this.getObject());
    }

    void notifyShort() {
        this.getPropertyChangeSupport().firePropertyChange("short", null, this.getShort());
    }

    void notifyString() {
        this.getPropertyChangeSupport().firePropertyChange("string", null, this.getString());
    }

    void notifyTime() {
        this.getPropertyChangeSupport().firePropertyChange("time", null, this.getTime());
    }

    void notifyTimestamp() {
        this.getPropertyChangeSupport().firePropertyChange("timestamp", null, this.getTimestamp());
    }

    void notifyVector() {
        this.getPropertyChangeSupport().firePropertyChange("vector", null, this.getVector());
    }

    void notifyVectorArray() {
    }

    void notifyVectorOfVectors() {
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.fListDataListeners.removeElement(listDataListener);
    }

    public void setBigDecimal(BigDecimal[] bigDecimalArray) {
        this.setValues(bigDecimalArray);
    }

    public void setBigInteger(BigInteger[] bigIntegerArray) {
        this.setValues(bigIntegerArray);
    }

    public void setBoolean(boolean[] blArray) {
        if (blArray != null) {
            int n = Math.min(blArray.length, this.getSize());
            int n2 = 0;
            while (n2 < n) {
                this.setValue(new Boolean(blArray[n2]), n2);
                ++n2;
            }
        }
    }

    public void setByte(byte[] byArray) {
        if (byArray != null) {
            int n = Math.min(byArray.length, this.getSize());
            int n2 = 0;
            while (n2 < n) {
                this.setValue(new Byte(byArray[n2]), n2);
                ++n2;
            }
        }
    }

    public void setByteArray(byte[][] byArray) {
        this.setValues((Object[])byArray);
    }

    public void setDate(Date[] dateArray) {
        this.setValues(dateArray);
    }

    public void setDouble(double[] dArray) {
        if (dArray != null) {
            int n = Math.min(dArray.length, this.getSize());
            int n2 = 0;
            while (n2 < n) {
                this.setValue(new Double(dArray[n2]), n2);
                ++n2;
            }
        }
    }

    public void setFloat(float[] fArray) {
        if (fArray != null) {
            int n = Math.min(fArray.length, this.getSize());
            int n2 = 0;
            while (n2 < n) {
                this.setValue(new Float(fArray[n2]), n2);
                ++n2;
            }
        }
    }

    public void setIncludeColumnName(boolean bl) {
        if (this.fIncludeColumnName != bl) {
            boolean bl2 = this.fIncludeColumnName;
            this.fIncludeColumnName = bl;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_INCLUDE_COLUMN_NAME, new Boolean(bl2), new Boolean(this.fIncludeColumnName));
            this.notifyData();
        }
    }

    public void setInt(int[] nArray) {
        if (nArray != null) {
            int n = Math.min(nArray.length, this.getSize());
            int n2 = 0;
            while (n2 < n) {
                this.setValue(new Integer(nArray[n2]), n2);
                ++n2;
            }
        }
    }

    public void setLong(long[] lArray) {
        if (lArray != null) {
            int n = Math.min(lArray.length, this.getSize());
            int n2 = 0;
            while (n2 < n) {
                this.setValue(new Long(lArray[n2]), n2);
                ++n2;
            }
        }
    }

    public void setMaximumRows(int n) {
        this.setMaximumRows(n, true);
    }

    private void setMaximumRows(int n, boolean bl) {
        if (this.fMaximumRows != n) {
            int n2;
            int n3;
            this.fCheckReadyDone = false;
            int n4 = this.fMaximumRows;
            this.fMaximumRows = n;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_MAXIMUM_ROWS, new Integer(n4), new Integer(this.fMaximumRows));
            if (bl && (n3 = this.getActualEndRowNumber(this.fMaximumRows) - this.fStartRowNumber) != (n2 = this.getActualEndRowNumber(n4) - this.fStartRowNumber)) {
                this.notifyData();
                if (n3 > n2) {
                    this.fireListDataEvent(new ListDataEvent((Object)this, 1, n2 + 1, n3));
                } else {
                    this.fireListDataEvent(new ListDataEvent((Object)this, 2, n3 + 1, n2));
                }
            }
        }
    }

    public void setObject(Object[] objectArray) {
        this.setValues(objectArray);
    }

    public void setSelectedItem(Object object) {
        this.fSelectedItem = object;
        this.fireListDataEvent(new ListDataEvent((Object)this, 0, -1, -1));
    }

    public void setShort(short[] sArray) {
        if (sArray != null) {
            int n = Math.min(sArray.length, this.getSize());
            int n2 = 0;
            while (n2 < n) {
                this.setValue(new Short(sArray[n2]), n2);
                ++n2;
            }
        }
    }

    public void setStartRowNumber(int n) {
        if (this.getIndexFromOne()) {
            --n;
        }
        this.setStartRowNumber(n, true);
    }

    private void setStartRowNumber(int n, boolean bl) {
        if (this.fStartRowNumber != n) {
            this.fCheckReadyDone = false;
            int n2 = this.fStartRowNumber;
            this.fStartRowNumber = n;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_START_ROW_NUMBER, new Integer(n2), new Integer(this.fStartRowNumber));
            if (bl) {
                this.notifyData();
                int n3 = this.fStartRowNumber - n2;
                if (n3 < 0) {
                    this.fireListDataEvent(new ListDataEvent((Object)this, 2, 0, -n3));
                } else {
                    this.fireListDataEvent(new ListDataEvent((Object)this, 1, 0, n3));
                }
            }
        }
    }

    public void setString(String[] stringArray) {
        this.setValues(stringArray);
    }

    public void setTime(Time[] timeArray) {
        this.setValues(timeArray);
    }

    public void setTimestamp(Timestamp[] timestampArray) {
        this.setValues(timestampArray);
    }

    private void setValue(Object object, int n) {
        this.checkReady();
        TableModel tableModel = this.getModel();
        int n2 = this.getActualColumnNumber();
        tableModel.setValueAt(Selector.coerce(object, tableModel.getColumnClass(n2), true), this.fStartRowNumber + n, n2);
    }

    private void setValues(Object[] objectArray) {
        if (objectArray != null) {
            int n = Math.min(objectArray.length, this.getSize());
            int n2 = 0;
            while (n2 < n) {
                this.setValue(objectArray[n2], n2);
                ++n2;
            }
        }
    }

    private void setValues(Vector vector) {
        if (vector != null) {
            int n = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.setValue(enumeration.nextElement(), n++);
            }
        }
    }

    public void setVector(Vector vector) {
        this.setValues(vector);
    }

    static void access$setStartRowNumber(ColumnSelector columnSelector, int n, boolean bl) {
        columnSelector.setStartRowNumber(n, bl);
    }

    static int access$getActualEndRowNumber(ColumnSelector columnSelector, int n) {
        return columnSelector.getActualEndRowNumber(n);
    }

    private class TableModelListener
    implements com.sun.java.swing.event.TableModelListener {
        /* synthetic */ ColumnSelector this$0;

        public void tableChanged(TableModelEvent tableModelEvent) {
            int n = this.this$0.getActualStartRowNumber();
            int n2 = this.this$0.getMaximumRows();
            int n3 = ColumnSelector.access$getActualEndRowNumber(this.this$0, n2);
            this.this$0.getActualColumnNumber();
            TableModel tableModel = (TableModel)tableModelEvent.getSource();
            tableModel.getRowCount();
            tableModel.getColumnCount();
            if (tableModelEvent.getFirstRow() == -1) {
                this.this$0.fCheckReadyDone = false;
                this.this$0.fColumnNumberResolved = false;
                this.this$0.checkNotifyData(true);
                this.this$0.fireListDataEvent(new ListDataEvent((Object)this.this$0, 0, 0, n3 - n));
            } else {
                int n4 = tableModelEvent.getColumn();
                int n5 = tableModelEvent.getFirstRow();
                int n6 = tableModelEvent.getLastRow();
                int n7 = n6 - n5 + 1;
                switch (tableModelEvent.getType()) {
                    case 1: {
                        if (n5 <= n) {
                            ColumnSelector.access$setStartRowNumber(this.this$0, n + n7, false);
                        }
                        if (n5 < n || n5 > n3) break;
                        this.this$0.checkNotifyData(true);
                        this.this$0.fireListDataEvent(new ListDataEvent((Object)this.this$0, 1, n5 - n, n6 - n));
                        break;
                    }
                    case -1: {
                        if (n6 < n) {
                            ColumnSelector.access$setStartRowNumber(this.this$0, n - n7, false);
                            break;
                        }
                        if (n5 <= n && n6 < n3) {
                            int n8 = n - n5;
                            if (n8 > 0) {
                                ColumnSelector.access$setStartRowNumber(this.this$0, n - n8, false);
                            }
                            this.this$0.checkNotifyData(true);
                            this.this$0.fireListDataEvent(new ListDataEvent((Object)this.this$0, 2, 0, n6 - n));
                            break;
                        }
                        if (n5 >= n && n6 <= n3) {
                            this.this$0.checkNotifyData(true);
                            this.this$0.fireListDataEvent(new ListDataEvent((Object)this.this$0, 2, n5 - n, n6 - n));
                            break;
                        }
                        if (n5 < n && n6 > n3) {
                            ColumnSelector.access$setStartRowNumber(this.this$0, n5, false);
                            this.this$0.checkNotifyData(true);
                            this.this$0.fireListDataEvent(new ListDataEvent((Object)this.this$0, 2, 0, n3 - n));
                            break;
                        }
                        if (n5 <= n || n6 <= n3) break;
                        this.this$0.checkNotifyData(true);
                        this.this$0.fireListDataEvent(new ListDataEvent((Object)this.this$0, 2, n5 - n, n3 - n));
                        break;
                    }
                    case 0: {
                        if (n5 > n3 || n6 < n || n4 != this.this$0.getActualColumnNumber() && n4 != -1) break;
                        this.this$0.checkNotifyData(true);
                        int n9 = n5 - Math.min(n5, n);
                        int n10 = n2 == Integer.MIN_VALUE ? n6 - n : Math.min(n6, n3) - n;
                        this.this$0.fireListDataEvent(new ListDataEvent((Object)this.this$0, 2, n9, n10));
                        break;
                    }
                }
            }
        }

        /* synthetic */ TableModelListener(ColumnSelector columnSelector) {
            this.this$0 = columnSelector;
        }
    }
}

