/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db.selector;

import com.ibm.db.selector.IBMSelectorMessages;
import com.ibm.db.selector.Selector;
import com.ibm.db.selector.SelectorException;
import com.ibm.db.selector.SingleColumnSelector;
import com.ibm.db.selector.Utilities;
import com.sun.java.swing.event.TableModelEvent;
import com.sun.java.swing.table.TableModel;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class CellSelector
extends SingleColumnSelector {
    static final String PROPERTY_ROW_NUMBER = "rowNumber";
    private int fRowNumber = 0;
    static final long serialVersionUID = 4905465859104006728L;

    public CellSelector() {
    }

    public CellSelector(TableModel tableModel) {
        super(tableModel);
    }

    boolean checkReady() {
        boolean bl = true;
        if (!this.fCheckReadyDone && (bl = super.checkReady())) {
            TableModel tableModel = this.getModel();
            int n = this.getActualRowNumber();
            if (n < 0 || n >= tableModel.getRowCount()) {
                Integer n2 = new Integer(this.getRowNumber());
                this.setRowNumber(n < 0 ? 0 : tableModel.getRowCount() - 1, true);
                throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_RowNumber_, new Object[]{n2}), 206);
            }
            this.fCheckReadyDone = true;
        }
        return bl;
    }

    private static String copyright() {
        return "\n\n(c) Copyright IBM Corporation 1999 (1998).\n\n";
    }

    public Serializable deserialize() {
        Serializable serializable = null;
        Object object = this.getValue();
        if (object instanceof byte[]) {
            serializable = Selector.deserializeFromByteArray((byte[])object);
        }
        return serializable;
    }

    int getActualRowNumber() {
        return this.fRowNumber;
    }

    public BigDecimal getBigDecimal() {
        return Selector.getBigDecimal(this.getValue());
    }

    public BigInteger getBigInteger() {
        return Selector.getBigInteger(this.getValue());
    }

    public boolean getBoolean() {
        return Selector.getBoolean(this.getValue());
    }

    public byte getByte() {
        return Selector.getByte(this.getValue());
    }

    public byte[] getByteArray() {
        return Selector.getByteArray(this.getValue());
    }

    public Date getDate() {
        return Selector.getDate(this.getValue());
    }

    public double getDouble() {
        return Selector.getDouble(this.getValue());
    }

    public float getFloat() {
        return Selector.getFloat(this.getValue());
    }

    public int getInt() {
        return Selector.getInt(this.getValue());
    }

    public long getLong() {
        return Selector.getLong(this.getValue());
    }

    public Object getObject() {
        return this.getValue();
    }

    public int getRowNumber() {
        return this.getIndexFromOne() ? this.fRowNumber + 1 : this.fRowNumber;
    }

    public short getShort() {
        return Selector.getShort(this.getValue());
    }

    public String getString() {
        return Selector.getString(this.getValue());
    }

    com.sun.java.swing.event.TableModelListener getTableModelListener() {
        return new TableModelListener(this);
    }

    public Time getTime() {
        return Selector.getTime(this.getValue());
    }

    public Timestamp getTimestamp() {
        return Selector.getTimestamp(this.getValue());
    }

    private Object getValue() {
        this.checkReady();
        return this.getModel().getValueAt(this.fRowNumber, this.getActualColumnNumber());
    }

    void initialise() {
        super.initialise();
    }

    public boolean isCellEditable() {
        this.checkReady();
        return this.getModel().isCellEditable(this.fRowNumber, this.getActualColumnNumber());
    }

    void notifyBigDecimal() {
        this.getPropertyChangeSupport().firePropertyChange("bigDecimal", null, this.getBigDecimal());
    }

    void notifyBigInteger() {
        this.getPropertyChangeSupport().firePropertyChange("bigInteger", null, this.getBigInteger());
    }

    void notifyBoolean() {
        this.getPropertyChangeSupport().firePropertyChange("boolean", null, new Boolean(this.getBoolean()));
    }

    void notifyByte() {
        this.getPropertyChangeSupport().firePropertyChange("byte", null, new Byte(this.getByte()));
    }

    void notifyByteArray() {
        this.getPropertyChangeSupport().firePropertyChange("byteArray", null, this.getByteArray());
    }

    void notifyDate() {
        this.getPropertyChangeSupport().firePropertyChange("date", null, this.getDate());
    }

    void notifyDouble() {
        this.getPropertyChangeSupport().firePropertyChange("double", null, new Double(this.getDouble()));
    }

    void notifyFloat() {
        this.getPropertyChangeSupport().firePropertyChange("float", null, new Float(this.getFloat()));
    }

    void notifyInt() {
        this.getPropertyChangeSupport().firePropertyChange("int", null, new Integer(this.getInt()));
    }

    void notifyLong() {
        this.getPropertyChangeSupport().firePropertyChange("long", null, new Long(this.getLong()));
    }

    void notifyObject() {
        this.getPropertyChangeSupport().firePropertyChange("object", null, this.getValue());
    }

    void notifyShort() {
        this.getPropertyChangeSupport().firePropertyChange("short", null, new Short(this.getShort()));
    }

    void notifyString() {
        this.getPropertyChangeSupport().firePropertyChange("string", null, this.getString());
    }

    void notifyTime() {
        this.getPropertyChangeSupport().firePropertyChange("time", null, this.getTime());
    }

    void notifyTimestamp() {
        this.getPropertyChangeSupport().firePropertyChange("timestamp", null, this.getTimestamp());
    }

    void notifyVector() {
    }

    void notifyVectorArray() {
    }

    void notifyVectorOfVectors() {
    }

    public void serialize(Serializable serializable) {
        this.setValue(Selector.serializeToByteArray(serializable));
    }

    public void setBigDecimal(BigDecimal bigDecimal) {
        this.setValue(bigDecimal);
    }

    public void setBigInteger(BigInteger bigInteger) {
        this.setValue(bigInteger);
    }

    public void setBoolean(boolean bl) {
        this.setValue(new Boolean(bl));
    }

    public void setByte(byte by) {
        this.setValue(new Byte(by));
    }

    public void setByteArray(byte[] byArray) {
        this.setValue(byArray);
    }

    public void setDate(Date date) {
        this.setValue(date);
    }

    public void setDouble(double d) {
        this.setValue(new Double(d));
    }

    public void setFloat(float f) {
        this.setValue(new Float(f));
    }

    public void setInt(int n) {
        this.setValue(new Integer(n));
    }

    public void setLong(long l) {
        this.setValue(new Long(l));
    }

    public void setObject(Object object) {
        this.setValue(object);
    }

    public void setRowNumber(int n) {
        if (this.getIndexFromOne()) {
            --n;
        }
        this.setRowNumber(n, true);
    }

    private void setRowNumber(int n, boolean bl) {
        if (this.fRowNumber != n) {
            this.fCheckReadyDone = false;
            int n2 = this.fRowNumber;
            this.fRowNumber = n;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ROW_NUMBER, new Integer(n2), new Integer(this.fRowNumber));
            if (bl) {
                this.notifyData();
            }
        }
    }

    public void setShort(short s) {
        this.setValue(new Short(s));
    }

    public void setString(String string) {
        this.setValue(string);
    }

    public void setTime(Time time) {
        this.setValue(time);
    }

    public void setTimestamp(Timestamp timestamp) {
        this.setValue(timestamp);
    }

    private void setValue(Object object) {
        this.checkReady();
        TableModel tableModel = this.getModel();
        tableModel.setValueAt(Selector.coerce(object, tableModel.getColumnClass(this.getActualColumnNumber()), true), this.fRowNumber, this.getActualColumnNumber());
    }

    static void access$setRowNumber(CellSelector cellSelector, int n, boolean bl) {
        cellSelector.setRowNumber(n, bl);
    }

    private class TableModelListener
    implements com.sun.java.swing.event.TableModelListener {
        /* synthetic */ CellSelector this$0;

        public void tableChanged(TableModelEvent tableModelEvent) {
            int n = this.this$0.getActualRowNumber();
            int n2 = this.this$0.getActualColumnNumber();
            TableModel tableModel = (TableModel)tableModelEvent.getSource();
            int n3 = tableModel.getRowCount();
            tableModel.getColumnCount();
            if (tableModelEvent.getFirstRow() == -1) {
                this.this$0.fCheckReadyDone = false;
                this.this$0.fColumnNumberResolved = false;
                this.this$0.checkNotifyData(true);
            } else {
                int n4 = tableModelEvent.getColumn();
                int n5 = tableModelEvent.getFirstRow();
                int n6 = tableModelEvent.getLastRow();
                int n7 = n6 - n5 + 1;
                switch (tableModelEvent.getType()) {
                    case 1: {
                        if (n5 > n) break;
                        CellSelector.access$setRowNumber(this.this$0, n + n7, false);
                        break;
                    }
                    case -1: {
                        if (n6 < n) {
                            CellSelector.access$setRowNumber(this.this$0, n - n7, false);
                            break;
                        }
                        if (n5 > n || n6 < n) break;
                        CellSelector.access$setRowNumber(this.this$0, Math.min(n, n3 - 1), false);
                        this.this$0.checkNotifyData(true);
                        break;
                    }
                    case 0: {
                        if (n5 > n || n6 < n || n4 != n2 && n4 != -1) break;
                        this.this$0.checkNotifyData(true);
                        break;
                    }
                }
            }
        }

        /* synthetic */ TableModelListener(CellSelector cellSelector) {
            this.this$0 = cellSelector;
        }
    }
}

