/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db.selector;

import com.ibm.db.selector.IBMSelectorMessages;
import com.ibm.db.selector.SelectionInfo;
import com.ibm.db.selector.Selector;
import com.ibm.db.selector.SelectorException;
import com.ibm.db.selector.Utilities;
import com.sun.java.swing.event.TableModelEvent;
import com.sun.java.swing.table.TableModel;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Vector;

public class CellRangeSelector
extends Selector
implements TableModel {
    static final String PROPERTY_START_COLUMN_NUMBER = "startColumnNumber";
    static final String PROPERTY_MAXIMUM_COLUMNS = "maximumColumns";
    static final String PROPERTY_START_ROW_NUMBER = "startRowNumber";
    static final String PROPERTY_MAXIMUM_ROWS = "maximumRows";
    static final String PROPERTY_INCLUDE_COLUMN_NAMES = "includeColumnNames";
    static final String PROPERTY_INVERT_DATA = "invertData";
    private int fStartColumnNumber = 0;
    private int fMaximumColumns = Integer.MIN_VALUE;
    private int fStartRowNumber = 0;
    private int fMaximumRows = Integer.MIN_VALUE;
    private boolean fIncludeColumnNames = false;
    private boolean fInvertData = false;
    private transient Vector fTableModelListeners;
    static final long serialVersionUID = 4006831814274742387L;

    public CellRangeSelector() {
    }

    public CellRangeSelector(TableModel tableModel) {
        super(tableModel);
    }

    public void addTableModelListener(com.sun.java.swing.event.TableModelListener tableModelListener) {
        if (!this.fTableModelListeners.contains(tableModelListener)) {
            this.fTableModelListeners.addElement(tableModelListener);
        }
    }

    boolean checkReady() {
        boolean bl = true;
        if (!this.fCheckReadyDone && (bl = super.checkReady())) {
            TableModel tableModel = this.getModel();
            int n = this.getActualStartColumnNumber();
            if (n < 0 || n >= tableModel.getColumnCount()) {
                Integer n2 = new Integer(this.getStartColumnNumber());
                this.setStartColumnNumber(n < 0 ? 0 : tableModel.getColumnCount() - 1, true);
                throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_SColNumber, new Object[]{n2}), 204);
            }
            if (this.fMaximumColumns != Integer.MIN_VALUE && this.fMaximumColumns < 0) {
                Integer n3 = new Integer(this.fMaximumColumns);
                this.fMaximumColumns = Integer.MIN_VALUE;
                throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_MaxCols___, new Object[]{n3}), 205);
            }
            int n4 = this.getActualStartRowNumber();
            if (n4 < 0 || n4 >= tableModel.getRowCount()) {
                Integer n5 = new Integer(this.getStartRowNumber());
                this.setStartRowNumber(n4 < 0 ? 0 : tableModel.getRowCount() - 1, true);
                throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_SRowNumber, new Object[]{n5}), 207);
            }
            if (this.fMaximumRows != Integer.MIN_VALUE && this.fMaximumRows < 0) {
                Integer n6 = new Integer(this.fMaximumRows);
                this.fMaximumRows = Integer.MIN_VALUE;
                throw new SelectorException(Utilities.logMessage(IBMSelectorMessages.err_MaxRows___, new Object[]{n6}), 208);
            }
            this.fCheckReadyDone = true;
        }
        return bl;
    }

    private static String copyright() {
        return "\n\n(c) Copyright IBM Corporation 1999 (1998).\n\n";
    }

    private void fireTableModelEvent(TableModelEvent tableModelEvent) {
        Enumeration enumeration = ((Vector)this.fTableModelListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((com.sun.java.swing.event.TableModelListener)enumeration.nextElement()).tableChanged(tableModelEvent);
        }
    }

    private int getActualEndColumnNumber(int n) {
        int n2 = this.getColumns() - 1;
        int n3 = n == Integer.MIN_VALUE ? n2 : Math.min(n2, n + this.fStartColumnNumber - 1);
        return n3;
    }

    private int getActualEndRowNumber(int n) {
        int n2 = this.getRows() - 1;
        int n3 = n == Integer.MIN_VALUE ? n2 : Math.min(n2, n + this.fStartRowNumber - 1);
        return n3;
    }

    int getActualStartColumnNumber() {
        return this.fStartColumnNumber;
    }

    int getActualStartRowNumber() {
        return this.fStartRowNumber;
    }

    public BigDecimal[][] getBigDecimal() {
        return Selector.getBigDecimal(this);
    }

    public BigInteger[][] getBigInteger() {
        return Selector.getBigInteger(this);
    }

    public boolean[][] getBoolean() {
        return Selector.getBoolean(this);
    }

    public byte[][] getByte() {
        return Selector.getByte(this);
    }

    public byte[][][] getByteArray() {
        return Selector.getByteArray(this);
    }

    public Class getColumnClass(int n) {
        this.checkReady();
        return this.getModel().getColumnClass(this.fStartColumnNumber + n);
    }

    public int getColumnCount() {
        int n = 0;
        if (this.getModel() != null && this.checkReady()) {
            n = this.getActualEndColumnNumber(this.fMaximumColumns) - this.fStartColumnNumber + 1;
        }
        return n;
    }

    public String getColumnName(int n) {
        this.checkReady();
        return this.getModel().getColumnName(this.fStartColumnNumber + n);
    }

    public String[] getColumnNames() {
        return this.getSelectionInfo().fColumnNames;
    }

    public Date[][] getDate() {
        return Selector.getDate(this);
    }

    public double[][] getDouble() {
        return Selector.getDouble(this);
    }

    public float[][] getFloat() {
        return Selector.getFloat(this);
    }

    public boolean getIncludeColumnNames() {
        return this.fIncludeColumnNames;
    }

    public int[][] getInt() {
        return Selector.getInt(this);
    }

    public boolean getInvertData() {
        return this.fInvertData;
    }

    public long[][] getLong() {
        return Selector.getLong(this);
    }

    public int getMaximumColumns() {
        return this.fMaximumColumns;
    }

    public int getMaximumRows() {
        return this.fMaximumRows;
    }

    public Object[][] getObject() {
        return Selector.getObject(this);
    }

    public int getRowCount() {
        int n = 0;
        if (this.getModel() != null && this.checkReady()) {
            n = this.getActualEndRowNumber(this.fMaximumRows) - this.fStartRowNumber + 1;
        }
        return n;
    }

    SelectionInfo getSelectionInfo() {
        this.checkReady();
        SelectionInfo selectionInfo = null;
        TableModel tableModel = this.getModel();
        int n = this.getActualEndRowNumber(this.fMaximumRows);
        int n2 = this.getActualEndColumnNumber(this.fMaximumColumns);
        if (this.fStartRowNumber >= 0 && this.fStartRowNumber <= n && this.fStartColumnNumber >= 0 && this.fStartColumnNumber <= n2) {
            selectionInfo = new SelectionInfo();
            selectionInfo.fTableModel = tableModel;
            selectionInfo.fRows = n - this.fStartRowNumber + 1;
            selectionInfo.fColumns = n2 - this.fStartColumnNumber + 1;
            selectionInfo.fStartRowNumber = this.fStartRowNumber;
            selectionInfo.fStartColumnNumber = this.fStartColumnNumber;
            selectionInfo.fEndRowNumber = n;
            selectionInfo.fEndColumnNumber = n2;
            selectionInfo.fVectorContentType = this.getVectorContentType();
            selectionInfo.fIncludeColumnNames = this.fIncludeColumnNames;
            selectionInfo.fColumnNames = new String[selectionInfo.fColumns];
            int n3 = 0;
            int n4 = this.fStartColumnNumber;
            while (n4 <= n2) {
                selectionInfo.fColumnNames[n3++] = tableModel.getColumnName(n4);
                ++n4;
            }
            selectionInfo.fInvertData = this.fInvertData;
        }
        return selectionInfo;
    }

    public short[][] getShort() {
        return Selector.getShort(this);
    }

    public int getStartColumnNumber() {
        return this.getIndexFromOne() ? this.fStartColumnNumber + 1 : this.fStartColumnNumber;
    }

    public int getStartRowNumber() {
        return this.getIndexFromOne() ? this.fStartRowNumber + 1 : this.fStartRowNumber;
    }

    public String[][] getString() {
        return Selector.getString(this);
    }

    com.sun.java.swing.event.TableModelListener getTableModelListener() {
        return new TableModelListener(this);
    }

    public Time[][] getTime() {
        return Selector.getTime(this);
    }

    public Timestamp[][] getTimestamp() {
        return Selector.getTimestamp(this);
    }

    public Object getValueAt(int n, int n2) {
        this.checkReady();
        return this.getModel().getValueAt(this.fStartRowNumber + n, this.fStartColumnNumber + n2);
    }

    public Vector[] getVectorArray() {
        return Selector.getVectorArray(this);
    }

    public Vector getVectorOfVectors() {
        return Selector.getVectorOfVectors(this);
    }

    void initialise() {
        super.initialise();
        this.fTableModelListeners = new Vector(1, 1);
    }

    public boolean isCellEditable(int n, int n2) {
        this.checkReady();
        return this.getModel().isCellEditable(this.fStartRowNumber + n, this.fStartColumnNumber + n2);
    }

    void notifyBigDecimal() {
        this.getPropertyChangeSupport().firePropertyChange("bigDecimal", null, this.getBigDecimal());
    }

    void notifyBigInteger() {
        this.getPropertyChangeSupport().firePropertyChange("bigInteger", null, this.getBigInteger());
    }

    void notifyBoolean() {
        this.getPropertyChangeSupport().firePropertyChange("boolean", null, this.getBoolean());
    }

    void notifyByte() {
        this.getPropertyChangeSupport().firePropertyChange("byte", null, this.getByte());
    }

    void notifyByteArray() {
        this.getPropertyChangeSupport().firePropertyChange("byteArray", null, this.getByteArray());
    }

    void notifyDate() {
        this.getPropertyChangeSupport().firePropertyChange("date", null, this.getDate());
    }

    void notifyDouble() {
        this.getPropertyChangeSupport().firePropertyChange("double", null, this.getDouble());
    }

    void notifyFloat() {
        this.getPropertyChangeSupport().firePropertyChange("float", null, this.getFloat());
    }

    void notifyInt() {
        this.getPropertyChangeSupport().firePropertyChange("int", null, this.getInt());
    }

    void notifyLong() {
        this.getPropertyChangeSupport().firePropertyChange("long", null, this.getLong());
    }

    void notifyObject() {
        this.getPropertyChangeSupport().firePropertyChange("object", null, this.getObject());
    }

    void notifyShort() {
        this.getPropertyChangeSupport().firePropertyChange("short", null, this.getShort());
    }

    void notifyString() {
        this.getPropertyChangeSupport().firePropertyChange("string", null, this.getString());
    }

    void notifyTime() {
        this.getPropertyChangeSupport().firePropertyChange("time", null, this.getTime());
    }

    void notifyTimestamp() {
        this.getPropertyChangeSupport().firePropertyChange("timestamp", null, this.getTimestamp());
    }

    void notifyVector() {
    }

    void notifyVectorArray() {
        this.getPropertyChangeSupport().firePropertyChange("vectorArray", null, this.getVectorArray());
    }

    void notifyVectorOfVectors() {
        this.getPropertyChangeSupport().firePropertyChange("vectorOfVectors", null, this.getVectorOfVectors());
    }

    public void removeTableModelListener(com.sun.java.swing.event.TableModelListener tableModelListener) {
        this.fTableModelListeners.removeElement(tableModelListener);
    }

    public void setBigDecimal(BigDecimal[][] bigDecimalArray) {
        this.setValues(bigDecimalArray);
    }

    public void setBigInteger(BigInteger[][] bigIntegerArray) {
        this.setValues(bigIntegerArray);
    }

    public void setBoolean(boolean[][] blArray) {
        if (blArray != null && blArray.length > 0) {
            Object[][] objectArray = new Object[blArray.length][blArray[0].length];
            int n = 0;
            while (n < blArray.length) {
                int n2 = 0;
                while (n2 < blArray[n].length) {
                    objectArray[n][n2] = new Boolean(blArray[n][n2]);
                    ++n2;
                }
                ++n;
            }
            this.setValues(objectArray);
        }
    }

    public void setByte(byte[][] byArray) {
        if (byArray != null && byArray.length > 0) {
            Object[][] objectArray = new Object[byArray.length][byArray[0].length];
            int n = 0;
            while (n < byArray.length) {
                int n2 = 0;
                while (n2 < byArray[n].length) {
                    objectArray[n][n2] = new Byte(byArray[n][n2]);
                    ++n2;
                }
                ++n;
            }
            this.setValues(objectArray);
        }
    }

    public void setByteArray(byte[][][] byArray) {
        this.setValues((Object[][])byArray);
    }

    public void setDate(Date[][] dateArray) {
        this.setValues(dateArray);
    }

    public void setDouble(double[][] dArray) {
        if (dArray != null && dArray.length > 0) {
            Object[][] objectArray = new Object[dArray.length][dArray[0].length];
            int n = 0;
            while (n < dArray.length) {
                int n2 = 0;
                while (n2 < dArray[n].length) {
                    objectArray[n][n2] = new Double(dArray[n][n2]);
                    ++n2;
                }
                ++n;
            }
            this.setValues(objectArray);
        }
    }

    public void setFloat(float[][] fArray) {
        if (fArray != null && fArray.length > 0) {
            Object[][] objectArray = new Object[fArray.length][fArray[0].length];
            int n = 0;
            while (n < fArray.length) {
                int n2 = 0;
                while (n2 < fArray[n].length) {
                    objectArray[n][n2] = new Float(fArray[n][n2]);
                    ++n2;
                }
                ++n;
            }
            this.setValues(objectArray);
        }
    }

    public void setIncludeColumnNames(boolean bl) {
        if (this.fIncludeColumnNames != bl) {
            boolean bl2 = this.fIncludeColumnNames;
            this.fIncludeColumnNames = bl;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_INCLUDE_COLUMN_NAMES, new Boolean(bl2), new Boolean(this.fIncludeColumnNames));
            this.notifyData();
        }
    }

    public void setInt(int[][] nArray) {
        if (nArray != null && nArray.length > 0) {
            Object[][] objectArray = new Object[nArray.length][nArray[0].length];
            int n = 0;
            while (n < nArray.length) {
                int n2 = 0;
                while (n2 < nArray[n].length) {
                    objectArray[n][n2] = new Integer(nArray[n][n2]);
                    ++n2;
                }
                ++n;
            }
            this.setValues(objectArray);
        }
    }

    public void setInvertData(boolean bl) {
        if (this.fInvertData != bl) {
            boolean bl2 = this.fInvertData;
            this.fInvertData = bl;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_INVERT_DATA, new Boolean(bl2), new Boolean(this.fInvertData));
            this.notifyData();
        }
    }

    public void setLong(long[][] lArray) {
        if (lArray != null && lArray.length > 0) {
            Object[][] objectArray = new Object[lArray.length][lArray[0].length];
            int n = 0;
            while (n < lArray.length) {
                int n2 = 0;
                while (n2 < lArray[n].length) {
                    objectArray[n][n2] = new Long(lArray[n][n2]);
                    ++n2;
                }
                ++n;
            }
            this.setValues(objectArray);
        }
    }

    public void setMaximumColumns(int n) {
        this.setMaximumColumns(n, true);
    }

    private void setMaximumColumns(int n, boolean bl) {
        if (this.fMaximumColumns != n) {
            int n2;
            int n3;
            this.fCheckReadyDone = false;
            int n4 = this.fMaximumColumns;
            this.fMaximumColumns = n;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_MAXIMUM_COLUMNS, new Integer(n4), new Integer(this.fMaximumColumns));
            if (bl && (n3 = this.getActualEndColumnNumber(this.fMaximumColumns) - this.fStartColumnNumber) != (n2 = this.getActualEndColumnNumber(n4) - this.fStartColumnNumber)) {
                this.notifyData();
                this.fireTableModelEvent(new TableModelEvent((TableModel)this, -1));
            }
        }
    }

    public void setMaximumRows(int n) {
        this.setMaximumRows(n, true);
    }

    private void setMaximumRows(int n, boolean bl) {
        if (this.fMaximumRows != n) {
            int n2;
            int n3;
            this.fCheckReadyDone = false;
            int n4 = this.fMaximumRows;
            this.fMaximumRows = n;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_MAXIMUM_ROWS, new Integer(n4), new Integer(this.fMaximumRows));
            if (bl && (n3 = this.getActualEndRowNumber(this.fMaximumRows) - this.fStartRowNumber) != (n2 = this.getActualEndRowNumber(n4) - this.fStartRowNumber)) {
                this.notifyData();
                if (n3 > n2) {
                    this.fireTableModelEvent(new TableModelEvent((TableModel)this, n2 + 1, n3, -1, 1));
                } else {
                    this.fireTableModelEvent(new TableModelEvent((TableModel)this, n3 + 1, n2, -1, -1));
                }
            }
        }
    }

    public void setObject(Object[][] objectArray) {
        this.setValues(objectArray);
    }

    public void setShort(short[][] sArray) {
        if (sArray != null && sArray.length > 0) {
            Object[][] objectArray = new Object[sArray.length][sArray[0].length];
            int n = 0;
            while (n < sArray.length) {
                int n2 = 0;
                while (n2 < sArray[n].length) {
                    objectArray[n][n2] = new Short(sArray[n][n2]);
                    ++n2;
                }
                ++n;
            }
            this.setValues(objectArray);
        }
    }

    public void setStartColumnNumber(int n) {
        if (this.getIndexFromOne()) {
            --n;
        }
        this.setStartColumnNumber(n, true);
    }

    private void setStartColumnNumber(int n, boolean bl) {
        if (this.fStartColumnNumber != n) {
            this.fCheckReadyDone = false;
            int n2 = this.fStartColumnNumber;
            this.fStartColumnNumber = n;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_START_COLUMN_NUMBER, new Integer(n2), new Integer(this.fStartColumnNumber));
            if (bl) {
                this.notifyData();
                this.fireTableModelEvent(new TableModelEvent((TableModel)this, -1));
            }
        }
    }

    public void setStartRowNumber(int n) {
        if (this.getIndexFromOne()) {
            --n;
        }
        this.setStartRowNumber(n, true);
    }

    private void setStartRowNumber(int n, boolean bl) {
        if (this.fStartRowNumber != n) {
            this.fCheckReadyDone = false;
            int n2 = this.fStartRowNumber;
            this.fStartRowNumber = n;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_START_ROW_NUMBER, new Integer(n2), new Integer(this.fStartRowNumber));
            if (bl) {
                this.notifyData();
                int cfr_ignored_0 = this.fStartRowNumber - n2;
                this.fireTableModelEvent(new TableModelEvent((TableModel)this, -1));
            }
        }
    }

    public void setString(String[][] stringArray) {
        this.setValues(stringArray);
    }

    public void setTime(Time[][] timeArray) {
        this.setValues(timeArray);
    }

    public void setTimestamp(Timestamp[][] timestampArray) {
        this.setValues(timestampArray);
    }

    private void setValue(Object object, int n, int n2) {
        this.checkReady();
        TableModel tableModel = this.getModel();
        int n3 = this.fStartColumnNumber + n2;
        tableModel.setValueAt(Selector.coerce(object, tableModel.getColumnClass(n3), true), this.fStartRowNumber + n, n3);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.setValue(object, n, n2);
    }

    private void setValues(Object[][] objectArray) {
        if (objectArray != null) {
            int n = this.fInvertData ? this.getColumnCount() : this.getRowCount();
            int n2 = this.fInvertData ? this.getRowCount() : this.getColumnCount();
            int n3 = Math.min(objectArray.length, n);
            int n4 = 0;
            while (n4 < n3) {
                int n5 = Math.min(objectArray[n4].length, n2);
                int n6 = 0;
                while (n6 < n5) {
                    if (this.fInvertData) {
                        this.setValue(objectArray[n6][n4], n4, n6);
                    } else {
                        this.setValue(objectArray[n4][n6], n4, n6);
                    }
                    ++n6;
                }
                ++n4;
            }
        }
    }

    public void setVectorArray(Vector[] vectorArray) {
        if (vectorArray != null && vectorArray.length > 0) {
            Object[][] objectArray = new Object[vectorArray.length][vectorArray[0].size()];
            int n = 0;
            while (n < vectorArray.length) {
                vectorArray[n].copyInto(objectArray[n]);
                ++n;
            }
            this.setValues(objectArray);
        }
    }

    public void setVectorOfVectors(Vector vector) {
        if (vector != null && vector.size() > 0) {
            Vector vector2 = (Vector)vector.elementAt(0);
            Object[][] objectArray = new Object[vector.size()][vector2.size()];
            int n = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ((Vector)enumeration.nextElement()).copyInto(objectArray[n++]);
            }
            this.setValues(objectArray);
        }
    }

    static void access$setStartRowNumber(CellRangeSelector cellRangeSelector, int n, boolean bl) {
        cellRangeSelector.setStartRowNumber(n, bl);
    }

    static int access$getActualEndColumnNumber(CellRangeSelector cellRangeSelector, int n) {
        return cellRangeSelector.getActualEndColumnNumber(n);
    }

    static void access$fireTableModelEvent(CellRangeSelector cellRangeSelector, TableModelEvent tableModelEvent) {
        cellRangeSelector.fireTableModelEvent(tableModelEvent);
    }

    static int access$getActualEndRowNumber(CellRangeSelector cellRangeSelector, int n) {
        return cellRangeSelector.getActualEndRowNumber(n);
    }

    private class TableModelListener
    implements com.sun.java.swing.event.TableModelListener {
        /* synthetic */ CellRangeSelector this$0;

        public void tableChanged(TableModelEvent tableModelEvent) {
            int n = this.this$0.getActualStartRowNumber();
            int n2 = this.this$0.getMaximumRows();
            int n3 = CellRangeSelector.access$getActualEndRowNumber(this.this$0, n2);
            int n4 = this.this$0.getActualStartColumnNumber();
            int n5 = this.this$0.getMaximumColumns();
            int n6 = CellRangeSelector.access$getActualEndColumnNumber(this.this$0, n5);
            TableModel tableModel = (TableModel)tableModelEvent.getSource();
            tableModel.getRowCount();
            tableModel.getColumnCount();
            if (tableModelEvent.getFirstRow() == -1) {
                this.this$0.fCheckReadyDone = false;
                this.this$0.checkNotifyData(true);
                CellRangeSelector.access$fireTableModelEvent(this.this$0, new TableModelEvent((TableModel)this.this$0, -1));
            } else {
                int n7 = tableModelEvent.getColumn();
                int n8 = tableModelEvent.getFirstRow();
                int n9 = tableModelEvent.getLastRow();
                int n10 = n9 - n8 + 1;
                switch (tableModelEvent.getType()) {
                    case 1: {
                        if (n8 <= n) {
                            CellRangeSelector.access$setStartRowNumber(this.this$0, n + n10, false);
                        }
                        if (n8 < n || n8 > n3) break;
                        this.this$0.checkNotifyData(true);
                        CellRangeSelector.access$fireTableModelEvent(this.this$0, new TableModelEvent((TableModel)this.this$0, n8 - n, n9 - n, -1, 1));
                        break;
                    }
                    case -1: {
                        if (n9 < n) {
                            CellRangeSelector.access$setStartRowNumber(this.this$0, n - n10, false);
                            break;
                        }
                        if (n8 <= n && n9 < n3) {
                            int n11 = n - n8;
                            if (n11 > 0) {
                                CellRangeSelector.access$setStartRowNumber(this.this$0, n - n11, false);
                            }
                            this.this$0.checkNotifyData(true);
                            int n12 = n9 - n;
                            CellRangeSelector.access$fireTableModelEvent(this.this$0, new TableModelEvent((TableModel)this.this$0, 0, n12, -1, -1));
                            break;
                        }
                        if (n8 >= n && n9 <= n3) {
                            this.this$0.checkNotifyData(true);
                            int n13 = Math.max(0, n8 - n);
                            int n14 = n13 + n10 - 1;
                            CellRangeSelector.access$fireTableModelEvent(this.this$0, new TableModelEvent((TableModel)this.this$0, n13, n14, -1, -1));
                            break;
                        }
                        if (n8 < n && n9 > n3) {
                            CellRangeSelector.access$setStartRowNumber(this.this$0, n8, false);
                            this.this$0.checkNotifyData(true);
                            CellRangeSelector.access$fireTableModelEvent(this.this$0, new TableModelEvent((TableModel)this.this$0, 0, n3 - n, -1, -1));
                            break;
                        }
                        if (n8 <= n || n9 <= n3) break;
                        this.this$0.checkNotifyData(true);
                        CellRangeSelector.access$fireTableModelEvent(this.this$0, new TableModelEvent((TableModel)this.this$0, n8 - n, n3 - n, -1, -1));
                        break;
                    }
                    case 0: {
                        boolean bl;
                        boolean bl2 = n8 <= n3 && n9 >= n;
                        boolean bl3 = bl = n7 == -1 || n7 <= n6 && n7 >= n4;
                        if (!bl2 || !bl) break;
                        this.this$0.checkNotifyData(true);
                        int n15 = n8 - Math.min(n8, n);
                        int n16 = n2 == Integer.MIN_VALUE ? n9 - n : Math.min(n9, n3) - n;
                        int n17 = n7 == -1 ? -1 : n7 - n4;
                        CellRangeSelector.access$fireTableModelEvent(this.this$0, new TableModelEvent((TableModel)this.this$0, n15, n16, n17, 0));
                        break;
                    }
                }
            }
        }

        /* synthetic */ TableModelListener(CellRangeSelector cellRangeSelector) {
            this.this$0 = cellRangeSelector;
        }
    }
}

