/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db.base;

import com.ibm.db.base.DataException;
import com.ibm.db.base.DatabaseConnection;
import com.ibm.db.base.DatabaseConnectionSpec;
import com.ibm.db.base.IBMDBBaseMessages;
import com.ibm.db.base.RegisteredConnection;
import com.ibm.db.base.UtilitiesBase;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

public class JDBCConnectionManager {
    private static Hashtable sqlTypeTable;
    private Hashtable connections;
    private Hashtable specs;
    static JDBCConnectionManager singleton;
    private Vector drivers = new Vector();
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999";

    public JDBCConnectionManager() {
        sqlTypeTable = JDBCConnectionManager.buildSQLTypeTable();
        this.connections = new Hashtable();
        singleton = this;
    }

    private static Hashtable buildSQLTypeTable() {
        Hashtable hashtable = new Hashtable();
        try {
            hashtable.put(new Integer(1), Class.forName("com.ibm.db.base.DatabaseStringField"));
            hashtable.put(new Integer(12), Class.forName("com.ibm.db.base.DatabaseStringField"));
            hashtable.put(new Integer(-1), Class.forName("com.ibm.db.base.DatabaseLongStringField"));
            hashtable.put(new Integer(4), Class.forName("com.ibm.db.base.DatabaseIntegerField"));
            hashtable.put(new Integer(-6), Class.forName("com.ibm.db.base.DatabaseIntegerField"));
            hashtable.put(new Integer(5), Class.forName("com.ibm.db.base.DatabaseShortIntegerField"));
            hashtable.put(new Integer(3), Class.forName("com.ibm.db.base.DatabaseDecimalField"));
            hashtable.put(new Integer(2), Class.forName("com.ibm.db.base.DatabaseDecimalField"));
            hashtable.put(new Integer(-7), Class.forName("com.ibm.db.base.DatabaseBooleanField"));
            hashtable.put(new Integer(-5), Class.forName("com.ibm.db.base.DatabaseLongIntegerField"));
            hashtable.put(new Integer(7), Class.forName("com.ibm.db.base.DatabaseFloatField"));
            hashtable.put(new Integer(6), Class.forName("com.ibm.db.base.DatabaseDoubleField"));
            hashtable.put(new Integer(8), Class.forName("com.ibm.db.base.DatabaseDoubleField"));
            hashtable.put(new Integer(-2), Class.forName("com.ibm.db.base.DatabaseBinaryField"));
            hashtable.put(new Integer(-3), Class.forName("com.ibm.db.base.DatabaseBinaryField"));
            hashtable.put(new Integer(-4), Class.forName("com.ibm.db.base.DatabaseLongBinaryField"));
            hashtable.put(new Integer(91), Class.forName("com.ibm.db.base.DatabaseDateField"));
            hashtable.put(new Integer(9), Class.forName("com.ibm.db.base.DatabaseDateField"));
            hashtable.put(new Integer(92), Class.forName("com.ibm.db.base.DatabaseTimeField"));
            hashtable.put(new Integer(10), Class.forName("com.ibm.db.base.DatabaseTimeField"));
            hashtable.put(new Integer(93), Class.forName("com.ibm.db.base.DatabaseTimestampField"));
            hashtable.put(new Integer(11), Class.forName("com.ibm.db.base.DatabaseTimestampField"));
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return hashtable;
    }

    protected DatabaseConnection connectUsingSpec(DatabaseConnectionSpec databaseConnectionSpec) throws SQLException, DataException {
        DatabaseConnection databaseConnection = new DatabaseConnection(this);
        databaseConnection.setConnectionSpec(databaseConnectionSpec);
        databaseConnection.connectToDataSource();
        return databaseConnection;
    }

    public void connectWithAlias(String string) throws SQLException, ClassNotFoundException, DataException {
        ((DatabaseConnectionSpec)this.specs.get(string)).connect();
    }

    public DatabaseConnection getConnectionAtAlias(String string) {
        if (string != null) {
            Object v = this.connections.get(string);
            if (v == null) {
                return null;
            }
            return ((RegisteredConnection)v).getConnection();
        }
        return null;
    }

    public static JDBCConnectionManager getJDBCConnectionManager(String string) throws ClassNotFoundException {
        JDBCConnectionManager jDBCConnectionManager = JDBCConnectionManager.singleton();
        jDBCConnectionManager.registerDriver(string);
        return jDBCConnectionManager;
    }

    public static Hashtable getSQLTypeTable() {
        if (sqlTypeTable == null) {
            sqlTypeTable = JDBCConnectionManager.buildSQLTypeTable();
        }
        return sqlTypeTable;
    }

    protected void registerConnection(DatabaseConnection databaseConnection) {
        RegisteredConnection registeredConnection = (RegisteredConnection)this.connections.get(databaseConnection.getAlias());
        if (registeredConnection == null) {
            registeredConnection = new RegisteredConnection(databaseConnection);
        }
        registeredConnection.incrementRegisteredCount();
        this.connections.put(databaseConnection.getAlias(), registeredConnection);
    }

    public void registerConnectionSpec(DatabaseConnectionSpec databaseConnectionSpec) {
        this.specs.put(databaseConnectionSpec.getAlias(), databaseConnectionSpec);
    }

    protected void registerDriver(String string) throws ClassNotFoundException {
        if (!this.drivers.contains(string)) {
            Class.forName(string);
            this.drivers.addElement(string);
        }
    }

    public static JDBCConnectionManager singleton() {
        if (singleton == null) {
            singleton = new JDBCConnectionManager();
        }
        return singleton;
    }

    protected boolean unregisterConnection(DatabaseConnection databaseConnection) {
        RegisteredConnection registeredConnection = (RegisteredConnection)this.connections.get(databaseConnection.getAlias());
        if (registeredConnection != null) {
            if (registeredConnection.decrementRegisteredCount()) {
                this.connections.remove(databaseConnection.getAlias());
                return true;
            }
            return false;
        }
        Object[] objectArray = new Object[]{databaseConnection.getAlias()};
        UtilitiesBase.getMessage(IBMDBBaseMessages.notRegistered, objectArray);
        return true;
    }

    public void unregisterConnectionSpec(DatabaseConnectionSpec databaseConnectionSpec) {
        this.specs.remove(databaseConnectionSpec.getAlias());
    }
}

