/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db.base;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class DatabaseTypeField
implements Serializable,
Cloneable {
    public static final int INPUT = 1;
    public static final int INOUT = 2;
    public static final int OUTPUT = 4;
    private String name;
    protected int sqlType;
    private int length;
    private int scale;
    private boolean searchable;
    protected int mode = 1;
    protected String sqlTypeName;
    static final long serialVersionUID = -8383779024501734283L;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999";

    public DatabaseTypeField() {
    }

    public DatabaseTypeField(String string) {
        this.name = string;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public abstract Class getFieldClass();

    public int getLength() {
        return this.length;
    }

    public int getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name;
    }

    public Object getObject(CallableStatement callableStatement, int n) throws SQLException {
        return callableStatement.getObject(n);
    }

    public abstract Object getObject(ResultSet var1, int var2) throws SQLException;

    public int getScale() {
        return this.scale;
    }

    public abstract int getSQLType();

    public String getSQLTypeName() {
        return this.sqlTypeName;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public abstract void setFieldObject(Object var1, PreparedStatement var2, int var3) throws SQLException;

    public void setLength(int n) {
        this.length = n;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setObject(Object object, PreparedStatement preparedStatement, int n) throws SQLException {
        if (object == null) {
            preparedStatement.setNull(n, this.getSQLType());
        } else {
            this.setFieldObject(object, preparedStatement, n);
        }
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public void setSearchable(boolean bl) {
        this.searchable = bl;
    }

    public void setSQLType(int n) {
        this.sqlType = n;
    }

    public void setSQLTypeName(String string) {
        this.sqlTypeName = string;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ":" + this.getName();
    }
}

