/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db.base;

import com.ibm.db.base.DataException;
import com.ibm.db.base.DatabaseCompoundType;
import com.ibm.db.base.DatabaseResultTable;
import com.ibm.db.base.DatabaseTypeField;
import com.ibm.db.base.IBMDBBaseMessages;
import com.ibm.db.base.UtilitiesBase;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Enumeration;

public class DatabaseRow
implements Serializable {
    private DatabaseCompoundType type;
    private Object[] values;
    private boolean[] nullIndicators;
    private boolean[] changedIndicators;
    static final long serialVersionUID = -8042148413714571291L;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999";

    public DatabaseRow(DatabaseCompoundType databaseCompoundType) {
        this.type = databaseCompoundType;
        int n = this.type.size();
        this.values = new Object[n];
        this.nullIndicators = new boolean[n];
        this.changedIndicators = new boolean[n];
    }

    public DatabaseRow(DatabaseRow databaseRow) {
        if (databaseRow == null) {
            return;
        }
        this.type = databaseRow.type;
        int n = this.type.size();
        this.values = new Object[n];
        this.nullIndicators = new boolean[n];
        this.changedIndicators = new boolean[n];
        int n2 = 1;
        while (n2 <= this.type.size()) {
            Object object = databaseRow.getAtIndex(n2);
            this.putAtIndex(n2, object);
            this.setColIsNull(n2, databaseRow.colIsNull(n2));
            this.setColWasChanged(n2, databaseRow.colWasChanged(n2));
            ++n2;
        }
    }

    protected boolean colIsNull(int n) {
        return this.getNullIndicators()[n - 1];
    }

    public String columnName(int n) {
        return this.getType().fieldAt(n).getName();
    }

    public boolean colWasChanged(int n) {
        return this.changedIndicators[n - 1];
    }

    protected DatabaseRow gatherValues(DatabaseResultTable databaseResultTable) throws SQLException, DataException {
        DatabaseCompoundType databaseCompoundType = this.getType();
        int n = 1;
        Enumeration enumeration = this.getColumnNames();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            Object object = databaseCompoundType.fieldAt(n).getObject(databaseResultTable.getResultSet(), n);
            this.setColIsNull(n, databaseResultTable.getResultSet().wasNull());
            databaseCompoundType.fieldAt(n).getName();
            if (!this.getNullIndicators()[n - 1]) {
                this.putAtIndex(n, object);
            }
            ++n;
        }
        return this;
    }

    public synchronized Object get(String string) {
        int n = this.getType().indexOfColumnName(string);
        return this.getAtIndex(n);
    }

    public Object getAtIndex(int n) {
        return this.getValues()[n - 1];
    }

    public int getColumnIndex(String string) {
        int n = this.getType().indexOfColumnName(string);
        return n;
    }

    public Enumeration getColumnNames() {
        return this.getType().getColumnNames();
    }

    protected boolean[] getNullIndicators() {
        return this.nullIndicators;
    }

    public DatabaseCompoundType getType() {
        return this.type;
    }

    protected Object[] getValues() {
        return this.values;
    }

    public synchronized DatabaseRow put(String string, Object object) throws DataException {
        int n = this.getType().indexOfColumnName(string);
        this.putAtIndexWithCheck(n, object);
        return this;
    }

    public void putAtIndex(int n, Object object) {
        this.getValues()[n - 1] = object;
    }

    public void putAtIndexWithCheck(int n, Object object) throws DataException {
        DatabaseTypeField databaseTypeField = this.type.fieldAt(n);
        if (object == null) {
            this.getValues()[n - 1] = object;
        } else {
            Class<?> clazz = object.getClass();
            if (clazz == databaseTypeField.getFieldClass()) {
                this.getValues()[n - 1] = object;
            } else {
                Object[] objectArray = new Object[]{databaseTypeField.getName(), clazz.getName()};
                String string = UtilitiesBase.getMessage(IBMDBBaseMessages.wrongObjectType, objectArray);
                DataException dataException = new DataException(string, 104);
                dataException.setMessageArgs(objectArray);
                throw dataException;
            }
        }
    }

    public void setColIsNull(int n, boolean bl) {
        this.nullIndicators[n - 1] = bl;
    }

    public void setColWasChanged(int n, boolean bl) {
        this.changedIndicators[n - 1] = bl;
    }

    public int size() {
        return this.getType().size();
    }

    public synchronized String toString() {
        int n = this.getType().size();
        String string = new String();
        int n2 = 1;
        while (n2 <= n) {
            string = String.valueOf(string) + "[" + this.getAtIndex(n2) + "]";
            ++n2;
        }
        return string;
    }
}

