/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db.base;

import com.ibm.db.base.DataException;
import com.ibm.db.base.DatabaseCompoundType;
import com.ibm.db.base.DatabaseConnection;
import com.ibm.db.base.DatabaseRow;
import java.io.Serializable;
import java.sql.SQLException;

public class DatabaseQuerySpec
implements Serializable {
    private String name;
    private String statement;
    private DatabaseCompoundType outputShape;
    private DatabaseCompoundType hostVarShape;
    static final long serialVersionUID = 5823869221779577202L;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999";

    public DatabaseQuerySpec() {
    }

    public DatabaseQuerySpec(DatabaseQuerySpec databaseQuerySpec) throws CloneNotSupportedException {
        if (databaseQuerySpec == null) {
            return;
        }
        if (databaseQuerySpec.name != null) {
            this.name = new String(databaseQuerySpec.name);
        }
        if (databaseQuerySpec.statement != null) {
            this.statement = new String(databaseQuerySpec.statement);
        }
        if (databaseQuerySpec.outputShape != null) {
            this.outputShape = (DatabaseCompoundType)databaseQuerySpec.outputShape.clone();
        }
        if (databaseQuerySpec.hostVarShape != null) {
            this.hostVarShape = (DatabaseCompoundType)databaseQuerySpec.hostVarShape.clone();
        }
    }

    public DatabaseQuerySpec(String string) {
        this(null, string);
    }

    public DatabaseQuerySpec(String string, String string2) {
        this.name = string;
        this.statement = string2;
    }

    public Object executeOnConnection(DatabaseConnection databaseConnection, DatabaseRow databaseRow) throws SQLException, DataException {
        int n = databaseRow == null ? databaseConnection.executeQuerySpec(this) : databaseConnection.executeQuerySpecWithValues(this, databaseRow);
        return new Integer(n);
    }

    public DatabaseRow getEmptyInputRow() {
        DatabaseCompoundType databaseCompoundType = this.getHostVarShape();
        if (databaseCompoundType == null) {
            return null;
        }
        return new DatabaseRow(databaseCompoundType);
    }

    public DatabaseCompoundType getHostVarShape() {
        return this.hostVarShape;
    }

    public String getName() {
        return this.name;
    }

    public DatabaseCompoundType getOutputShape() {
        return this.outputShape;
    }

    public String getStatement() {
        return this.statement;
    }

    protected boolean isInputDescribed() {
        return this.getHostVarShape() != null;
    }

    protected boolean isOutputDescribed() {
        return this.getOutputShape() != null;
    }

    public void setHostVarShape(DatabaseCompoundType databaseCompoundType) {
        this.hostVarShape = databaseCompoundType;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setOutputShape(DatabaseCompoundType databaseCompoundType) {
        this.outputShape = databaseCompoundType;
    }

    public void setStatement(String string) {
        this.statement = string;
    }
}

