/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db;

import com.ibm.db.DataException;
import com.ibm.db.IBMDBMessages;
import com.ibm.db.Statement;
import com.ibm.db.Utilities;
import com.ibm.db.base.DataRuntimeException;
import com.ibm.db.base.DatabaseCompoundType;
import com.ibm.db.base.DatabaseDecimalField;
import com.ibm.db.base.DatabaseQuerySpec;
import com.ibm.db.base.DatabaseRow;
import com.ibm.db.base.DatabaseTypeField;
import com.ibm.db.base.JDBCConnectionManager;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class StatementMetaData
implements Serializable {
    protected DatabaseQuerySpec querySpec = null;
    protected Vector tables = new Vector(4);
    protected StatementMetaData nextMetaData = null;
    protected Statement fieldStatement;
    public static final int PARM_MODE_INPUT = 1;
    public static final int PARM_MODE_INOUT = 2;
    public static final int PARM_MODE_OUTPUT = 4;
    static final long serialVersionUID = -3067265728930518462L;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public StatementMetaData() {
        this.querySpec = new DatabaseQuerySpec("", "");
    }

    protected StatementMetaData(DatabaseQuerySpec databaseQuerySpec) {
        this.querySpec = databaseQuerySpec;
    }

    public void addColumn(String string, int n, int n2) throws DataException {
        DatabaseCompoundType databaseCompoundType;
        DatabaseTypeField databaseTypeField = null;
        Hashtable hashtable = JDBCConnectionManager.getSQLTypeTable();
        Class clazz = (Class)hashtable.get(new Integer(n));
        if (clazz == null) {
            Object[] objectArray = new Object[]{new Integer(n), string};
            String string2 = Utilities.logMessage(IBMDBMessages.badSQLType, objectArray);
            throw new DataException(string2, 107);
        }
        try {
            databaseTypeField = (DatabaseTypeField)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            String string3 = Utilities.logMessage(IBMDBMessages.instantiationException);
            throw new com.ibm.db.DataRuntimeException(string3);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string4 = Utilities.logMessage(IBMDBMessages.illegalAccess);
            throw new com.ibm.db.DataRuntimeException(string4);
        }
        databaseTypeField.setName(string);
        databaseTypeField.setSQLType(n2);
        databaseTypeField.setMode(2);
        if (this.querySpec == null) {
            this.querySpec = new DatabaseQuerySpec();
        }
        if ((databaseCompoundType = this.querySpec.getOutputShape()) == null) {
            databaseCompoundType = new DatabaseCompoundType();
            this.querySpec.setOutputShape(databaseCompoundType);
        }
        try {
            databaseCompoundType.addField(databaseTypeField);
        }
        catch (DataRuntimeException dataRuntimeException) {
            Object[] objectArray = new Object[]{string};
            String string5 = Utilities.logMessage(IBMDBMessages.duplicateColumn, objectArray);
            throw new DataException(string5, 232);
        }
    }

    public void addColumn(String string, Class clazz, int n) throws DataException {
        DatabaseCompoundType databaseCompoundType;
        if (clazz == null) {
            String string2 = Utilities.logMessage(IBMDBMessages.badJavaClass);
            throw new DataException(string2, 211);
        }
        String string3 = clazz.getName();
        DatabaseTypeField databaseTypeField = DatabaseCompoundType.makeField(string3);
        if (databaseTypeField == null) {
            Object[] objectArray = new Object[]{string3};
            String string4 = Utilities.logMessage(IBMDBMessages.errorMakeField, objectArray);
            throw new DataException(string4, 212);
        }
        databaseTypeField.setName(string);
        databaseTypeField.setSQLType(n);
        databaseTypeField.setMode(2);
        if (this.querySpec == null) {
            this.querySpec = new DatabaseQuerySpec();
        }
        if ((databaseCompoundType = this.querySpec.getOutputShape()) == null) {
            databaseCompoundType = new DatabaseCompoundType();
            this.querySpec.setOutputShape(databaseCompoundType);
        }
        try {
            databaseCompoundType.addField(databaseTypeField);
        }
        catch (DataRuntimeException dataRuntimeException) {
            Object[] objectArray = new Object[]{string};
            String string5 = Utilities.logMessage(IBMDBMessages.duplicateColumn, objectArray);
            throw new DataException(string5, 232);
        }
    }

    public void addParameter(String string, int n, int n2) throws DataException {
        this.addParameter(string, n, n2, 1);
    }

    public void addParameter(String string, int n, int n2, int n3) throws DataException {
        DatabaseCompoundType databaseCompoundType;
        DatabaseTypeField databaseTypeField = null;
        Hashtable hashtable = JDBCConnectionManager.getSQLTypeTable();
        Class clazz = (Class)hashtable.get(new Integer(n));
        if (clazz == null) {
            Object[] objectArray = new Object[]{new Integer(n), string};
            String string2 = Utilities.logMessage(IBMDBMessages.badSQLType, objectArray);
            throw new DataException(string2, 107);
        }
        try {
            databaseTypeField = (DatabaseTypeField)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            String string3 = Utilities.logMessage(IBMDBMessages.instantiationException);
            throw new com.ibm.db.DataRuntimeException(string3);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string4 = Utilities.logMessage(IBMDBMessages.illegalAccess);
            throw new com.ibm.db.DataRuntimeException(string4);
        }
        databaseTypeField.setName(string);
        databaseTypeField.setSQLType(n2);
        databaseTypeField.setMode(n3);
        if (this.querySpec == null) {
            this.querySpec = new DatabaseQuerySpec();
        }
        if ((databaseCompoundType = this.querySpec.getHostVarShape()) == null) {
            databaseCompoundType = new DatabaseCompoundType();
            this.querySpec.setHostVarShape(databaseCompoundType);
        }
        try {
            databaseCompoundType.addField(databaseTypeField);
        }
        catch (DataRuntimeException dataRuntimeException) {
            Object[] objectArray = new Object[]{string};
            String string5 = Utilities.logMessage(IBMDBMessages.duplicateParm, objectArray);
            throw new DataException(string5, 233);
        }
        if (this.fieldStatement != null) {
            DatabaseRow databaseRow = new DatabaseRow(databaseCompoundType);
            this.fieldStatement.copyParameters(databaseRow);
        }
    }

    public void addParameter(String string, Class clazz, int n) throws DataException {
        this.addParameter(string, clazz, n, 1);
    }

    public void addParameter(String string, Class clazz, int n, int n2) throws DataException {
        DatabaseCompoundType databaseCompoundType;
        if (clazz == null) {
            String string2 = Utilities.logMessage(IBMDBMessages.badJavaClass);
            throw new DataException(string2, 211);
        }
        String string3 = clazz.getName();
        DatabaseTypeField databaseTypeField = DatabaseCompoundType.makeField(string3);
        if (databaseTypeField == null) {
            Object[] objectArray = new Object[]{string3};
            String string4 = Utilities.logMessage(IBMDBMessages.errorMakeField, objectArray);
            throw new DataException(string4, 212);
        }
        databaseTypeField.setName(string);
        databaseTypeField.setSQLType(n);
        databaseTypeField.setMode(1);
        if (this.querySpec == null) {
            this.querySpec = new DatabaseQuerySpec();
        }
        if ((databaseCompoundType = this.querySpec.getHostVarShape()) == null) {
            databaseCompoundType = new DatabaseCompoundType();
            this.querySpec.setHostVarShape(databaseCompoundType);
        }
        try {
            databaseCompoundType.addField(databaseTypeField);
        }
        catch (DataRuntimeException dataRuntimeException) {
            Object[] objectArray = new Object[]{string};
            String string5 = Utilities.logMessage(IBMDBMessages.duplicateParm, objectArray);
            throw new DataException(string5, 233);
        }
        if (this.fieldStatement != null) {
            DatabaseRow databaseRow = new DatabaseRow(databaseCompoundType);
            this.fieldStatement.copyParameters(databaseRow);
        }
    }

    public void addTable(String string) {
        this.tables.addElement(string);
    }

    public Class getColumnClass(int n) {
        Class clazz = null;
        DatabaseTypeField databaseTypeField = this.getColumnType(n);
        clazz = databaseTypeField.getFieldClass();
        return clazz;
    }

    public Class getColumnClass(String string) {
        return this.getColumnClass(this.getColumnIndex(string));
    }

    public int getColumnCount() {
        DatabaseCompoundType databaseCompoundType = this.getColumnShape();
        if (databaseCompoundType == null) {
            return 0;
        }
        return databaseCompoundType.size();
    }

    public int getColumnIndex(String string) {
        DatabaseCompoundType databaseCompoundType = this.getColumnShape();
        if (databaseCompoundType == null) {
            String string2 = Utilities.logMessage(IBMDBMessages.noSuchColumn);
            throw new IndexOutOfBoundsException(string2);
        }
        int n = databaseCompoundType.indexOfColumnName(string);
        if (n == 0) {
            String string3 = Utilities.logMessage(IBMDBMessages.noSuchColumn);
            throw new IndexOutOfBoundsException(string3);
        }
        return n;
    }

    public int getColumnLength(int n) {
        int n2 = 0;
        DatabaseTypeField databaseTypeField = this.getColumnType(n);
        n2 = databaseTypeField.getLength();
        return n2;
    }

    public int getColumnLength(String string) {
        return this.getColumnLength(this.getColumnIndex(string));
    }

    public String getColumnName(int n) {
        DatabaseTypeField databaseTypeField = this.getColumnType(n);
        String string = databaseTypeField.getName();
        return string;
    }

    public Enumeration getColumnNames() {
        DatabaseCompoundType databaseCompoundType = this.getColumnShape();
        int n = 0;
        if (databaseCompoundType != null) {
            n = databaseCompoundType.size();
        }
        Vector<String> vector = new Vector<String>();
        int n2 = 1;
        while (n2 <= n) {
            vector.addElement(databaseCompoundType.fieldAt(n2).getName());
            ++n2;
        }
        return vector.elements();
    }

    public int getColumnScale(int n) {
        DatabaseTypeField databaseTypeField = this.getColumnType(n);
        return ((DatabaseDecimalField)databaseTypeField).getScale();
    }

    public int getColumnScale(String string) {
        return this.getColumnScale(this.getColumnIndex(string));
    }

    protected DatabaseCompoundType getColumnShape() {
        if (this.querySpec == null) {
            return null;
        }
        return this.querySpec.getOutputShape();
    }

    public int getColumnSQLType(int n) {
        DatabaseTypeField databaseTypeField = this.getColumnType(n);
        int n2 = databaseTypeField.getSQLType();
        return n2;
    }

    public int getColumnSQLType(String string) {
        return this.getColumnSQLType(this.getColumnIndex(string));
    }

    protected String getColumnSQLTypeName(int n) {
        DatabaseTypeField databaseTypeField = this.getColumnType(n);
        String string = databaseTypeField.getSQLTypeName();
        return string;
    }

    protected DatabaseTypeField getColumnType(int n) {
        DatabaseTypeField databaseTypeField = null;
        DatabaseCompoundType databaseCompoundType = this.getColumnShape();
        if (databaseCompoundType == null) {
            String string = Utilities.logMessage(IBMDBMessages.noSuchColumn);
            throw new IndexOutOfBoundsException(string);
        }
        databaseTypeField = databaseCompoundType.fieldAt(n);
        if (databaseTypeField == null) {
            String string = Utilities.logMessage(IBMDBMessages.noSuchColumn);
            throw new IndexOutOfBoundsException(string);
        }
        return databaseTypeField;
    }

    protected DatabaseQuerySpec getDbQuerySpec() {
        return this.querySpec;
    }

    public String getName() {
        if (this.querySpec == null) {
            return null;
        }
        return this.querySpec.getName();
    }

    public StatementMetaData getNextMetaData() {
        return this.nextMetaData;
    }

    public Class getParameterClass(int n) {
        Class clazz = null;
        DatabaseTypeField databaseTypeField = this.getParameterType(n);
        clazz = databaseTypeField.getFieldClass();
        return clazz;
    }

    public Class getParameterClass(String string) {
        return this.getParameterClass(this.getParameterIndex(string));
    }

    public int getParameterCount() {
        DatabaseCompoundType databaseCompoundType = this.getParameterShape();
        if (databaseCompoundType == null) {
            return 0;
        }
        return databaseCompoundType.size();
    }

    public int getParameterIndex(String string) {
        DatabaseCompoundType databaseCompoundType = this.getParameterShape();
        if (databaseCompoundType == null) {
            String string2 = Utilities.logMessage(IBMDBMessages.noSuchParm);
            throw new IndexOutOfBoundsException(string2);
        }
        int n = databaseCompoundType.indexOfColumnName(string);
        if (n == 0) {
            String string3 = Utilities.logMessage(IBMDBMessages.noSuchParm);
            throw new IndexOutOfBoundsException(string3);
        }
        return n;
    }

    public int getParameterLength(int n) {
        int n2 = 0;
        DatabaseTypeField databaseTypeField = this.getParameterType(n);
        n2 = databaseTypeField.getLength();
        return n2;
    }

    public int getParameterLength(String string) {
        return this.getParameterLength(this.getParameterIndex(string));
    }

    public int getParameterMode(int n) {
        int n2 = 0;
        DatabaseTypeField databaseTypeField = this.getParameterType(n);
        n2 = databaseTypeField.getMode();
        return n2;
    }

    public int getParameterMode(String string) {
        return this.getParameterMode(this.getParameterIndex(string));
    }

    public String getParameterName(int n) {
        DatabaseTypeField databaseTypeField = this.getParameterType(n);
        String string = databaseTypeField.getName();
        return string;
    }

    public int getParameterScale(int n) {
        DatabaseTypeField databaseTypeField = this.getParameterType(n);
        return ((DatabaseDecimalField)databaseTypeField).getScale();
    }

    public int getParameterScale(String string) {
        return this.getParameterScale(this.getParameterIndex(string));
    }

    protected DatabaseCompoundType getParameterShape() {
        if (this.querySpec == null) {
            return null;
        }
        return this.querySpec.getHostVarShape();
    }

    public int getParameterSQLType(int n) {
        DatabaseTypeField databaseTypeField = this.getParameterType(n);
        int n2 = databaseTypeField.getSQLType();
        return n2;
    }

    public int getParameterSQLType(String string) {
        return this.getParameterSQLType(this.getParameterIndex(string));
    }

    protected DatabaseTypeField getParameterType(int n) {
        DatabaseTypeField databaseTypeField = null;
        DatabaseCompoundType databaseCompoundType = this.getParameterShape();
        if (databaseCompoundType == null) {
            String string = Utilities.logMessage(IBMDBMessages.noSuchParm);
            throw new IndexOutOfBoundsException(string);
        }
        databaseTypeField = databaseCompoundType.fieldAt(n);
        if (databaseTypeField == null) {
            String string = Utilities.logMessage(IBMDBMessages.noSuchParm);
            throw new IndexOutOfBoundsException(string);
        }
        return databaseTypeField;
    }

    public String getSQL() {
        if (this.querySpec == null) {
            return null;
        }
        return this.querySpec.getStatement();
    }

    public Enumeration getTables() {
        return this.tables.elements();
    }

    public void removeColumn(int n) {
        if (this.getColumnShape() == null) {
            String string = Utilities.logMessage(IBMDBMessages.noSuchColumn);
            throw new IndexOutOfBoundsException(string);
        }
        if (!this.getColumnShape().removeFieldAt(n)) {
            String string = Utilities.logMessage(IBMDBMessages.noSuchColumn);
            throw new IndexOutOfBoundsException(string);
        }
    }

    public void removeColumn(String string) {
        this.removeColumn(this.getColumnIndex(string));
    }

    public void removeParameter(int n) {
        if (this.getParameterShape() == null) {
            String string = Utilities.logMessage(IBMDBMessages.noSuchParm);
            throw new IndexOutOfBoundsException(string);
        }
        if (!this.getParameterShape().removeFieldAt(n)) {
            String string = Utilities.logMessage(IBMDBMessages.noSuchParm);
            throw new IndexOutOfBoundsException(string);
        }
    }

    public void removeParameter(String string) {
        this.removeParameter(this.getParameterIndex(string));
    }

    public void removeTable(String string) throws DataException {
        if (!this.tables.removeElement(string)) {
            Object[] objectArray = new Object[]{string};
            String string2 = Utilities.logMessage(IBMDBMessages.noSuchTable, objectArray);
            throw new DataException(string2, 231);
        }
    }

    public void setColumnLength(int n, int n2) {
        DatabaseTypeField databaseTypeField = this.getColumnType(n);
        databaseTypeField.setLength(n2);
    }

    public void setColumnLength(String string, int n) {
        this.setColumnLength(this.getColumnIndex(string), n);
    }

    public void setColumnScale(int n, int n2) {
        DatabaseTypeField databaseTypeField = this.getColumnType(n);
        databaseTypeField.setScale(n2);
    }

    public void setColumnScale(String string, int n) {
        this.setColumnScale(this.getColumnIndex(string), n);
    }

    protected void setColumnShape(DatabaseCompoundType databaseCompoundType) {
        if (this.querySpec == null) {
            this.querySpec = new DatabaseQuerySpec();
        }
        this.querySpec.setOutputShape(databaseCompoundType);
    }

    public void setColumnSQLType(int n, int n2) {
        DatabaseTypeField databaseTypeField = this.getColumnType(n);
        databaseTypeField.setSQLType(n2);
    }

    public void setColumnSQLType(String string, int n) {
        this.setColumnSQLType(this.getColumnIndex(string), n);
    }

    public void setName(String string) {
        if (this.querySpec == null) {
            this.querySpec = new DatabaseQuerySpec();
        }
        this.querySpec.setName(string);
    }

    public void setNextMetaData(StatementMetaData statementMetaData) {
        this.nextMetaData = statementMetaData;
    }

    public void setParameterLength(int n, int n2) {
        DatabaseTypeField databaseTypeField = this.getParameterType(n);
        databaseTypeField.setLength(n2);
    }

    public void setParameterLength(String string, int n) {
        this.setParameterLength(this.getParameterIndex(string), n);
    }

    public void setParameterMode(int n, int n2) {
        DatabaseTypeField databaseTypeField = this.getParameterType(n);
        databaseTypeField.setMode(n2);
    }

    public void setParameterMode(String string, int n) {
        this.setParameterMode(this.getParameterIndex(string), n);
    }

    public void setParameterScale(int n, int n2) {
        DatabaseTypeField databaseTypeField = this.getParameterType(n);
        databaseTypeField.setScale(n2);
    }

    public void setParameterScale(String string, int n) {
        this.setParameterScale(this.getParameterIndex(string), n);
    }

    public void setParameterSQLType(int n, int n2) {
        DatabaseTypeField databaseTypeField = this.getParameterType(n);
        databaseTypeField.setSQLType(n2);
    }

    public void setParameterSQLType(String string, int n) {
        this.setParameterSQLType(this.getParameterIndex(string), n);
    }

    public void setSQL(String string) {
        if (this.querySpec == null) {
            this.querySpec = new DatabaseQuerySpec(string);
        } else {
            this.querySpec.setStatement(string);
        }
    }

    protected void setStatement(Statement statement) {
        this.fieldStatement = statement;
    }
}

