/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db;

import com.ibm.db.DataEvent;
import com.ibm.db.DatabaseConnection;
import com.ibm.db.IBMDBMessages;
import com.ibm.db.SelectStatement;
import com.ibm.db.StatementMetaData;
import com.ibm.db.StatementResult;
import com.ibm.db.StatementResultRow;
import com.ibm.db.StatementResultValueChangeEventMulticaster;
import com.ibm.db.StatementResultValueChangeListener;
import com.ibm.db.Utilities;
import com.ibm.db.base.DataException;
import com.ibm.db.base.DatabaseCompoundType;
import com.ibm.db.base.DatabaseQuerySpec;
import com.ibm.db.base.DatabaseResultTable;
import com.ibm.db.base.DatabaseRow;
import com.ibm.db.base.DatabaseTypeField;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class SelectResult
extends StatementResult {
    protected int fieldCurrentRow = 0;
    protected int fieldCurrentRowInCache = 0;
    protected int fieldNumPacketsInCache = 0;
    protected int fieldNumRowsInCache = 0;
    protected SelectStatement statement;
    protected StatementMetaData metaData = null;
    protected Vector rows;
    protected transient Vector changes;
    protected transient DatabaseResultTable singleRowResult;
    protected transient DatabaseResultTable currentStatement;
    protected transient boolean dataChangesPending = false;
    protected transient boolean moreRows = true;
    protected transient boolean leavingRow = false;
    protected transient boolean nextOrPrev = false;
    protected boolean deferUpdates = false;
    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    protected transient StatementResultValueChangeListener aStatementResultValueChangeListener = null;
    static final long serialVersionUID = -4708209390642378510L;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";
    static Class class$array1$$byte;
    static Class class$java$lang$Short;
    static Class class$java$sql$Time;
    static Class class$java$lang$String;
    static Class class$java$lang$Float;
    static Class class$java$sql$Timestamp;
    static Class class$java$lang$Double;
    static Class class$java$lang$Boolean;
    static Class class$java$sql$Date;
    static Class class$java$lang$Long;
    static Class class$java$lang$Integer;
    static Class class$java$math$BigDecimal;

    public SelectResult() {
    }

    public SelectResult(SelectStatement selectStatement) {
        this.statement = selectStatement;
        if (selectStatement != null) {
            this.metaData = selectStatement.getMetaData();
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChange.addPropertyChangeListener(propertyChangeListener);
    }

    public void addStatementResultValueChangeListener(StatementResultValueChangeListener statementResultValueChangeListener) {
        this.aStatementResultValueChangeListener = StatementResultValueChangeEventMulticaster.add(this.aStatementResultValueChangeListener, statementResultValueChangeListener);
    }

    protected void apply() throws com.ibm.db.DataException {
        if (this.statement != null && this.statement.isReadOnly()) {
            Object[] objectArray = new Object[]{"apply"};
            String string = Utilities.logMessage(IBMDBMessages.readOnly, objectArray);
            throw new com.ibm.db.DataException(string, 215);
        }
        StatementResultRow statementResultRow = null;
        try {
            if (this.changes != null) {
                while (true) {
                    statementResultRow = (StatementResultRow)this.changes.firstElement();
                    switch (statementResultRow.getAction()) {
                        case 1: {
                            this.applyUpdate(statementResultRow);
                            break;
                        }
                        case 2: {
                            this.applyDelete(statementResultRow);
                            break;
                        }
                        case 3: {
                            this.applyInsert(statementResultRow);
                            break;
                        }
                    }
                    this.changes.removeElementAt(0);
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (com.ibm.db.DataException dataException) {
            this.restoreChanges();
            throw dataException;
        }
    }

    protected void applyDelete(StatementResultRow statementResultRow) throws com.ibm.db.DataException {
        block29: {
            DatabaseResultTable databaseResultTable;
            block28: {
                DatabaseRow databaseRow = null;
                String string = null;
                databaseResultTable = null;
                DatabaseConnection databaseConnection = this.statement.getConnection();
                if (!statementResultRow.isInDatabase()) {
                    return;
                }
                if (!databaseConnection.databaseName.equals("Microsoft SQL Server") && !databaseConnection.databaseName.equals("SQL Server") && !databaseConnection.databaseName.equals("Sybase SQL Server") && !databaseConnection.databaseName.startsWith("Oracle") && databaseConnection.supportsPositionedDelete && !this.statement.isForceSearchedUpdate()) break block28;
                DatabaseQuerySpec databaseQuerySpec = this.generateSearchedDeleteSpec(statementResultRow);
                databaseRow = statementResultRow.getPreviousColumnValues() == null ? statementResultRow.getCurrentColumnValues() : statementResultRow.getPreviousColumnValues();
                DatabaseRow databaseRow2 = this.generateHostVars(databaseQuerySpec, databaseRow);
                try {
                    try {
                        databaseResultTable = new DatabaseResultTable(this.statement.getConnection().getConnection(), databaseQuerySpec);
                        databaseResultTable.setTimeout(this.statement.getTimeout());
                        this.currentStatement = databaseResultTable;
                        databaseResultTable.execute(databaseRow2);
                        this.currentStatement = null;
                        int n = databaseResultTable.getUpdateCount();
                        if (n == 0) {
                            string = Utilities.logMessage(IBMDBMessages.rowChanged);
                            throw new com.ibm.db.DataException(string, 237);
                        }
                        if (n > 1) {
                            string = Utilities.logMessage(IBMDBMessages.multipleRowsChanged);
                        }
                    }
                    catch (SQLException sQLException) {
                        StatementResult.handleSQLException(sQLException);
                    }
                    catch (DataException dataException) {
                        Utilities.logBaseException(dataException);
                        throw new com.ibm.db.DataException(dataException.getMessage(), dataException.getErrorCode());
                    }
                }
                catch (Throwable throwable) {
                    Object var8_15 = null;
                    this.currentStatement = null;
                    if (databaseResultTable != null) {
                        try {
                            databaseResultTable.closeStatement();
                        }
                        catch (SQLException sQLException) {}
                    }
                    throw throwable;
                }
                Object var8_16 = null;
                this.currentStatement = null;
                if (databaseResultTable == null) break block29;
                try {
                    databaseResultTable.closeStatement();
                }
                catch (SQLException sQLException) {}
                break block29;
            }
            if (!this.isRowLocked()) {
                this.applyLock(statementResultRow);
            }
            DatabaseQuerySpec databaseQuerySpec = new DatabaseQuerySpec(this.generatePositionedDeleteSQL());
            try {
                try {
                    this.leavingRow = true;
                    databaseResultTable = new DatabaseResultTable(this.statement.getConnection().getConnection(), databaseQuerySpec);
                    databaseResultTable.setTimeout(this.statement.getTimeout());
                    this.currentStatement = databaseResultTable;
                    databaseResultTable.execute();
                }
                catch (SQLException sQLException) {
                    this.leavingRow = false;
                    StatementResult.handleSQLException(sQLException);
                }
                catch (DataException dataException) {
                    this.leavingRow = false;
                    Utilities.logBaseException(dataException);
                    throw new com.ibm.db.DataException(dataException.getMessage(), dataException.getErrorCode());
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.currentStatement = null;
                if (this.leavingRow || !this.statement.isLockRows()) {
                    this.unlockRow();
                }
                this.leavingRow = false;
                if (databaseResultTable != null) {
                    try {
                        databaseResultTable.closeStatement();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            Object var7_10 = null;
            this.currentStatement = null;
            if (this.leavingRow || !this.statement.isLockRows()) {
                this.unlockRow();
            }
            this.leavingRow = false;
            if (databaseResultTable == null) break block29;
            try {
                databaseResultTable.closeStatement();
            }
            catch (SQLException sQLException) {}
        }
    }

    protected void applyInsert(StatementResultRow statementResultRow) throws com.ibm.db.DataException {
        DatabaseResultTable databaseResultTable = null;
        DatabaseQuerySpec databaseQuerySpec = this.generateInsertSpec(statementResultRow);
        DatabaseRow databaseRow = statementResultRow.getCurrentColumnValues();
        DatabaseRow databaseRow2 = this.generateInsertHostVars(databaseQuerySpec, databaseRow);
        try {
            try {
                databaseResultTable = new DatabaseResultTable(this.statement.getConnection().getConnection(), databaseQuerySpec);
                databaseResultTable.setTimeout(this.statement.getTimeout());
                this.currentStatement = databaseResultTable;
                databaseResultTable.execute(databaseRow2);
            }
            catch (SQLException sQLException) {
                StatementResult.handleSQLException(sQLException);
            }
            catch (DataException dataException) {
                Utilities.logBaseException(dataException);
                throw new com.ibm.db.DataException(dataException.getMessage(), dataException.getErrorCode());
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.currentStatement = null;
            if (databaseResultTable != null) {
                try {
                    databaseResultTable.closeStatement();
                }
                catch (SQLException sQLException) {}
            }
            throw throwable;
        }
        Object var6_10 = null;
        this.currentStatement = null;
        if (databaseResultTable != null) {
            try {
                databaseResultTable.closeStatement();
            }
            catch (SQLException sQLException) {}
        }
        if (!this.leavingRow && this.statement.isLockRows()) {
            this.applyLock(statementResultRow);
        }
    }

    protected void applyLock(StatementResultRow statementResultRow) throws com.ibm.db.DataException {
        boolean bl = false;
        if (this.isRowLocked()) {
            return;
        }
        if (!statementResultRow.isInDatabase()) {
            String string = Utilities.logMessage(IBMDBMessages.rowNotInDatabase);
            throw new com.ibm.db.DataException(string, 217);
        }
        if (statementResultRow.status == 3) {
            String string = Utilities.logMessage(IBMDBMessages.truncated);
            throw new com.ibm.db.DataException(string, 240);
        }
        DatabaseRow databaseRow = null;
        databaseRow = statementResultRow.getPreviousColumnValues() == null ? statementResultRow.getCurrentColumnValues() : statementResultRow.getPreviousColumnValues();
        DatabaseQuerySpec databaseQuerySpec = this.generateSelectSpec(databaseRow);
        DatabaseRow databaseRow2 = this.generateHostVars(databaseQuerySpec, databaseRow);
        try {
            try {
                this.singleRowResult = new DatabaseResultTable(this.statement.getConnection().getConnection(), databaseQuerySpec);
                this.singleRowResult.setTimeout(this.statement.getTimeout());
                this.currentStatement = this.singleRowResult;
                this.singleRowResult.execute(databaseRow2);
                bl = this.singleRowResult.next();
            }
            catch (SQLException sQLException) {
                if (this.singleRowResult != null) {
                    try {
                        this.singleRowResult.closeStatement();
                    }
                    catch (SQLException sQLException2) {}
                    this.singleRowResult = null;
                }
                StatementResult.handleSQLException(sQLException);
            }
            catch (DataException dataException) {
                if (this.singleRowResult != null) {
                    try {
                        this.singleRowResult.closeStatement();
                    }
                    catch (SQLException sQLException) {}
                    this.singleRowResult = null;
                }
                Utilities.logBaseException(dataException);
                throw new com.ibm.db.DataException(dataException.getMessage(), dataException.getErrorCode());
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            this.currentStatement = null;
            throw throwable;
        }
        String string = null;
        this.currentStatement = null;
        if (!bl) {
            try {
                this.singleRowResult.closeStatement();
            }
            catch (SQLException sQLException) {}
            this.singleRowResult = null;
            if (this.leavingRow) {
                string = Utilities.logMessage(IBMDBMessages.rowChanged);
                throw new com.ibm.db.DataException(string, 237);
            }
            string = Utilities.logMessage(IBMDBMessages.rowNotFound);
            throw new com.ibm.db.DataException(string, 205);
        }
    }

    protected void applyUpdate(StatementResultRow statementResultRow) throws com.ibm.db.DataException {
        block32: {
            DatabaseResultTable databaseResultTable;
            DatabaseQuerySpec databaseQuerySpec;
            block31: {
                databaseQuerySpec = null;
                databaseResultTable = null;
                DatabaseConnection databaseConnection = this.statement.getConnection();
                String string = null;
                if (!databaseConnection.databaseName.equals("Microsoft SQL Server") && !databaseConnection.databaseName.equals("SQL Server") && !databaseConnection.databaseName.equals("Sybase SQL Server") && !databaseConnection.databaseName.startsWith("Oracle") && databaseConnection.supportsPositionedUpdate && !this.statement.isForceSearchedUpdate()) break block31;
                databaseQuerySpec = this.generateSearchedUpdateSpec(statementResultRow);
                if (databaseQuerySpec == null) {
                    return;
                }
                try {
                    try {
                        DatabaseRow databaseRow = statementResultRow.getCurrentColumnValues();
                        DatabaseRow databaseRow2 = statementResultRow.getPreviousColumnValues();
                        if (databaseRow2 == null) {
                            databaseRow2 = databaseRow;
                        }
                        DatabaseRow databaseRow3 = this.generateSearchedUpdateHostVars(databaseQuerySpec, databaseRow, databaseRow2);
                        databaseResultTable = new DatabaseResultTable(this.statement.getConnection().getConnection(), databaseQuerySpec);
                        databaseResultTable.setTimeout(this.statement.getTimeout());
                        this.currentStatement = databaseResultTable;
                        databaseResultTable.execute(databaseRow3);
                        this.currentStatement = null;
                        int n = databaseResultTable.getUpdateCount();
                        if (n == 0) {
                            string = Utilities.logMessage(IBMDBMessages.rowChanged);
                            throw new com.ibm.db.DataException(string, 237);
                        }
                        if (n > 1) {
                            string = Utilities.logMessage(IBMDBMessages.multipleRowsChanged);
                        }
                    }
                    catch (SQLException sQLException) {
                        StatementResult.handleSQLException(sQLException);
                    }
                    catch (DataException dataException) {
                        Utilities.logBaseException(dataException);
                        throw new com.ibm.db.DataException(dataException.getMessage(), dataException.getErrorCode());
                    }
                }
                catch (Throwable throwable) {
                    Object var9_19 = null;
                    this.currentStatement = null;
                    if (databaseResultTable != null) {
                        try {
                            databaseResultTable.closeStatement();
                        }
                        catch (SQLException sQLException) {}
                    }
                    throw throwable;
                }
                Object var9_20 = null;
                this.currentStatement = null;
                if (databaseResultTable == null) break block32;
                try {
                    databaseResultTable.closeStatement();
                }
                catch (SQLException sQLException) {}
                break block32;
            }
            if (!this.isRowLocked()) {
                boolean bl = this.leavingRow;
                this.leavingRow = true;
                this.applyLock(statementResultRow);
                this.leavingRow = bl;
            }
            if ((databaseQuerySpec = this.generatePositionedUpdateSpec(statementResultRow)) == null) {
                return;
            }
            DatabaseRow databaseRow = statementResultRow.getCurrentColumnValues();
            DatabaseRow databaseRow4 = statementResultRow.getPreviousColumnValues();
            if (databaseRow4 == null) {
                databaseRow4 = databaseRow;
            }
            DatabaseRow databaseRow5 = this.generatePositionedUpdateHostVars(databaseQuerySpec, databaseRow, databaseRow4);
            try {
                try {
                    databaseResultTable = new DatabaseResultTable(this.statement.getConnection().getConnection(), databaseQuerySpec);
                    databaseResultTable.setTimeout(this.statement.getTimeout());
                    this.currentStatement = databaseResultTable;
                    databaseResultTable.execute(databaseRow5);
                }
                catch (SQLException sQLException) {
                    this.leavingRow = false;
                    StatementResult.handleSQLException(sQLException);
                }
                catch (DataException dataException) {
                    this.leavingRow = false;
                    Utilities.logBaseException(dataException);
                    throw new com.ibm.db.DataException(dataException.getMessage(), dataException.getErrorCode());
                }
            }
            catch (Throwable throwable) {
                Object var9_22 = null;
                this.currentStatement = null;
                if (databaseResultTable != null) {
                    try {
                        databaseResultTable.closeStatement();
                    }
                    catch (SQLException sQLException) {}
                }
                if (this.leavingRow || !this.statement.isLockRows()) {
                    this.unlockRow();
                }
                throw throwable;
            }
            Object var9_23 = null;
            this.currentStatement = null;
            if (databaseResultTable != null) {
                try {
                    databaseResultTable.closeStatement();
                }
                catch (SQLException sQLException) {}
            }
            if (!this.leavingRow && this.statement.isLockRows()) break block32;
            this.unlockRow();
        }
    }

    public void cancelAction() throws com.ibm.db.DataException {
        if (this.statement == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new com.ibm.db.DataException(string, 229);
        }
        this.checkConnection();
        if (this.currentStatement == null) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuting);
            throw new com.ibm.db.DataException(string, 246);
        }
        try {
            this.currentStatement.cancel();
            this.currentStatement.closeStatement();
            this.currentStatement = null;
        }
        catch (SQLException sQLException) {
            StatementResult.handleSQLException(sQLException);
        }
    }

    protected void checkConnection() throws com.ibm.db.DataException {
        if (this.statement.getConnection() == null || !this.statement.getConnection().isConnected()) {
            this.statement.disconnect();
            String string = Utilities.logMessage(IBMDBMessages.noActiveConnection);
            throw new com.ibm.db.DataException(string, 226);
        }
    }

    public synchronized void close() throws com.ibm.db.DataException {
        if (this.statement == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new com.ibm.db.DataException(string, 229);
        }
        this.statement.close();
    }

    protected void closeInternal(boolean bl) throws com.ibm.db.DataException {
        if (!bl) {
            this.updateRowBeforeLeaving();
        }
        if (this.statement.getConnection() == null || !this.statement.getConnection().isConnected()) {
            this.statement.disconnect();
        } else {
            try {
                this.moreRows = false;
                if (this.rt != null) {
                    DatabaseResultTable databaseResultTable = this.rt;
                    this.rt = null;
                    databaseResultTable.close();
                }
            }
            catch (SQLException sQLException) {
                if (bl) {
                    Utilities.logSQLException(sQLException);
                }
                StatementResult.handleSQLException(sQLException);
            }
        }
    }

    public synchronized void closeResult() throws com.ibm.db.DataException {
        this.fireAboutToClose(new DataEvent(this));
        this.closeInternal(false);
        this.fireClosed(new DataEvent(this));
    }

    public Enumeration columnNames() throws com.ibm.db.DataException {
        if (this.metaData == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new com.ibm.db.DataException(string, 229);
        }
        return this.metaData.getColumnNames();
    }

    public synchronized void deleteRow() throws com.ibm.db.DataException {
        StatementResultRow statementResultRow;
        block9: {
            statementResultRow = this.getCurrentRowObject();
            try {
                this.checkConnection();
            }
            catch (com.ibm.db.DataException dataException) {
                if (statementResultRow.getStatus() == 2 && dataException.getErrorCode() == 226) break block9;
                throw dataException;
            }
        }
        if (this.statement.isReadOnly()) {
            Object[] objectArray = new Object[]{"deleteRow"};
            String string = Utilities.logMessage(IBMDBMessages.readOnly, objectArray);
            throw new com.ibm.db.DataException(string, 215);
        }
        if (statementResultRow.getStatus() == 3) {
            String string = Utilities.logMessage(IBMDBMessages.truncated);
            throw new com.ibm.db.DataException(string, 240);
        }
        this.fireAboutToDeleteRow(new DataEvent(this));
        this.changes.addElement(statementResultRow);
        statementResultRow.setNumberWhenChanged(this.fieldCurrentRow);
        statementResultRow.setAction(2);
        this.rows.removeElementAt(this.fieldCurrentRowInCache - 1);
        --this.fieldNumRows;
        --this.fieldNumRowsInCache;
        if (!this.deferUpdates) {
            this.apply();
        }
        this.fireDeletedRow(new DataEvent(this));
        Integer n = null;
        Integer n2 = null;
        if (this.moreRows) {
            this.fetchNextRow();
            this.fireCacheRowsChanged(new DataEvent(this, 2));
        } else {
            if (this.fieldCurrentRow > this.fieldNumRows) {
                n = new Integer(this.fieldCurrentRow);
                n2 = new Integer(this.fieldCurrentRowInCache);
                --this.fieldCurrentRow;
                --this.fieldCurrentRowInCache;
            }
            this.fireCacheRowsChanged(new DataEvent(this, 1));
        }
        if (this.statement.isLockRows() && this.fieldCurrentRow != 0) {
            this.lockRow();
        }
        this.firePropertyChange("currentRow", n, new Integer(this.fieldCurrentRow));
        this.firePropertyChange("currentRowInCache", n2, new Integer(this.fieldCurrentRowInCache));
    }

    protected void disconnect() {
        this.rt = null;
        this.moreRows = false;
        this.singleRowResult = null;
    }

    protected void fetchNextPacket() throws com.ibm.db.DataException {
        int n;
        if (!this.moreRows) {
            return;
        }
        if (this.rt == null) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuted);
            throw new com.ibm.db.DataException(string, 213);
        }
        if (this.fieldNumPacketsInCache == this.statement.getMaximumPacketsInCache() && this.statement.getMaximumPacketsInCache() > 0) {
            if (this.fieldCurrentRowInCache <= this.statement.getPacketSize() && this.fieldCurrentRowInCache > 0) {
                this.updateRowBeforeLeaving();
            }
            n = 0;
            while (n < this.statement.getPacketSize()) {
                this.rows.removeElementAt(0);
                --this.fieldNumRowsInCache;
                --this.fieldCurrentRowInCache;
                ++n;
            }
            --this.fieldNumPacketsInCache;
        }
        if ((n = this.statement.getPacketSize()) < 1) {
            n = 1;
        }
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            if (!this.moreRows) break;
            this.fetchNextRow();
            ++this.fieldCurrentRow;
            ++this.fieldCurrentRowInCache;
            ++n2;
        }
        if (n2 > 0) {
            ++this.fieldNumPacketsInCache;
        }
    }

    protected void fetchNextRow() throws com.ibm.db.DataException {
        if (!this.moreRows) {
            return;
        }
        try {
            Object object = this.rt.nextElement();
            DatabaseRow databaseRow = (DatabaseRow)object;
            StatementResultRow statementResultRow = new StatementResultRow(databaseRow);
            SQLWarning sQLWarning = this.rt.getWarnings();
            if (sQLWarning != null && sQLWarning.getSQLState().equals("01004")) {
                statementResultRow.setStatus(3);
            }
            this.rows.addElement(statementResultRow);
        }
        catch (SQLException sQLException) {
            StatementResult.handleSQLException(sQLException);
        }
        catch (DataException dataException) {
            Utilities.logBaseException(dataException);
            throw new com.ibm.db.DataException(dataException.getMessage(), dataException.getErrorCode());
        }
        ++this.fieldNumRows;
        ++this.fieldNumRowsInCache;
        try {
            if (!this.rt.next()) {
                this.moreRows = false;
            }
        }
        catch (SQLException sQLException) {
            StatementResult.handleSQLException(sQLException);
        }
        if (this.fieldNumRows >= this.statement.getMaximumRows() && this.statement.getMaximumRows() > 0) {
            this.moreRows = false;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected void fireAboutToSetColumnValue(PropertyChangeEvent propertyChangeEvent) {
        if (this.aStatementResultValueChangeListener == null) {
            return;
        }
        this.aStatementResultValueChangeListener.aboutToSetColumnValue(propertyChangeEvent);
    }

    protected void fireCacheRowsChanged(DataEvent dataEvent) {
        if (this.aStatementResultAfterListener == null) {
            return;
        }
        this.aStatementResultAfterListener.cacheRowsChanged(dataEvent);
    }

    protected void fireColumnValueSet(PropertyChangeEvent propertyChangeEvent) {
        if (this.aStatementResultValueChangeListener == null) {
            return;
        }
        this.aStatementResultValueChangeListener.columnValueSet(propertyChangeEvent);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChange.firePropertyChange(string, object, object2);
    }

    public void firstRow() throws com.ibm.db.DataException {
        this.setCurrentRow(1);
    }

    protected String generateCast(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(60);
        int n2 = this.metaData.getColumnSQLType(n);
        String string2 = "";
        if (!this.statement.getConnection().supportsMixedCaseIdentifiers && this.statement.getConnection().supportsMixedCaseQuotedIdentifiers) {
            string2 = "\"";
        }
        stringBuffer.append("CAST (");
        stringBuffer.append(String.valueOf(string2) + string + string2 + " AS ");
        stringBuffer.append(this.metaData.getColumnSQLTypeName(n));
        if (n2 == 1 || n2 == 12 || n2 == -2 || n2 == -3) {
            stringBuffer.append("(" + this.metaData.getColumnLength(n) + ")");
        } else if (n2 == 3 || n2 == 2) {
            stringBuffer.append("(" + this.metaData.getColumnLength(n) + "," + this.metaData.getColumnScale(n) + ")");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected DatabaseRow generateHostVars(DatabaseQuerySpec databaseQuerySpec, DatabaseRow databaseRow) {
        DatabaseCompoundType databaseCompoundType = databaseQuerySpec.getHostVarShape();
        DatabaseRow databaseRow2 = new DatabaseRow(databaseCompoundType);
        int n = 1;
        while (n <= databaseCompoundType.size()) {
            String string = databaseCompoundType.fieldAt(n).getName();
            Object object = databaseRow.get(string);
            databaseRow2.putAtIndex(n, object);
            databaseRow2.setColWasChanged(n, true);
            ++n;
        }
        return databaseRow2;
    }

    protected DatabaseRow generateInsertHostVars(DatabaseQuerySpec databaseQuerySpec, DatabaseRow databaseRow) {
        DatabaseCompoundType databaseCompoundType = databaseQuerySpec.getHostVarShape();
        DatabaseRow databaseRow2 = new DatabaseRow(databaseCompoundType);
        int n = 1;
        int n2 = 1;
        while (n2 <= databaseRow.size()) {
            if (databaseRow.colWasChanged(n2)) {
                databaseRow2.putAtIndex(n, databaseRow.getAtIndex(n2));
                databaseRow2.setColWasChanged(n, true);
                ++n;
            }
            ++n2;
        }
        return databaseRow2;
    }

    protected DatabaseQuerySpec generateInsertSpec(StatementResultRow statementResultRow) throws com.ibm.db.DataException {
        this.metaData.getTables();
        boolean bl = true;
        DatabaseCompoundType databaseCompoundType = null;
        DatabaseQuerySpec databaseQuerySpec = null;
        int n = this.statement.getMetaData().getSQL().length() * 2;
        StringBuffer stringBuffer = new StringBuffer(n);
        String string = "";
        if (!this.statement.getConnection().supportsMixedCaseIdentifiers && this.statement.getConnection().supportsMixedCaseQuotedIdentifiers) {
            string = "\"";
        }
        try {
            databaseCompoundType = new DatabaseCompoundType(this.statement.getMetaData().getColumnShape());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(this.generateTableName());
        stringBuffer.append(" (" + string);
        bl = true;
        Enumeration enumeration = this.columnNames();
        int n2 = 1;
        while (n2 <= this.getColumnCount()) {
            String string2 = (String)enumeration.nextElement();
            if (!statementResultRow.getCurrentColumnValues().colWasChanged(n2)) {
                databaseCompoundType.removeFieldAt(string2);
            } else {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", " + string);
                }
                int n3 = string2.lastIndexOf(".");
                string2 = string2.substring(n3 + 1);
                stringBuffer.append(String.valueOf(string2) + string);
            }
            ++n2;
        }
        stringBuffer.append(") VALUES (");
        bl = true;
        n2 = 1;
        while (n2 <= databaseCompoundType.size()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(" ?");
            ++n2;
        }
        stringBuffer.append(" )");
        databaseQuerySpec = new DatabaseQuerySpec(new String(stringBuffer));
        databaseQuerySpec.setHostVarShape(databaseCompoundType);
        return databaseQuerySpec;
    }

    protected String generatePositionedDeleteSQL() throws com.ibm.db.DataException {
        this.metaData.getTables();
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append("DELETE FROM ");
        stringBuffer.append(this.generateTableName());
        stringBuffer.append(" WHERE CURRENT OF ");
        try {
            stringBuffer.append(this.singleRowResult.getCursorName());
        }
        catch (SQLException sQLException) {
            StatementResult.handleSQLException(sQLException);
        }
        return new String(stringBuffer);
    }

    protected DatabaseRow generatePositionedUpdateHostVars(DatabaseQuerySpec databaseQuerySpec, DatabaseRow databaseRow, DatabaseRow databaseRow2) {
        DatabaseCompoundType databaseCompoundType = databaseQuerySpec.getHostVarShape();
        DatabaseRow databaseRow3 = new DatabaseRow(databaseCompoundType);
        int n = 1;
        int n2 = 1;
        while (n2 <= databaseRow.size()) {
            if (databaseRow.colWasChanged(n2)) {
                databaseRow3.putAtIndex(n, databaseRow.getAtIndex(n2));
                databaseRow3.setColWasChanged(n, true);
                ++n;
            }
            ++n2;
        }
        return databaseRow3;
    }

    protected DatabaseQuerySpec generatePositionedUpdateSpec(StatementResultRow statementResultRow) throws com.ibm.db.DataException {
        this.metaData.getTables();
        boolean bl = true;
        DatabaseCompoundType databaseCompoundType = null;
        DatabaseQuerySpec databaseQuerySpec = null;
        int n = this.statement.getMetaData().getSQL().length() * 2;
        StringBuffer stringBuffer = new StringBuffer(n);
        String string = "";
        if (!this.statement.getConnection().supportsMixedCaseIdentifiers && this.statement.getConnection().supportsMixedCaseQuotedIdentifiers) {
            string = "\"";
        }
        try {
            databaseCompoundType = new DatabaseCompoundType(this.statement.getMetaData().getColumnShape());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        stringBuffer.append("UPDATE ");
        stringBuffer.append(this.generateTableName());
        stringBuffer.append(" SET " + string);
        Enumeration enumeration = this.columnNames();
        int n2 = 1;
        while (n2 <= this.getColumnCount()) {
            String string2 = (String)enumeration.nextElement();
            if (!statementResultRow.getCurrentColumnValues().colWasChanged(n2)) {
                databaseCompoundType.removeFieldAt(string2);
            } else {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", " + string);
                }
                int n3 = string2.lastIndexOf(".");
                string2 = string2.substring(n3 + 1);
                stringBuffer.append(string2);
                stringBuffer.append(String.valueOf(string) + " = ?");
            }
            ++n2;
        }
        if (databaseCompoundType.size() == 0) {
            return null;
        }
        stringBuffer.append(" WHERE CURRENT OF ");
        try {
            stringBuffer.append(this.singleRowResult.getCursorName());
        }
        catch (SQLException sQLException) {
            StatementResult.handleSQLException(sQLException);
        }
        databaseQuerySpec = new DatabaseQuerySpec(new String(stringBuffer));
        databaseQuerySpec.setHostVarShape(databaseCompoundType);
        return databaseQuerySpec;
    }

    protected DatabaseQuerySpec generateSearchedDeleteSpec(StatementResultRow statementResultRow) throws com.ibm.db.DataException {
        Object object;
        int n;
        Object object2;
        String string;
        DatabaseQuerySpec databaseQuerySpec = null;
        boolean bl = true;
        DatabaseCompoundType databaseCompoundType = null;
        int n2 = this.metaData.getSQL().length() * 2;
        StringBuffer stringBuffer = new StringBuffer(n2);
        String string2 = "";
        if (!this.statement.getConnection().supportsMixedCaseIdentifiers && this.statement.getConnection().supportsMixedCaseQuotedIdentifiers) {
            string2 = "\"";
        }
        databaseCompoundType = new DatabaseCompoundType();
        DatabaseRow databaseRow = null;
        databaseRow = statementResultRow.getPreviousColumnValues() == null ? statementResultRow.getCurrentColumnValues() : statementResultRow.getPreviousColumnValues();
        stringBuffer.append("DELETE FROM ");
        stringBuffer.append(this.generateTableName());
        stringBuffer.append(" WHERE ");
        bl = true;
        Enumeration enumeration = this.columnNames();
        int n3 = 0;
        while (n3 < this.getColumnCount()) {
            string = (String)enumeration.nextElement();
            object2 = databaseRow.getType().fieldAt(n3 + 1);
            if (((DatabaseTypeField)object2).isSearchable()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(" AND ");
                }
                n = string.lastIndexOf(".");
                string = string.substring(n + 1);
                object = databaseRow.getAtIndex(n3 + 1);
                if (object == null) {
                    stringBuffer.append(String.valueOf(string2) + string + string2 + " IS NULL");
                } else {
                    if (this.statement.areDistinctTypesEnabled()) {
                        stringBuffer.append(this.generateCast(string, n3 + 1));
                    } else {
                        stringBuffer.append(String.valueOf(string2) + string + string2);
                    }
                    stringBuffer.append(" = ?");
                    try {
                        databaseCompoundType.addField((DatabaseTypeField)((DatabaseTypeField)object2).clone());
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {}
                }
            }
            ++n3;
        }
        if (bl) {
            enumeration = this.columnNames();
            n3 = 0;
            while (n3 < this.getColumnCount()) {
                string = (String)enumeration.nextElement();
                object2 = databaseRow.getType().fieldAt(n3 + 1);
                if (((DatabaseTypeField)object2).getSQLType() != -4 && ((DatabaseTypeField)object2).getSQLType() != -1) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuffer.append(" AND ");
                    }
                    n = string.lastIndexOf(".");
                    string = string.substring(n + 1);
                    object = databaseRow.getAtIndex(n3 + 1);
                    if (object == null) {
                        stringBuffer.append(String.valueOf(string2) + string + string2 + " IS NULL");
                    } else {
                        if (this.statement.areDistinctTypesEnabled()) {
                            stringBuffer.append(this.generateCast(string, n3 + 1));
                        } else {
                            stringBuffer.append(String.valueOf(string2) + string + string2);
                        }
                        stringBuffer.append(" = ?");
                        try {
                            databaseCompoundType.addField((DatabaseTypeField)((DatabaseTypeField)object2).clone());
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {}
                    }
                }
                ++n3;
            }
        }
        if (bl) {
            object2 = Utilities.logMessage(IBMDBMessages.noSearchableColumns);
            throw new com.ibm.db.DataException((String)object2, 249);
        }
        databaseQuerySpec = new DatabaseQuerySpec(new String(stringBuffer));
        databaseQuerySpec.setHostVarShape(databaseCompoundType);
        return databaseQuerySpec;
    }

    protected DatabaseRow generateSearchedUpdateHostVars(DatabaseQuerySpec databaseQuerySpec, DatabaseRow databaseRow, DatabaseRow databaseRow2) {
        DatabaseCompoundType databaseCompoundType = databaseQuerySpec.getHostVarShape();
        DatabaseRow databaseRow3 = new DatabaseRow(databaseCompoundType);
        int n = 1;
        int n2 = 1;
        while (n2 <= databaseRow.size()) {
            if (databaseRow.colWasChanged(n2)) {
                databaseRow3.putAtIndex(n, databaseRow.getAtIndex(n2));
                databaseRow3.setColWasChanged(n, true);
                ++n;
            }
            ++n2;
        }
        n2 = n;
        while (n2 <= databaseCompoundType.size()) {
            String string = databaseCompoundType.fieldAt(n2).getName();
            string = string.substring(0, string.length() - 6);
            Object object = databaseRow2.get(string);
            databaseRow3.putAtIndex(n2, object);
            databaseRow3.setColWasChanged(n2, true);
            ++n2;
        }
        return databaseRow3;
    }

    protected DatabaseQuerySpec generateSearchedUpdateSpec(StatementResultRow statementResultRow) throws com.ibm.db.DataException {
        DatabaseTypeField databaseTypeField;
        Object object;
        Object object2;
        int n;
        String string;
        DatabaseQuerySpec databaseQuerySpec = null;
        this.metaData.getTables();
        DatabaseCompoundType databaseCompoundType = null;
        boolean bl = true;
        int n2 = this.statement.getMetaData().getSQL().length() * 2;
        StringBuffer stringBuffer = new StringBuffer(n2);
        String string2 = "";
        if (!this.statement.getConnection().supportsMixedCaseIdentifiers && this.statement.getConnection().supportsMixedCaseQuotedIdentifiers) {
            string2 = "\"";
        }
        try {
            databaseCompoundType = new DatabaseCompoundType(this.statement.getMetaData().getColumnShape());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        DatabaseRow databaseRow = null;
        databaseRow = statementResultRow.getPreviousColumnValues() == null ? statementResultRow.getCurrentColumnValues() : statementResultRow.getPreviousColumnValues();
        stringBuffer.append("UPDATE ");
        stringBuffer.append(this.generateTableName());
        stringBuffer.append(" SET " + string2);
        Enumeration enumeration = this.columnNames();
        bl = true;
        int n3 = 1;
        while (n3 <= this.getColumnCount()) {
            string = (String)enumeration.nextElement();
            if (!statementResultRow.getCurrentColumnValues().colWasChanged(n3)) {
                databaseCompoundType.removeFieldAt(string);
            } else {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", " + string2);
                }
                n = string.lastIndexOf(".");
                string = string.substring(n + 1);
                stringBuffer.append(string);
                stringBuffer.append(String.valueOf(string2) + " = ?");
            }
            ++n3;
        }
        if (databaseCompoundType.size() == 0) {
            return null;
        }
        stringBuffer.append(" WHERE ");
        bl = true;
        enumeration = this.columnNames();
        n3 = 0;
        while (n3 < this.getColumnCount()) {
            string = (String)enumeration.nextElement();
            object2 = databaseRow.getType().fieldAt(n3 + 1);
            if (((DatabaseTypeField)object2).isSearchable()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(" AND ");
                }
                n = string.lastIndexOf(".");
                string = string.substring(n + 1);
                object = databaseRow.getAtIndex(n3 + 1);
                if (object == null) {
                    stringBuffer.append(String.valueOf(string2) + string + string2 + " IS NULL");
                } else {
                    if (this.statement.areDistinctTypesEnabled()) {
                        stringBuffer.append(this.generateCast(string, n3 + 1));
                    } else {
                        stringBuffer.append(String.valueOf(string2) + string + string2);
                    }
                    stringBuffer.append(" = ?");
                    try {
                        databaseTypeField = (DatabaseTypeField)((DatabaseTypeField)object2).clone();
                        databaseTypeField.setName(String.valueOf(databaseTypeField.getName()) + "_WHERE");
                        databaseCompoundType.addFieldWithProposedName(databaseTypeField);
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {}
                }
            }
            ++n3;
        }
        if (bl) {
            enumeration = this.columnNames();
            n3 = 0;
            while (n3 < this.getColumnCount()) {
                string = (String)enumeration.nextElement();
                object2 = databaseRow.getType().fieldAt(n3 + 1);
                if (((DatabaseTypeField)object2).getSQLType() != -4 && ((DatabaseTypeField)object2).getSQLType() != -1) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuffer.append(" AND ");
                    }
                    n = string.lastIndexOf(".");
                    string = string.substring(n + 1);
                    object = databaseRow.getAtIndex(n3 + 1);
                    if (object == null) {
                        stringBuffer.append(String.valueOf(string2) + string + string2 + " IS NULL");
                    } else {
                        if (this.statement.areDistinctTypesEnabled()) {
                            stringBuffer.append(this.generateCast(string, n3 + 1));
                        } else {
                            stringBuffer.append(String.valueOf(string2) + string + string2);
                        }
                        stringBuffer.append(" = ?");
                        try {
                            databaseTypeField = (DatabaseTypeField)((DatabaseTypeField)object2).clone();
                            databaseTypeField.setName(String.valueOf(databaseTypeField.getName()) + "_WHERE");
                            databaseCompoundType.addFieldWithProposedName(databaseTypeField);
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {}
                    }
                }
                ++n3;
            }
        }
        if (bl) {
            object2 = Utilities.logMessage(IBMDBMessages.noSearchableColumns);
            throw new com.ibm.db.DataException((String)object2, 249);
        }
        databaseQuerySpec = new DatabaseQuerySpec(new String(stringBuffer));
        databaseQuerySpec.setHostVarShape(databaseCompoundType);
        return databaseQuerySpec;
    }

    protected DatabaseQuerySpec generateSelectSpec(DatabaseRow databaseRow) throws com.ibm.db.DataException {
        DatabaseTypeField databaseTypeField;
        Object object;
        int n;
        String string;
        DatabaseQuerySpec databaseQuerySpec = null;
        DatabaseCompoundType databaseCompoundType = new DatabaseCompoundType();
        boolean bl = true;
        int n2 = 0;
        int n3 = this.metaData.getSQL().length() * 2;
        StringBuffer stringBuffer = new StringBuffer(n3);
        String string2 = "";
        if (!this.statement.getConnection().supportsMixedCaseIdentifiers && this.statement.getConnection().supportsMixedCaseQuotedIdentifiers) {
            string2 = "\"";
        }
        stringBuffer.append("SELECT " + string2);
        Enumeration enumeration = this.columnNames();
        n2 = 0;
        while (n2 < this.getColumnCount()) {
            if (n2 > 0) {
                stringBuffer.append(String.valueOf(string2) + ", " + string2);
            }
            string = (String)enumeration.nextElement();
            n = string.lastIndexOf(".");
            string = string.substring(n + 1);
            stringBuffer.append(string);
            ++n2;
        }
        stringBuffer.append(String.valueOf(string2) + " FROM ");
        stringBuffer.append(this.generateTableName());
        stringBuffer.append(" WHERE ");
        bl = true;
        enumeration = this.columnNames();
        n2 = 0;
        while (n2 < this.getColumnCount()) {
            string = (String)enumeration.nextElement();
            if (databaseRow.getType().fieldAt(n2 + 1).isSearchable()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(" AND ");
                }
                n = string.lastIndexOf(".");
                string = string.substring(n + 1);
                object = databaseRow.getAtIndex(n2 + 1);
                if (object == null) {
                    stringBuffer.append(String.valueOf(string2) + string + string2 + " IS NULL");
                } else {
                    if (this.statement.areDistinctTypesEnabled()) {
                        stringBuffer.append(this.generateCast(string, n2 + 1));
                    } else {
                        stringBuffer.append(String.valueOf(string2) + string + string2);
                    }
                    stringBuffer.append(" = ?");
                    databaseTypeField = databaseRow.getType().fieldAt(n2 + 1);
                    databaseCompoundType.addField(databaseTypeField);
                }
            }
            ++n2;
        }
        if (bl) {
            enumeration = this.columnNames();
            n2 = 0;
            while (n2 < this.getColumnCount()) {
                string = (String)enumeration.nextElement();
                if (databaseRow.getType().fieldAt(n2 + 1).getSQLType() != -4 && databaseRow.getType().fieldAt(n2 + 1).getSQLType() != -1) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuffer.append(" AND ");
                    }
                    n = string.lastIndexOf(".");
                    string = string.substring(n + 1);
                    object = databaseRow.getAtIndex(n2 + 1);
                    if (object == null) {
                        stringBuffer.append(String.valueOf(string2) + string + string2 + " IS NULL");
                    } else {
                        if (this.statement.areDistinctTypesEnabled()) {
                            stringBuffer.append(this.generateCast(string, n2 + 1));
                        } else {
                            stringBuffer.append(String.valueOf(string2) + string + string2);
                        }
                        stringBuffer.append(" = ?");
                        databaseTypeField = databaseRow.getType().fieldAt(n2 + 1);
                        databaseCompoundType.addField(databaseTypeField);
                    }
                }
                ++n2;
            }
        }
        if (bl) {
            object = Utilities.logMessage(IBMDBMessages.noSearchableColumns);
            throw new com.ibm.db.DataException((String)object, 249);
        }
        if (!this.statement.isReadOnly()) {
            stringBuffer.append(" FOR UPDATE OF " + string2);
        }
        enumeration = this.columnNames();
        n2 = 0;
        while (n2 < this.getColumnCount()) {
            if (n2 > 0) {
                stringBuffer.append(String.valueOf(string2) + ", " + string2);
            }
            string = (String)enumeration.nextElement();
            n = string.lastIndexOf(".");
            string = string.substring(n + 1);
            stringBuffer.append(string);
            ++n2;
        }
        stringBuffer.append(string2);
        databaseQuerySpec = new DatabaseQuerySpec(new String(stringBuffer));
        databaseQuerySpec.setHostVarShape(databaseCompoundType);
        return databaseQuerySpec;
    }

    protected String generateTableName() throws com.ibm.db.DataException {
        Enumeration enumeration;
        String string = "";
        String string2 = "";
        if (!this.statement.getConnection().supportsMixedCaseIdentifiers && this.statement.getConnection().supportsMixedCaseQuotedIdentifiers) {
            string2 = "\"";
        }
        if (!(enumeration = this.statement.getMetaData().getTables()).hasMoreElements()) {
            String string3 = null;
            String string4 = " \t\n\r";
            String string5 = this.metaData.getSQL();
            StringTokenizer stringTokenizer = new StringTokenizer(string5, String.valueOf(string4) + ",", true);
            block0: while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (!string3.toUpperCase().equals("FROM")) continue;
                string3 = stringTokenizer.nextToken();
                string = String.valueOf(string) + stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    if (string3.equals(",")) {
                        String string6 = Utilities.logMessage(IBMDBMessages.multipleTables);
                        throw new com.ibm.db.DataException(string6, 218);
                    }
                    if (string4.indexOf(string3) < 0) break block0;
                }
                break block0;
            }
            if (string.equals("")) {
                String string7 = Utilities.logMessage(IBMDBMessages.noTableDefined);
                throw new com.ibm.db.DataException(string7, 250);
            }
        } else {
            String string8;
            int n = 0;
            while (enumeration.hasMoreElements()) {
                int n2;
                string = n == 0 ? String.valueOf(string) + string2 : String.valueOf(string) + string2 + ", " + string2;
                string8 = (String)enumeration.nextElement();
                int n3 = 0;
                while ((n2 = string8.indexOf(".", n3)) >= 0) {
                    string = String.valueOf(string) + string8.substring(n3, n2);
                    string = String.valueOf(string) + string2 + "." + string2;
                    n3 = n2 + 1;
                }
                string = String.valueOf(string) + string8.substring(n3);
                ++n;
            }
            if (n != 0) {
                string = String.valueOf(string) + string2;
            }
            if (n != 1) {
                string8 = Utilities.logMessage(IBMDBMessages.multipleTables);
                throw new com.ibm.db.DataException(string8, 218);
            }
        }
        return string;
    }

    public Object getCacheValueAt(int n, int n2) throws com.ibm.db.DataException {
        if (this.statement == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new com.ibm.db.DataException(string, 229);
        }
        if (!this.statement.isExecuted() && !this.statement.executing) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuted);
            throw new com.ibm.db.DataException(string, 213);
        }
        if (this.fieldCurrentRow <= 0) {
            String string = Utilities.logMessage(IBMDBMessages.noResults);
            throw new com.ibm.db.DataException(string, 214);
        }
        if (n <= 0) {
            Object[] objectArray = this.statement.isForVAJavaSelect() ? new Object[]{new Integer(n - 1)} : new Object[]{new Integer(n)};
            String string = Utilities.logMessage(IBMDBMessages.beforeCacheStart, objectArray);
            throw new com.ibm.db.DataException(string, 216);
        }
        if (n > this.fieldNumRowsInCache) {
            Object[] objectArray = this.statement.isForVAJavaSelect() ? new Object[]{new Integer(n - 1)} : new Object[]{new Integer(n)};
            String string = Utilities.logMessage(IBMDBMessages.indexTooLarge, objectArray);
            throw new com.ibm.db.DataException(string, 234);
        }
        StatementResultRow statementResultRow = (StatementResultRow)this.rows.elementAt(n - 1);
        return statementResultRow.getColumnValue(n2);
    }

    public int getColumnCount() throws com.ibm.db.DataException {
        if (this.metaData == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new com.ibm.db.DataException(string, 229);
        }
        return this.metaData.getColumnCount();
    }

    public String getColumnName(int n) throws com.ibm.db.DataException {
        if (this.metaData == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new com.ibm.db.DataException(string, 229);
        }
        return this.metaData.getColumnName(n);
    }

    public Object getColumnValue(int n) throws com.ibm.db.DataException {
        StatementResultRow statementResultRow = this.getCurrentRowObject();
        return statementResultRow.getColumnValue(n);
    }

    public Object getColumnValue(String string) throws com.ibm.db.DataException {
        StatementResultRow statementResultRow = this.getCurrentRowObject();
        return statementResultRow.getColumnValue(string);
    }

    public String getColumnValueToString(int n) throws com.ibm.db.DataException {
        String string = null;
        Object object = this.getColumnValue(n);
        if (object == null) {
            string = null;
            return string;
        }
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            try {
                clazz2 = class$java$lang$String = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            string = (String)object;
        } else {
            Class<?> clazz3 = class$java$lang$Integer;
            if (clazz3 == null) {
                try {
                    clazz3 = class$java$lang$Integer = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz3) {
                string = ((Integer)object).toString();
            } else {
                Class<?> clazz4 = class$java$lang$Long;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$java$lang$Long = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz4) {
                    string = ((Long)object).toString();
                } else {
                    Class<?> clazz5 = class$java$lang$Short;
                    if (clazz5 == null) {
                        try {
                            clazz5 = class$java$lang$Short = Class.forName("java.lang.Short");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz == clazz5) {
                        string = ((Short)object).toString();
                    } else {
                        Class<?> clazz6 = class$java$math$BigDecimal;
                        if (clazz6 == null) {
                            try {
                                clazz6 = class$java$math$BigDecimal = Class.forName("java.math.BigDecimal");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz == clazz6) {
                            string = ((BigDecimal)object).toString();
                        } else {
                            Class<?> clazz7 = class$java$lang$Float;
                            if (clazz7 == null) {
                                try {
                                    clazz7 = class$java$lang$Float = Class.forName("java.lang.Float");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (clazz == clazz7) {
                                string = ((Float)object).toString();
                            } else {
                                Class<?> clazz8 = class$java$lang$Double;
                                if (clazz8 == null) {
                                    try {
                                        clazz8 = class$java$lang$Double = Class.forName("java.lang.Double");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (clazz == clazz8) {
                                    string = ((Double)object).toString();
                                } else {
                                    Class<?> clazz9 = class$java$lang$Boolean;
                                    if (clazz9 == null) {
                                        try {
                                            clazz9 = class$java$lang$Boolean = Class.forName("java.lang.Boolean");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (clazz == clazz9) {
                                        string = ((Boolean)object).toString();
                                    } else {
                                        Class<?> clazz10 = class$java$sql$Date;
                                        if (clazz10 == null) {
                                            try {
                                                clazz10 = class$java$sql$Date = Class.forName("java.sql.Date");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (clazz == clazz10) {
                                            string = ((Date)object).toString();
                                        } else {
                                            Class<?> clazz11 = class$java$sql$Time;
                                            if (clazz11 == null) {
                                                try {
                                                    clazz11 = class$java$sql$Time = Class.forName("java.sql.Time");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            if (clazz == clazz11) {
                                                string = ((Time)object).toString();
                                            } else {
                                                Class<?> clazz12 = class$java$sql$Timestamp;
                                                if (clazz12 == null) {
                                                    try {
                                                        clazz12 = class$java$sql$Timestamp = Class.forName("java.sql.Timestamp");
                                                    }
                                                    catch (ClassNotFoundException classNotFoundException) {
                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                    }
                                                }
                                                if (clazz == clazz12) {
                                                    string = ((Timestamp)object).toString();
                                                } else {
                                                    Class<?> clazz13 = class$array1$$byte;
                                                    if (clazz13 == null) {
                                                        try {
                                                            clazz13 = class$array1$$byte = Class.forName("[B");
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                        }
                                                    }
                                                    if (clazz == clazz13) {
                                                        byte[] byArray = (byte[])object;
                                                        StringBuffer stringBuffer = new StringBuffer(byArray.length);
                                                        int n2 = 0;
                                                        while (n2 < byArray.length) {
                                                            String string2;
                                                            int n3 = byArray[n2];
                                                            if (n3 < 0) {
                                                                n3 &= 0xFF;
                                                            }
                                                            if ((string2 = Integer.toString(n3, 16)).length() == 1) {
                                                                stringBuffer.append("0");
                                                            }
                                                            stringBuffer.append(string2);
                                                            ++n2;
                                                        }
                                                        string = new String(stringBuffer);
                                                    } else {
                                                        string = object.toString();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return string;
    }

    public String getColumnValueToString(String string) throws com.ibm.db.DataException {
        if (this.statement == null) {
            String string2 = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new com.ibm.db.DataException(string2, 229);
        }
        return this.getColumnValueToString(this.metaData.getColumnIndex(string));
    }

    public int getCurrentRow() {
        return this.fieldCurrentRow;
    }

    public int getCurrentRowInCache() {
        return this.fieldCurrentRowInCache;
    }

    protected StatementResultRow getCurrentRowObject() throws com.ibm.db.DataException {
        if (this.statement == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new com.ibm.db.DataException(string, 229);
        }
        if (!this.statement.isExecuted() && !this.statement.executing) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuted);
            throw new com.ibm.db.DataException(string, 213);
        }
        if (this.fieldCurrentRow <= 0) {
            String string = Utilities.logMessage(IBMDBMessages.noResults);
            throw new com.ibm.db.DataException(string, 214);
        }
        if (this.fieldCurrentRowInCache <= 0) {
            Object[] objectArray = this.statement.isForVAJavaSelect() ? new Object[]{new Integer(this.fieldCurrentRow - 1)} : new Object[]{new Integer(this.fieldCurrentRow)};
            String string = Utilities.logMessage(IBMDBMessages.beforeCacheStart, objectArray);
            throw new com.ibm.db.DataException(string, 216);
        }
        return (StatementResultRow)this.rows.elementAt(this.fieldCurrentRowInCache - 1);
    }

    public int getNumPacketsInCache() {
        return this.fieldNumPacketsInCache;
    }

    public int getNumRowsInCache() {
        return this.fieldNumRowsInCache;
    }

    protected synchronized void initialize() throws com.ibm.db.DataException {
        this.statement.getConnection().getConnection();
        int n = 0;
        if (this.statement.getPacketSize() == 0) {
            n = 40;
            this.rows = new Vector(n);
        } else {
            n = this.statement.getMaximumPacketsInCache() == 0 ? this.statement.getPacketSize() : this.statement.getPacketSize() * this.statement.getMaximumPacketsInCache();
            this.rows = new Vector(n, this.statement.getPacketSize());
        }
        if (!this.statement.isReadOnly()) {
            this.changes = new Vector(n / 4);
        }
        this.fieldNumRows = 0;
        this.fieldNumRowsInCache = 0;
        this.fieldNumPacketsInCache = 0;
        this.fieldCurrentRow = 0;
        this.fieldCurrentRowInCache = 0;
        this.singleRowResult = null;
        this.moreRows = true;
        try {
            if (!this.rt.next()) {
                this.moreRows = false;
            }
        }
        catch (SQLException sQLException) {
            StatementResult.handleSQLException(sQLException);
        }
    }

    public boolean isEnd() {
        return this.fieldCurrentRow >= this.fieldNumRows && !this.moreRows;
    }

    public boolean isMaxRowsReached() throws com.ibm.db.DataException {
        if (this.statement == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new com.ibm.db.DataException(string, 229);
        }
        if (this.statement.getMaximumRows() == 0) {
            return false;
        }
        return this.fieldNumRows >= this.statement.getMaximumRows();
    }

    public boolean isRowLocked() {
        return this.singleRowResult != null && this.singleRowResult.isOpen();
    }

    public synchronized void lastRow() throws com.ibm.db.DataException {
        boolean bl = false;
        if (this.statement == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new com.ibm.db.DataException(string, 229);
        }
        if (!this.statement.isExecuted()) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuted);
            throw new com.ibm.db.DataException(string, 213);
        }
        if (this.fieldCurrentRowInCache <= 0) {
            String string = Utilities.logMessage(IBMDBMessages.noResults);
            throw new com.ibm.db.DataException(string, 214);
        }
        if (this.isEnd()) {
            return;
        }
        int n = this.fieldCurrentRow;
        int n2 = this.fieldCurrentRowInCache;
        this.updateRowBeforeLeaving();
        while (this.moreRows) {
            this.fetchNextPacket();
            bl = true;
        }
        this.fieldCurrentRow = this.fieldNumRows;
        this.fieldCurrentRowInCache = this.fieldNumRowsInCache;
        this.firePropertyChange("currentRow", new Integer(n), new Integer(this.fieldCurrentRow));
        this.firePropertyChange("currentRowInCache", new Integer(n2), new Integer(this.fieldCurrentRowInCache));
        if (this.statement != null && this.statement.isLockRows()) {
            this.lockRow();
        }
        if (bl) {
            this.fireCacheRowsChanged(new DataEvent(this, 4));
        }
    }

    public synchronized void lockRow() throws com.ibm.db.DataException {
        StatementResultRow statementResultRow = this.getCurrentRowObject();
        this.checkConnection();
        if (this.statement.isReadOnly()) {
            Object[] objectArray = new Object[]{"lockRow"};
            String string = Utilities.logMessage(IBMDBMessages.readOnly, objectArray);
            throw new com.ibm.db.DataException(string, 215);
        }
        if (this.deferUpdates) {
            return;
        }
        DatabaseConnection databaseConnection = this.statement.getConnection();
        if (databaseConnection.databaseName.equals("Microsoft SQL Server") || databaseConnection.databaseName.equals("SQL Server") || databaseConnection.databaseName.equals("Sybase SQL Server") || !databaseConnection.supportsPositionedUpdate) {
            Object[] objectArray = new Object[]{databaseConnection.databaseName};
            String string = Utilities.logMessage(IBMDBMessages.lockNotSupported, objectArray);
            throw new com.ibm.db.DataException(string, 238);
        }
        this.applyLock(statementResultRow);
    }

    public synchronized void newRow(boolean bl) throws com.ibm.db.DataException {
        int n;
        int n2;
        if (this.statement == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new com.ibm.db.DataException(string, 229);
        }
        if (!this.statement.isExecuted()) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuted);
            throw new com.ibm.db.DataException(string, 213);
        }
        if (this.statement.isReadOnly()) {
            Object[] objectArray = new Object[]{"newRow"};
            String string = Utilities.logMessage(IBMDBMessages.readOnly, objectArray);
            throw new com.ibm.db.DataException(string, 215);
        }
        if (this.isMaxRowsReached()) {
            String string = Utilities.logMessage(IBMDBMessages.maxSize);
            throw new com.ibm.db.DataException(string, 235);
        }
        this.updateRowBeforeLeaving();
        this.fireAboutToAddNewRow(new DataEvent(this));
        DatabaseCompoundType databaseCompoundType = null;
        if (this.fieldCurrentRowInCache == 0) {
            try {
                databaseCompoundType = new DatabaseCompoundType(this.metaData.getColumnShape());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
            n2 = this.fieldCurrentRow + 1;
            n = this.fieldCurrentRowInCache + 1;
        } else if (bl) {
            databaseCompoundType = this.getCurrentRowObject().getCurrentColumnValues().getType();
            n2 = this.fieldCurrentRow++;
            n = this.fieldCurrentRowInCache++;
        } else {
            databaseCompoundType = this.getCurrentRowObject().getCurrentColumnValues().getType();
            n2 = this.fieldCurrentRow + 1;
            n = this.fieldCurrentRowInCache + 1;
        }
        ++this.fieldNumRows;
        ++this.fieldNumRowsInCache;
        DatabaseRow databaseRow = new DatabaseRow(databaseCompoundType);
        StatementResultRow statementResultRow = new StatementResultRow(databaseRow);
        statementResultRow.setStatus(2);
        statementResultRow.setInDatabase(false);
        this.rows.insertElementAt(statementResultRow, n - 1);
        this.fireAddedNewRow(new DataEvent(this));
        this.fireCacheRowsChanged(new DataEvent(this, 3));
        this.setCurrentRow(n2);
    }

    public synchronized void nextPacket() throws com.ibm.db.DataException {
        int n = this.fieldCurrentRowInCache;
        if (this.statement == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new com.ibm.db.DataException(string, 229);
        }
        if (!this.statement.isExecuted()) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuted);
            throw new com.ibm.db.DataException(string, 213);
        }
        if (this.fieldCurrentRowInCache <= 0) {
            String string = Utilities.logMessage(IBMDBMessages.noResults);
            throw new com.ibm.db.DataException(string, 214);
        }
        if (!this.isOpen()) {
            String string = Utilities.logMessage(IBMDBMessages.notOpen);
            throw new com.ibm.db.DataException(string, 207);
        }
        this.fetchNextPacket();
        if (this.fieldCurrentRowInCache < 1) {
            int n2 = this.fieldCurrentRow;
            this.fieldCurrentRow = this.fieldCurrentRow - this.fieldCurrentRowInCache + 1;
            this.fieldCurrentRowInCache = 1;
            this.firePropertyChange("currentRow", new Integer(n2), new Integer(this.fieldCurrentRow));
            this.firePropertyChange("currentRowInCache", new Integer(n), new Integer(this.fieldCurrentRowInCache));
            if (this.statement != null && this.statement.isLockRows()) {
                this.lockRow();
            }
        }
        this.fireCacheRowsChanged(new DataEvent(this, 4));
    }

    public void nextRow() throws com.ibm.db.DataException {
        this.nextOrPrev = true;
        try {
            this.setCurrentRow(this.fieldCurrentRow + 1);
        }
        catch (com.ibm.db.DataException dataException) {
            this.nextOrPrev = false;
            throw dataException;
        }
        this.nextOrPrev = false;
    }

    public void previousRow() throws com.ibm.db.DataException {
        this.nextOrPrev = true;
        try {
            this.setCurrentRow(this.fieldCurrentRow - 1);
        }
        catch (com.ibm.db.DataException dataException) {
            this.nextOrPrev = false;
            throw dataException;
        }
        this.nextOrPrev = false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.propertyChange = new PropertyChangeSupport(this);
        this.dataChangesPending = false;
        this.moreRows = false;
        this.leavingRow = false;
        this.nextOrPrev = false;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChange.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeStatementResultValueChangeListener(StatementResultValueChangeListener statementResultValueChangeListener) {
        this.aStatementResultValueChangeListener = StatementResultValueChangeEventMulticaster.remove(this.aStatementResultValueChangeListener, statementResultValueChangeListener);
    }

    protected synchronized void restoreChanges() {
        StatementResultRow statementResultRow = null;
        try {
            while (true) {
                statementResultRow = (StatementResultRow)this.changes.lastElement();
                switch (statementResultRow.getAction()) {
                    case 1: 
                    case 3: {
                        this.restoreUpdate(statementResultRow);
                        break;
                    }
                    case 2: {
                        this.restoreDelete(statementResultRow);
                        break;
                    }
                }
                this.changes.removeElementAt(0);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    protected void restoreDelete(StatementResultRow statementResultRow) {
        int n = statementResultRow.getNumberWhenChanged();
        statementResultRow.setAction(0);
        this.rows.insertElementAt(statementResultRow, n - 1);
    }

    public void restoreRow() throws com.ibm.db.DataException {
        String string = null;
        Object object = null;
        Object object2 = null;
        StatementResultRow statementResultRow = this.getCurrentRowObject();
        if (this.statement.isReadOnly()) {
            Object[] objectArray = new Object[]{"restoreRow"};
            String string2 = Utilities.logMessage(IBMDBMessages.readOnly, objectArray);
            throw new com.ibm.db.DataException(string2, 215);
        }
        if (statementResultRow.getStatus() == 1) {
            if (this.statement != null && this.statement.isReadOnly()) {
                Object[] objectArray = new Object[]{"restoreRow"};
                String string3 = Utilities.logMessage(IBMDBMessages.readOnly, objectArray);
                throw new com.ibm.db.DataException(string3, 215);
            }
            DatabaseRow databaseRow = statementResultRow.getCurrentColumnValues();
            int n = 1;
            while (n <= this.getColumnCount()) {
                if (databaseRow.colWasChanged(n)) {
                    string = this.getColumnName(n);
                    object = statementResultRow.getColumnValue(n);
                    object2 = statementResultRow.getPreviousColumnValue(n);
                    this.fireAboutToSetColumnValue(new PropertyChangeEvent(this, string, object, object2));
                }
                ++n;
            }
            statementResultRow.restore();
            n = 1;
            while (n <= this.getColumnCount()) {
                if (databaseRow.colWasChanged(n)) {
                    string = this.getColumnName(n);
                    object = databaseRow.getAtIndex(n);
                    object2 = statementResultRow.getColumnValue(n);
                    this.fireColumnValueSet(new PropertyChangeEvent(this, string, object, object2));
                }
                ++n;
            }
        }
    }

    protected void restoreUpdate(StatementResultRow statementResultRow) {
        int n = statementResultRow.getNumberWhenChanged();
        statementResultRow.setAction(0);
        this.rows.removeElementAt(n - 1);
        this.rows.insertElementAt(statementResultRow, n - 1);
    }

    public synchronized void setColumnValue(int n, Object object) throws com.ibm.db.DataException {
        String string = this.getColumnName(n);
        Object object2 = this.getColumnValue(n);
        if (this.statement.isReadOnly()) {
            Object[] objectArray = new Object[]{"setColumnValue"};
            String string2 = Utilities.logMessage(IBMDBMessages.readOnly, objectArray);
            throw new com.ibm.db.DataException(string2, 215);
        }
        this.fireAboutToSetColumnValue(new PropertyChangeEvent(this, string, object2, object));
        StatementResultRow statementResultRow = this.getCurrentRowObject();
        try {
            statementResultRow.setColumnValue(n, object);
        }
        catch (DataException dataException) {
            String string3 = Utilities.logBaseException(dataException, this.statement.isForVAJavaSelect());
            throw new com.ibm.db.DataException(string3, dataException.getErrorCode());
        }
        this.fireColumnValueSet(new PropertyChangeEvent(this, string, object2, object));
    }

    public void setColumnValue(String string, Object object) throws com.ibm.db.DataException {
        if (this.statement == null) {
            String string2 = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new com.ibm.db.DataException(string2, 229);
        }
        int n = this.metaData.getColumnIndex(string);
        this.setColumnValue(n, object);
    }

    public void setColumnValueFromString(int n, String string) throws com.ibm.db.DataException {
        Class clazz;
        block85: {
            block84: {
                if (this.statement == null) {
                    String string2 = Utilities.logMessage(IBMDBMessages.noStatement);
                    throw new com.ibm.db.DataException(string2, 229);
                }
                if (this.statement.isReadOnly()) {
                    Object[] objectArray = new Object[]{"setColumnValue"};
                    String string3 = Utilities.logMessage(IBMDBMessages.readOnly, objectArray);
                    throw new com.ibm.db.DataException(string3, 215);
                }
                clazz = this.metaData.getColumnClass(n);
                if (string == null) break block84;
                Class<?> clazz2 = class$java$lang$String;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$java$lang$String = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz2 || string.length() != 0) break block85;
            }
            this.setColumnValue(n, null);
            return;
        }
        Class<?> clazz3 = class$java$lang$String;
        if (clazz3 == null) {
            try {
                clazz3 = class$java$lang$String = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz3) {
            this.setColumnValue(n, (Object)string);
        } else {
            Class<?> clazz4 = class$java$lang$Integer;
            if (clazz4 == null) {
                try {
                    clazz4 = class$java$lang$Integer = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz4) {
                this.setColumnValue(n, (Object)new Integer(string));
            } else {
                Class<?> clazz5 = class$java$lang$Long;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$java$lang$Long = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz5) {
                    this.setColumnValue(n, (Object)new Long(string));
                } else {
                    Class<?> clazz6 = class$java$lang$Short;
                    if (clazz6 == null) {
                        try {
                            clazz6 = class$java$lang$Short = Class.forName("java.lang.Short");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz == clazz6) {
                        this.setColumnValue(n, (Object)new Short(string));
                    } else {
                        Class<?> clazz7 = class$java$math$BigDecimal;
                        if (clazz7 == null) {
                            try {
                                clazz7 = class$java$math$BigDecimal = Class.forName("java.math.BigDecimal");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz == clazz7) {
                            this.setColumnValue(n, (Object)new BigDecimal(string));
                        } else {
                            Class<?> clazz8 = class$java$lang$Float;
                            if (clazz8 == null) {
                                try {
                                    clazz8 = class$java$lang$Float = Class.forName("java.lang.Float");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (clazz == clazz8) {
                                this.setColumnValue(n, (Object)new Float(string));
                            } else {
                                Class<?> clazz9 = class$java$lang$Double;
                                if (clazz9 == null) {
                                    try {
                                        clazz9 = class$java$lang$Double = Class.forName("java.lang.Double");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (clazz == clazz9) {
                                    this.setColumnValue(n, (Object)new Double(string));
                                } else {
                                    Class<?> clazz10 = class$java$lang$Boolean;
                                    if (clazz10 == null) {
                                        try {
                                            clazz10 = class$java$lang$Boolean = Class.forName("java.lang.Boolean");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if (clazz == clazz10) {
                                        this.setColumnValue(n, (Object)Boolean.valueOf(string));
                                    } else {
                                        Class<?> clazz11 = class$java$sql$Date;
                                        if (clazz11 == null) {
                                            try {
                                                clazz11 = class$java$sql$Date = Class.forName("java.sql.Date");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if (clazz == clazz11) {
                                            this.setColumnValue(n, (Object)Date.valueOf(string));
                                        } else {
                                            Class<?> clazz12 = class$java$sql$Time;
                                            if (clazz12 == null) {
                                                try {
                                                    clazz12 = class$java$sql$Time = Class.forName("java.sql.Time");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            if (clazz == clazz12) {
                                                this.setColumnValue(n, (Object)Time.valueOf(string));
                                            } else {
                                                Class<?> clazz13 = class$java$sql$Timestamp;
                                                if (clazz13 == null) {
                                                    try {
                                                        clazz13 = class$java$sql$Timestamp = Class.forName("java.sql.Timestamp");
                                                    }
                                                    catch (ClassNotFoundException classNotFoundException) {
                                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                    }
                                                }
                                                if (clazz == clazz13) {
                                                    this.setColumnValue(n, (Object)Timestamp.valueOf(string));
                                                } else {
                                                    Class<?> clazz14 = class$array1$$byte;
                                                    if (clazz14 == null) {
                                                        try {
                                                            clazz14 = class$array1$$byte = Class.forName("[B");
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                        }
                                                    }
                                                    if (clazz == clazz14) {
                                                        if (string.length() % 2 != 0) {
                                                            String string4 = Utilities.logMessage(IBMDBMessages.cannotConvert);
                                                            throw new com.ibm.db.DataException(string4, 222);
                                                        }
                                                        byte[] byArray = new byte[string.length() / 2];
                                                        int n2 = 0;
                                                        while (n2 < byArray.length) {
                                                            int n3 = n2 * 2;
                                                            byte by = Byte.parseByte(string.substring(n3, n3 + 1), 16);
                                                            byte by2 = Byte.parseByte(string.substring(n3 + 1, n3 + 2), 16);
                                                            byArray[n2] = (byte)(by * 16 + by2);
                                                            ++n2;
                                                        }
                                                        this.setColumnValue(n, (Object)byArray);
                                                    } else {
                                                        String string5 = Utilities.logMessage(IBMDBMessages.cannotConvert);
                                                        throw new com.ibm.db.DataException(string5, 222);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public void setColumnValueFromString(String string, String string2) throws com.ibm.db.DataException {
        if (this.statement == null) {
            String string3 = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new com.ibm.db.DataException(string3, 229);
        }
        int n = this.metaData.getColumnIndex(string);
        this.setColumnValueFromString(n, string2);
    }

    public synchronized void setCurrentRow(int n) throws com.ibm.db.DataException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.statement == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new com.ibm.db.DataException(string, 229);
        }
        if (!this.statement.isExecuted() && !this.statement.executing) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuted);
            throw new com.ibm.db.DataException(string, 213);
        }
        if (this.statement.getConnection() == null || !this.statement.getConnection().isConnected()) {
            this.statement.disconnect();
        }
        int n2 = n;
        Integer n3 = new Integer(this.fieldCurrentRow);
        Integer n4 = new Integer(this.fieldCurrentRowInCache);
        if (this.fieldCurrentRow == 0 && this.statement.executing) {
            n3 = null;
            n4 = null;
        }
        int n5 = this.fieldCurrentRow - this.fieldCurrentRowInCache + 1;
        int n6 = n5 + this.fieldNumRowsInCache - 1;
        if (n != this.fieldCurrentRow) {
            this.updateRowBeforeLeaving();
        }
        if (n < n5) {
            bl2 = true;
            n = n5;
        }
        boolean bl4 = this.statement.isFillCacheOnExecute();
        int n7 = this.statement.getMaximumPacketsInCache();
        if (n7 == 0) {
            n7 = Integer.MAX_VALUE;
        }
        while (this.moreRows && (n > n6 || bl4 && this.fieldNumPacketsInCache < n7)) {
            this.fetchNextPacket();
            bl = true;
            n5 = this.fieldCurrentRow - this.fieldCurrentRowInCache + 1;
            n6 = n5 + this.fieldNumRowsInCache - 1;
        }
        if (this.statement != null && this.statement.isLockRows()) {
            this.lockRow();
        }
        if (n > n6) {
            bl3 = true;
            this.fieldCurrentRow = this.fieldNumRows;
            this.fieldCurrentRowInCache = this.fieldNumRowsInCache;
        } else {
            int n8 = this.fieldCurrentRow - n;
            this.fieldCurrentRow = n;
            this.fieldCurrentRowInCache -= n8;
        }
        if (bl || this.fieldCurrentRow == 0 && this.statement.executing) {
            this.fireCacheRowsChanged(new DataEvent(this, 4));
        }
        this.firePropertyChange("currentRow", n3, new Integer(this.fieldCurrentRow));
        this.firePropertyChange("currentRowInCache", n4, new Integer(this.fieldCurrentRowInCache));
        if (bl2 || n == 0) {
            if (this.fieldNumRows == 0) {
                String string = Utilities.logMessage(IBMDBMessages.noResults);
                throw new com.ibm.db.DataException(string, 214);
            }
            if (!this.nextOrPrev || this.fieldCurrentRow != 1) {
                Object[] objectArray = this.statement.isForVAJavaSelect() ? new Object[]{new Integer(n2 - 1)} : new Object[]{new Integer(n2)};
                String string = Utilities.logMessage(IBMDBMessages.beforeCacheStart, objectArray);
                throw new com.ibm.db.DataException(string, 216);
            }
        }
        if (bl3) {
            if (this.fieldNumRows == 0) {
                String string = Utilities.logMessage(IBMDBMessages.noResults);
                throw new com.ibm.db.DataException(string, 214);
            }
            if (!this.nextOrPrev) {
                Object[] objectArray = this.statement.isForVAJavaSelect() ? new Object[]{new Integer(n2 - 1)} : new Object[]{new Integer(n2)};
                String string = Utilities.logMessage(IBMDBMessages.indexTooLarge, objectArray);
                throw new com.ibm.db.DataException(string, 234);
            }
        }
    }

    protected void setCurrentRowInCache(int n) {
        int n2 = this.fieldCurrentRowInCache;
        this.fieldCurrentRowInCache = n;
        this.firePropertyChange("currentRowInCache", new Integer(n2), new Integer(this.fieldCurrentRowInCache));
    }

    public void setStatement(SelectStatement selectStatement) {
        this.statement = selectStatement;
        if (selectStatement != null) {
            this.metaData = selectStatement.getMetaData();
        }
    }

    public void unlockRow() throws com.ibm.db.DataException {
        if (this.statement == null) {
            String string = Utilities.logMessage(IBMDBMessages.noStatement);
            throw new com.ibm.db.DataException(string, 229);
        }
        if (!this.statement.isExecuted()) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuted);
            throw new com.ibm.db.DataException(string, 213);
        }
        if (this.fieldCurrentRowInCache <= 0) {
            String string = Utilities.logMessage(IBMDBMessages.noResults);
            throw new com.ibm.db.DataException(string, 214);
        }
        if (!this.isRowLocked()) {
            return;
        }
        this.checkConnection();
        if (this.statement.isReadOnly()) {
            Object[] objectArray = new Object[]{"unlockRow"};
            String string = Utilities.logMessage(IBMDBMessages.readOnly, objectArray);
            throw new com.ibm.db.DataException(string, 215);
        }
        try {
            this.singleRowResult.closeStatement();
            this.singleRowResult = null;
        }
        catch (SQLException sQLException) {
            StatementResult.handleSQLException(sQLException);
        }
    }

    public synchronized void updateRow() throws com.ibm.db.DataException {
        StatementResultRow statementResultRow = this.getCurrentRowObject();
        if (statementResultRow.getStatus() == 2 && !this.leavingRow) {
            String string = Utilities.logMessage(IBMDBMessages.noValuesSet);
            throw new com.ibm.db.DataException(string, 244);
        }
        if (statementResultRow.getStatus() == 1) {
            this.checkConnection();
            if (this.statement != null && this.statement.isReadOnly()) {
                Object[] objectArray = new Object[]{"updateRow"};
                String string = Utilities.logMessage(IBMDBMessages.readOnly, objectArray);
                throw new com.ibm.db.DataException(string, 215);
            }
            StatementResultRow statementResultRow2 = new StatementResultRow(statementResultRow);
            statementResultRow2.setNumberWhenChanged(this.fieldCurrentRow);
            this.fireAboutToUpdateRow(new DataEvent(this));
            if (statementResultRow.isInDatabase()) {
                statementResultRow2.setAction(1);
            } else {
                statementResultRow2.setAction(3);
            }
            this.changes.addElement(statementResultRow2);
            statementResultRow.reset();
            statementResultRow.setInDatabase(true);
            if (!this.deferUpdates) {
                this.apply();
            }
            this.fireUpdatedRow(new DataEvent(this));
        } else if (!(this.statement.isReadOnly() || !this.leavingRow && this.statement.isLockRows())) {
            this.unlockRow();
        }
    }

    protected void updateRowBeforeLeaving() throws com.ibm.db.DataException {
        if (this.fieldCurrentRowInCache > 0) {
            this.leavingRow = true;
            try {
                this.updateRow();
            }
            catch (com.ibm.db.DataException dataException) {
                this.leavingRow = false;
                throw dataException;
            }
            this.leavingRow = false;
        }
    }
}

