/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db;

import com.ibm.db.DataEvent;
import com.ibm.db.IBMDBMessages;
import com.ibm.db.Statement;
import com.ibm.db.Utilities;
import com.ibm.db.base.DataException;
import com.ibm.db.base.DatabaseConnection;
import com.ibm.db.base.DatabaseQuerySpec;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.SQLException;

public class SQLStatement
extends Statement {
    protected int fieldNumAffectedRows;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChange().addPropertyChangeListener(propertyChangeListener);
    }

    public void cancelExecution() throws com.ibm.db.DataException {
        if (this.fieldConnection == null) {
            String string = Utilities.logMessage(IBMDBMessages.noConnection);
            throw new com.ibm.db.DataException(string, 206);
        }
        if (!this.executingSQL) {
            String string = Utilities.logMessage(IBMDBMessages.notExecuting);
            throw new com.ibm.db.DataException(string, 246);
        }
        try {
            this.rt.cancel();
        }
        catch (SQLException sQLException) {
            Statement.handleSQLException(sQLException);
        }
    }

    public void execute() throws com.ibm.db.DataException {
        DatabaseQuerySpec databaseQuerySpec = null;
        this.fireAboutToExecute(new DataEvent(this));
        if (!this.connect()) {
            return;
        }
        DatabaseConnection databaseConnection = this.fieldConnection.getConnection();
        Integer n = new Integer(this.fieldNumAffectedRows);
        try {
            databaseQuerySpec = new DatabaseQuerySpec(this.getMetaData().getDbQuerySpec());
            if (this.getParameters() == null) {
                this.rt = databaseConnection.resultTableFromQuerySpec(databaseQuerySpec);
                this.rt.setTimeout(this.fieldTimeout);
                this.executingSQL = true;
                this.rt.execute();
            } else {
                databaseQuerySpec.setStatement(Statement.replaceHostVars(databaseQuerySpec.getStatement()));
                this.rt = databaseConnection.resultTableFromQuerySpec(databaseQuerySpec, this.getParameters());
                this.rt.setTimeout(this.fieldTimeout);
                this.executingSQL = true;
                this.rt.execute(this.getParameters());
            }
            this.executingSQL = false;
            this.fieldNumAffectedRows = this.rt.getUpdateCount();
            this.firePropertyChange("numAffectedRows", n, new Integer(this.fieldNumAffectedRows));
            this.rt.closeStatement();
            this.rt = null;
        }
        catch (SQLException sQLException) {
            this.executingSQL = false;
            String string = Utilities.logSQLException(sQLException);
            throw new com.ibm.db.DataException(string, sQLException);
        }
        catch (DataException dataException) {
            this.executingSQL = false;
            Utilities.logBaseException(dataException);
            throw new com.ibm.db.DataException(dataException.getMessage(), dataException.getErrorCode());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        this.fireExecuted(new DataEvent(this));
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.getPropertyChange().firePropertyChange(string, object, object2);
    }

    public int getNumAffectedRows() {
        return this.fieldNumAffectedRows;
    }

    protected PropertyChangeSupport getPropertyChange() {
        if (this.propertyChange == null) {
            this.propertyChange = new PropertyChangeSupport(this);
        }
        return this.propertyChange;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChange().removePropertyChangeListener(propertyChangeListener);
    }
}

