/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.quote;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import sunw.demo.quote.HttpProxy;
import sunw.demo.quote.LocalQuote;
import sunw.demo.quote.QuoteEvent;
import sunw.demo.quote.QuoteListener;
import sunw.demo.quote.QuoteServer;
import sunw.demo.quote.QuoteThread;
import sunw.demo.quote.YahooQuote;

public class QuoteServerImpl
extends UnicastRemoteObject
implements QuoteServer {
    private int quoteEventRate = 2;
    private Thread quoteThread;
    private String quoteSource = "Local";
    private boolean quoteThreadStopped = false;
    private Vector quoteListeners = new Vector();

    QuoteServerImpl() throws RemoteException {
        this.quoteThread = new QuoteThread(this);
        this.quoteThread.start();
    }

    void deliverQuotes() {
        Object object;
        Object object2;
        Vector vector;
        Serializable serializable = this;
        synchronized (serializable) {
            vector = (Vector)this.quoteListeners.clone();
            int n = vector.size();
            if (n == 0) {
                Object var4_4 = null;
                return;
            }
        }
        serializable = new Vector();
        int n = 0;
        while (n < vector.size()) {
            object2 = (QuoteListener)vector.elementAt(n);
            try {
                object = object2.getStockSymbol();
                if (object != null && !((Vector)serializable).contains(object)) {
                    ((Vector)serializable).addElement(object);
                }
            }
            catch (RemoteException remoteException) {}
            ++n;
        }
        object2 = this.quoteSource.equalsIgnoreCase("Yahoo") ? YahooQuote.getQuotes(this, (Vector)serializable) : LocalQuote.getQuotes(this, (Vector)serializable);
        if (object2 == null) {
            return;
        }
        object = null;
        int n2 = 0;
        while (n2 < vector.size()) {
            try {
                object = (QuoteListener)vector.elementAt(n2);
                String string = object.getStockSymbol();
                QuoteEvent quoteEvent = (QuoteEvent)((Hashtable)object2).get(string.toUpperCase());
                object.quoteChanged(quoteEvent);
            }
            catch (RemoteException remoteException) {
                System.err.println("disconnecting listener " + object);
                this.quoteListeners.removeElement(object);
            }
            ++n2;
        }
    }

    public int getQuoteEventRate() {
        return this.quoteEventRate;
    }

    public void setQuoteEventRate(int n) {
        this.quoteEventRate = n;
    }

    public synchronized void addQuoteListener(QuoteListener quoteListener) throws RemoteException {
        this.quoteListeners.addElement(quoteListener);
    }

    public synchronized void removeQuoteListener(QuoteListener quoteListener) throws RemoteException {
        this.quoteListeners.removeElement(quoteListener);
    }

    public HttpProxy getHttpProxy() throws RemoteException {
        Properties properties = System.getProperties();
        String string = properties.getProperty("http.proxyHost");
        String string2 = properties.getProperty("http.proxyPort");
        try {
            int n = Integer.parseInt(string2, 10);
            return new HttpProxy(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteException("can't parse port number", numberFormatException);
        }
    }

    public void setHttpProxy(HttpProxy httpProxy) throws RemoteException {
        String string = httpProxy.getHost();
        int n = httpProxy.getPort();
        if (n < 0) {
            throw new RemoteException("invalid port number");
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RemoteException("not a valid host", unknownHostException);
        }
        Properties properties = System.getProperties();
        ((Hashtable)properties).put("http.proxyHost", string);
        ((Hashtable)properties).put("http.proxyPort", String.valueOf(n));
    }

    public String getQuoteSource() throws RemoteException {
        return this.quoteSource;
    }

    public void setQuoteSource(String string) throws RemoteException {
        this.quoteSource = string;
    }

    boolean isQuoteThreadStopped() {
        return this.quoteThreadStopped;
    }

    void stopQuoteThread() {
        this.quoteThreadStopped = true;
    }
}

