/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.widget;

import java.awt.Adjustable;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class Scroller
extends Panel
implements Adjustable {
    public static final int DEFAULT_ORIENTATION = 1;
    public static final int DEFAULT_SCROLL_PAUSE = 500;
    public static final int DEFAULT_SCROLL_DELAY = 75;
    static final int WIDTH = 16;
    static final int MINIMUM_HANDLE_SIZE = 8;
    static final boolean THREAD = true;
    EventHandler fEventHandler = new EventHandler();
    ArrowButton fTopButton;
    Handle fHandle;
    ArrowButton fBottomButton;
    protected transient Vector fAdjustmentListeners;
    int fOrientation = 1;
    int fValue;
    int fVisible = 1;
    int fMinimum;
    int fMaximum = 1;
    int fUnit = 1;
    int fBlock = 1;
    int fScrollPause = 500;
    int fScrollDelay = 75;
    transient int fOffset1;
    transient int fOffset2;
    transient int fScrollOffset;
    transient int fScrollEndValue;
    transient ScrollThread fThread;
    transient int fScrollType;
    transient boolean fStopScroll;

    public Scroller() {
        this(1);
    }

    public Scroller(int n) {
        this.init();
        this.fTopButton = new ArrowButton();
        this.fHandle = new Handle();
        this.fBottomButton = new ArrowButton();
        this.setBackground(SystemColor.control);
        this.setLayout(new Layout());
        this.add(this.fTopButton);
        this.add(this.fHandle);
        this.add(this.fBottomButton);
        this.setOrientation(n);
    }

    public Scroller(int n, int n2, int n3, int n4, int n5) {
        this(n);
        this.setValues(n2, n3, n4, n5);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    private void init() {
        this.fAdjustmentListeners = new Vector();
        this.fThread = new ScrollThread();
    }

    protected void fireAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        Vector vector = (Vector)this.fAdjustmentListeners.clone();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((AdjustmentListener)vector.elementAt(n2)).adjustmentValueChanged(adjustmentEvent);
            ++n2;
        }
    }

    static void drawSolidBorder(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        graphics.setColor(color2);
    }

    static void draw3DBorder(Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4) {
        Color color3 = graphics.getColor();
        graphics.setColor(color);
        graphics.drawLine(n, n2, n + n3 - 1, n2);
        graphics.drawLine(n, n2 + 1, n, n2 + n4 - 1);
        graphics.setColor(color2);
        graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 2);
        graphics.setColor(color3);
    }

    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.fAdjustmentListeners.addElement(adjustmentListener);
    }

    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.fAdjustmentListeners.removeElement(adjustmentListener);
    }

    public int getOrientation() {
        return this.fOrientation;
    }

    public synchronized void setValue(int n) {
        if (this.fValue != n) {
            if (n < this.fMinimum) {
                n = this.fMinimum;
            } else if (n > this.fMaximum - this.fVisible) {
                n = this.fMaximum - this.fVisible;
            }
            this.fValue = n;
            this.repaint();
        }
    }

    public int getValue() {
        return this.fValue;
    }

    public synchronized void setMinimum(int n) {
        if (this.fMinimum != n) {
            if (n > this.fMaximum) {
                n = this.fMaximum;
            }
            this.fMinimum = n;
            this.repaint();
        }
    }

    public int getMinimum() {
        return this.fMinimum;
    }

    public synchronized void setMaximum(int n) {
        if (this.fMaximum != n) {
            if (n < this.fMinimum) {
                n = this.fMinimum;
            }
            this.fMaximum = n;
            this.repaint();
        }
    }

    public int getMaximum() {
        return this.fMaximum;
    }

    public synchronized void setUnitIncrement(int n) {
        if (this.fUnit != n) {
            this.fUnit = n;
            this.repaint();
        }
    }

    public int getUnitIncrement() {
        return this.fUnit;
    }

    public synchronized void setBlockIncrement(int n) {
        if (this.fBlock != n) {
            this.fBlock = n;
            this.repaint();
        }
    }

    public int getBlockIncrement() {
        return this.fBlock;
    }

    public synchronized void setVisibleAmount(int n) {
        if (this.fVisible != n) {
            if (n > this.fMaximum - this.fMinimum) {
                n = this.fMaximum - this.fMinimum;
            } else if (n < 0) {
                n = 0;
            }
            this.fVisible = n;
            this.repaint();
        }
    }

    public int getVisibleAmount() {
        return this.fVisible;
    }

    public synchronized void setOrientation(int n) {
        if (n != 1 && n != 0) {
            n = 1;
        }
        if (this.fOrientation != n) {
            this.fOrientation = n;
            this.invalidate();
            this.repaint();
        }
    }

    public synchronized void setValues(int n, int n2, int n3, int n4) {
        this.setMinimum(n3);
        this.setMaximum(n4);
        this.setValue(n);
        this.setVisibleAmount(n2);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.repaint();
    }

    public synchronized void setBackground(Color color) {
        this.fHandle.fBackground = null;
        super.setBackground(color);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        if (this.fOrientation == 1) {
            return new Dimension(16, 100);
        }
        return new Dimension(100, 16);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.doLayout();
    }

    public void repaint() {
        this.fTopButton.repaint();
        this.fHandle.repaint();
        this.fBottomButton.repaint();
        super.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append("orientation=");
        switch (this.fOrientation) {
            case 1: {
                stringBuffer.append("VERTICAL");
                break;
            }
            case 0: {
                stringBuffer.append("HORIZONTAL");
                break;
            }
            default: {
                stringBuffer.append("unknown");
            }
        }
        stringBuffer.append(",value=" + this.fValue);
        stringBuffer.append(",visible=" + this.fVisible);
        stringBuffer.append(",min=" + this.fMinimum);
        stringBuffer.append(",max=" + this.fMaximum);
        stringBuffer.append(",unit=" + this.fUnit);
        stringBuffer.append(",block=" + this.fBlock);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    class EventHandler
    implements Serializable,
    KeyListener,
    MouseListener,
    MouseMotionListener {
        private final Scroller fParent;

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void mousePressed(MouseEvent mouseEvent) {
            Dimension dimension = Scroller.this.getSize();
            boolean bl = this.fParent.fOrientation == 1;
            int n = bl ? dimension.height : dimension.width;
            Object object = mouseEvent.getSource();
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            int n4 = bl ? n3 : n2;
            AdjustmentEvent adjustmentEvent = null;
            Scroller scroller = this.fParent;
            synchronized (scroller) {
                this.fParent.fStopScroll = true;
                if (object == this.fParent.fTopButton) {
                    this.fParent.fTopButton.fUp = false;
                    this.fParent.fTopButton.repaint();
                    int n5 = this.fParent.fValue;
                    this.fParent.setValue(n5 - this.fParent.getUnitIncrement());
                    if (n5 != this.fParent.fValue) {
                        adjustmentEvent = new AdjustmentEvent(this.fParent, 601, 2, this.fParent.fValue);
                    }
                    this.fParent.fScrollType = 2;
                    this.fParent.fScrollEndValue = this.fParent.fMinimum - 1;
                    this.fParent.fScrollOffset = -1;
                    this.fParent.fStopScroll = false;
                } else if (object == this.fParent.fHandle) {
                    int n6 = 0;
                    if (n4 < this.fParent.fOffset1) {
                        int n7 = this.fParent.fValue;
                        this.fParent.setValue(this.fParent.fValue - this.fParent.fBlock);
                        if (this.fParent.fValue == n7) {
                            return;
                        }
                        this.fParent.fScrollOffset = n4;
                        n6 = 3;
                        this.fParent.fHandle.fBlockUp = true;
                    } else {
                        if (n4 < this.fParent.fOffset2) {
                            this.fParent.fHandle.fScrolling = true;
                            this.fParent.fScrollOffset = n4 - this.fParent.fOffset1;
                            return;
                        }
                        int n8 = this.fParent.fValue;
                        this.fParent.setValue(this.fParent.fValue + this.fParent.fBlock);
                        if (this.fParent.fValue == n8) {
                            return;
                        }
                        this.fParent.fScrollOffset = n4;
                        n6 = 4;
                        this.fParent.fHandle.fBlockDown = true;
                    }
                    adjustmentEvent = new AdjustmentEvent(this.fParent, 601, n6, this.fParent.fValue);
                    this.fParent.fScrollType = n6;
                    this.fParent.fStopScroll = false;
                    this.fParent.fThread.resume();
                    this.fParent.repaint();
                } else if (object == this.fParent.fBottomButton) {
                    this.fParent.fBottomButton.fUp = false;
                    this.fParent.fBottomButton.repaint();
                    int n9 = this.fParent.fValue;
                    this.fParent.setValue(n9 + this.fParent.getUnitIncrement());
                    if (n9 != this.fParent.fValue) {
                        adjustmentEvent = new AdjustmentEvent(this.fParent, 601, 1, this.fParent.fValue);
                    }
                    this.fParent.fScrollType = 1;
                    this.fParent.fScrollEndValue = this.fParent.fMaximum + 1;
                    this.fParent.fScrollOffset = n + 1;
                    this.fParent.fStopScroll = false;
                }
            }
            if (adjustmentEvent == null) return;
            this.fParent.fireAdjustmentEvent(adjustmentEvent);
            this.fParent.fThread.resume();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Scroller scroller = this.fParent;
            synchronized (scroller) {
                this.fParent.fStopScroll = true;
                this.fParent.fTopButton.fUp = true;
                this.fParent.fBottomButton.fUp = true;
                this.fParent.fHandle.fScrolling = false;
                this.fParent.fHandle.fBlockUp = false;
                this.fParent.fHandle.fBlockDown = false;
                Scroller.this.repaint();
                return;
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            AdjustmentEvent adjustmentEvent = null;
            Scroller scroller = this.fParent;
            synchronized (scroller) {
                if (object == this.fParent.fHandle && this.fParent.fHandle.fScrolling) {
                    Dimension dimension = this.fParent.fHandle.getSize();
                    int n = 0;
                    int n2 = 0;
                    if (this.fParent.fOrientation == 1) {
                        n = dimension.height;
                        n2 = mouseEvent.getY();
                    } else {
                        n = dimension.width;
                        n2 = mouseEvent.getX();
                    }
                    int n3 = Scroller.this.fValue;
                    int n4 = this.fParent.fMinimum + (int)((double)(n2 -= this.fParent.fScrollOffset) / (double)n * (double)(this.fParent.fMaximum - this.fParent.fMinimum));
                    if (n4 != n3) {
                        this.fParent.setValue(n4);
                        adjustmentEvent = new AdjustmentEvent(this.fParent, 601, 5, this.fParent.fValue);
                    }
                }
            }
            if (adjustmentEvent != null) {
                this.fParent.repaint();
                this.fParent.fireAdjustmentEvent(adjustmentEvent);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        EventHandler() {
            this.fParent = Scroller.this = Scroller.this;
        }
    }

    class Layout
    implements LayoutManager,
    Serializable {
        private final Scroller fParent;

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return null;
        }

        public Dimension minimumLayoutSize(Container container) {
            return null;
        }

        public void layoutContainer(Container container) {
            Dimension dimension = container.getSize();
            if (Scroller.this.fOrientation == 1) {
                int n = 32;
                if (dimension.height > n) {
                    this.fParent.fTopButton.setBounds(0, 0, dimension.width, 16);
                    this.fParent.fHandle.setBounds(0, 16, dimension.width, dimension.height - n);
                    this.fParent.fBottomButton.setBounds(0, dimension.height - 16, dimension.width, 16);
                    this.fParent.fHandle.setVisible(true);
                    return;
                }
                int n2 = dimension.height / 2;
                this.fParent.fTopButton.setBounds(0, 0, dimension.width, n2);
                this.fParent.fBottomButton.setBounds(0, n2, dimension.width, n2);
                this.fParent.fHandle.setVisible(false);
                return;
            }
            int n = 32;
            if (dimension.width > n) {
                this.fParent.fTopButton.setBounds(0, 0, 16, dimension.height);
                this.fParent.fHandle.setBounds(16, 0, dimension.width - n, dimension.height);
                this.fParent.fBottomButton.setBounds(dimension.width - 16, 0, 16, dimension.height);
                this.fParent.fHandle.setVisible(true);
                return;
            }
            int n3 = dimension.width / 2;
            this.fParent.fTopButton.setBounds(0, 0, n3, dimension.height);
            this.fParent.fBottomButton.setBounds(0, n3, n3, dimension.height);
            this.fParent.fHandle.setVisible(false);
        }

        Layout() {
            this.fParent = Scroller.this = Scroller.this;
        }
    }

    class ArrowButton
    extends Canvas {
        private final Scroller fParent;
        private final Dimension fMinimumSize;
        boolean fUp;
        private transient Image fBuffer;
        private transient Graphics fGraphics;
        private transient Dimension fSize;

        public ArrowButton() {
            this.fParent = Scroller.this = Scroller.this;
            this.fMinimumSize = new Dimension(16, 16);
            this.fUp = true;
            this.addMouseListener(this.fParent.fEventHandler);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public Dimension getMinimumSize() {
            return this.fMinimumSize;
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public synchronized void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            Graphics graphics2 = graphics;
            try {
                if (this.fBuffer == null || !this.fSize.equals(dimension)) {
                    if (this.fBuffer != null) {
                        this.fBuffer.flush();
                        this.fBuffer = null;
                        this.fGraphics.dispose();
                    }
                    this.fBuffer = this.createImage(dimension.width, dimension.height);
                    this.fGraphics = this.fBuffer.getGraphics();
                    this.fSize = dimension;
                }
                graphics2 = this.fGraphics;
            }
            catch (Exception exception) {
                this.fBuffer = null;
                graphics2 = graphics;
            }
            graphics2.setColor(this.getBackground());
            graphics2.fillRect(0, 0, dimension.width, dimension.height);
            Scroller scroller = this.fParent;
            synchronized (scroller) {
                int n = 0;
                int n2 = 0;
                if (this.fUp) {
                    Scroller.draw3DBorder(graphics2, SystemColor.controlHighlight, SystemColor.controlDkShadow, 0, 0, dimension.width, dimension.height);
                    Scroller.draw3DBorder(graphics2, SystemColor.controlLtHighlight, SystemColor.controlShadow, 1, 1, dimension.width - 2, dimension.height - 2);
                    n2 = 2;
                    n = 2;
                } else {
                    Scroller.drawSolidBorder(graphics2, SystemColor.controlShadow, 0, 0, dimension.width, dimension.height);
                    n2 = 1;
                    n = 1;
                }
                int n3 = dimension.width / 2;
                int n4 = dimension.height / 3;
                int n5 = 2 - n;
                int n6 = 2 - n2;
                graphics2.setClip(n, n2, dimension.width - 2 * n, dimension.height - 2 * n2);
                if (this.fParent.isEnabled()) {
                    graphics2.setColor(SystemColor.controlDkShadow);
                    this.paintArrow(graphics2, dimension, n5, n6, n3, n4, 0);
                } else {
                    graphics2.setColor(SystemColor.controlLtHighlight);
                    this.paintArrow(graphics2, dimension, n5, n6, n3, n4, 1);
                    graphics2.setColor(SystemColor.controlShadow);
                    this.paintArrow(graphics2, dimension, n5, n6, n3, n4, 0);
                }
                graphics2.setClip(0, 0, dimension.width, dimension.height);
            }
            if (this.fBuffer != null && graphics2 != graphics) {
                graphics.drawImage(this.fBuffer, 0, 0, this);
            }
        }

        private void paintArrow(Graphics graphics, Dimension dimension, int n, int n2, int n3, int n4, int n5) {
            if (this.fParent.fOrientation == 1) {
                if (this == this.fParent.fTopButton) {
                    int n6 = 0;
                    while (n6 < n4 - 1) {
                        graphics.drawLine(n3 - n6 - 1 + n + n5, n4 + n6 + 1 + n2 + n5, n3 + n6 - 1 + n + n5, n4 + n6 + 1 + n2 + n5);
                        ++n6;
                    }
                    return;
                }
                int n7 = 0;
                while (n7 < n4 - 1) {
                    graphics.drawLine(n3 - n7 - 1 + n + n5, 2 * n4 - n7 + n2 + n5, n3 + n7 - 1 + n + n5, 2 * n4 - n7 + n2 + n5);
                    ++n7;
                }
                return;
            }
            if (this == this.fParent.fTopButton) {
                int n8 = 0;
                while (n8 < n4 - 1) {
                    graphics.drawLine(n4 + n8 + n + n5, n3 - n8 - 1 + n2 + n5, n4 + n8 + n + n5, n3 + n8 - 1 + n2 + n5);
                    ++n8;
                }
                return;
            }
            int n9 = 0;
            while (n9 < n4 - 1) {
                graphics.drawLine(2 * n4 - n9 + n + n5, n3 - n9 - 1 + n2 + n5, 2 * n4 - n9 + n + n5, n3 + n9 - 1 + n2 + n5);
                ++n9;
            }
        }
    }

    class Handle
    extends Canvas {
        private final Scroller fParent;
        boolean fScrolling;
        boolean fBlockUp;
        boolean fBlockDown;
        private transient Image fBuffer;
        private transient Graphics fGraphics;
        private transient Dimension fSize;
        transient Image fBackground;
        transient Image fBlockBackground;

        public Handle() {
            this.fParent = Scroller.this = Scroller.this;
            this.fScrolling = false;
            this.fBlockUp = false;
            this.fBlockDown = false;
            this.addMouseListener(this.fParent.fEventHandler);
            this.addMouseMotionListener(this.fParent.fEventHandler);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            block34: {
                Dimension dimension = this.getSize();
                Graphics graphics2 = graphics;
                try {
                    if (this.fBuffer == null || !this.fSize.equals(dimension)) {
                        if (this.fBuffer != null) {
                            this.fBuffer.flush();
                            this.fBuffer = null;
                            this.fGraphics.dispose();
                        }
                        this.fBuffer = this.createImage(dimension.width, dimension.height);
                        this.fGraphics = this.fBuffer.getGraphics();
                        this.fSize = dimension;
                    }
                    graphics2 = this.fGraphics;
                    graphics2.setColor(this.getBackground());
                    graphics2.fillRect(0, 0, this.fSize.width, this.fSize.height);
                }
                catch (Exception exception) {
                    graphics2 = graphics;
                }
                if (this.fBackground == null) {
                    this.fBackground = this.createBackground(true);
                    this.fBlockBackground = this.createBackground(false);
                }
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                if (this.fBackground != null) {
                    n = this.fBackground.getWidth(this);
                    n2 = this.fBackground.getHeight(this);
                    n3 = dimension.width / n + 1;
                    n4 = dimension.height / n2 + 1;
                }
                Scroller scroller = this.fParent;
                synchronized (scroller) {
                    block30: {
                        int n5;
                        int n6;
                        block33: {
                            block31: {
                                int n7;
                                double d;
                                block32: {
                                    int n8;
                                    int n9;
                                    if (!this.fParent.isEnabled()) break block30;
                                    boolean bl = this.fParent.fOrientation == 1;
                                    int n10 = bl ? dimension.height : dimension.width;
                                    double d2 = (double)n10 / (double)(n9 = this.fParent.fMaximum - this.fParent.fMinimum);
                                    d = d2 * (double)this.fParent.fVisible;
                                    if (d < 8.0) {
                                        double d3 = 8.0;
                                        double d4 = d3 - d;
                                        double d5 = (double)n10 - d4;
                                        d2 = d5 / (double)n9;
                                        d = d3;
                                    }
                                    n6 = (int)((double)(this.fParent.fValue - this.fParent.fMinimum) * d2);
                                    n5 = n6 + (int)d;
                                    if ((int)d > n10) break block31;
                                    if (!bl) break block32;
                                    int n11 = 0;
                                    while (n11 < n3) {
                                        n8 = 0;
                                        while (n8 < n4) {
                                            graphics2.drawImage(this.fBackground, n11 * n, n8 * n2, this);
                                            ++n8;
                                        }
                                        ++n11;
                                    }
                                    if (this.fParent.fHandle.fBlockUp) {
                                        graphics2.setClip(0, 0, dimension.width, n6);
                                        n8 = 0;
                                        while (n8 < n3) {
                                            int n12 = 0;
                                            while (n12 < n4) {
                                                graphics2.drawImage(this.fBlockBackground, n8 * n, n12 * n2, this);
                                                ++n12;
                                            }
                                            ++n8;
                                        }
                                        graphics2.setClip(0, 0, dimension.width, dimension.height);
                                    }
                                    graphics2.setColor(this.getBackground());
                                    graphics2.fillRect(0, n6, dimension.width, (int)d);
                                    Scroller.draw3DBorder(graphics2, Color.lightGray, Color.black, 0, n6, dimension.width, (int)d);
                                    Scroller.draw3DBorder(graphics2, Color.white, Color.gray, 1, n6 + 1, dimension.width - 2, (int)d - 2);
                                    if (this.fParent.fHandle.fBlockDown) {
                                        graphics2.setClip(0, n5, dimension.width, dimension.height - n5);
                                        n8 = 0;
                                        while (n8 < n3) {
                                            int n13 = 0;
                                            while (n13 < n4) {
                                                graphics2.drawImage(this.fBlockBackground, n8 * n, n13 * n2, this);
                                                ++n13;
                                            }
                                            ++n8;
                                        }
                                        graphics2.setClip(0, 0, dimension.width, dimension.height);
                                    }
                                    break block33;
                                }
                                int n14 = 0;
                                while (n14 < n3) {
                                    n7 = 0;
                                    while (n7 < n4) {
                                        graphics2.drawImage(this.fBackground, n14 * n, n7 * n2, this);
                                        ++n7;
                                    }
                                    ++n14;
                                }
                                if (this.fParent.fHandle.fBlockUp) {
                                    graphics2.setClip(0, 0, n6, dimension.height);
                                    n7 = 0;
                                    while (n7 < n3) {
                                        int n15 = 0;
                                        while (n15 < n4) {
                                            graphics2.drawImage(this.fBlockBackground, n7 * n, n15 * n2, this);
                                            ++n15;
                                        }
                                        ++n7;
                                    }
                                    graphics2.setClip(0, 0, dimension.width, dimension.height);
                                }
                                graphics2.setColor(this.getBackground());
                                graphics2.fillRect(n6, 0, (int)d, dimension.height);
                                Scroller.draw3DBorder(graphics2, SystemColor.controlHighlight, SystemColor.controlDkShadow, n6, 0, (int)d, dimension.height);
                                Scroller.draw3DBorder(graphics2, SystemColor.controlLtHighlight, SystemColor.controlShadow, n6 + 1, 1, (int)d - 2, dimension.height - 2);
                                if (!this.fParent.fHandle.fBlockDown) break block33;
                                graphics2.setClip(n5, 0, dimension.width - n5, dimension.height);
                                n7 = 0;
                                while (n7 < n3) {
                                    int n16 = 0;
                                    while (n16 < n4) {
                                        graphics2.drawImage(this.fBlockBackground, n7 * n, n16 * n2, this);
                                        ++n16;
                                    }
                                    ++n7;
                                }
                                graphics2.setClip(0, 0, dimension.width, dimension.height);
                                break block33;
                            }
                            int n17 = 0;
                            while (n17 < n3) {
                                int n18 = 0;
                                while (n18 < n4) {
                                    graphics2.drawImage(this.fBackground, n17 * n, n18 * n2, this);
                                    ++n18;
                                }
                                ++n17;
                            }
                        }
                        this.fParent.fOffset1 = n6;
                        this.fParent.fOffset2 = n5;
                        break block34;
                    }
                    int n19 = 0;
                    while (n19 < n3) {
                        int n20 = 0;
                        while (n20 < n4) {
                            graphics2.drawImage(this.fBackground, n19 * n, n20 * n2, this);
                            ++n20;
                        }
                        ++n19;
                    }
                    this.fParent.fOffset1 = -1;
                    this.fParent.fOffset2 = -1;
                }
            }
            if (this.fBuffer != null) {
                graphics.drawImage(this.fBuffer, 0, 0, this);
            }
        }

        private Image createBackground(boolean bl) {
            try {
                Image image = this.createImage(16, 16);
                Graphics graphics = image.getGraphics();
                Color color = bl ? this.getBackground() : Color.black;
                Color color2 = bl ? Color.white : Color.darkGray;
                graphics.setColor(color);
                graphics.fillRect(0, 0, 16, 16);
                graphics.setColor(color2);
                int n = 0;
                while (n < 16) {
                    int n2 = n % 2;
                    int n3 = 0;
                    while (n3 < 16) {
                        if (n3 % 2 == 0) {
                            graphics.drawLine(n3 + n2, n, n3 + n2, n);
                        }
                        ++n3;
                    }
                    ++n;
                }
                graphics.dispose();
                return image;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    class ScrollThread
    extends Thread {
        private final Scroller fParent;

        public ScrollThread() {
            this.fParent = Scroller.this = Scroller.this;
            this.start();
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            block8: while (true) {
                this.fParent.fStopScroll = false;
                this.suspend();
                Thread.sleep(this.fParent.fScrollPause);
                while (true) {
                    if (this.fParent.fStopScroll || this.fParent.fScrollOffset >= this.fParent.fOffset1 && this.fParent.fScrollOffset <= this.fParent.fOffset2) continue block8;
                    var1_1 = 0;
                    switch (this.fParent.fScrollType) {
                        case 3: {
                            var1_1 = -this.fParent.fBlock;
                            break;
                        }
                        case 2: {
                            var1_1 = -this.fParent.fUnit;
                            break;
                        }
                        case 1: {
                            var1_1 = this.fParent.fUnit;
                            break;
                        }
                        case 4: {
                            var1_1 = this.fParent.fBlock;
                            break;
                        }
                    }
                    var2_2 = this.fParent.fValue;
                    this.fParent.setValue(var2_2 + var1_1);
                    var3_3 = this.fParent.fValue;
                    if (var2_2 != var3_3) ** break;
                    continue block8;
                    var4_4 = new AdjustmentEvent(this.fParent, 601, this.fParent.fScrollType, var3_3);
                    this.fParent.fireAdjustmentEvent(var4_4);
                    Thread.sleep(this.fParent.fScrollDelay);
                }
                break;
            }
            catch (InterruptedException v0) {
                return;
            }
        }
    }
}

