/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.widget;

import com.ibm.webrunner.widget.Paintable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.StringTokenizer;

public class Caption
implements Serializable,
Paintable {
    public static final int DEFAULT_LENGTH = 50;
    private Object fLabel;
    private int fLength = 50;
    private boolean fResizable = true;
    private boolean fShowing = true;
    private boolean fSelected = false;

    public Caption() {
        this("");
    }

    public Caption(String string) {
        this((Object)string);
    }

    public Caption(Object object) {
        this.setLabel(object);
    }

    public void setLabel(Object object) {
        this.fLabel = object;
    }

    public Object getLabel() {
        return this.fLabel;
    }

    public void setLength(int n) {
        if (n > 0) {
            this.fLength = n;
            return;
        }
        this.fLength = 50;
    }

    public int getLength() {
        return this.fLength;
    }

    public void setResizable(boolean bl) {
        this.fResizable = bl;
    }

    public boolean isResizable() {
        return this.fResizable;
    }

    public void setVisible(boolean bl) {
        this.fShowing = bl;
    }

    public boolean isVisible() {
        return this.fShowing;
    }

    public void setSelected(boolean bl) {
        this.fSelected = bl;
    }

    public boolean isSelected() {
        return this.fSelected;
    }

    public Dimension getSize() {
        return new Dimension(this.fLength, 20);
    }

    public synchronized void paint(Graphics graphics) {
        this.paintBackground(graphics);
        if (this.fLabel == null) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        Color color = graphics.getColor();
        color.brighter().brighter().brighter();
        Color color2 = color.darker().darker().darker();
        Color color3 = color2.darker().darker();
        graphics.setClip(rectangle.x + 2, rectangle.y + 2, rectangle.width - 5, rectangle.height - 5);
        Font font = graphics.getFont();
        font = this.fSelected ? new Font(font.getName(), font.getStyle() | 1, font.getSize()) : new Font(font.getName(), font.getStyle() & 0xFFFFFFFE, font.getSize());
        graphics.setFont(font);
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int n = 3 + fontMetrics.getAscent();
        StringTokenizer stringTokenizer = new StringTokenizer(this.fLabel.toString(), "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            graphics.setColor(color3);
            graphics.drawString(string, rectangle.x + 4, rectangle.y + n);
            n += fontMetrics.getHeight();
        }
        graphics.setClip(rectangle);
    }

    public void paintBackground(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            return;
        }
        Color color = graphics.getColor();
        Color color2 = color.brighter().brighter().brighter();
        Color color3 = color.darker().darker().darker();
        graphics.setColor(color2);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y + 1, rectangle.x, rectangle.y + rectangle.height - 1);
        graphics.setColor(color3);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 1);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.getClass().getName()) + "[");
        stringBuffer.append("label=" + this.fLabel);
        stringBuffer.append(",length=" + this.fLength);
        if (this.fResizable) {
            stringBuffer.append(",resizable");
        }
        if (this.fShowing) {
            stringBuffer.append(",showing");
        }
        if (this.fSelected) {
            stringBuffer.append(",selected");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

