/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist.common;

import com.ibm.sqlassist.SQLAssistPanel;
import com.ibm.sqlassist.SQLAssistVariableButton;
import com.ibm.sqlassist.common.ColumnObject;
import com.ibm.sqlassist.common.ColumnTextField;
import com.ibm.sqlassist.common.MCLB;
import com.ibm.sqlassist.common.PanelObject;
import com.ibm.sqlassist.common.SQLAssistStrings;
import com.ibm.sqlassist.common.SQLAssistUtils;
import com.ibm.sqlassist.common.TableObject;
import com.ibm.webrunner.util.SelectionSorter;
import com.ibm.webrunner.widget.ListboxColumn;
import com.ibm.webrunner.widget.event.ListboxEvent;
import com.ibm.webrunner.widget.event.ListboxListener;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class SetValuesPanel
extends Panel
implements TextListener,
ListboxListener,
FocusListener,
ActionListener {
    private SQLAssistPanel resource;
    private boolean isValid = false;
    private Choice selectedDatabaseTablesChoice = new Choice();
    private MCLB multiColumnListbox;
    private SQLAssistVariableButton variableButton;
    private ColumnTextField currentColumnTextField;
    private TextArea descriptionTextArea = new TextArea("", 2, 40, 1);
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public SetValuesPanel(SQLAssistPanel sQLAssistPanel) {
        this.resource = sQLAssistPanel;
        this.build();
        this.getProperties();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.getVariableButton())) {
            this.processVariableButton();
        }
    }

    private void build() {
        Panel panel;
        this.setLayout(new BorderLayout());
        PanelObject panelObject = new PanelObject(this.getTitle());
        PanelObject panelObject2 = new PanelObject(this.getFieldsTitle());
        this.setMultiColumnListbox(new MCLB(this.getResource(), true));
        panelObject2.add("Center", this.multiColumnListbox);
        this.multiColumnListbox.addColumn(this.resource.getString(SQLAssistStrings.Field_Text));
        this.multiColumnListbox.addColumn(this.resource.getString(SQLAssistStrings.Type_Text));
        this.multiColumnListbox.addColumn(this.resource.getString(SQLAssistStrings.Equals_Char));
        this.multiColumnListbox.addColumn(this.resource.getString(SQLAssistStrings.Value_Text));
        ListboxColumn listboxColumn = this.multiColumnListbox.getColumnInfo(0);
        listboxColumn.setWidth(125);
        listboxColumn.setSorter(new SelectionSorter());
        listboxColumn = this.multiColumnListbox.getColumnInfo(1);
        listboxColumn.setWidth(125);
        listboxColumn.setSorter(new SelectionSorter());
        listboxColumn = this.multiColumnListbox.getColumnInfo(2);
        listboxColumn.setWidth(25);
        listboxColumn = this.multiColumnListbox.getColumnInfo(3);
        listboxColumn.setWidth(400);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        this.setVariableButton(new SQLAssistVariableButton(this.resource));
        if (this.resource.getOptions().getDisplayVariableButton()) {
            this.getVariableButton().setEnabled(false);
            this.getVariableButton().addActionListener(this);
            panel = new Panel();
            panel.setLayout(new BorderLayout());
            panel.add("East", this.getVariableButton());
            panel.add("South", SQLAssistUtils.spacer(5));
            panel2.add("North", panel);
        } else {
            panel2.add("North", SQLAssistUtils.spacer(5));
        }
        panel2.add("Center", this.descriptionTextArea);
        this.descriptionTextArea.setEditable(false);
        panel = new Panel();
        panel.setLayout(new BorderLayout(5, 5));
        panel.add("North", panelObject);
        panel.add("Center", panelObject2);
        panel.add("South", panel2);
        this.setLayout(new BorderLayout(10, 10));
        this.add("Center", panel);
        this.add("North", new Label());
        this.add("South", this.resource.getGui().buildStatusbarPanel());
        this.add("East", new Label());
        this.add("West", new Label());
        this.populateSelectedDatabaseTablesChoice();
        this.multiColumnListbox.addListboxListener(this);
    }

    private synchronized void checkRequiredFields() {
        boolean bl = this.isValid;
        boolean bl2 = true;
        int n = 0;
        int n2 = 0;
        while (n2 < this.multiColumnListbox.getRowCount()) {
            ColumnObject columnObject = (ColumnObject)this.multiColumnListbox.getRowKey(n2);
            Object[] objectArray = this.multiColumnListbox.getRow(n2);
            if (((ColumnTextField)objectArray[3]).getText().equals("")) {
                if (columnObject.getIsRequired()) {
                    bl2 = false;
                }
            } else {
                ++n;
            }
            ++n2;
        }
        if (this.resource.getQuery().getType() == 3 && n > 0) {
            bl2 = true;
        }
        this.isValid = bl2;
        if (bl != this.isValid) {
            this.resource.getGui().refreshButtons(true);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() instanceof ColumnTextField) {
            this.setCurrentColumnTextField((ColumnTextField)focusEvent.getSource());
            this.getVariableButton().setEnabled(true);
            if (this.getCurrentColumnTextField().getIsVariable() && this.resource.getOptions().getDisplayVariableButton()) {
                this.processVariableButton();
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public ColumnTextField getCurrentColumnTextField() {
        return this.currentColumnTextField;
    }

    public String getFieldsTitle() {
        return null;
    }

    public boolean getIsValid() {
        return this.isValid;
    }

    public MCLB getMultiColumnListbox() {
        return this.multiColumnListbox;
    }

    public synchronized void getProperties() {
        this.getProperties(false);
    }

    private synchronized void getProperties(boolean bl) {
        String string = this.getResource().getProperties().getProperty(this.getPropertySelectedDatabaseTablesName(), "");
        if (!SQLAssistUtils.contains(this.selectedDatabaseTablesChoice, string)) {
            return;
        }
        this.selectedDatabaseTablesChoice.select(string);
        if (!bl) {
            this.populateMultiColumnListbox();
        }
        int n = 0;
        while (n < this.multiColumnListbox.getRowCount()) {
            String string2;
            Object[] objectArray = this.multiColumnListbox.getRow(n);
            String string3 = (String)objectArray[0];
            if (string3.startsWith(this.resource.getString(SQLAssistStrings.Required_Char))) {
                string3 = SQLAssistUtils.parseString(string3, false, " ");
            }
            if ((string2 = this.getResource().getProperties().getProperty(this.getPropertyValueName(), "", new String[]{string3})) != null) {
                ColumnTextField columnTextField = (ColumnTextField)objectArray[3];
                columnTextField.setText(string2);
                String string4 = this.getResource().getProperties().getProperty("503_{0}", "0", new String[]{string3});
                if (string4.equals("1")) {
                    columnTextField.setIsVariable(true);
                } else {
                    columnTextField.setIsVariable(false);
                }
                columnTextField.setVariableFont();
                this.multiColumnListbox.replaceRow(objectArray, n);
            }
            ++n;
        }
        this.populateDescriptionTextArea();
        this.checkRequiredFields();
    }

    public String getPropertyName() {
        return null;
    }

    public String getPropertySelectedDatabaseTablesName() {
        return null;
    }

    public String getPropertyValueName() {
        return null;
    }

    public SQLAssistPanel getResource() {
        return this.resource;
    }

    public Choice getSelectedDatabaseTablesChoice() {
        return this.selectedDatabaseTablesChoice;
    }

    public String getTitle() {
        return null;
    }

    public String getTypeDescription() {
        return null;
    }

    public SQLAssistVariableButton getVariableButton() {
        return this.variableButton;
    }

    public void populateDescriptionTextArea() {
        if (this.selectedDatabaseTablesChoice.getSelectedItem() == null) {
            this.descriptionTextArea.setText("");
            return;
        }
        String string = String.valueOf(this.resource.getString(SQLAssistStrings.InTable_Text, new Object[]{this.selectedDatabaseTablesChoice.getSelectedItem()})) + " " + this.getTypeDescription();
        String string2 = "";
        int n = 0;
        int n2 = 0;
        while (n2 < this.multiColumnListbox.getRowCount()) {
            ColumnObject columnObject = (ColumnObject)this.multiColumnListbox.getRowKey(n2);
            Object[] objectArray = this.multiColumnListbox.getRow(n2);
            String string3 = ((ColumnTextField)objectArray[3]).getText();
            if (!string3.equals("")) {
                if (++n >= 2) {
                    string2 = String.valueOf(string2) + ", ";
                }
                string2 = String.valueOf(string2) + columnObject.getName() + " = ";
                string2 = columnObject.getGenericData_Type() == 1 ? String.valueOf(string2) + "'" + string3 + "'" : String.valueOf(string2) + string3;
            }
            ++n2;
        }
        string = !string2.equals("") ? String.valueOf(string) + "\n  " + this.resource.getString(SQLAssistStrings.Set_Text) + " " + string2 : String.valueOf(string) + this.resource.getString(SQLAssistStrings.Periods_Char);
        this.descriptionTextArea.setText(string);
    }

    private void populateMultiColumnListbox() {
        Object object;
        Vector vector = new Vector();
        this.multiColumnListbox.removeAllRows();
        String[] stringArray = this.resource.getGui().getSqlAssistTablesPanel().getSelectedDatabaseTablesList().getItems();
        this.resource.getGui().setStatus();
        int n = 0;
        while (n < stringArray.length) {
            if (this.selectedDatabaseTablesChoice.getSelectedItem().equals(stringArray[n])) {
                try {
                    object = this.resource.getQuery().getDatabase().getTable(stringArray[n]);
                    vector = ((TableObject)object).getColumns();
                }
                catch (Exception exception) {}
                break;
            }
            ++n;
        }
        n = 0;
        while (n < vector.size()) {
            object = (ColumnObject)vector.elementAt(n);
            String string = ((ColumnObject)object).getName();
            if (((ColumnObject)object).getIsRequired()) {
                string = String.valueOf(this.resource.getString(SQLAssistStrings.Required_Char)) + " " + string;
            }
            String string2 = this.getResource().getQuery().getDatabase().getTypeInfo().getType_Name(((ColumnObject)object).getData_Type());
            if (((ColumnObject)object).getSize() > 0) {
                string2 = String.valueOf(string2) + "(" + ((ColumnObject)object).getSize() + ")";
            }
            ColumnTextField columnTextField = new ColumnTextField(this.resource, (ColumnObject)object, true);
            columnTextField.addFocusListener(this);
            columnTextField.addTextListener(this);
            Object[] objectArray = new Object[]{string, string2, this.resource.getString(SQLAssistStrings.Equals_Char), columnTextField};
            this.multiColumnListbox.addRow(objectArray, object);
            ++n;
        }
        this.selectRequiredFields();
        this.populateDescriptionTextArea();
        this.getProperties(true);
    }

    public void populateSelectedDatabaseTablesChoice() {
        this.selectedDatabaseTablesChoice.removeAll();
        List list = this.resource.getGui().getSqlAssistTablesPanel().getSelectedDatabaseTablesList();
        int n = 0;
        while (n < list.getItemCount()) {
            this.selectedDatabaseTablesChoice.addItem(list.getItem(n));
            ++n;
        }
        if (this.selectedDatabaseTablesChoice.getItemCount() > 0) {
            this.selectedDatabaseTablesChoice.select(0);
        }
        this.populateMultiColumnListbox();
    }

    public void processVariableButton() {
        this.getVariableButton().process(this.getCurrentColumnTextField());
    }

    public synchronized void putProperties() {
        this.getResource().getProperties().put(this.getPropertySelectedDatabaseTablesName(), this.selectedDatabaseTablesChoice.getSelectedItem());
        int n = 0;
        while (n < this.multiColumnListbox.getRowCount()) {
            Object[] objectArray = this.multiColumnListbox.getRow(n);
            String string = (String)objectArray[0];
            if (string.startsWith(this.resource.getString(SQLAssistStrings.Required_Char))) {
                string = SQLAssistUtils.parseString(string, false, " ");
            }
            if (!string.equals("")) {
                this.getResource().getProperties().put(this.getPropertyValueName(), ((ColumnTextField)objectArray[3]).getText(), new String[]{string});
                ColumnTextField columnTextField = (ColumnTextField)objectArray[3];
                int n2 = 0;
                if (columnTextField.getIsVariable()) {
                    n2 = 1;
                }
                this.getResource().getProperties().put("503_{0}", "" + n2, new String[]{string});
            }
            ++n;
        }
    }

    public void rowDeselected(ListboxEvent listboxEvent) {
        this.selectRequiredFields();
    }

    public void rowSelected(ListboxEvent listboxEvent) {
        this.selectRequiredFields();
    }

    private void selectRequiredFields() {
        int n = 0;
        while (n < this.multiColumnListbox.getRowCount()) {
            ColumnObject columnObject = (ColumnObject)this.multiColumnListbox.getRowKey(n);
            if (columnObject.getIsRequired()) {
                this.multiColumnListbox.selectRow(n);
            } else {
                this.multiColumnListbox.deselectRow(n);
            }
            ++n;
        }
        this.checkRequiredFields();
    }

    public void setCurrentColumnTextField(ColumnTextField columnTextField) {
        this.currentColumnTextField = columnTextField;
    }

    public void setIsValid(boolean bl) {
        this.isValid = bl;
    }

    public void setMultiColumnListbox(MCLB mCLB) {
        this.multiColumnListbox = mCLB;
    }

    public void setResource(SQLAssistPanel sQLAssistPanel) {
        this.resource = sQLAssistPanel;
    }

    public void setSelectedDatabaseTablesChoice(Choice choice) {
        this.selectedDatabaseTablesChoice = choice;
    }

    public void setVariableButton(SQLAssistVariableButton sQLAssistVariableButton) {
        this.variableButton = sQLAssistVariableButton;
    }

    public void textValueChanged(TextEvent textEvent) {
        this.resource.getGui().setStatus();
        this.populateDescriptionTextArea();
        this.checkRequiredFields();
        this.resource.getQuery().eventBuildSQL();
    }
}

