/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist.common;

import com.ibm.sqlassist.SQLAssistPanel;
import com.ibm.sqlassist.common.ColumnObject;
import com.ibm.sqlassist.common.DatabaseObject;
import com.ibm.sqlassist.common.SQLAssistNotebookTabPanelObject;
import com.ibm.sqlassist.common.SQLAssistStrings;
import com.ibm.sqlassist.common.SQLAssistUtils;
import com.ibm.sqlassist.common.SchemaObject;
import com.ibm.sqlassist.common.TableObject;
import com.ibm.sqlassist.common.TypeInfoObject;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.Connection;
import java.util.Vector;

public class SQLAssistQueryObject {
    private DatabaseObject database;
    private int type = 0;
    private boolean isValid = false;
    private String login;
    private String password;
    private String server;
    private String driver;
    private String schema;
    private String tableNamePattern = "%";
    private String[] table_Type;
    private boolean manuallyModified = false;
    public static final int SELECT = 0;
    public static final int SELECTUNIQUE = 1;
    public static final int INSERT = 2;
    public static final int UPDATE = 3;
    public static final int DELETE = 4;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private String sql = "";
    private SQLAssistPanel resource;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public SQLAssistQueryObject(SQLAssistPanel sQLAssistPanel) {
        this.resource = sQLAssistPanel;
        this.init();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public String buildSQL() {
        if (!this.resource.getOptions().getSupportBuildSQL()) {
            return this.getSql();
        }
        if (this.resource.getGui().getSqlAssistSQLPanel() == null) {
            this.setSql("");
            return this.getSql();
        }
        this.resource.getGui().getSqlAssistSQLPanel().populateStatementTextArea();
        this.setSql(this.resource.getGui().getSqlAssistSQLPanel().getStatementTextArea().getText());
        return this.getSql();
    }

    public void closeDatabaseConnection() {
        if (this.resource.getOptions().getCloseDatabaseConnection() && this.database != null) {
            try {
                Object[] objectArray = new Object[]{this.database.getJdbcServer()};
                this.resource.getGui().setStatus(this.resource.getString(SQLAssistStrings.ClosingConnection_Msg, objectArray));
                this.database.close();
            }
            catch (Exception exception) {}
        }
    }

    public void eventBuildSQL() {
        if (this.resource.getOptions().getEventBuildSQL()) {
            this.buildSQL();
            if (this.resource.getGui().getOtherNotebookTabsVector() != null) {
                int n = 0;
                while (n < this.resource.getGui().getOtherNotebookTabsVector().size()) {
                    SQLAssistNotebookTabPanelObject sQLAssistNotebookTabPanelObject = (SQLAssistNotebookTabPanelObject)this.resource.getGui().getOtherNotebookTabsVector().elementAt(n);
                    if (sQLAssistNotebookTabPanelObject.getExists() && sQLAssistNotebookTabPanelObject.getEventBuildRefresh()) {
                        sQLAssistNotebookTabPanelObject.refresh();
                    }
                    ++n;
                }
            }
        }
    }

    public String[] getAvailableFields() {
        Vector vector = this.getAvailableFieldsAsTableObjectColumnObjectArray();
        if (vector == null || vector.size() == 0) {
            return null;
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            Object[] objectArray = (Object[])vector.elementAt(n);
            TableObject tableObject = (TableObject)objectArray[0];
            ColumnObject columnObject = (ColumnObject)objectArray[1];
            stringArray[n] = String.valueOf(tableObject.getName()) + "." + columnObject.getName();
            ++n;
        }
        return stringArray;
    }

    public Vector getAvailableFieldsAsTableObjectColumnObjectArray() {
        DatabaseObject databaseObject = this.resource.getQuery().getDatabase();
        if (databaseObject == null) {
            return null;
        }
        String[] stringArray = this.getSelectedDatabaseTables(true);
        if (stringArray == null) {
            return null;
        }
        Vector<Object[]> vector = new Vector<Object[]>();
        int n = 0;
        while (n < stringArray.length) {
            TableObject tableObject = databaseObject.getTable(stringArray[n]);
            if (tableObject != null) {
                int n2 = 0;
                while (n2 < tableObject.getColumns().size()) {
                    ColumnObject columnObject = (ColumnObject)tableObject.getColumns().elementAt(n2);
                    vector.addElement(new Object[]{tableObject, columnObject});
                    ++n2;
                }
            }
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public String[] getAvailableFieldsMatchingData_Type(int n) {
        Vector vector = this.getAvailableFieldsAsTableObjectColumnObjectArray();
        if (vector == null || vector.size() == 0) {
            return null;
        }
        Vector<String> vector2 = new Vector<String>();
        int n2 = 0;
        while (n2 < vector.size()) {
            Object[] objectArray = (Object[])vector.elementAt(n2);
            TableObject tableObject = (TableObject)objectArray[0];
            ColumnObject columnObject = (ColumnObject)objectArray[1];
            if (columnObject.getData_Type() == n) {
                vector2.addElement(String.valueOf(tableObject.getName()) + "." + columnObject.getName());
            }
            ++n2;
        }
        if (vector2.size() == 0) {
            return null;
        }
        String[] stringArray = new String[vector2.size()];
        int n3 = 0;
        while (n3 < vector2.size()) {
            stringArray[n3] = (String)vector2.elementAt(n3);
            ++n3;
        }
        return stringArray;
    }

    public String[] getAvailableVariableNames() {
        if (this.resource.getGui().getSqlAssistSQLPanel() == null) {
            return null;
        }
        Vector vector = this.resource.getGui().getSqlAssistSQLPanel().getVariableNames();
        if (vector.size() == 0) {
            return null;
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    public String[][] getAvailableVariables() {
        if (this.resource.getGui().getSqlAssistSQLPanel() == null) {
            return null;
        }
        Vector vector = this.resource.getGui().getSqlAssistSQLPanel().getVariableNames();
        if (vector.size() == 0) {
            return null;
        }
        Vector vector2 = this.resource.getGui().getSqlAssistSQLPanel().getVariableTypes();
        String[][] stringArray = new String[vector.size()][2];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n][0] = (String)vector.elementAt(n);
            stringArray[n][1] = (String)vector2.elementAt(n);
            ++n;
        }
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    public Vector getAvailableVariablesAsColumnObjects() {
        Vector<ColumnObject> vector = new Vector<ColumnObject>();
        String[][] stringArray = this.getAvailableVariables();
        if (stringArray == null) {
            return vector;
        }
        TypeInfoObject typeInfoObject = null;
        if (this.getDatabase() != null) {
            typeInfoObject = this.getDatabase().getTypeInfo();
        }
        int n = 0;
        while (n < stringArray.length) {
            ColumnObject columnObject = new ColumnObject(stringArray[n][0], Integer.parseInt(stringArray[n][1]), 0, "", true, typeInfoObject);
            vector.addElement(columnObject);
            ++n;
        }
        return vector;
    }

    public DatabaseObject getDatabase() {
        return this.database;
    }

    public String[][] getDataTypeMappings() {
        if (this.resource.getGui().getSqlAssistDataTypeMappingPanel() == null) {
            return null;
        }
        return this.resource.getGui().getSqlAssistDataTypeMappingPanel().toArray();
    }

    public String getDriver() {
        return this.driver;
    }

    public boolean getIsValid() {
        return this.isValid;
    }

    public String getLogin() {
        return this.login;
    }

    public boolean getManuallyModified() {
        return this.manuallyModified;
    }

    public String getName(ColumnObject columnObject) {
        return this.getName(columnObject.getName());
    }

    public String getName(TableObject tableObject) {
        return this.getName(tableObject.getName());
    }

    public String getName(TableObject tableObject, boolean bl) {
        return this.getName(tableObject.getName(bl));
    }

    public String getName(String string) {
        if (this.resource.getOptions().getSupportQuoteMixedCaseNames()) {
            return SQLAssistUtils.quoteString(string);
        }
        return string;
    }

    public String getPassword() {
        return this.password;
    }

    public synchronized void getProperties() {
        int n;
        this.setLogin(this.resource.getProperties().getProperty("1", this.getLogin()));
        this.setPassword(this.resource.getProperties().getProperty("2", this.getPassword()));
        this.setServer(this.resource.getProperties().getProperty("3", this.getServer()));
        this.setDriver(this.resource.getProperties().getProperty("4", this.getDriver()));
        String string = this.resource.getProperties().getProperty("6", this.getTableNamePattern());
        if (string != null && !string.equals("null") && !string.equals("")) {
            this.setTableNamePattern(string);
        }
        this.setSchema(this.resource.getProperties().getProperty("5", this.getSchema()));
        if (this.getSchema() != null && (this.getSchema().equals("null") || this.getSchema().equals(""))) {
            this.setSchema(";");
        }
        if ((n = Integer.parseInt(this.resource.getProperties().getProperty("7", "0"))) > 0) {
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = this.resource.getProperties().getProperty("8_{0}", "", new String[]{"" + n2});
                ++n2;
            }
            this.setTable_Type(stringArray);
        }
    }

    public String getSchema() {
        return this.schema;
    }

    public String[] getSelectedDatabaseTables() {
        return this.getSelectedDatabaseTables(false);
    }

    public String[] getSelectedDatabaseTables(boolean bl) {
        Vector<String> vector = new Vector<String>();
        if (this.resource.getGui().getSqlAssistTablesPanel() == null || this.resource.getGui().getSqlAssistTablesPanel().getSelectedDatabaseTablesList() == null) {
            return null;
        }
        int n = 0;
        while (n < this.resource.getGui().getSqlAssistTablesPanel().getSelectedDatabaseTablesList().getItemCount()) {
            String string = this.resource.getGui().getSqlAssistTablesPanel().getSelectedDatabaseTablesList().getItem(n);
            if (!bl) {
                vector.addElement(string);
            } else {
                vector.addElement(string);
            }
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        String[] stringArray = new String[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            stringArray[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public String[] getSelectedFields() {
        if (this.resource.getGui().getSqlAssistFieldsPanel() == null) {
            return null;
        }
        String[] stringArray = this.resource.getGui().getSqlAssistFieldsPanel().getSelectedList().getItems();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    public String[] getSelectedSortFields() {
        if (this.resource.getGui().getSqlAssistSortPanel() == null) {
            return null;
        }
        String[] stringArray = this.resource.getGui().getSqlAssistSortPanel().getSelectedList().getItems();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    public String getServer() {
        return this.server;
    }

    public synchronized String getSql() {
        return this.sql;
    }

    public String[] getTable_Type() {
        return this.table_Type;
    }

    public String getTableNamePattern() {
        return this.tableNamePattern;
    }

    public int getType() {
        return this.type;
    }

    public String[] getUniqueAvailableVariableNames() {
        String[] stringArray = this.getAvailableVariableNames();
        if (stringArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (!vector.contains(string)) {
                vector.addElement(string);
            }
            ++n;
        }
        String[] stringArray2 = new String[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            stringArray2[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        if (stringArray2.length == 0) {
            return null;
        }
        return stringArray2;
    }

    private void init() {
        this.setIsValid(false);
        this.setSchema(null);
        this.setTableNamePattern("%");
        this.setTable_Type(null);
        this.setManuallyModified(false);
    }

    public synchronized boolean isVariable(String string) {
        return string != null && string.length() > 1 && this.isVariableStart(string);
    }

    public synchronized boolean isVariableStart(String string) {
        return this.resource.getOptions().getVariableCharacters() != null && string != null && string.length() >= 1 && this.resource.getOptions().getVariableCharacters().indexOf(string.substring(0, 1)) >= 0;
    }

    public synchronized void putNonLogonProperties() {
        String string = this.getSchema();
        if (string == null) {
            string = "null";
        }
        this.resource.getProperties().put("5", string);
        this.resource.getProperties().put("6", this.getTableNamePattern());
        if (this.getTable_Type() != null) {
            this.resource.getProperties().put("7", "" + this.getTable_Type().length);
            int n = 0;
            while (n < this.getTable_Type().length) {
                this.resource.getProperties().put("8_{0}", this.getTable_Type()[n], new String[]{"" + n});
                ++n;
            }
        }
    }

    public synchronized void putProperties() {
        this.resource.getProperties().put("1", this.getLogin());
        if (this.resource.getOptions().getSupportSavingLogonPasswordProperty()) {
            this.resource.getProperties().put("2", this.getPassword());
        } else {
            this.resource.getProperties().put("2", "");
        }
        this.resource.getProperties().put("3", this.getServer());
        this.resource.getProperties().put("4", this.getDriver());
        this.putNonLogonProperties();
    }

    public void refreshSchema() {
        String string = "";
        int n = 0;
        while (n < this.getDatabase().getSchemas().size()) {
            SchemaObject schemaObject = (SchemaObject)this.getDatabase().getSchemas().elementAt(n);
            if (schemaObject.getSelected()) {
                string = String.valueOf(string) + schemaObject.getName() + ";";
            }
            ++n;
        }
        this.setSchema(string);
        try {
            Vector<TableObject> vector = new Vector<TableObject>();
            int n2 = 0;
            while (n2 < this.getDatabase().getTables().size()) {
                TableObject tableObject = (TableObject)this.getDatabase().getTables().elementAt(n2);
                if (!tableObject.getLive()) {
                    vector.addElement(tableObject);
                }
                ++n2;
            }
            this.getDatabase().setTables(new Vector());
            this.resource.getGui().getSqlAssistLogonPanel().retrieveSchemas(this.getSchema());
            n2 = 0;
            while (n2 < vector.size()) {
                this.getDatabase().getTables().addElement((TableObject)vector.elementAt(n2));
                ++n2;
            }
            this.resource.getGui().getSqlAssistTablesPanel().populateAvailableTablesListbox();
            this.resource.getGui().setStatus();
        }
        catch (Exception exception) {
            this.resource.getGui().handleException(exception);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    public void reset() {
        this.closeDatabaseConnection();
        this.setDatabase(null);
        this.setSql("");
        this.init();
    }

    public void setDatabase(DatabaseObject databaseObject) {
        this.database = databaseObject;
        if (this.database != null && this.resource.getOptions().getSupportSchema() && !this.database.getSupportsSchemas()) {
            this.resource.getOptions().setSupportSchema(false);
            this.setSchema(null);
        }
    }

    public void setDatabase(Connection connection, String string) throws UnsatisfiedLinkError, Exception {
        this.setDatabase(new DatabaseObject(string));
        this.database.setConnection(connection);
        try {
            this.database.retrieveTables("%", "%");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw unsatisfiedLinkError;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public void setIsValid(boolean bl) {
        this.isValid = bl;
    }

    public void setLogin(String string) {
        this.login = string;
    }

    public void setManuallyModified(boolean bl) {
        this.manuallyModified = bl;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setSchema(String string) {
        this.schema = string;
    }

    public void setServer(String string) {
        this.server = string;
    }

    public void setSql(String string) {
        if (string != null) {
            if (!this.resource.getOptions().getFormatSQL()) {
                string = string.replace('\n', ' ');
                string = string.replace('\r', ' ');
                int n = 0;
                boolean bl = false;
                boolean bl2 = false;
                while (n < string.length() - 2) {
                    String string2 = string.substring(n, n + 2);
                    if (string2.startsWith("\"")) {
                        boolean bl3 = bl = !bl;
                    }
                    if (string2.startsWith("'")) {
                        boolean bl4 = bl2 = !bl2;
                    }
                    if (string2.equals("  ") && !bl && !bl2) {
                        string = String.valueOf(string.substring(0, n)) + string.substring(n + 1);
                        continue;
                    }
                    ++n;
                }
                string = string.trim();
            }
        } else {
            string = "";
        }
        String string3 = this.sql;
        this.sql = string;
        this.listeners.firePropertyChange("sql", string3, string);
    }

    public void setTable_Type(String[] stringArray) {
        this.table_Type = stringArray;
    }

    public void setTableNamePattern(String string) {
        this.tableNamePattern = string;
    }

    public void setType(int n) {
        this.type = n;
    }
}

