/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist.common;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.util.StringTokenizer;

public class ManyLineLabel
extends Canvas {
    private String text = "";
    private int alignment = 0;
    private boolean border = false;
    private int topBottomMargin = 0;
    private int leftRightMargin = 0;
    private int maxLineLen = 60;
    private String[] lines;
    private int num_lines;
    private int line_height;
    private int line_ascent;
    private int[] line_widths;
    private int max_width;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;

    public ManyLineLabel(String string) {
        this(string, 0, 60, false);
    }

    public ManyLineLabel(String string, int n) {
        this(string, n, 60, false);
    }

    public ManyLineLabel(String string, int n, int n2) {
        this(string, n, n2, false);
    }

    public ManyLineLabel(String string, int n, int n2, boolean bl) {
        this.setAlignment(n);
        this.setBorder(bl);
        this.setMaxLineLen(n2);
        this.setText(string);
    }

    public void addNotify() {
        super.addNotify();
        this.measure();
    }

    private String formatText(String string) {
        if (this.maxLineLen < 0) {
            return string;
        }
        String string2 = string;
        String string3 = "";
        String string4 = "";
        do {
            if (string2.length() <= this.maxLineLen) {
                string3 = String.valueOf(string3) + string2;
                string2 = null;
                continue;
            }
            if (string2.substring(this.maxLineLen, this.maxLineLen).equals(" ")) {
                string3 = String.valueOf(string3) + string2.substring(0, this.maxLineLen) + "\n";
                string2 = string2.substring(this.maxLineLen + 1);
                continue;
            }
            string4 = string2.substring(0, this.maxLineLen);
            int n = string4.lastIndexOf(" ");
            int n2 = string4.indexOf("\n");
            if (n2 >= 0 && n2 < n) {
                string3 = String.valueOf(string3) + string4.substring(0, n2) + " \n";
                string2 = string2.substring(n2 + 1);
                continue;
            }
            if (n <= 0) {
                string3 = String.valueOf(string3) + string4 + "\n";
                string2 = string2.substring(this.maxLineLen + 1);
                continue;
            }
            string3 = String.valueOf(string3) + string2.substring(0, n) + "\n";
            string2 = string2.substring(n + 1);
        } while (string2 != null);
        return string3;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public boolean getBorder() {
        return this.border;
    }

    public int getLeftRightMargin() {
        return this.leftRightMargin;
    }

    public int getMaxLineLen() {
        return this.maxLineLen;
    }

    public Dimension getMinimumSize() {
        int n = this.num_lines == 0 ? 1 : this.num_lines;
        Dimension dimension = new Dimension(this.max_width + this.leftRightMargin * 2, n * this.line_height + this.topBottomMargin * 2);
        if (dimension.width < 1) {
            dimension.width = 10;
        }
        if (dimension.height < 1) {
            dimension.height = 10;
        }
        ++dimension.height;
        return dimension;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public String getText() {
        return this.text;
    }

    public int getTopBottomMargin() {
        return this.topBottomMargin;
    }

    private void measure() {
        FontMetrics fontMetrics;
        Font font = this.getFont();
        if (font != null && (fontMetrics = this.getFontMetrics(font)) != null) {
            this.line_height = fontMetrics.getHeight();
            this.line_ascent = fontMetrics.getAscent();
            this.max_width = 0;
            int n = 0;
            while (n < this.num_lines) {
                this.line_widths[n] = fontMetrics.stringWidth(this.lines[n]);
                if (this.line_widths[n] > this.max_width) {
                    this.max_width = this.line_widths[n];
                }
                ++n;
            }
        }
    }

    public void paint(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        if (this.border) {
            graphics.setColor(SystemColor.controlShadow);
            graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        }
        n2 = this.line_ascent + (dimension.height - this.num_lines * this.line_height) / 2;
        int n3 = 0;
        while (n3 < this.num_lines) {
            switch (this.alignment) {
                case 0: {
                    n = 0;
                    break;
                }
                case 2: {
                    n = dimension.width - this.line_widths[n3];
                    break;
                }
                default: {
                    n = (dimension.width - this.line_widths[n3]) / 2;
                    break;
                }
            }
            graphics.setColor(this.getForeground());
            graphics.drawString(this.lines[n3], n += this.leftRightMargin, n2);
            ++n3;
            n2 += this.line_height;
        }
    }

    public void setAlignment(int n) {
        switch (this.alignment) {
            case 0: 
            case 1: 
            case 2: {
                this.alignment = n;
                this.repaint();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setBorder(boolean bl) {
        this.border = bl;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.measure();
        this.repaint();
    }

    public void setLeftRightMargin(int n) {
        this.leftRightMargin = n;
    }

    public void setMaxLineLen(int n) {
        this.maxLineLen = n;
    }

    public String setText(String string) {
        string = this.formatText(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, new Character('\n').toString());
        this.num_lines = stringTokenizer.countTokens();
        this.lines = new String[this.num_lines];
        this.line_widths = new int[this.num_lines];
        int n = 0;
        while (n < this.num_lines) {
            this.lines[n] = stringTokenizer.nextToken();
            ++n;
        }
        this.measure();
        this.repaint();
        this.text = new String(string);
        return this.text;
    }

    public void setTopBottomMargin(int n) {
        this.topBottomMargin = n;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

