/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist.common;

import com.ibm.sqlassist.SQLAssistPanel;
import com.ibm.sqlassist.common.ColumnObject;
import com.ibm.sqlassist.common.TableObject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;

public class JoinListPanelObject
extends Panel {
    private TableObject table;
    private Label label = new Label("", 1);
    private List list;
    private SQLAssistPanel resource;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restrictfd Rights -\nUse, duplication or disclosure restrictfd by\nGSA ADP Schedule Contract with IBM Corp.";

    public JoinListPanelObject(SQLAssistPanel sQLAssistPanel, TableObject tableObject) {
        this(sQLAssistPanel, tableObject, true);
    }

    public JoinListPanelObject(SQLAssistPanel sQLAssistPanel, TableObject tableObject, boolean bl) {
        this.resource = sQLAssistPanel;
        this.table = tableObject;
        this.build(bl);
    }

    public void build(boolean bl) {
        this.setLayout(new BorderLayout());
        this.label.setText(this.table.getName(true));
        this.label.setBackground(Color.yellow.brighter());
        this.add("North", this.label);
        int n = this.table.getColumns().size();
        this.setList(new List(n, false));
        this.add("Center", this.list);
        int n2 = 0;
        while (n2 < n) {
            this.list.add(((ColumnObject)this.table.getColumns().elementAt(n2)).getName());
            ++n2;
        }
        if (bl) {
            this.list.addItemListener(this.resource.getGui().getSqlAssistJoinPanel());
        }
    }

    public Label getLabel() {
        return this.label;
    }

    public List getList() {
        return this.list;
    }

    public int getListIndex(String string) {
        int n = 0;
        while (n < this.list.getItemCount()) {
            if (this.list.getItem(n).equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String getName() {
        return this.table.getName();
    }

    public String getQualifiedName() {
        return String.valueOf(this.table.getName()) + "." + this.list.getSelectedItem();
    }

    public TableObject getTable() {
        return this.table;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public void setList(List list) {
        this.list = list;
    }

    public void setTable(TableObject tableObject) {
        this.table = tableObject;
    }
}

