/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist.common;

import com.ibm.sqlassist.SQLAssistPanel;
import com.ibm.sqlassist.common.ColumnObject;
import com.ibm.sqlassist.common.DatabaseObject;
import com.ibm.sqlassist.common.PanelObject;
import com.ibm.sqlassist.common.SQLAssistStrings;
import com.ibm.sqlassist.common.SQLAssistUtils;
import com.ibm.sqlassist.common.TableObject;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class AddRemovePanel
extends Panel
implements ActionListener,
ItemListener {
    private SQLAssistPanel resource;
    private String title = "";
    private String selectedTitle = "";
    private Choice selectedDatabaseTablesChoice = new Choice();
    private List availableColumnsList = new List(5, true);
    private boolean isSort = false;
    private Button addButton = new Button();
    private Button removeButton = new Button();
    private Button selectAllButton = new Button();
    private Button unselectAllButton = new Button();
    private Button upButton = new Button();
    private Button downButton = new Button();
    private String lastSelectedDatabaseTablesString = "-";
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public AddRemovePanel(SQLAssistPanel sQLAssistPanel) {
        this.resource = sQLAssistPanel;
        this.build();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = true;
        this.resource.getGui().setStatus();
        if (actionEvent.getSource().equals(this.addButton)) {
            this.populateAddList();
        } else if (actionEvent.getSource().equals(this.removeButton)) {
            this.populateRemoveList();
        } else if (actionEvent.getSource().equals(this.selectAllButton)) {
            this.processSelect(true);
            bl = false;
        } else if (actionEvent.getSource().equals(this.unselectAllButton)) {
            this.processSelect(false);
            bl = false;
        } else if (actionEvent.getSource().equals(this.upButton)) {
            this.processMoveUp();
        } else if (actionEvent.getSource().equals(this.downButton)) {
            this.processMoveDown();
        }
        this.enableButtons();
        if (bl) {
            this.resource.getQuery().eventBuildSQL();
        }
    }

    private void addColumnsToAvailableList(TableObject tableObject) {
        String string = "";
        int n = 0;
        while (n < this.getSelectedList().getItemCount()) {
            string = String.valueOf(string) + this.getSelectedList().getItem(n) + " ";
            ++n;
        }
        Vector vector = tableObject.getColumns();
        String string2 = "";
        String string3 = "";
        int n2 = 0;
        while (n2 < vector.size()) {
            ColumnObject columnObject = (ColumnObject)vector.elementAt(n2);
            string2 = String.valueOf(tableObject.getName()) + "." + columnObject.getName();
            string3 = this.isSort && !this.resource.getOptions().getSupportSortTableSelect() ? string2 : columnObject.getName();
            if (string.indexOf(String.valueOf(string2) + " ") < 0) {
                if (this.isSort && !this.resource.getQuery().getDatabase().getSupportsOrderByUnrelated()) {
                    if (SQLAssistUtils.contains(this.resource.getGui().getSqlAssistFieldsPanel().getSelectedList(), string2) || this.resource.getQuery().getSelectedFields() == null) {
                        this.availableColumnsList.addItem(string3);
                    }
                } else {
                    this.availableColumnsList.addItem(string3);
                }
            }
            ++n2;
        }
    }

    public void build() {
        this.addButton.setLabel(this.resource.getString(SQLAssistStrings.Add_Button));
        this.removeButton.setLabel(this.resource.getString(SQLAssistStrings.Remove_Button));
        this.selectAllButton.setLabel(this.resource.getString(SQLAssistStrings.SelectAll_Button));
        this.unselectAllButton.setLabel(this.resource.getString(SQLAssistStrings.UnselectAll_Button));
        this.upButton.setLabel(this.resource.getString(SQLAssistStrings.Up_Button));
        this.downButton.setLabel(this.resource.getString(SQLAssistStrings.Down_Button));
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(2, 2));
        Panel panel2 = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel2.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        Label label = new Label(this.resource.getString(SQLAssistStrings.SelectedDatabaseTables_Label));
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel2.add(label);
        gridBagLayout.setConstraints(this.selectedDatabaseTablesChoice, gridBagConstraints);
        panel2.add(this.selectedDatabaseTablesChoice);
        PanelObject panelObject = new PanelObject(this.resource.getString(SQLAssistStrings.Fields_Label));
        panelObject.add("Center", this.availableColumnsList);
        if (!this.isSort || this.resource.getOptions().getSupportSortTableSelect()) {
            panel.add("North", panel2);
        }
        panel.add("Center", panelObject);
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(5, 1, 10, 10));
        panel3.add(new Label());
        panel3.add(this.addButton);
        panel3.add(this.removeButton);
        panel3.add(this.selectAllButton);
        panel3.add(this.unselectAllButton);
        this.enableButtons();
        Panel panel4 = new Panel();
        panel4.setLayout(new BorderLayout(5, 20));
        panel4.add("Center", panel3);
        panel4.add("North", new Label());
        panel4.add("East", new Label());
        panel4.add("West", new Label());
        PanelObject panelObject2 = new PanelObject(this.selectedTitle, 0);
        panelObject2.add("Center", this.buildSelectedListPanel());
        Panel panel5 = new Panel();
        panel5.setLayout(new GridLayout(1, 2, 10, 10));
        panel5.add(this.upButton);
        panel5.add(this.downButton);
        Panel panel6 = new Panel();
        panel6.setLayout(new BorderLayout(0, 0));
        panel6.add("North", SQLAssistUtils.spacer(5));
        panel6.add("South", panel5);
        panelObject2.add("South", panel6);
        Panel panel7 = new Panel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        panel7.setLayout(gridBagLayout2);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = new Insets(2, 2, 5, 2);
        panel7.add(panel);
        gridBagLayout2.setConstraints(panel, gridBagConstraints2);
        gridBagConstraints2.gridwidth = -1;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.fill = 0;
        panel7.add(panel4);
        gridBagLayout2.setConstraints(panel4, gridBagConstraints2);
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 1;
        panel7.add(panelObject2);
        gridBagLayout2.setConstraints(panelObject2, gridBagConstraints2);
        this.populateSelectedDatabaseTablesChoice();
        PanelObject panelObject3 = new PanelObject(this.title, 5);
        panelObject3.add("Center", panel7);
        this.setLayout(new BorderLayout(10, 10));
        this.add("Center", panelObject3);
        this.add("North", new Label());
        this.add("South", this.resource.getGui().buildStatusbarPanel());
        this.add("East", new Label());
        this.add("West", new Label());
        this.selectedDatabaseTablesChoice.addItemListener(this);
        this.availableColumnsList.addItemListener(this);
        this.getSelectedList().addItemListener(this);
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.selectAllButton.addActionListener(this);
        this.unselectAllButton.addActionListener(this);
        this.upButton.addActionListener(this);
        this.downButton.addActionListener(this);
    }

    public Panel buildSelectedListPanel() {
        return null;
    }

    private void enableButtons() {
        if (this.availableColumnsList.getSelectedIndexes().length > 0) {
            this.addButton.setEnabled(true);
        } else {
            this.addButton.setEnabled(false);
        }
        if (this.getSelectedList().getSelectedIndexes().length > 0) {
            this.removeButton.setEnabled(true);
            this.upButton.setEnabled(true);
            this.downButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
        if (this.getAvailableColumnsList().getItemCount() > 0 || this.getSelectedList().getItemCount() > 0) {
            this.selectAllButton.setEnabled(true);
            this.unselectAllButton.setEnabled(true);
        } else {
            this.selectAllButton.setEnabled(false);
            this.unselectAllButton.setEnabled(false);
        }
    }

    public Button getAddButton() {
        return this.addButton;
    }

    public List getAvailableColumnsList() {
        return this.availableColumnsList;
    }

    public Button getDownButton() {
        return this.downButton;
    }

    public boolean getIsSort() {
        return this.isSort;
    }

    public Button getRemoveButton() {
        return this.removeButton;
    }

    public SQLAssistPanel getResource() {
        return this.resource;
    }

    public Button getSelectAllButton() {
        return this.selectAllButton;
    }

    public Choice getSelectedDatabaseTablesChoice() {
        return this.selectedDatabaseTablesChoice;
    }

    public List getSelectedList() {
        return null;
    }

    public String getSelectedTitle() {
        return this.selectedTitle;
    }

    public String getTitle() {
        return this.title;
    }

    public Button getUnselectAllButton() {
        return this.unselectAllButton;
    }

    public Button getUpButton() {
        return this.upButton;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.resource.getGui().setStatus();
        if (itemEvent.getSource().equals(this.selectedDatabaseTablesChoice) && !this.lastSelectedDatabaseTablesString.equals(this.selectedDatabaseTablesChoice.getSelectedItem())) {
            this.lastSelectedDatabaseTablesString = this.selectedDatabaseTablesChoice.getSelectedItem();
            this.populateAvailableColumnsList();
        }
        this.enableButtons();
    }

    public void populateAddList() {
        this.populateAvailableColumnsList();
    }

    private void populateAvailableColumnsList() {
        if (this.selectedDatabaseTablesChoice.getSelectedItem() == null) {
            return;
        }
        DatabaseObject databaseObject = this.resource.getQuery().getDatabase();
        if (databaseObject == null) {
            return;
        }
        TableObject tableObject = databaseObject.getTable(this.selectedDatabaseTablesChoice.getSelectedItem());
        if (tableObject == null) {
            return;
        }
        this.availableColumnsList.removeAll();
        if (this.isSort && !this.resource.getOptions().getSupportSortTableSelect()) {
            String[] stringArray = this.resource.getQuery().getSelectedDatabaseTables();
            int n = 0;
            while (n < stringArray.length) {
                this.addColumnsToAvailableList(databaseObject.getTable(stringArray[n]));
                ++n;
            }
        } else {
            this.addColumnsToAvailableList(tableObject);
        }
        this.verifyProperties();
        if (this.resource.getGui().getSqlAssistSortPanel() != null && !this.isSort && !this.resource.getQuery().getDatabase().getSupportsOrderByUnrelated()) {
            super.populateAvailableColumnsList();
        }
    }

    private void populateRemoveList() {
        int[] nArray = this.getSelectedList().getSelectedIndexes();
        int n = nArray.length - 1;
        while (n > -1) {
            this.getSelectedList().delItem(nArray[n]);
            --n;
        }
        this.populateAvailableColumnsList();
    }

    public void populateSelectedDatabaseTablesChoice() {
        this.resource.getGui().populateSelectedDatabaseTables(this.selectedDatabaseTablesChoice, true);
        if (this.selectedDatabaseTablesChoice.getItemCount() > 0) {
            this.populateAvailableColumnsList();
        } else {
            this.availableColumnsList.removeAll();
            this.getSelectedList().removeAll();
        }
    }

    private void processMove(int n, int n2) {
        int n3 = n + n2;
        if (n3 >= 0 && n3 < this.getSelectedList().getItemCount()) {
            String string = this.getSelectedList().getItem(n);
            this.getSelectedList().delItem(n);
            this.getSelectedList().addItem(string, n3);
            this.getSelectedList().select(n3);
        }
    }

    private void processMoveDown() {
        int[] nArray = this.getSelectedList().getSelectedIndexes();
        int n = nArray.length - 1;
        while (n > -1) {
            this.processMove(nArray[n], 1);
            --n;
        }
    }

    private void processMoveUp() {
        int[] nArray = this.getSelectedList().getSelectedIndexes();
        int n = 0;
        while (n < nArray.length) {
            this.processMove(nArray[n], -1);
            ++n;
        }
    }

    private void processSelect(List list, boolean bl) {
        int n = 0;
        while (n < list.getItemCount()) {
            if (bl != list.isIndexSelected(n)) {
                if (bl) {
                    list.select(n);
                } else {
                    list.deselect(n);
                }
            }
            ++n;
        }
    }

    private void processSelect(boolean bl) {
        this.processSelect(this.getAvailableColumnsList(), bl);
        this.processSelect(this.getSelectedList(), bl);
    }

    public void refresh() {
        this.enableButtons();
    }

    public void setAddButton(Button button) {
        this.addButton = button;
    }

    public void setAvailableColumnsList(List list) {
        this.availableColumnsList = list;
    }

    public void setDownButton(Button button) {
        this.downButton = button;
    }

    public void setIsSort(boolean bl) {
        this.isSort = bl;
    }

    public void setRemoveButton(Button button) {
        this.removeButton = button;
    }

    public void setResource(SQLAssistPanel sQLAssistPanel) {
        this.resource = sQLAssistPanel;
    }

    public void setSelectAllButton(Button button) {
        this.selectAllButton = button;
    }

    public void setSelectedDatabaseTablesChoice(Choice choice) {
        this.selectedDatabaseTablesChoice = choice;
    }

    public void setSelectedTitle(String string) {
        this.selectedTitle = string;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setUnselectAllButton(Button button) {
        this.unselectAllButton = button;
    }

    public void setUpButton(Button button) {
        this.upButton = button;
    }

    public void verifyProperties() {
        if (this.resource.getQuery().getDatabase() == null) {
            this.getSelectedList().removeAll();
        } else {
            String[] stringArray = this.getSelectedList().getItems();
            String[] stringArray2 = this.resource.getQuery().getSelectedDatabaseTables(true);
            int n = stringArray.length - 1;
            while (n >= 0) {
                String string = stringArray[n];
                if (this.isSort) {
                    string = SQLAssistUtils.parseString(string, false, " ");
                }
                boolean bl = false;
                if (stringArray2 != null) {
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        if (string.indexOf(String.valueOf(stringArray2[n2]) + ".") > -1) {
                            bl = true;
                            if (!this.isSort || this.resource.getQuery().getDatabase().getSupportsOrderByUnrelated() || SQLAssistUtils.contains(this.resource.getGui().getSqlAssistFieldsPanel().getSelectedList(), string) || this.resource.getQuery().getSelectedFields() == null) break;
                            bl = false;
                            break;
                        }
                        ++n2;
                    }
                }
                if (!bl) {
                    this.getSelectedList().remove(stringArray[n]);
                }
                --n;
            }
        }
    }
}

