/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist;

import com.ibm.sqlassist.SQLAssistPanel;
import com.ibm.sqlassist.common.ColumnObject;
import com.ibm.sqlassist.common.ColumnTextField;
import com.ibm.sqlassist.common.MCLB;
import com.ibm.sqlassist.common.PanelObject;
import com.ibm.sqlassist.common.SQLAssistStrings;
import com.ibm.sqlassist.common.SQLAssistUtils;
import com.ibm.webrunner.util.SelectionSorter;
import com.ibm.webrunner.widget.ListboxColumn;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class SQLAssistVariableValueDialog
extends Dialog
implements ActionListener,
WindowListener,
KeyListener {
    private MCLB multiColumnListbox;
    private Button runButton;
    private Button cancelButton;
    private Properties values = new Properties();
    private boolean isValid = false;
    private SQLAssistPanel resource;
    private Vector colNames = new Vector();
    private Vector colValues = new Vector();
    private String typeText = "";
    private String TypeText = "";
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public SQLAssistVariableValueDialog(SQLAssistPanel sQLAssistPanel) {
        super(sQLAssistPanel.getGui().getParentFrame(), "", true);
        this.resource = sQLAssistPanel;
        this.build();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.runButton)) {
            this.setVariablesValues(true);
            this.terminate();
        } else if (actionEvent.getSource().equals(this.cancelButton)) {
            this.processCancelButton();
        }
    }

    private void build() {
        if (this.resource.getOptions().getReferToAsVariable()) {
            this.typeText = SQLAssistStrings.getText(SQLAssistStrings.variable_Text);
            this.TypeText = SQLAssistStrings.getText(SQLAssistStrings.Variable_Text);
        } else {
            this.typeText = SQLAssistStrings.getText(SQLAssistStrings.parameter_Text);
            this.TypeText = SQLAssistStrings.getText(SQLAssistStrings.Parameter_Text);
        }
        this.setTitle(this.resource.getString(SQLAssistStrings.SpecifyVariableValues_Title, new String[]{this.TypeText}));
        PanelObject panelObject = new PanelObject(String.valueOf(this.resource.getString(SQLAssistStrings.SpecifyVariableValues_Label, new String[]{this.typeText})) + ":");
        this.setMultiColumnListbox(new MCLB(this.resource, true));
        panelObject.add("Center", this.multiColumnListbox);
        this.multiColumnListbox.addColumn(this.resource.getString(SQLAssistStrings.Name_Text));
        this.multiColumnListbox.addColumn(this.resource.getString(SQLAssistStrings.Type_Text));
        this.multiColumnListbox.addColumn(this.resource.getString(SQLAssistStrings.Equals_Char));
        this.multiColumnListbox.addColumn(this.resource.getString(SQLAssistStrings.Value_Text));
        ListboxColumn listboxColumn = this.multiColumnListbox.getColumnInfo(0);
        listboxColumn.setWidth(125);
        listboxColumn.setSorter(new SelectionSorter());
        listboxColumn = this.multiColumnListbox.getColumnInfo(1);
        listboxColumn.setWidth(125);
        listboxColumn.setSorter(new SelectionSorter());
        listboxColumn = this.multiColumnListbox.getColumnInfo(2);
        listboxColumn.setWidth(25);
        listboxColumn.setSorter(new SelectionSorter());
        listboxColumn = this.multiColumnListbox.getColumnInfo(3);
        listboxColumn.setWidth(125);
        listboxColumn.setSorter(new SelectionSorter());
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(5, 5));
        panel.add("Center", panelObject);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 2, 10, 10));
        this.runButton = new Button(this.resource.getString(SQLAssistStrings.RunSQL_Button));
        this.cancelButton = new Button(this.resource.getString(SQLAssistStrings.Cancel_Button));
        panel2.add(this.runButton);
        panel2.add(this.cancelButton);
        this.runButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout());
        panel3.add("Center", new Label());
        panel3.add("East", panel2);
        panel.add("South", panel3);
        this.setLayout(new BorderLayout(10, 10));
        this.add("Center", panel);
        this.add("North", SQLAssistUtils.spacer(5));
        this.add("South", this.resource.getGui().buildStatusbarPanel());
        this.add("East", new Label());
        this.add("West", new Label());
        this.addWindowListener(this);
        this.runButton.addKeyListener(this);
        this.cancelButton.addKeyListener(this);
        this.setResizable(true);
        this.pack();
        Dimension dimension = this.getSize();
        if (dimension.height < 350 || dimension.width < 525) {
            if (dimension.height < 350) {
                dimension.height = 350;
            }
            if (dimension.width < 525) {
                dimension.width = 525;
            }
            ((Component)this).setSize(dimension);
        }
        this.refresh();
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    public boolean getIsValid() {
        return this.isValid;
    }

    public MCLB getMultiColumnListbox() {
        return this.multiColumnListbox;
    }

    public PreparedStatement getPreparedStatement() throws Exception {
        boolean bl = this.resource.getOptions().getParametersToQuestionMark();
        if (!bl) {
            this.resource.getOptions().setParametersToQuestionMark(true);
            this.resource.getQuery().buildSQL();
        }
        PreparedStatement preparedStatement = this.resource.getQuery().getDatabase().getConnection().prepareStatement(this.resource.getQuery().getSql());
        if (!bl) {
            this.resource.getOptions().setParametersToQuestionMark(bl);
            this.resource.getQuery().buildSQL();
        }
        int n = 0;
        while (n < this.multiColumnListbox.getRowCount()) {
            Object[] objectArray = this.multiColumnListbox.getRow(n);
            if (objectArray != null) {
                if (!this.resource.getOptions().getParametersToQuestionMark()) {
                    ((Label)objectArray[0]).getText();
                }
                ColumnTextField columnTextField = (ColumnTextField)objectArray[3];
                String string = columnTextField.getText();
                ColumnObject columnObject = (ColumnObject)this.multiColumnListbox.getRowKey(n);
                if (this.resource.getOptions().getSupportPrepstmtTypeConversion()) {
                    if (columnObject.getData_Type() == 4) {
                        preparedStatement.setInt(n + 1, new Integer(string));
                    } else if (columnObject.getData_Type() == -6) {
                        preparedStatement.setByte(n + 1, new Integer(string).byteValue());
                    } else if (columnObject.getData_Type() == 5) {
                        preparedStatement.setShort(n + 1, new Integer(string).shortValue());
                    } else if (columnObject.getData_Type() == -5) {
                        preparedStatement.setLong(n + 1, new Integer(string).longValue());
                    } else if (columnObject.getData_Type() == 6) {
                        preparedStatement.setFloat(n + 1, new Integer(string).floatValue());
                    } else if (columnObject.getData_Type() == 8) {
                        preparedStatement.setDouble(n + 1, new Integer(string).doubleValue());
                    } else if (columnObject.getGenericData_Type() == 2) {
                        preparedStatement.setBigDecimal(n + 1, new BigDecimal(string));
                    } else if (columnObject.getData_Type() == -7) {
                        preparedStatement.setBoolean(n + 1, new Boolean(string));
                    } else if (columnObject.getData_Type() == -3 || columnObject.getData_Type() == -4) {
                        preparedStatement.setBytes(n + 1, string.getBytes());
                    } else if (columnObject.getGenericData_Type() == 91) {
                        preparedStatement.setDate(n + 1, Date.valueOf(string));
                    } else if (columnObject.getGenericData_Type() == 92) {
                        preparedStatement.setTime(n + 1, Time.valueOf(string));
                    } else if (columnObject.getGenericData_Type() == 93) {
                        preparedStatement.setTimestamp(n + 1, Timestamp.valueOf(string));
                    } else if (columnObject.getDecimal_digits() > 0) {
                        preparedStatement.setObject(n + 1, (Object)string, columnObject.getData_Type(), columnObject.getDecimal_digits());
                    } else {
                        preparedStatement.setObject(n + 1, (Object)string, columnObject.getData_Type());
                    }
                } else if (columnObject.getDecimal_digits() > 0) {
                    preparedStatement.setObject(n + 1, (Object)string, columnObject.getData_Type(), columnObject.getDecimal_digits());
                } else {
                    preparedStatement.setObject(n + 1, (Object)string, columnObject.getData_Type());
                }
            }
            ++n;
        }
        return preparedStatement;
    }

    public Button getRunButton() {
        return this.runButton;
    }

    public Properties getValues() {
        return this.values;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27 && this.resource.getOptions().getSupportEscapeCancelDialog()) {
            this.processCancelButton();
        }
        this.setVariablesValues(false);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void processCancelButton() {
        this.setIsValid(false);
        this.terminate();
    }

    public void refresh() {
        if (this.resource.getQuery().getDatabase() == null) {
            this.terminate();
            return;
        }
        this.multiColumnListbox.removeAllRows();
        this.resource.getGui().setStatus();
        Vector vector = this.resource.getQuery().getAvailableVariablesAsColumnObjects();
        this.multiColumnListbox.setUpdate(false);
        Object[][] objectArray = new Object[vector.size()][4];
        Object[] objectArray2 = new Object[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            ColumnObject columnObject = (ColumnObject)vector.elementAt(n);
            Label label = new Label(columnObject.getName());
            label.setFont(this.resource.getOptions().getDefaultVariableFont());
            objectArray[n][0] = label;
            objectArray[n][1] = columnObject.getType_Name();
            objectArray[n][2] = this.resource.getString(SQLAssistStrings.Equals_Char);
            columnObject.setDefaultValue(this.getValues().getProperty(String.valueOf(columnObject.getName()) + columnObject.getGenericData_Type(), ""));
            ColumnTextField columnTextField = new ColumnTextField(this.resource, columnObject, true);
            columnTextField.setIsVariable(false);
            columnTextField.addKeyListener(this);
            objectArray[n][3] = columnTextField;
            objectArray2[n] = columnObject;
            ++n;
        }
        this.multiColumnListbox.addRows(objectArray, objectArray2);
        this.multiColumnListbox.setUpdate(true);
        this.setVariablesValues(false);
        this.show();
    }

    public void setCancelButton(Button button) {
        this.cancelButton = button;
    }

    public void setIsValid(boolean bl) {
        this.isValid = bl;
    }

    public void setMultiColumnListbox(MCLB mCLB) {
        this.multiColumnListbox = mCLB;
    }

    public void setRunButton(Button button) {
        this.runButton = button;
    }

    public void setValues(Properties properties) {
        this.values = properties;
    }

    private void setVariablesValues(boolean bl) {
        this.setIsValid(true);
        int n = 0;
        while (n < this.multiColumnListbox.getRowCount()) {
            Object[] objectArray = this.multiColumnListbox.getRow(n);
            if (objectArray != null) {
                String string = ((Label)objectArray[0]).getText();
                ColumnTextField columnTextField = (ColumnTextField)objectArray[3];
                String string2 = columnTextField.getText();
                if (bl) {
                    ((Hashtable)this.getValues()).put(String.valueOf(string) + columnTextField.getColumnObject().getGenericData_Type(), string2);
                }
                if (string2.equals("")) {
                    this.setIsValid(false);
                }
            }
            ++n;
        }
        this.runButton.setEnabled(this.getIsValid());
    }

    private void terminate() {
        this.dispose();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setIsValid(false);
        this.terminate();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

