/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist;

import com.ibm.sqlassist.SQLAssistConditionPanel;
import com.ibm.sqlassist.SQLAssistPanel;
import com.ibm.sqlassist.SQLAssistSchemaDialog;
import com.ibm.sqlassist.SQLAssistTableNamePatternDialog;
import com.ibm.sqlassist.common.CheckboxComparator;
import com.ibm.sqlassist.common.MCLB;
import com.ibm.sqlassist.common.PanelObject;
import com.ibm.sqlassist.common.SQLAssistStrings;
import com.ibm.sqlassist.common.SQLAssistUtils;
import com.ibm.sqlassist.common.TableObject;
import com.ibm.webrunner.util.SelectionSorter;
import com.ibm.webrunner.util.Sorter;
import com.ibm.webrunner.widget.ListboxColumn;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Vector;

public class SQLAssistTablesPanel
extends Panel
implements ActionListener,
ItemListener {
    private List selectedDatabaseTablesList;
    private Checkbox selectCheckbox;
    private Checkbox insertCheckbox;
    private Checkbox updateCheckbox;
    private Checkbox deleteCheckbox;
    private Checkbox selectUniqueCheckbox;
    private Button schemaButton;
    private Button tableNamePatternButton;
    private Button refreshButton;
    private SQLAssistPanel resource;
    private MCLB availableTablesListbox;
    private CheckboxGroup typeCheckboxGroup = new CheckboxGroup();
    private int totalColumns = 0;
    private Checkbox lastSelectedCheckbox;
    private Checkbox lastSelectedTableCheckbox;
    private Label selectTablesLabel;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public SQLAssistTablesPanel(SQLAssistPanel sQLAssistPanel) {
        this.resource = sQLAssistPanel;
        this.build();
        this.getProperties();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.getSchemaButton())) {
            this.processSchemaButton();
        } else if (actionEvent.getSource().equals(this.getTableNamePatternButton())) {
            this.processTableNamePatternButton();
        } else if (actionEvent.getSource().equals(this.getRefreshButton())) {
            this.populateAvailableTablesListbox();
        }
    }

    private synchronized void build() {
        Panel panel;
        Serializable serializable;
        Serializable serializable2;
        PanelObject panelObject;
        this.selectTablesLabel = new Label();
        this.availableTablesListbox = new MCLB(this.resource, false);
        this.setSelectedDatabaseTablesList(new List(5, false));
        this.selectCheckbox = new Checkbox(this.resource.getString(SQLAssistStrings.Select_Text), false, this.typeCheckboxGroup);
        this.selectUniqueCheckbox = new Checkbox(this.resource.getString(SQLAssistStrings.SelectUnique_Text), false, this.typeCheckboxGroup);
        this.insertCheckbox = new Checkbox(this.resource.getString(SQLAssistStrings.Insert_Text), false, this.typeCheckboxGroup);
        this.updateCheckbox = new Checkbox(this.resource.getString(SQLAssistStrings.Update_Text), false, this.typeCheckboxGroup);
        this.deleteCheckbox = new Checkbox(this.resource.getString(SQLAssistStrings.Delete_Text), false, this.typeCheckboxGroup);
        this.setTypeCheckbox();
        this.processTypeCheckbox();
        if (this.resource.getOptions().getDisplayStatementType()) {
            panelObject = new PanelObject(this.resource.getString(SQLAssistStrings.TablesPanelType_Title), 5);
            serializable2 = new Panel();
            ((Container)serializable2).setLayout(new BorderLayout());
            ((Container)serializable2).add("North", new Label(this.resource.getString(SQLAssistStrings.StatementType_Label)));
            serializable = new Panel();
            ((Container)serializable).setLayout(new FlowLayout());
            if (this.resource.getOptions().getDisplaySelect()) {
                ((Container)serializable).add(this.selectCheckbox);
            }
            if (this.resource.getOptions().getDisplaySelectUnique()) {
                ((Container)serializable).add(this.selectUniqueCheckbox);
            }
            if (this.resource.getOptions().getDisplayInsert()) {
                ((Container)serializable).add(this.insertCheckbox);
            }
            if (this.resource.getOptions().getDisplayUpdate()) {
                ((Container)serializable).add(this.updateCheckbox);
            }
            if (this.resource.getOptions().getDisplayDelete()) {
                ((Container)serializable).add(this.deleteCheckbox);
            }
            ((Container)serializable2).add("West", (Component)serializable);
            panelObject.add("Center", (Component)serializable2);
        } else {
            panelObject = new PanelObject(this.resource.getString(SQLAssistStrings.TablesPanel_Title), 5);
        }
        this.availableTablesListbox.addColumn("");
        this.availableTablesListbox.addColumn(this.resource.getString(SQLAssistStrings.TableName_Text));
        if (this.resource.getOptions().getDisplayTableRemarks()) {
            this.availableTablesListbox.addColumn(this.resource.getString(SQLAssistStrings.Remarks_Text));
        }
        serializable2 = this.availableTablesListbox.getColumnInfo(0);
        ((ListboxColumn)serializable2).setWidth(10);
        serializable2 = this.availableTablesListbox.getColumnInfo(1);
        ((ListboxColumn)serializable2).setWidth(225);
        serializable = new SelectionSorter();
        ((Sorter)serializable).setComparator(new CheckboxComparator());
        ((ListboxColumn)serializable2).setSorter((Sorter)serializable);
        if (this.resource.getOptions().getDisplayTableRemarks()) {
            serializable2 = this.availableTablesListbox.getColumnInfo(2);
            ((ListboxColumn)serializable2).setWidth(500);
            ((ListboxColumn)serializable2).setSorter(new SelectionSorter());
        }
        this.populateAvailableTablesListbox();
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout(5, 5));
        if (this.resource.getOptions().getDisplayStatementType()) {
            panel2.add("North", this.selectTablesLabel);
        }
        panel2.add("Center", this.availableTablesListbox);
        Vector<Button> vector = new Vector<Button>();
        if (this.resource.getOptions().getSupportSchema()) {
            this.setSchemaButton(new Button(this.resource.getString(SQLAssistStrings.ViewSchema_Button)));
            vector.addElement(this.getSchemaButton());
            this.getSchemaButton().addActionListener(this);
            try {
                if (this.resource.getQuery().getDatabase().getSchemas().size() == 0) {
                    this.getSchemaButton().setVisible(false);
                }
            }
            catch (Exception exception) {}
        }
        if (this.resource.getOptions().getSupportTableNamePattern()) {
            this.setTableNamePatternButton(new Button(this.resource.getString(SQLAssistStrings.FilterTables_Button)));
            vector.addElement(this.getTableNamePatternButton());
            this.getTableNamePatternButton().addActionListener(this);
        }
        if (this.resource.getOptions().getSupportRefreshTableList()) {
            if (this.resource.getGui().getRefreshButtonLabel() != null) {
                this.setRefreshButton(new Button(this.resource.getGui().getRefreshButtonLabel()));
            } else {
                this.setRefreshButton(new Button(this.resource.getString(SQLAssistStrings.Refresh_Button)));
            }
            vector.addElement(this.getRefreshButton());
            this.getRefreshButton().addActionListener(this);
        }
        if (vector.size() > 0) {
            panel = new Panel();
            panel.setLayout(new GridLayout(1, vector.size(), 10, 10));
            int n = 0;
            while (n < vector.size()) {
                panel.add((Button)vector.elementAt(n));
                ++n;
            }
            Panel panel3 = new Panel();
            panel3.setLayout(new BorderLayout(0, 0));
            panel3.add("Center", new Label(" "));
            panel3.add("East", panel);
            panel2.add("South", panel3);
        }
        panel = new Panel();
        panel.setLayout(new BorderLayout(5, 5));
        panel.add("North", panelObject);
        panel.add("Center", panel2);
        this.setLayout(new BorderLayout(10, 10));
        this.add("North", new Label());
        this.add("South", this.resource.getGui().buildStatusbarPanel());
        this.add("East", new Label());
        this.add("West", new Label());
        this.add("Center", panel);
        this.selectCheckbox.addItemListener(this);
        this.selectUniqueCheckbox.addItemListener(this);
        this.insertCheckbox.addItemListener(this);
        this.updateCheckbox.addItemListener(this);
        this.deleteCheckbox.addItemListener(this);
        this.selectCheckbox.setEnabled(this.resource.getOptions().getEnableSelect());
        this.selectUniqueCheckbox.setEnabled(this.resource.getOptions().getEnableSelectUnique());
        this.insertCheckbox.setEnabled(this.resource.getOptions().getEnableInsert());
        this.updateCheckbox.setEnabled(this.resource.getOptions().getEnableUpdate());
        this.deleteCheckbox.setEnabled(this.resource.getOptions().getEnableDelete());
    }

    private void checkSelections() {
        Object object;
        int n;
        boolean bl = false;
        if (this.resource.getQuery().getType() != 0 && this.resource.getQuery().getType() != 1) {
            n = 0;
            while (n < this.availableTablesListbox.getRowCount()) {
                object = this.availableTablesListbox.getRow(n);
                Checkbox checkbox = (Checkbox)object[1];
                if (checkbox.getState() && checkbox != this.lastSelectedTableCheckbox) {
                    checkbox.setState(false);
                    bl = true;
                }
                ++n;
            }
        }
        this.populateSelectedDatabaseTablesList();
        if (bl) {
            n = 0;
            while (n < this.resource.getGui().getSqlAssistConditionPanelVector().size()) {
                object = (SQLAssistConditionPanel)this.resource.getGui().getSqlAssistConditionPanelVector().elementAt(n);
                ((SQLAssistConditionPanel)object).reset();
                ++n;
            }
            this.resource.getGui().setStatus(this.resource.getString(SQLAssistStrings.OnlyOneTable_Msg));
        }
    }

    public Checkbox getDeleteCheckbox() {
        return this.deleteCheckbox;
    }

    public Checkbox getInsertCheckbox() {
        return this.insertCheckbox;
    }

    public synchronized void getProperties() {
        String string = this.resource.getProperties().getProperty("101", "");
        if (string != null && !string.equals("")) {
            try {
                this.resource.getQuery().setType(Integer.parseInt(string));
            }
            catch (Exception exception) {}
        }
        this.setTypeCheckbox();
        this.processTypeCheckbox();
        int n = Integer.parseInt(this.resource.getProperties().getProperty("102", "0"));
        this.lastSelectedTableCheckbox = null;
        int n2 = 0;
        while (n2 < this.availableTablesListbox.getRowCount()) {
            Object[] objectArray = this.availableTablesListbox.getRow(n2);
            Checkbox checkbox = (Checkbox)objectArray[1];
            boolean bl = false;
            String string2 = "";
            int n3 = 0;
            while (n3 < n) {
                string2 = this.resource.getProperties().getProperty("103_{0}", "", new String[]{"" + n3});
                if (string2 != null && (checkbox.getLabel().equals(string2) || checkbox.getLabel().equals(SQLAssistUtils.parseString(string2, true, "_")))) {
                    if (this.lastSelectedTableCheckbox == null) {
                        this.lastSelectedTableCheckbox = checkbox;
                    }
                    checkbox.setState(true);
                    bl = true;
                    break;
                }
                if (!bl) {
                    checkbox.setState(false);
                }
                ++n3;
            }
            ++n2;
        }
        this.recreateAliases(n);
        this.populateSelectedDatabaseTablesList();
        this.resource.getGui().refreshButtons(true);
    }

    public Button getRefreshButton() {
        return this.refreshButton;
    }

    public Button getSchemaButton() {
        return this.schemaButton;
    }

    public Checkbox getSelectCheckbox() {
        return this.selectCheckbox;
    }

    public List getSelectedDatabaseTablesList() {
        return this.selectedDatabaseTablesList;
    }

    public Checkbox getSelectUniqueCheckbox() {
        return this.selectUniqueCheckbox;
    }

    public Button getTableNamePatternButton() {
        return this.tableNamePatternButton;
    }

    public Checkbox getUpdateCheckbox() {
        return this.updateCheckbox;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.resource.getGui().setStatus();
        if (itemEvent.getSource().equals(this.selectCheckbox) || itemEvent.getSource().equals(this.selectUniqueCheckbox) || itemEvent.getSource().equals(this.insertCheckbox) || itemEvent.getSource().equals(this.updateCheckbox) || itemEvent.getSource().equals(this.deleteCheckbox)) {
            this.processTypeCheckbox();
        } else if (((Checkbox)itemEvent.getSource()).getState()) {
            this.lastSelectedTableCheckbox = (Checkbox)itemEvent.getSource();
        } else {
            TableObject tableObject = this.resource.getQuery().getDatabase().getTable(((Checkbox)itemEvent.getSource()).getLabel());
            if (tableObject != null) {
                this.resource.getQuery().getDatabase().removeAlias(tableObject);
                this.populateSelectedDatabaseTablesList();
                if (this.resource.getGui().getSqlAssistJoinPanel() != null) {
                    this.resource.getGui().getSqlAssistJoinPanel().rebuild(true);
                }
            }
        }
        this.checkSelections();
        this.resource.getQuery().eventBuildSQL();
    }

    public void populateAvailableTablesListbox() {
        int n;
        String[] stringArray = this.resource.getQuery().getSelectedDatabaseTables();
        String string = "";
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                string = String.valueOf(string) + stringArray[n] + " ";
                ++n;
            }
        }
        this.availableTablesListbox.removeAllRows();
        try {
            n = 0;
            while (n < this.resource.getQuery().getDatabase().getTables().size()) {
                TableObject tableObject = (TableObject)this.resource.getQuery().getDatabase().getTables().elementAt(n);
                Checkbox checkbox = new Checkbox(tableObject.getName(false));
                if (string.indexOf(String.valueOf(checkbox.getLabel()) + " ") > -1) {
                    checkbox.setState(true);
                }
                checkbox.addItemListener(this);
                Object[] objectArray = new Object[]{" ", checkbox, tableObject.getRemarks()};
                this.availableTablesListbox.addRow(objectArray, tableObject);
                ++n;
            }
            this.populateSelectedDatabaseTablesList();
        }
        catch (Exception exception) {
            this.resource.getGui().handleException(exception);
        }
    }

    public synchronized void populateSelectedDatabaseTablesList() {
        Object object;
        this.getSelectedDatabaseTablesList().removeAll();
        int n = 0;
        while (n < this.availableTablesListbox.getRowCount()) {
            object = this.availableTablesListbox.getRow(n);
            Checkbox checkbox = (Checkbox)object[1];
            String string = checkbox.getLabel();
            TableObject tableObject = this.resource.getQuery().getDatabase().getTable(string);
            if (checkbox.getState() && tableObject != null) {
                if (tableObject.getColumns().size() == 0) {
                    try {
                        this.retrieveColumns(tableObject);
                    }
                    catch (Exception exception) {
                        this.resource.getGui().handleException(exception);
                    }
                }
                if (tableObject.getColumns().size() > 0) {
                    if (tableObject.getAliasIndex() == 1) {
                        this.getSelectedDatabaseTablesList().addItem(checkbox.getLabel());
                    } else {
                        int n2 = 0;
                        while (n2 < tableObject.getAliasIndex()) {
                            this.getSelectedDatabaseTablesList().addItem(String.valueOf(checkbox.getLabel()) + "_" + (n2 + 1));
                            ++n2;
                        }
                    }
                } else {
                    checkbox.setState(false);
                    this.resource.getGui().displayExceptionDialog(this.resource.getString(SQLAssistStrings.NoColumns_Msg, new Object[]{tableObject.getName()}));
                }
            }
            ++n;
        }
        if (this.resource.getGui().currentPage(this.resource.getString(SQLAssistStrings.Tables_Text))) {
            this.resource.getGui().refreshButtons(true);
        }
        if (this.resource.getGui().getSqlAssistConditionPanelVector() != null) {
            n = 0;
            while (n < this.resource.getGui().getSqlAssistConditionPanelVector().size()) {
                object = (SQLAssistConditionPanel)this.resource.getGui().getSqlAssistConditionPanelVector().elementAt(n);
                if (!SQLAssistUtils.contains(this.getSelectedDatabaseTablesList(), ((SQLAssistConditionPanel)object).getSelectedDatabaseTablesChoice().getSelectedItem())) {
                    if (this.resource.getGui().getSqlAssistConditionPanelVector().size() == 1) {
                        ((SQLAssistConditionPanel)object).reset();
                    } else {
                        this.resource.getGui().getSqlAssistConditionPanelVector().removeElement(object);
                        this.resource.getGui().removeCondition(this.resource.getString(SQLAssistStrings.Condition_nn_Text, new Object[]{"" + ((SQLAssistConditionPanel)object).getConditionIndex()}));
                    }
                }
                ++n;
            }
        }
        this.resource.getGui().refreshPanels(true);
    }

    public void processSchemaButton() {
        SQLAssistSchemaDialog sQLAssistSchemaDialog = new SQLAssistSchemaDialog(this.resource);
        ((Component)sQLAssistSchemaDialog).setVisible(true);
    }

    public void processTableNamePatternButton() {
        String string = this.resource.getQuery().getTableNamePattern();
        String string2 = SQLAssistUtils.arrayToString(this.resource.getQuery().getDatabase().getTable_Type());
        SQLAssistTableNamePatternDialog sQLAssistTableNamePatternDialog = new SQLAssistTableNamePatternDialog(this.resource);
        ((Component)sQLAssistTableNamePatternDialog).setVisible(true);
        if (!this.resource.getQuery().getTableNamePattern().equals(string) || !string2.equals(SQLAssistUtils.arrayToString(this.resource.getQuery().getDatabase().getTable_Type()))) {
            this.resource.getQuery().getDatabase().setTables(new Vector());
            try {
                if (this.resource.getOptions().getSupportSchema()) {
                    this.resource.getQuery().getDatabase().retrieveSchemas(this.resource.getQuery().getSchema(), this.resource.getQuery().getTableNamePattern());
                } else {
                    this.resource.getQuery().getDatabase().retrieveTables(this.resource.getQuery().getSchema(), this.resource.getQuery().getTableNamePattern());
                }
            }
            catch (Exception exception) {
                this.resource.getGui().handleException(exception);
            }
            this.populateAvailableTablesListbox();
            this.resource.getGui().refreshPanels(true);
            this.resource.getQuery().eventBuildSQL();
        }
    }

    private void processTypeCheckbox() {
        int[] nArray = null;
        if (this.selectUniqueCheckbox.getState()) {
            this.resource.getQuery().setType(1);
        } else if (this.insertCheckbox.getState()) {
            this.resource.getQuery().setType(2);
        } else if (this.updateCheckbox.getState()) {
            this.resource.getQuery().setType(3);
        } else if (this.deleteCheckbox.getState()) {
            this.resource.getQuery().setType(4);
        } else {
            this.resource.getQuery().setType(0);
        }
        if (this.resource.getQuery().getType() == 0 || this.resource.getQuery().getType() == 1) {
            this.selectTablesLabel.setText(this.resource.getString(SQLAssistStrings.SelectTables_Label));
        } else {
            this.selectTablesLabel.setText(this.resource.getString(SQLAssistStrings.SelectTable_Label));
            Vector vector = this.resource.getQuery().getDatabase().getTables();
            int n = vector.size() - 1;
            while (n >= 0) {
                TableObject tableObject = (TableObject)vector.elementAt(n);
                if (tableObject.getIsAlias()) {
                    vector.removeElement(tableObject);
                } else if (tableObject.getAliasIndex() > 1) {
                    tableObject.reset();
                }
                --n;
            }
        }
        if (this.lastSelectedCheckbox != this.typeCheckboxGroup.getSelectedCheckbox()) {
            if (!(this.typeCheckboxGroup.getSelectedCheckbox() != this.selectCheckbox && this.typeCheckboxGroup.getSelectedCheckbox() != this.selectUniqueCheckbox || this.lastSelectedCheckbox != this.selectCheckbox && this.lastSelectedCheckbox != this.selectUniqueCheckbox)) {
                this.lastSelectedCheckbox = this.typeCheckboxGroup.getSelectedCheckbox();
            } else {
                this.lastSelectedCheckbox = this.typeCheckboxGroup.getSelectedCheckbox();
                this.resource.getGui().buildNotebook();
            }
        }
        if (this.resource.getQuery().getType() != 0 && this.resource.getQuery().getType() != 1) {
            nArray = this.availableTablesListbox.getSelectedIndexes();
            int n = 0;
            while (n < nArray.length - 1) {
                this.availableTablesListbox.deselectRow(nArray[n]);
                ++n;
            }
        }
    }

    public synchronized void putProperties() {
        this.resource.getProperties().put("101", "" + this.resource.getQuery().getType());
        String[] stringArray = this.resource.getQuery().getSelectedDatabaseTables(false);
        if (stringArray == null) {
            return;
        }
        this.resource.getProperties().put("102", "" + stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            this.resource.getProperties().put("103_{0}", stringArray[n], new String[]{"" + n});
            ++n;
        }
    }

    private void recreateAliases(int n) {
        if (n <= 0) {
            return;
        }
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            String string = this.resource.getProperties().getProperty("103_{0}", "", new String[]{"" + n4});
            if (string.indexOf("_") > -1) {
                try {
                    String string2 = string;
                    n2 = Integer.parseInt(SQLAssistUtils.parseString(string2, false, "_"));
                    TableObject tableObject = this.resource.getQuery().getDatabase().getTable(SQLAssistUtils.parseString(string2, true, "_"));
                    if (n2 == 1) {
                        if (tableObject.getColumns().size() == 0) {
                            this.retrieveColumns(tableObject);
                        }
                    } else if (n2 > 1) {
                        this.resource.getQuery().getDatabase().addTable(tableObject.createAlias());
                        ++n3;
                    }
                }
                catch (Exception exception) {}
            }
            ++n4;
        }
    }

    private void retrieveColumns(TableObject tableObject) {
        if (tableObject != null) {
            this.resource.getGui().setStatus(this.resource.getString(SQLAssistStrings.RetrievingTableDetails_Msg, new Object[]{tableObject.getName()}));
            try {
                tableObject.retrieveColumns();
            }
            catch (Exception exception) {}
            this.resource.getGui().setStatus();
        }
    }

    public void setDeleteCheckbox(Checkbox checkbox) {
        this.deleteCheckbox = checkbox;
    }

    public void setInsertCheckbox(Checkbox checkbox) {
        this.insertCheckbox = checkbox;
    }

    public void setRefreshButton(Button button) {
        this.refreshButton = button;
    }

    public void setSchemaButton(Button button) {
        this.schemaButton = button;
    }

    public void setSelectCheckbox(Checkbox checkbox) {
        this.selectCheckbox = checkbox;
    }

    public void setSelectedDatabaseTablesList(List list) {
        this.selectedDatabaseTablesList = list;
    }

    public void setSelectUniqueCheckbox(Checkbox checkbox) {
        this.selectUniqueCheckbox = checkbox;
    }

    public void setTableNamePatternButton(Button button) {
        this.tableNamePatternButton = button;
    }

    private void setTypeCheckbox() {
        switch (this.resource.getQuery().getType()) {
            case 1: {
                this.selectUniqueCheckbox.setState(true);
                break;
            }
            case 2: {
                this.insertCheckbox.setState(true);
                break;
            }
            case 3: {
                this.updateCheckbox.setState(true);
                break;
            }
            case 4: {
                this.deleteCheckbox.setState(true);
                break;
            }
            default: {
                this.selectCheckbox.setState(true);
                break;
            }
        }
        this.lastSelectedCheckbox = this.typeCheckboxGroup.getSelectedCheckbox();
    }

    public void setTypeCheckbox(int n) {
        this.resource.getQuery().setType(n);
        this.setTypeCheckbox();
    }

    public void setUpdateCheckbox(Checkbox checkbox) {
        this.updateCheckbox = checkbox;
    }
}

