/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist;

import com.ibm.sqlassist.SQLAssistPanel;
import com.ibm.sqlassist.common.AddRemovePanel;
import com.ibm.sqlassist.common.PanelObject;
import com.ibm.sqlassist.common.SQLAssistStrings;
import com.ibm.sqlassist.common.SQLAssistUtils;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.List;
import java.awt.Panel;

public class SQLAssistSortPanel
extends AddRemovePanel {
    private List sortList;
    private Choice selectedSortOrderChoice;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public SQLAssistSortPanel(SQLAssistPanel sQLAssistPanel) {
        super(sQLAssistPanel);
    }

    public void build() {
        this.setIsSort(true);
        this.sortList = new List(5, true);
        this.setTitle(this.getResource().getString(SQLAssistStrings.SortPanel_Title));
        this.setSelectedTitle(this.getResource().getString(SQLAssistStrings.SortOrder_Label));
        super.build();
        this.getProperties();
    }

    public Panel buildSelectedListPanel() {
        this.selectedSortOrderChoice = new Choice();
        this.selectedSortOrderChoice.addItem(this.getResource().getString(SQLAssistStrings.Ascending_Text));
        this.selectedSortOrderChoice.addItem(this.getResource().getString(SQLAssistStrings.Descending_Text));
        this.selectedSortOrderChoice.select(0);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(5, 5));
        panel.add("North", this.selectedSortOrderChoice);
        PanelObject panelObject = new PanelObject(this.getResource().getString(SQLAssistStrings.FieldsToSortOn_Label));
        panelObject.add("Center", this.getSelectedList());
        panel.add("Center", panelObject);
        return panel;
    }

    public synchronized void getProperties() {
        int n = Integer.parseInt(this.getResource().getProperties().getProperty("401", "0"));
        int n2 = 0;
        while (n2 < n) {
            String string = this.getResource().getProperties().getProperty("403_{0}", "", new String[]{"" + n2});
            if (string != null && !string.equals("") && this.getResource().getQuery().getDatabase().validateColumnExists(string)) {
                String string2 = this.getResource().getProperties().getProperty("402_{0}", "", new String[]{"" + n2});
                string = string2.equals("1") ? String.valueOf(this.getResource().getString(SQLAssistStrings.sortZA_Text)) + " " + string : String.valueOf(this.getResource().getString(SQLAssistStrings.sortAZ_Text)) + " " + string;
                this.getSelectedList().addItem(string);
            }
            ++n2;
        }
        this.populateAddList();
    }

    public List getSelectedList() {
        return this.sortList;
    }

    public List getSortList() {
        return this.sortList;
    }

    public void populateAddList() {
        String[] stringArray = this.getAvailableColumnsList().getSelectedItems();
        String string = "";
        String string2 = "";
        int[] nArray = this.getSelectedList().getSelectedIndexes();
        int n = this.getSelectedList().getItemCount();
        if (nArray.length > 0) {
            n = nArray[nArray.length - 1] + 1;
        }
        int n2 = stringArray.length - 1;
        while (n2 > -1) {
            boolean bl = false;
            if (this.getSelectedDatabaseTablesChoice().getSelectedItem() != null) {
                string = !this.getResource().getOptions().getSupportSortTableSelect() ? stringArray[n2] : String.valueOf(this.getSelectedDatabaseTablesChoice().getSelectedItem()) + "." + stringArray[n2];
                int n3 = 0;
                while (n3 < this.getSelectedList().getItemCount()) {
                    string2 = this.getSelectedList().getItem(n3);
                    if ((string2 = string2.substring(string2.indexOf(" ") + 1)).equals(string)) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
            }
            if (!bl) {
                string = this.selectedSortOrderChoice.getSelectedItem().equals(this.getResource().getString(SQLAssistStrings.Ascending_Text)) ? String.valueOf(this.getResource().getString(SQLAssistStrings.sortAZ_Text)) + " " + string : String.valueOf(this.getResource().getString(SQLAssistStrings.sortZA_Text)) + " " + string;
                this.getSelectedList().addItem(string, n);
            }
            --n2;
        }
        super.populateAddList();
    }

    public void populateSelectedDatabaseTablesChoice() {
        super.populateSelectedDatabaseTablesChoice();
        this.verifyProperties();
    }

    public synchronized void putProperties() {
        String[] stringArray = this.getResource().getQuery().getSelectedSortFields();
        if (stringArray == null) {
            return;
        }
        this.getResource().getProperties().put("401", "" + stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            if (SQLAssistUtils.parseString(stringArray[n], true, " ").equals(this.getResource().getString(SQLAssistStrings.sortZA_Text))) {
                this.getResource().getProperties().put("402_{0}", "1", new String[]{"" + n});
            } else {
                this.getResource().getProperties().put("402_{0}", "0", new String[]{"" + n});
            }
            this.getResource().getProperties().put("403_{0}", SQLAssistUtils.parseString(stringArray[n], false, " "), new String[]{"" + n});
            ++n;
        }
    }

    public void setSortList(List list) {
        this.sortList = list;
    }
}

