/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist;

import com.ibm.sqlassist.SQLAssistConditionPanel;
import com.ibm.sqlassist.SQLAssistPanel;
import com.ibm.sqlassist.SQLAssistResultSetDialog;
import com.ibm.sqlassist.SQLAssistVariableValueDialog;
import com.ibm.sqlassist.common.ColumnObject;
import com.ibm.sqlassist.common.ColumnTextField;
import com.ibm.sqlassist.common.DatabaseObject;
import com.ibm.sqlassist.common.JoinObject;
import com.ibm.sqlassist.common.MCLB;
import com.ibm.sqlassist.common.PanelObject;
import com.ibm.sqlassist.common.SQLAssistStrings;
import com.ibm.sqlassist.common.SQLAssistUtils;
import com.ibm.sqlassist.common.TableObject;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Vector;

public class SQLAssistSQLPanel
extends Panel
implements ActionListener,
ItemListener,
MouseListener,
KeyListener {
    private TextArea statementTextArea = new TextArea("", 5, 10);
    private Vector variableNames = new Vector();
    private Vector variableTypes = new Vector();
    private Button runButton;
    private Button saveSQLButton;
    private Button undoButton;
    private Button copyToClipboardButton;
    private Checkbox schemaQualifiedNamesCheckbox = new Checkbox(SQLAssistStrings.getText(SQLAssistStrings.SchemaQualifiedNames), true);
    private SQLAssistPanel resource;
    private Choice selectedDatabaseTablesChoice = new Choice();
    private List availableColumnsList = new List(5, false);
    private TableObject currentTable;
    private ColumnObject currentColumn;
    private String lastSelectedDatabaseTablesString = "-";
    private boolean selectAll = false;
    private boolean editSQLWarningMessageDisplayed = false;
    private ActionListener saveSQLListener;
    private ActionListener saveResultListener;
    private ActionListener runSQLListener;
    private SQLAssistVariableValueDialog sqlassistVariableValueDialog;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public SQLAssistSQLPanel(SQLAssistPanel sQLAssistPanel) {
        this.resource = sQLAssistPanel;
        this.build();
        this.getProperties();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.saveSQLButton)) {
            this.processSaveSQLButton();
        } else if (actionEvent.getSource().equals(this.undoButton)) {
            this.processUndoButton();
        } else if (actionEvent.getSource().equals(this.runButton)) {
            this.processRunButton();
        } else if (actionEvent.getSource() == this.copyToClipboardButton) {
            this.processCopyToClipboardButton();
        }
    }

    private void addVariable(ColumnTextField columnTextField, ColumnObject columnObject) {
        this.getVariableNames().addElement(columnTextField.getText());
        this.getVariableTypes().addElement("" + columnObject.getData_Type());
    }

    private void build() {
        PanelObject panelObject;
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(5, 5));
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        PanelObject panelObject2 = new PanelObject(this.resource.getString(SQLAssistStrings.SelectedDatabaseTables_Label));
        panelObject2.add("Center", this.selectedDatabaseTablesChoice);
        PanelObject panelObject3 = new PanelObject(this.resource.getString(SQLAssistStrings.Fields_Label));
        panelObject3.add("Center", this.availableColumnsList);
        panel2.add("North", panelObject2);
        panel2.add("Center", panelObject3);
        panel.add("Center", panel2);
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout(5, 5));
        if (this.resource.getOptions().getSupportEditSQL()) {
            panel3.add("North", new Label(this.resource.getString(SQLAssistStrings.SQLStatement_Label)));
        }
        panel3.add("Center", this.statementTextArea);
        if (this.resource.getOptions().getSchemaQualifiedNames() && this.checkSchemaQualifiedNamesEnablement()) {
            panel3.add("South", this.schemaQualifiedNamesCheckbox);
        }
        this.schemaQualifiedNamesCheckbox.setState(true);
        this.schemaQualifiedNamesCheckbox.addItemListener(this);
        this.statementTextArea.setEditable(this.resource.getOptions().getSupportEditSQL());
        if (this.resource.getOptions().getSupportEditSQL()) {
            panelObject = new PanelObject(this.resource.getString(SQLAssistStrings.SQLPanelEdit_Title), 5);
            panelObject.add("West", panel);
        } else {
            panelObject = new PanelObject(this.resource.getString(SQLAssistStrings.SQLPanel_Title), 5);
        }
        panelObject.add("Center", panel3);
        Vector<Button> vector = new Vector<Button>();
        if (this.resource.getOptions().getSupportEditSQL()) {
            this.undoButton = new Button(this.resource.getString(SQLAssistStrings.Undo_Button));
            this.undoButton.addActionListener(this);
            vector.addElement(this.undoButton);
        }
        if (this.resource.getOptions().getSupportSQLCopyToClipboard()) {
            this.copyToClipboardButton = new Button(this.resource.getString(SQLAssistStrings.CopyToClipboard_Button));
            this.copyToClipboardButton.addActionListener(this);
            vector.addElement(this.copyToClipboardButton);
        }
        if (this.resource.getOptions().getSupportSaveSQL()) {
            this.saveSQLButton = new Button(this.resource.getString(SQLAssistStrings.SaveSQL_Button));
            this.saveSQLButton.addActionListener(this);
            this.saveSQLListener = this;
            vector.addElement(this.saveSQLButton);
        }
        if ((this.resource.getOptions().getSupportRunSQLSelect() || this.resource.getOptions().getSupportRunSQLSelectUnique() || this.resource.getOptions().getSupportRunSQLInsert() || this.resource.getOptions().getSupportRunSQLUpdate() || this.resource.getOptions().getSupportRunSQLDelete()) && this.resource.getQuery().getDatabase().getConnection() != null) {
            this.runButton = new Button(this.resource.getString(SQLAssistStrings.RunSQL_Button));
            this.runButton.addActionListener(this);
            this.runSQLListener = this;
            vector.addElement(this.runButton);
        }
        Panel panel4 = new Panel();
        if (vector.size() > 0) {
            panel4.setLayout(new GridLayout(1, vector.size(), 10, 10));
            int n = 0;
            while (n < vector.size()) {
                panel4.add((Button)vector.elementAt(n));
                ++n;
            }
        }
        Panel panel5 = new Panel();
        panel5.setLayout(new BorderLayout());
        panel5.add("Center", new Label());
        panel5.add("East", panel4);
        if (vector.size() > 0) {
            panelObject.add("South", panel5);
        }
        this.setLayout(new BorderLayout(10, 10));
        this.add("Center", panelObject);
        this.add("North", new Label());
        this.add("South", this.resource.getGui().buildStatusbarPanel());
        this.add("East", new Label());
        this.add("West", new Label());
        this.populateSelectedDatabaseTablesChoice();
        this.selectedDatabaseTablesChoice.addItemListener(this);
        this.availableColumnsList.addMouseListener(this);
        this.statementTextArea.addKeyListener(this);
    }

    private String buildColumnsSQLText() {
        if (this.resource.getGui().getSqlAssistFieldsPanel() == null) {
            return "";
        }
        String string = "";
        if (this.resource.getGui().getSqlAssistFieldsPanel().getViewList().getItemCount() < 1) {
            string = String.valueOf(string) + "   *";
            this.selectAll = true;
        } else {
            int n = 0;
            while (n < this.resource.getGui().getSqlAssistFieldsPanel().getViewList().getItemCount()) {
                string = String.valueOf(string) + "   ";
                String string2 = this.resource.getGui().getSqlAssistFieldsPanel().getViewList().getItem(n);
                string = String.valueOf(string) + "   " + string2;
                if (n < this.resource.getGui().getSqlAssistFieldsPanel().getViewList().getItemCount() - 1) {
                    string = String.valueOf(string) + ",\n";
                }
                ++n;
            }
        }
        if (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private String buildInsertSQLText(boolean bl) {
        if (this.resource.getGui().getSqlAssistInsertPanel() == null) {
            return "";
        }
        String string = "";
        MCLB mCLB = this.resource.getGui().getSqlAssistInsertPanel().getMultiColumnListbox();
        int n = 0;
        while (n < mCLB.getRowCount()) {
            ColumnObject columnObject = (ColumnObject)mCLB.getRowKey(n);
            Object[] objectArray = mCLB.getRow(n);
            ColumnTextField columnTextField = (ColumnTextField)objectArray[3];
            String string2 = columnTextField.getText();
            if (columnTextField.getIsVariable() && bl) {
                this.addVariable(columnTextField, columnObject);
            }
            if (!string2.equals("")) {
                if (!string.equals("")) {
                    string = String.valueOf(string) + ",\n";
                }
                string = String.valueOf(string) + "      ";
                string = bl ? String.valueOf(string) + this.resource.getQuery().getName(columnObject) : (!columnObject.quoteValue() || columnTextField.getIsVariable() ? String.valueOf(string) + string2 : String.valueOf(string) + "'" + string2 + "'");
            }
            ++n;
        }
        if (!bl) {
            string = this.checkVariables(string);
        }
        if (string.equals("")) {
            return "";
        }
        if ((string = "   (\n" + string + "\n   )\n").endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        if (bl) {
            return string;
        }
        return "\n    VALUES\n" + string;
    }

    private String buildOrderBySQLText() {
        if (this.resource.getGui().getSqlAssistSortPanel() == null) {
            return "";
        }
        String string = "";
        if (this.resource.getGui().getSqlAssistSortPanel().getSortList().getItemCount() > 0) {
            string = String.valueOf(string) + "ORDER BY\n";
            int n = 0;
            while (n < this.resource.getGui().getSqlAssistSortPanel().getSortList().getItemCount()) {
                String string2 = SQLAssistUtils.parseString(this.resource.getGui().getSqlAssistSortPanel().getSortList().getItem(n), false, " ");
                string = String.valueOf(string) + "   " + string2;
                if (!this.resource.getGui().getSqlAssistSortPanel().getSortList().getItem(n).startsWith(this.resource.getString(SQLAssistStrings.sortAZ_Text))) {
                    string = String.valueOf(string) + " DESC";
                }
                if (n < this.resource.getGui().getSqlAssistSortPanel().getSortList().getItemCount() - 1) {
                    string = String.valueOf(string) + ",\n";
                }
                ++n;
            }
        }
        if (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private String buildTableJoinedSQLText() {
        if (this.resource.getQuery().getType() != 0 && this.resource.getQuery().getType() != 1) {
            return "";
        }
        String[] stringArray = this.resource.getQuery().getSelectedDatabaseTables(false);
        if (stringArray == null || this.resource.getGui().getSqlAssistJoinPanel() == null) {
            return "";
        }
        String string = "";
        Vector vector = (Vector)this.resource.getGui().getSqlAssistJoinPanel().getJoins().clone();
        int n = 0;
        while (n < stringArray.length) {
            DatabaseObject databaseObject = this.resource.getQuery().getDatabase();
            TableObject tableObject = databaseObject.getTable(stringArray[n]);
            boolean bl = true;
            if (this.resource.getGui().getSqlAssistJoinPanel() != null && this.resource.getGui().getSqlAssistJoinPanel().usedInJoins(tableObject)) {
                String string2 = "";
                int n2 = 0;
                while (n2 < vector.size()) {
                    boolean bl2 = false;
                    JoinObject joinObject = (JoinObject)vector.elementAt(n2);
                    if (!(this.resource.getQuery().getDatabase().isOracle() && joinObject.isOuterJoin() || joinObject.getType() == 0 || joinObject.getJlpo1().getTable() != tableObject)) {
                        if (!string2.equals("")) {
                            string2 = String.valueOf(string2) + ",\n";
                        }
                        string2 = tableObject.getAliasIndex() > 1 ? String.valueOf(string2) + this.resource.getQuery().getName(tableObject, false) + " " + this.resource.getQuery().getName(tableObject) : String.valueOf(string2) + "   " + stringArray[n];
                        int n3 = 0;
                        while (n3 < this.resource.getGui().getSqlAssistJoinPanel().getJoins().size()) {
                            JoinObject joinObject2 = (JoinObject)this.resource.getGui().getSqlAssistJoinPanel().getJoins().elementAt(n3);
                            if ((!this.resource.getQuery().getDatabase().isOracle() || !joinObject2.isOuterJoin()) && joinObject.getType() != 0 && joinObject2.getType() != 0 && this.resource.getQuery().getName(joinObject.getJlpo1().getTable()).equals(this.resource.getQuery().getName(joinObject2.getJlpo1().getTable())) && this.resource.getQuery().getName(joinObject.getJlpo2().getTable()).equals(this.resource.getQuery().getName(joinObject2.getJlpo2().getTable()))) {
                                if (bl) {
                                    if (joinObject2.getType() == 1) {
                                        string2 = String.valueOf(string2) + " LEFT OUTER JOIN";
                                    } else if (joinObject2.getType() == 2) {
                                        string2 = String.valueOf(string2) + " RIGHT OUTER JOIN";
                                    } else if (joinObject2.getType() == 3) {
                                        string2 = String.valueOf(string2) + " FULL OUTER JOIN";
                                    }
                                    bl = false;
                                    string2 = String.valueOf(string2) + " ";
                                    if (joinObject2.getJlpo2().getTable().getAliasIndex() > 1) {
                                        string2 = String.valueOf(string2) + this.resource.getQuery().getName(joinObject2.getJlpo2().getTable(), false) + " ";
                                    }
                                    string2 = String.valueOf(string2) + this.resource.getQuery().getName(joinObject2.getJlpo2().getTable());
                                    string2 = String.valueOf(string2) + "\n      ON ( ";
                                } else {
                                    string2 = String.valueOf(string2) + "\n      AND ";
                                }
                                string2 = String.valueOf(string2) + this.resource.getQuery().getName(joinObject2.getJlpo1().getTable()) + "." + this.resource.getQuery().getName(joinObject2.getCobj1()) + " = " + this.resource.getQuery().getName(joinObject2.getJlpo2().getTable()) + "." + this.resource.getQuery().getName(joinObject2.getCobj2());
                                vector.removeElement(joinObject2);
                                bl2 = true;
                            }
                            ++n3;
                        }
                    }
                    if (bl2) continue;
                    ++n2;
                }
                if (!string2.equals("")) {
                    string = String.valueOf(string) + string2;
                    string = String.valueOf(string) + " )\n";
                }
            }
            ++n;
        }
        if (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private String buildTableNonJoinedSQLText() {
        String[] stringArray = this.resource.getQuery().getSelectedDatabaseTables(false);
        if (stringArray == null) {
            return "";
        }
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            DatabaseObject databaseObject = this.resource.getQuery().getDatabase();
            TableObject tableObject = databaseObject.getTable(stringArray[n]);
            String string2 = null;
            if (!(tableObject == null || this.resource.getGui().getSqlAssistJoinPanel() != null && this.resource.getGui().getSqlAssistJoinPanel().usedInJoins(tableObject))) {
                string2 = tableObject.getAliasIndex() > 1 ? String.valueOf(this.resource.getQuery().getName(tableObject, false)) + " " + this.resource.getQuery().getName(tableObject, true) : this.resource.getQuery().getName(tableObject, false);
            }
            if (string2 != null) {
                if (!string.equals("")) {
                    string = String.valueOf(string) + ",\n";
                }
                string = String.valueOf(string) + "   " + string2;
            }
            ++n;
        }
        if (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private String buildTableSQLText() {
        String[] stringArray = this.resource.getQuery().getSelectedDatabaseTables(false);
        if (stringArray == null) {
            this.resource.getQuery().setIsValid(false);
            return "";
        }
        String string = "";
        String string2 = this.buildTableNonJoinedSQLText();
        String string3 = this.buildTableJoinedSQLText();
        string = String.valueOf(string) + string2;
        if (!string2.equals("") && !string3.equals("")) {
            string = String.valueOf(string) + ",\n";
        }
        if ((string = String.valueOf(string) + string3).endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private String buildUpdateSQLText() {
        if (this.resource.getGui().getSqlAssistUpdatePanel() == null) {
            return "";
        }
        String string = "";
        MCLB mCLB = this.resource.getGui().getSqlAssistUpdatePanel().getMultiColumnListbox();
        int n = 0;
        while (n < mCLB.getRowCount()) {
            ColumnObject columnObject = (ColumnObject)mCLB.getRowKey(n);
            Object[] objectArray = mCLB.getRow(n);
            ColumnTextField columnTextField = (ColumnTextField)objectArray[3];
            String string2 = columnTextField.getText();
            if (columnTextField.getIsVariable()) {
                this.addVariable(columnTextField, columnObject);
            }
            if (!string2.equals("")) {
                string = !string.equals("") ? String.valueOf(string) + ",\n   " : String.valueOf(string) + "SET ";
                string = String.valueOf(string) + this.resource.getQuery().getName(columnObject) + " = ";
                string = !columnObject.quoteValue() || columnTextField.getIsVariable() ? String.valueOf(string) + string2 : String.valueOf(string) + "'" + string2 + "'";
            }
            ++n;
        }
        if (string.equals("")) {
            return "";
        }
        if (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        return this.checkVariables(string);
    }

    private String buildWhereConditionSQLText() {
        if (this.resource.getGui().getSqlAssistConditionPanelVector().size() == 0) {
            return "";
        }
        String string = "";
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (n2 < this.resource.getGui().getSqlAssistConditionPanelVector().size()) {
            SQLAssistConditionPanel sQLAssistConditionPanel = (SQLAssistConditionPanel)this.resource.getGui().getSqlAssistConditionPanelVector().elementAt(n2);
            if (sQLAssistConditionPanel.getIsValid()) {
                String string2;
                ++n;
                if (!bl) {
                    string = String.valueOf(string) + "      ( ";
                    bl = true;
                } else if (n > 1) {
                    string2 = "OR";
                    if (sQLAssistConditionPanel.getFindType().equals(this.resource.getString(SQLAssistStrings.AND_Text))) {
                        string2 = "AND";
                    }
                    string = String.valueOf(string) + "   " + string2 + "\n";
                    string = String.valueOf(string) + "      ( ";
                }
                string2 = null;
                if (sQLAssistConditionPanel.getSelectedDatabaseTablesChoice().getSelectedItem() != null) {
                    string2 = sQLAssistConditionPanel.getSelectedDatabaseTablesChoice().getSelectedItem();
                }
                String string3 = this.resource.getQuery().getName(String.valueOf(string2) + "." + sQLAssistConditionPanel.getAvailableColumnsList().getSelectedItem());
                if (this.resource.getOptions().getEnableDistinctTypeSupport() && sQLAssistConditionPanel.getEnableDistinctTypeSupportCheckbox().getState() && sQLAssistConditionPanel.getCurrentColumn() != null && !sQLAssistConditionPanel.getCurrentColumn().getTypeSize().equals("")) {
                    string3 = "CAST ( " + string3 + " AS " + sQLAssistConditionPanel.getCurrentColumn().getTypeSize() + " )";
                }
                String[] stringArray = sQLAssistConditionPanel.getCurrentTypeArray()[sQLAssistConditionPanel.getOperatorList().getSelectedIndex()];
                String string4 = null;
                String string5 = null;
                boolean bl2 = false;
                boolean bl3 = false;
                if (stringArray[3].equals("0")) {
                    if (sQLAssistConditionPanel.getSelectedDatabaseTablesChoice().getSelectedItem() != null) {
                        sQLAssistConditionPanel.getSelectedDatabaseTablesChoice().getSelectedItem();
                        String string6 = "";
                        string6 = SQLAssistUtils.replaceText(stringArray[4], "%COL%", string3);
                        string = String.valueOf(string) + "\n         ";
                        string = String.valueOf(string) + string6;
                        string = String.valueOf(string) + " OR ";
                    }
                } else {
                    int n3 = stringArray[3].equals("1") ? 1 : sQLAssistConditionPanel.getValuesMultiColumnListbox().getResults().length;
                    int n4 = 0;
                    while (n4 < n3) {
                        string5 = null;
                        string4 = sQLAssistConditionPanel.getValuesMultiColumnListbox().getResults()[n4][0];
                        bl2 = sQLAssistConditionPanel.getValuesMultiColumnListbox().getResultsIsVariable()[n4][0];
                        bl3 = sQLAssistConditionPanel.getValuesMultiColumnListbox().getResultsIsVariable()[n4][1];
                        if (!sQLAssistConditionPanel.getValuesMultiColumnListbox().getResults()[n4][1].equals("")) {
                            string5 = sQLAssistConditionPanel.getValuesMultiColumnListbox().getResults()[n4][1];
                        }
                        if (!(string4 == null || string4.equals("") || stringArray[3].equals("B") && (string5 == null || string5.equals("")) || sQLAssistConditionPanel.getSelectedDatabaseTablesChoice().getSelectedItem() == null)) {
                            sQLAssistConditionPanel.getSelectedDatabaseTablesChoice().getSelectedItem();
                            String string7 = "";
                            string7 = SQLAssistUtils.replaceText(stringArray[4], "%COL%", string3);
                            string = String.valueOf(string) + "\n         ";
                            boolean bl4 = false;
                            switch (sQLAssistConditionPanel.getCurrentColumn().getGenericData_Type()) {
                                case 91: {
                                    if (string7.indexOf("MONTH(") != -1 || string7.indexOf("DAYOFWEEK(") != -1 || string7.indexOf("YEAR(") != -1) break;
                                    bl4 = true;
                                    break;
                                }
                                case 1: 
                                case 92: 
                                case 93: {
                                    bl4 = true;
                                }
                            }
                            String string8 = "%VAL%";
                            if (bl4) {
                                if (sQLAssistConditionPanel.getCurrentColumn().getGenericData_Type() == 1 && string4 != null) {
                                    if (string7.indexOf("%%VAL%%") > -1) {
                                        string4 = "%" + string4 + "%";
                                        string8 = "%%VAL%%";
                                    } else if (string7.indexOf("%%VAL%") > -1) {
                                        string4 = "%" + string4;
                                        string8 = "%%VAL%";
                                    } else if (string7.indexOf("%VAL%%") > -1) {
                                        string4 = String.valueOf(string4) + "%";
                                        string8 = "%VAL%%";
                                    }
                                }
                                if (string4 != null && !bl2) {
                                    string4 = "'" + string4 + "'";
                                }
                                if (string5 != null && !bl3) {
                                    string5 = "'" + string5 + "'";
                                }
                            }
                            string7 = SQLAssistUtils.replaceText(string7, string8, string4);
                            if (bl2) {
                                String string9 = sQLAssistConditionPanel.getValuesMultiColumnListbox().getResultsNames()[n4][0];
                                this.variableNames.addElement(string9);
                                int n5 = sQLAssistConditionPanel.getCurrentColumn().getData_Type();
                                if (!(n5 != 91 && n5 != sQLAssistConditionPanel.getCurrentColumn().getGenericData_Type() || string7.indexOf("MONTH(") <= -1 && string7.indexOf("DAYOFWEEK(") <= -1 && string7.indexOf("YEAR(") <= -1)) {
                                    n5 = 4;
                                }
                                this.variableTypes.addElement("" + n5);
                            }
                            if (string5 != null) {
                                string7 = SQLAssistUtils.replaceText(string7, "%VAL2%", string5);
                                if (bl3) {
                                    this.variableNames.addElement(sQLAssistConditionPanel.getValuesMultiColumnListbox().getResultsNames()[n4][1]);
                                    this.variableTypes.addElement("" + sQLAssistConditionPanel.getCurrentColumn().getData_Type());
                                }
                            }
                            string = String.valueOf(string) + string7;
                            string = String.valueOf(string) + " OR ";
                        }
                        ++n4;
                    }
                }
                if (string.endsWith(" OR ")) {
                    string = string.substring(0, string.length() - 4);
                }
                string = String.valueOf(string) + "\n";
                string = String.valueOf(string) + "      )\n";
            }
            ++n2;
        }
        if (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        return this.checkVariables(string);
    }

    private String buildWhereJoinSQLText() {
        if (this.resource.getGui().getSqlAssistJoinPanel() == null || this.resource.getGui().getSqlAssistJoinPanel().getJoins() == null) {
            return "";
        }
        String string = "";
        int n = 0;
        int n2 = 0;
        while (n2 < this.resource.getGui().getSqlAssistJoinPanel().getJoins().size()) {
            JoinObject joinObject = (JoinObject)this.resource.getGui().getSqlAssistJoinPanel().getJoins().elementAt(n2);
            if (joinObject.getType() == 0 || this.resource.getQuery().getDatabase().isOracle() && joinObject.isOuterJoin()) {
                string = ++n > 1 ? String.valueOf(string) + " AND" : String.valueOf(string) + "      ( ";
                string = String.valueOf(string) + "\n        " + this.resource.getQuery().getName(joinObject.getJlpo1().getTable()) + "." + this.resource.getQuery().getName(joinObject.getCobj1());
                if (this.resource.getQuery().getDatabase().isOracle() && joinObject.getType() == 2) {
                    string = String.valueOf(string) + " (+) ";
                }
                string = String.valueOf(string) + " = " + this.resource.getQuery().getName(joinObject.getJlpo2().getTable()) + "." + this.resource.getQuery().getName(joinObject.getCobj2());
                if (this.resource.getQuery().getDatabase().isOracle() && joinObject.getType() == 1) {
                    string = String.valueOf(string) + " (+) ";
                }
            }
            ++n2;
        }
        if (n > 0) {
            string = String.valueOf(string) + "\n      )\n";
        }
        if (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private String buildWhereSQLText() {
        String string = "";
        String string2 = this.buildWhereJoinSQLText();
        String string3 = this.buildWhereConditionSQLText();
        string = String.valueOf(string) + string2;
        boolean bl = false;
        if (!string2.equals("") && !string3.equals("")) {
            bl = true;
        }
        if (!string3.equals("") && !string.equals("")) {
            string = String.valueOf(string) + "\n     AND" + "\n";
        }
        if ((string = bl ? String.valueOf(string) + "    ( " + string3.trim() + " )" : String.valueOf(string) + string3).equals("")) {
            return "";
        }
        if (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        return "WHERE\n   (\n" + string + "\n   )";
    }

    private boolean checkSchemaQualifiedNamesEnablement() {
        boolean bl = true;
        if (this.resource.getQuery().getLogin() == null || this.resource.getQuery().getLogin().equals("")) {
            bl = false;
        }
        this.schemaQualifiedNamesCheckbox.setEnabled(bl);
        return bl;
    }

    private String checkVariables(String string) {
        Vector vector = this.resource.getQuery().getAvailableVariablesAsColumnObjects();
        if (vector == null || vector.size() == 0) {
            return string;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < vector.size()) {
            ColumnObject columnObject = (ColumnObject)vector.elementAt(n2);
            String string2 = columnObject.getName();
            if (this.resource.getOptions().getParametersToQuestionMark()) {
                n = string.indexOf(string2);
                string = SQLAssistUtils.replaceFirstTextVariable(string, string2, "?");
                string2 = "?";
            }
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            try {
                int n3;
                int n4 = string.indexOf(string2, n);
                int n5 = n4 - 1;
                n = n3 = n4 + string2.length();
                if (n4 > -1) {
                    if (n5 > -1 && (string3 = string.substring(n5, n5 + 1)).equals(" ")) {
                        string3 = "";
                    }
                    if (n3 > -1 && (string4 = string.substring(n3, n3 + 1)).equals(" ")) {
                        string4 = "";
                    }
                }
                if ((string5 = String.valueOf(string3) + string2 + string4).startsWith("%") && string5.endsWith("%")) {
                    string6 = "'%'||" + string2 + "||'%'";
                } else if (string5.startsWith("%")) {
                    string6 = "'%'||" + string2;
                } else if (string5.endsWith("%")) {
                    string6 = String.valueOf(string2) + "||'%'";
                }
                if (!string6.equals("")) {
                    string = SQLAssistUtils.replaceFirstText(string, string5, string6);
                    n = n4 + string6.length();
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        return string;
    }

    private void enableButtons(boolean bl) {
        SQLAssistUtils.enableButton(this.saveSQLButton, bl);
        if (bl) {
            switch (this.resource.getQuery().getType()) {
                case 0: {
                    bl = this.resource.getOptions().getSupportRunSQLSelect();
                    break;
                }
                case 1: {
                    bl = this.resource.getOptions().getSupportRunSQLSelectUnique();
                    break;
                }
                case 2: {
                    bl = this.resource.getOptions().getSupportRunSQLInsert();
                    break;
                }
                case 3: {
                    bl = this.resource.getOptions().getSupportRunSQLUpdate();
                    break;
                }
                case 4: {
                    bl = this.resource.getOptions().getSupportRunSQLDelete();
                    break;
                }
            }
        }
        SQLAssistUtils.enableButton(this.runButton, bl);
    }

    public Button getCopyToClipboardButton() {
        return this.copyToClipboardButton;
    }

    public synchronized void getProperties() {
        if (this.resource.getProperties().getProperty("801", "TRUE").equalsIgnoreCase("TRUE") || !this.schemaQualifiedNamesCheckbox.isEnabled()) {
            this.schemaQualifiedNamesCheckbox.setState(true);
        } else {
            this.schemaQualifiedNamesCheckbox.setState(false);
        }
    }

    public Button getRunButton() {
        return this.runButton;
    }

    public Button getSaveSQLButton() {
        return this.saveSQLButton;
    }

    public Checkbox getSchemaQualifiedNamesCheckbox() {
        return this.schemaQualifiedNamesCheckbox;
    }

    public TextArea getStatementTextArea() {
        return this.statementTextArea;
    }

    public Button getUndoButton() {
        return this.undoButton;
    }

    public Vector getVariableNames() {
        return this.variableNames;
    }

    public Vector getVariableTypes() {
        return this.variableTypes;
    }

    public void initVariables() {
        this.setVariableNames(new Vector());
        this.setVariableTypes(new Vector());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.resource.getGui().setStatus();
        if (itemEvent.getSource().equals(this.schemaQualifiedNamesCheckbox)) {
            this.resource.getQuery().buildSQL();
        } else if (itemEvent.getSource().equals(this.selectedDatabaseTablesChoice)) {
            if (this.selectedDatabaseTablesChoice.getSelectedItem() != null) {
                if (!this.lastSelectedDatabaseTablesString.equals(this.selectedDatabaseTablesChoice.getSelectedItem())) {
                    this.lastSelectedDatabaseTablesString = this.selectedDatabaseTablesChoice.getSelectedItem();
                    this.currentTable = this.resource.getQuery().getDatabase().getTable(this.lastSelectedDatabaseTablesString);
                    this.currentColumn = null;
                    this.populateAvailableColumnsList();
                }
            } else {
                this.currentTable = null;
                this.currentColumn = null;
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource().equals(this.statementTextArea)) {
            if (this.resource.getOptions().getSupportEditSQL()) {
                if (this.resource.getOptions().getDisplayEditWarning() && !this.editSQLWarningMessageDisplayed) {
                    this.editSQLWarningMessageDisplayed = true;
                    this.resource.getGui().displayMessageDialog(this.resource.getString(SQLAssistStrings.Warning_Title), this.resource.getString(SQLAssistStrings.Warning_Label), this.resource.getString(SQLAssistStrings.Warning_Msg));
                    keyEvent.consume();
                    this.statementTextArea.requestFocus();
                }
                this.resource.getQuery().setSql(this.statementTextArea.getText());
            }
            this.schemaQualifiedNamesCheckbox.setEnabled(false);
            this.resource.getQuery().setManuallyModified(true);
            if (this.resource.getQuery().getAvailableVariableNames() != null) {
                SQLAssistUtils.enableButton(this.runButton, false);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.availableColumnsList) && mouseEvent.getClickCount() == 2) {
            this.currentColumn = this.currentTable.getColumn(this.availableColumnsList.getSelectedItem());
            this.statementTextArea.insert(String.valueOf(this.resource.getQuery().getName(this.currentTable)) + "." + this.resource.getQuery().getName(this.currentColumn), this.statementTextArea.getSelectionStart());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void populateAvailableColumnsList() {
        if (this.resource.getQuery().getDatabase() == null) {
            return;
        }
        this.currentTable = this.resource.getQuery().getDatabase().getTable(this.selectedDatabaseTablesChoice.getSelectedItem());
        if (this.currentTable == null) {
            return;
        }
        this.availableColumnsList.removeAll();
        int n = 0;
        while (n < this.currentTable.getColumns().size()) {
            this.availableColumnsList.addItem(this.resource.getQuery().getName((ColumnObject)this.currentTable.getColumns().elementAt(n)));
            ++n;
        }
    }

    public void populateSelectedDatabaseTablesChoice() {
        this.resource.getGui().populateSelectedDatabaseTables(this.selectedDatabaseTablesChoice, true);
        if (this.selectedDatabaseTablesChoice.getItemCount() > 0) {
            this.populateAvailableColumnsList();
        } else {
            this.availableColumnsList.removeAll();
        }
    }

    public void populateStatementTextArea() {
        String string = "";
        this.resource.getQuery().setIsValid(true);
        this.initVariables();
        if (this.resource.getQuery().getType() == 2 && this.resource.getGui().getSqlAssistInsertPanel() != null) {
            string = "INSERT INTO\n" + this.buildTableSQLText() + "\n" + this.buildInsertSQLText(true) + this.buildInsertSQLText(false);
            if (this.resource.getQuery().getIsValid()) {
                this.resource.getQuery().setIsValid(this.resource.getGui().getSqlAssistInsertPanel().getIsValid());
            }
        } else if (this.resource.getQuery().getType() == 3 && this.resource.getGui().getSqlAssistUpdatePanel() != null) {
            string = "UPDATE\n" + this.buildTableSQLText() + "\n" + this.buildUpdateSQLText() + "\n" + this.buildWhereSQLText();
            if (this.resource.getQuery().getIsValid()) {
                this.resource.getQuery().setIsValid(this.resource.getGui().getSqlAssistUpdatePanel().getIsValid());
            }
        } else if (this.resource.getQuery().getType() == 4) {
            String string2 = this.buildWhereSQLText();
            string = "DELETE FROM\n  " + this.buildTableSQLText() + "\n" + string2;
            if (string2.equals("")) {
                this.resource.getQuery().setIsValid(false);
            }
        } else {
            string = "SELECT";
            if (this.resource.getQuery().getType() == 1) {
                string = String.valueOf(string) + " " + "DISTINCT";
            }
            string = String.valueOf(string) + "\n" + this.buildColumnsSQLText() + "\nFROM\n" + this.buildTableSQLText() + "\n";
            String string3 = this.buildWhereSQLText();
            string = String.valueOf(string) + string3;
            if (!string3.equals("")) {
                string = String.valueOf(string) + "\n";
            }
            string = String.valueOf(string) + this.buildOrderBySQLText();
        }
        if (this.resource.getGui().getNotebook().getTab().equals(this.resource.getString(SQLAssistStrings.SQL_Text))) {
            if (!this.resource.getQuery().getIsValid() || this.buildTableSQLText().equals("")) {
                this.resource.getGui().setStatus(this.resource.getString(SQLAssistStrings.InvalidSQL_Msg));
                this.enableButtons(false);
            } else {
                this.resource.getGui().setStatus();
                this.enableButtons(true);
            }
        }
        if (!this.schemaQualifiedNamesCheckbox.getState() && this.resource.getQuery().getLogin() != null && !this.resource.getQuery().getLogin().equals("")) {
            string = SQLAssistUtils.replaceText(string, " " + this.resource.getQuery().getLogin() + ".", " ");
            string = SQLAssistUtils.replaceText(string, " " + this.resource.getQuery().getLogin().toUpperCase() + ".", " ");
        }
        this.statementTextArea.setText(String.valueOf(string) + "\n");
        try {
            this.statementTextArea.setCaretPosition(0);
        }
        catch (Exception exception) {}
        SQLAssistUtils.enableButton(this.resource.getGui().getFinishButton(), this.resource.getQuery().getIsValid());
        if (this.runButton != null) {
            if (this.resource.getQuery().getAvailableVariableNames() != null && !this.resource.getOptions().getDisplayVariableValueDialog()) {
                SQLAssistUtils.enableButton(this.runButton, false);
            } else {
                SQLAssistUtils.enableButton(this.runButton, true);
            }
        }
    }

    private void processCopyToClipboardButton() {
        this.resource.getGui().copyToClipboard(this.statementTextArea.getText());
    }

    private void processRunButton() {
        String string = this.resource.getQuery().getSql();
        PreparedStatement preparedStatement = null;
        if (this.resource.getQuery().getAvailableVariables() != null) {
            if (this.sqlassistVariableValueDialog == null) {
                this.sqlassistVariableValueDialog = new SQLAssistVariableValueDialog(this.resource);
            } else {
                this.sqlassistVariableValueDialog.refresh();
            }
            if (!this.sqlassistVariableValueDialog.getIsValid()) {
                return;
            }
            try {
                preparedStatement = this.sqlassistVariableValueDialog.getPreparedStatement();
            }
            catch (Exception exception) {
                this.resource.getGui().handleException(exception);
                return;
            }
        }
        this.resource.getGui().setStatus(this.resource.getString(SQLAssistStrings.RunningQuery_Msg));
        try {
            ResultSet resultSet = null;
            if (preparedStatement == null) {
                resultSet = this.resource.getQuery().getDatabase().execute(string, this.resource.getOptions().getQueryTimeout(), 0);
            } else {
                try {
                    preparedStatement.setQueryTimeout(this.resource.getOptions().getQueryTimeout());
                }
                catch (Exception exception) {}
                preparedStatement.execute();
                this.resource.getQuery().getDatabase().setStatement(preparedStatement);
                try {
                    this.resource.getQuery().getDatabase().setResultSet(preparedStatement.getResultSet());
                }
                catch (Exception exception) {}
            }
            new SQLAssistResultSetDialog(this.resource, this.resource.getQuery().getType(), this.resource.getQuery().getDatabase().getResultSet(), this.saveResultListener);
            try {
                resultSet.close();
                preparedStatement = null;
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            this.resource.getGui().handleException(this.resource.getString(SQLAssistStrings.QueryFailed_Text), exception);
            this.resource.getGui().setStatus(this.resource.getString(SQLAssistStrings.QueryFailed_Text));
        }
    }

    public void processSaveSQLButton() {
        try {
            SQLAssistUtils.saveToFile(this.resource.getGui().getParentFrame(), this.resource.getString(SQLAssistStrings.SaveStatement_Title), this.resource.getQuery().getSql(), "*.sql");
        }
        catch (Exception exception) {
            this.resource.getGui().handleException(exception);
        }
    }

    private void processUndoButton() {
        this.resource.getQuery().buildSQL();
        this.checkSchemaQualifiedNamesEnablement();
        this.resource.getQuery().setManuallyModified(false);
    }

    public synchronized void putProperties() {
        this.resource.getProperties().put("801", "" + this.schemaQualifiedNamesCheckbox.getState());
    }

    public ActionListener replaceResultListener(ActionListener actionListener) {
        ActionListener actionListener2 = this.saveResultListener;
        this.saveResultListener = actionListener;
        return actionListener2;
    }

    public ActionListener replaceRunListener(ActionListener actionListener) {
        if (this.runButton != null) {
            ActionListener actionListener2 = this.runSQLListener;
            this.runButton.removeActionListener(actionListener2);
            this.runButton.addActionListener(actionListener);
            this.runSQLListener = actionListener;
            return actionListener2;
        }
        return null;
    }

    public ActionListener replaceSaveListener(ActionListener actionListener) {
        if (this.saveSQLButton != null) {
            ActionListener actionListener2 = this.saveSQLListener;
            this.saveSQLButton.removeActionListener(actionListener2);
            this.saveSQLButton.addActionListener(actionListener);
            this.saveSQLListener = actionListener;
            return actionListener2;
        }
        return null;
    }

    public void setCopyToClipboardButton(Button button) {
        this.copyToClipboardButton = button;
    }

    public void setRunButton(Button button) {
        this.runButton = button;
    }

    public void setSaveSQLButton(Button button) {
        this.saveSQLButton = button;
    }

    public void setSchemaQualifiedNamesCheckbox(Checkbox checkbox) {
        this.schemaQualifiedNamesCheckbox = checkbox;
    }

    public void setStatementTextArea(TextArea textArea) {
        this.statementTextArea = textArea;
    }

    public void setUndoButton(Button button) {
        this.undoButton = button;
    }

    public void setVariableNames(Vector vector) {
        this.variableNames = vector;
    }

    public void setVariableTypes(Vector vector) {
        this.variableTypes = vector;
    }

    private Vector sortVariablesBySize(Vector vector) {
        int n = 0;
        while (n < vector.size() - 1) {
            ColumnObject columnObject = (ColumnObject)vector.elementAt(n);
            int n2 = n;
            while (n2 < vector.size()) {
                ColumnObject columnObject2 = (ColumnObject)vector.elementAt(n2);
                if (columnObject.getName().length() < columnObject2.getName().length()) {
                    vector.setElementAt(columnObject2, n);
                    vector.setElementAt(columnObject, n2);
                    columnObject = (ColumnObject)vector.elementAt(n);
                }
                ++n2;
            }
            ++n;
        }
        return vector;
    }
}

