/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist;

import com.ibm.sqlassist.SQLAssistPanel;
import com.ibm.sqlassist.common.ConnectEvent;
import com.ibm.sqlassist.common.ConnectListener;
import com.ibm.sqlassist.common.DatabaseObject;
import com.ibm.sqlassist.common.DualLabelButton;
import com.ibm.sqlassist.common.ExitEvent;
import com.ibm.sqlassist.common.ImagePanel;
import com.ibm.sqlassist.common.PanelObject;
import com.ibm.sqlassist.common.SQLAssistStrings;
import com.ibm.sqlassist.common.SQLAssistUtils;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.Serializable;
import java.util.Vector;

public class SQLAssistLogonPanel
extends ImagePanel
implements TextListener,
ActionListener,
KeyListener,
ItemListener,
Runnable {
    private String login = "";
    private String password = "";
    private String server = "";
    private String driver = "";
    private DualLabelButton connectButton = new DualLabelButton();
    private DatabaseObject logonDatabase;
    private SQLAssistPanel resource;
    private TextField loginTF = new TextField();
    private TextField passwordTF = new TextField();
    private TextField serverTF = new TextField();
    private Choice driverChoice = new Choice();
    private TextField driverTF = new TextField();
    private transient Vector eventList = new Vector();
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public SQLAssistLogonPanel(SQLAssistPanel sQLAssistPanel) {
        super(sQLAssistPanel.getOptions().getLogonImage());
        this.resource = sQLAssistPanel;
        this.build();
        this.getProperties();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setStatus();
        if (actionEvent.getSource().equals(this.connectButton)) {
            if (this.connectButton.getLabel().equals(this.resource.getString(SQLAssistStrings.Disconnect_Button))) {
                this.processDisconnect();
            } else {
                Thread thread = new Thread(this);
                thread.start();
            }
        }
    }

    public synchronized void addConnectListener(ConnectListener connectListener) {
        this.eventList.addElement(connectListener);
    }

    public void addNotify() {
        super.addNotify();
        this.serverTF.requestFocus();
    }

    private void autoFillDatabaseName() {
        if (!this.resource.getOptions().getAutoFillDatabaseName()) {
            return;
        }
        if (this.resource.getOptions().getAutoFillDatabaseNames().size() == 0) {
            this.initAutoFillDatabaseName();
        }
        if (this.serverTF.getText() == null || this.serverTF.getText().equals("")) {
            ((TextComponent)this.serverTF).setText(this.getAutoFillDatabaseName());
        }
    }

    private void build() {
        String string;
        PanelObject panelObject = new PanelObject(this.resource.getString(SQLAssistStrings.ConnectToADatabase_Text), 15);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(3, 1, 10, 10));
        String string2 = "";
        try {
            string2 = this.resource.getString(SQLAssistStrings.DatabaseURL_Label);
        }
        catch (Exception exception) {}
        if (string2 == null || string2.equals("")) {
            string2 = this.resource.getString(SQLAssistStrings.Server_Label);
        }
        PanelObject panelObject2 = new PanelObject(string2, 5);
        panelObject2.add("Center", this.serverTF);
        panel.add(panelObject2);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 2, 10, 10));
        PanelObject panelObject3 = new PanelObject(this.resource.getString(SQLAssistStrings.Login_Label), 5);
        panelObject3.add("Center", this.loginTF);
        panel2.add(panelObject3);
        PanelObject panelObject4 = new PanelObject(this.resource.getString(SQLAssistStrings.Password_Label), 5);
        panelObject4.add("Center", this.passwordTF);
        this.passwordTF.setEchoChar('*');
        panel2.add(panelObject4);
        panel.add(panel2);
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(1, 2, 10, 10));
        PanelObject panelObject5 = new PanelObject(this.resource.getString(SQLAssistStrings.Driver_Label), 5);
        panel3.add(panelObject5);
        this.driverChoice = new Choice();
        int n = 0;
        while (n < this.resource.getOptions().getJdbcDrivers().size()) {
            string = SQLAssistUtils.parseString((String)this.resource.getOptions().getJdbcDrivers().elementAt(n), true, "=");
            this.driverChoice.add(string);
            ++n;
        }
        panelObject5.add("Center", this.driverChoice);
        PanelObject panelObject6 = new PanelObject(this.resource.getString(SQLAssistStrings.OtherDriver_Label), 5);
        panelObject6.add("Center", this.driverTF);
        panel3.add(panelObject6);
        panel.add(panel3);
        panelObject.add("Center", panel);
        string = this.resource.getString(SQLAssistStrings.Connect_Button);
        String string3 = this.resource.getString(SQLAssistStrings.Disconnect_Button);
        this.connectButton = new DualLabelButton(string, string3);
        Panel panel4 = new Panel();
        panel4.setLayout(new BorderLayout());
        panel4.add("East", this.connectButton);
        Panel panel5 = new Panel();
        panel5.setLayout(new BorderLayout(15, 15));
        panel5.add("North", panelObject);
        panel5.add("Center", panel4);
        Panel panel6 = new Panel();
        panel6.setLayout(new BorderLayout());
        panel6.add("North", panel5);
        super.build(panel6);
        this.add("South", this.resource.getGui().buildStatusbarPanel());
        this.loginTF.addTextListener(this);
        this.loginTF.addKeyListener(this);
        this.passwordTF.addTextListener(this);
        this.passwordTF.addKeyListener(this);
        this.serverTF.addTextListener(this);
        this.serverTF.addKeyListener(this);
        this.driverTF.addTextListener(this);
        this.driverTF.addKeyListener(this);
        this.driverChoice.addItemListener(this);
        this.connectButton.addActionListener(this);
        this.connectButton.requestFocus();
        this.autoFillDatabaseName();
    }

    private String getAutoFillDatabaseName() {
        if (!this.resource.getOptions().getAutoFillDatabaseName()) {
            return "";
        }
        int n = 0;
        while (n < this.resource.getOptions().getAutoFillDatabaseNames().size()) {
            String string = SQLAssistUtils.parseString((String)this.resource.getOptions().getAutoFillDatabaseNames().elementAt(n), true, "=");
            String string2 = SQLAssistUtils.parseString((String)this.resource.getOptions().getAutoFillDatabaseNames().elementAt(n), false, "=");
            if (string.equals(this.driverTF.getText())) {
                return string2;
            }
            ++n;
        }
        return "";
    }

    public DualLabelButton getConnectButton() {
        return this.connectButton;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public synchronized void getProperties() {
        this.resource.getQuery().getProperties();
        this.login = this.resource.getQuery().getLogin();
        this.password = this.resource.getQuery().getPassword();
        this.server = this.resource.getQuery().getServer();
        this.driver = this.resource.getQuery().getDriver();
        this.selectDriverChoice();
        this.setTextFields();
        this.autoFillDatabaseName();
    }

    public String getServer() {
        return this.server;
    }

    private void handleException(Exception exception) {
        this.logonEnabled(true);
        this.resource.getQuery().setDatabase(null);
        this.resource.getGui().handleException(exception);
    }

    private void handleException(UnsatisfiedLinkError unsatisfiedLinkError) {
        this.logonEnabled(true);
        this.resource.getQuery().setDatabase(null);
        this.resource.getGui().handleException("" + unsatisfiedLinkError.getMessage());
    }

    private void initAutoFillDatabaseName() {
        if (!this.resource.getOptions().getAutoFillDatabaseName()) {
            return;
        }
        try {
            String string = this.resource.getString(SQLAssistStrings.leftBracket_Char);
            String string2 = this.resource.getString(SQLAssistStrings.rightBracket_Char);
            String string3 = String.valueOf(string) + this.resource.getString(SQLAssistStrings.host_Text) + string2;
            String string4 = String.valueOf(string) + this.resource.getString(SQLAssistStrings.port_Text) + string2;
            String string5 = String.valueOf(string) + this.resource.getString(SQLAssistStrings.database_Text) + string2;
            this.resource.getOptions().getAutoFillDatabaseNames().addElement("COM.ibm.db2.jdbc.app.DB2Driver=jdbc:db2:" + string5);
            this.resource.getOptions().getAutoFillDatabaseNames().addElement("COM.ibm.db2.jdbc.net.DB2Driver=jdbc:db2://" + string3 + ":" + string4 + "/" + string5);
            this.resource.getOptions().getAutoFillDatabaseNames().addElement("sun.jdbc.odbc.JdbcOdbcDriver=jdbc:odbc:" + string5);
            this.resource.getOptions().getAutoFillDatabaseNames().addElement("oracle.jdbc.driver.OracleDriver=jdbc:oracle:thin:@" + string3 + ":" + string4 + ":" + string5);
            this.resource.getOptions().getAutoFillDatabaseNames().addElement("com.sybase.jdbc.SybDriver=jdbc:sybase:Tds:" + string3 + ":" + string4 + "/" + string5);
            this.resource.getOptions().getAutoFillDatabaseNames().addElement("com.ibm.as400.access.AS400JDBCDriver=jdbc:as400://" + string3);
        }
        catch (Exception exception) {
            this.resource.getOptions().setAutoFillDatabaseNames(new Vector());
        }
    }

    private boolean isAutoFillDatabaseName() {
        if (!this.resource.getOptions().getAutoFillDatabaseName()) {
            return false;
        }
        int n = 0;
        while (n < this.resource.getOptions().getAutoFillDatabaseNames().size()) {
            String string = SQLAssistUtils.parseString((String)this.resource.getOptions().getAutoFillDatabaseNames().elementAt(n), false, "=");
            if (string.equals(this.serverTF.getText())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.isAutoFillDatabaseName()) {
            ((TextComponent)this.serverTF).setText("");
        }
        this.setStatus();
        this.setText();
        this.setTextFields();
        this.autoFillDatabaseName();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && this.connectButton.isEnabled() && (keyEvent.getSource() == this.loginTF || keyEvent.getSource() == this.passwordTF || keyEvent.getSource() == this.serverTF || keyEvent.getSource() == this.driverTF)) {
            this.processConnect();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void logonEnabled(boolean bl) {
        this.loginTF.setEnabled(bl);
        this.passwordTF.setEnabled(bl);
        this.serverTF.setEnabled(bl);
        this.driverChoice.setEnabled(bl);
        this.driverTF.setEnabled(bl);
        this.connectButton.setEnabled(bl);
    }

    public synchronized void processConnect() {
        ConnectListener connectListener;
        Vector vector;
        this.setText();
        this.logonEnabled(false);
        this.resource.getGui().setStatus(this.resource.getString(SQLAssistStrings.ConnectingTo_Msg, new Object[]{this.server}));
        Serializable serializable = this.eventList;
        synchronized (serializable) {
            vector = (Vector)this.eventList.clone();
        }
        serializable = new ConnectEvent(this, this.login);
        int n = 0;
        while (n < vector.size()) {
            connectListener = (ConnectListener)vector.elementAt(n);
            connectListener.connecting((ConnectEvent)serializable);
            ++n;
        }
        if (!((ExitEvent)serializable).isCancel()) {
            block23: {
                if (this.resource.getOptions().getForceLogon() && this.resource.getQuery().getDatabase() != null) {
                    this.logonDatabase = this.resource.getQuery().getDatabase();
                    this.resource.getQuery().setLogin(this.logonDatabase.getLogin());
                    this.resource.getQuery().setPassword(this.logonDatabase.getPassword());
                    this.resource.getQuery().setDriver(this.logonDatabase.getJdbcDriver());
                    this.resource.getQuery().setServer(this.logonDatabase.getJdbcServer());
                } else {
                    try {
                        this.logonDatabase = new DatabaseObject(this.login, this.password, this.driver, this.server);
                        this.logonDatabase.setPromptSchemasAtLogon(this.resource.getOptions().getPromptSchemasAtLogon());
                        this.logonDatabase.setTable_Type(this.resource.getQuery().getTable_Type());
                        this.resource.getQuery().setLogin(this.login);
                        this.resource.getQuery().setPassword(this.password);
                        this.resource.getQuery().setDriver(this.driver);
                        this.resource.getQuery().setServer(this.server);
                        if (this.resource.getOptions().getSupportSchema()) {
                            n = 0;
                            if (this.resource.getQuery().getSchema() == null) {
                                try {
                                    this.retrieveSchemas(this.login.toUpperCase());
                                    this.resource.getQuery().setSchema(this.login.toUpperCase());
                                }
                                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                                    this.handleException(unsatisfiedLinkError);
                                    return;
                                }
                                catch (Exception exception) {
                                    n = 1;
                                }
                                if (this.logonDatabase != null && this.logonDatabase.getTables() != null && this.logonDatabase.getTables().size() == 0) {
                                    n = 1;
                                }
                                if (!(n == 0 || this.logonDatabase != null && this.logonDatabase.isValidToPromptForSchemasAtLogon())) {
                                    this.retrieveSchemas(";");
                                    this.resource.getQuery().setSchema(";");
                                }
                                break block23;
                            }
                            this.retrieveSchemas(this.resource.getQuery().getSchema());
                            break block23;
                        }
                        this.resource.getGui().setStatus(this.resource.getString(SQLAssistStrings.RetrievingDatabaseDetails_Msg));
                        this.logonDatabase.retrieveTables(null, this.resource.getQuery().getTableNamePattern());
                    }
                    catch (Exception exception) {
                        this.handleException(exception);
                        return;
                    }
                }
            }
            if (this.logonDatabase.getTables().size() == 0 && !this.logonDatabase.isValidToPromptForSchemasAtLogon()) {
                this.resource.getGui().displayExceptionDialog(this.resource.getString(SQLAssistStrings.NoTables_Msg, new Object[]{this.getServer()}));
                this.logonEnabled(true);
                this.logonDatabase = null;
                this.resource.getQuery().setDatabase(null);
                return;
            }
            this.logonEnabled(false);
            this.resource.getGui().setStatus(this.resource.getString(SQLAssistStrings.ConnectionSuccessful_Msg, new Object[]{this.server}));
            this.resource.getGui().setStatusLocked(true, this);
            this.resource.getGui().getSqlAssistPanel().processLogon(this.logonDatabase);
            this.resource.getGui().setStatusLocked(false, this);
            this.resource.getGui().setStatus();
            if (this.resource.getOptions().getSupportDisconnect()) {
                this.connectButton.setEnabled(true);
                this.connectButton.setLabel(this.resource.getString(SQLAssistStrings.Disconnect_Button));
            }
            Vector vector2 = this.eventList;
            synchronized (vector2) {
                vector = (Vector)this.eventList.clone();
            }
            serializable = new ConnectEvent(this, this.resource.getQuery().getLogin());
            int n2 = 0;
            while (n2 < vector.size()) {
                connectListener = (ConnectListener)vector.elementAt(n2);
                connectListener.connected((ConnectEvent)serializable);
                ++n2;
            }
            if (this.logonDatabase.isValidToPromptForSchemasAtLogon() && this.resource.getOptions().getSupportSchema() && this.resource.getGui().getSqlAssistTablesPanel() != null) {
                this.resource.getGui().getSqlAssistTablesPanel().processSchemaButton();
            }
        }
    }

    public synchronized void processDisconnect() {
        ConnectListener connectListener;
        Vector vector;
        Serializable serializable = this.eventList;
        synchronized (serializable) {
            vector = (Vector)this.eventList.clone();
        }
        serializable = new ConnectEvent(this, this.resource.getQuery().getLogin());
        int n = 0;
        while (n < vector.size()) {
            connectListener = (ConnectListener)vector.elementAt(n);
            connectListener.disconnecting((ConnectEvent)serializable);
            ++n;
        }
        if (!((ExitEvent)serializable).isCancel()) {
            this.resource.getGui().setStatus(this.resource.getString(SQLAssistStrings.OneMomentPlease_Msg));
            this.resource.getGui().setStatusLocked(true, this);
            this.logonEnabled(false);
            this.resource.reset();
            this.resource.getGui().refreshButtons(true);
            SQLAssistUtils.enableButton(this.resource.getGui().getFinishButton(), false);
            this.connectButton.setLabel(this.resource.getString(SQLAssistStrings.Connect_Button));
            this.logonDatabase = null;
            this.logonEnabled(true);
            this.connectButton.setEnabled(true);
            this.resource.getGui().setStatusLocked(false, this);
            this.setStatus();
            Vector vector2 = this.eventList;
            synchronized (vector2) {
                vector = (Vector)this.eventList.clone();
            }
            serializable = new ConnectEvent(this, this.resource.getQuery().getLogin());
            int n2 = 0;
            while (n2 < vector.size()) {
                connectListener = (ConnectListener)vector.elementAt(n2);
                connectListener.disconnected((ConnectEvent)serializable);
                ++n2;
            }
        }
    }

    public synchronized void putProperties() {
        this.resource.getQuery().putProperties();
    }

    private void refreshButtons() {
        if (this.server == null || this.server.equals("") || this.driver == null || this.driver.equals("")) {
            this.connectButton.setEnabled(false);
        } else {
            this.connectButton.setEnabled(true);
        }
    }

    public synchronized void removeConnectListener(ConnectListener connectListener) {
        this.eventList.removeElement(connectListener);
    }

    public void retrieveSchemas(String string) throws UnsatisfiedLinkError, Exception {
        if (!this.resource.getOptions().getSupportSchema()) {
            return;
        }
        this.resource.getGui().setStatus(this.resource.getString(SQLAssistStrings.RetrievingDatabaseDetails_Msg));
        try {
            this.resource.getQuery().setSchema(this.logonDatabase.retrieveSchemas(string, this.resource.getQuery().getTableNamePattern()));
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw unsatisfiedLinkError;
        }
        catch (Exception exception) {
            throw exception;
        }
        this.resource.getGui().setStatus();
    }

    public void run() {
        this.processConnect();
    }

    private void selectDriverChoice() {
        String string = this.resource.getString(SQLAssistStrings.Other_Text);
        if (this.driver == null || this.driver.equals("")) {
            String string2;
            string = string2 = SQLAssistUtils.parseString((String)this.resource.getOptions().getJdbcDrivers().elementAt(0), true, "=");
        } else {
            int n = 0;
            while (n < this.resource.getOptions().getJdbcDrivers().size()) {
                String string3 = SQLAssistUtils.parseString((String)this.resource.getOptions().getJdbcDrivers().elementAt(n), true, "=");
                String string4 = SQLAssistUtils.parseString((String)this.resource.getOptions().getJdbcDrivers().elementAt(n), false, "=");
                if (string4 != null && string4.equals(this.driver)) {
                    string = string3;
                    break;
                }
                ++n;
            }
        }
        this.driverChoice.select(string);
    }

    public void setConnectButton(DualLabelButton dualLabelButton) {
        this.connectButton = dualLabelButton;
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public void setLogin(String string) {
        this.login = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setServer(String string) {
        this.server = string;
    }

    public void setStatus() {
        if (this.resource.getQuery().getDatabase() == null) {
            this.resource.getGui().setStatus(this.resource.getString(SQLAssistStrings.EnterInfo_Msg));
        } else {
            this.resource.getGui().setStatus();
        }
    }

    private void setText() {
        this.login = this.loginTF.getText();
        this.password = this.passwordTF.getText();
        this.server = this.serverTF.getText();
        this.driver = this.driverChoice.getSelectedItem();
        this.driver = this.driver.equals(this.resource.getString(SQLAssistStrings.Other_Text)) ? this.driverTF.getText() : SQLAssistUtils.parseString((String)this.resource.getOptions().getJdbcDrivers().elementAt(this.driverChoice.getSelectedIndex()), false, "=");
        this.refreshButtons();
    }

    private void setTextFields() {
        ((TextComponent)this.loginTF).setText(this.login);
        ((TextComponent)this.passwordTF).setText(this.password);
        ((TextComponent)this.serverTF).setText(this.server);
        if (this.driverChoice.getSelectedItem().equals(this.resource.getString(SQLAssistStrings.Other_Text))) {
            ((TextComponent)this.driverTF).setText(this.driver);
            this.driverTF.setEnabled(true);
        } else {
            ((TextComponent)this.driverTF).setText(SQLAssistUtils.parseString((String)this.resource.getOptions().getJdbcDrivers().elementAt(this.driverChoice.getSelectedIndex()), false, "="));
            this.driverTF.setEnabled(false);
        }
        this.refreshButtons();
    }

    public void textValueChanged(TextEvent textEvent) {
        this.setText();
    }
}

