/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist;

import com.ibm.sqlassist.SQLAssistPanel;
import com.ibm.sqlassist.common.JoinObject;
import com.ibm.sqlassist.common.ManyLineLabel;
import com.ibm.sqlassist.common.SQLAssistStrings;
import com.ibm.sqlassist.common.SQLAssistUtils;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class SQLAssistJoinOptionsDialog
extends Dialog
implements ActionListener,
WindowListener,
KeyListener {
    private SQLAssistPanel resource;
    private JoinObject jobj;
    private CheckboxGroup checkboxGroup = new CheckboxGroup();
    private Checkbox innerJoinCheckbox;
    private Checkbox leftOuterJoinCheckbox;
    private Checkbox rightOuterJoinCheckbox;
    private Button okButton;
    private Button cancelButton;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public SQLAssistJoinOptionsDialog(SQLAssistPanel sQLAssistPanel, JoinObject joinObject) {
        super(sQLAssistPanel.getGui().getParentFrame(), "", true);
        this.resource = sQLAssistPanel;
        this.jobj = joinObject;
        this.build();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.okButton)) {
            this.processJoinType();
        } else if (actionEvent.getSource().equals(this.cancelButton)) {
            this.processCancelButton();
        }
    }

    private void build() {
        this.setTitle(this.resource.getString(SQLAssistStrings.JoinOptionsDialog_Title));
        this.innerJoinCheckbox = new Checkbox(this.resource.getString(SQLAssistStrings.One_Label), true, this.checkboxGroup);
        this.leftOuterJoinCheckbox = new Checkbox(this.resource.getString(SQLAssistStrings.Two_Label), false, this.checkboxGroup);
        this.rightOuterJoinCheckbox = new Checkbox(this.resource.getString(SQLAssistStrings.Three_Label), false, this.checkboxGroup);
        this.okButton = new Button(this.resource.getString(SQLAssistStrings.OK_Button));
        this.cancelButton = new Button(this.resource.getString(SQLAssistStrings.Cancel_Button));
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("West", this.innerJoinCheckbox);
        panel.add("Center", new ManyLineLabel(this.resource.getGui().getSqlAssistJoinPanel().buildDescription(this.jobj, 0, false)));
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel2.add("West", this.leftOuterJoinCheckbox);
        panel2.add("Center", new ManyLineLabel(this.resource.getGui().getSqlAssistJoinPanel().buildDescription(this.jobj, 1, false)));
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout());
        panel3.add("West", this.rightOuterJoinCheckbox);
        panel3.add("Center", new ManyLineLabel(this.resource.getGui().getSqlAssistJoinPanel().buildDescription(this.jobj, 2, false)));
        Panel panel4 = new Panel();
        panel4.setLayout(new GridLayout(3, 1, 10, 10));
        panel4.add(panel);
        panel4.add(panel2);
        panel4.add(panel3);
        this.leftOuterJoinCheckbox.setEnabled(this.resource.getQuery().getDatabase().getSupportsOuterJoins());
        this.rightOuterJoinCheckbox.setEnabled(this.resource.getQuery().getDatabase().getSupportsOuterJoins());
        Panel panel5 = new Panel();
        panel5.setLayout(new GridLayout(1, 2, 10, 10));
        panel5.add(this.okButton);
        panel5.add(this.cancelButton);
        Panel panel6 = new Panel();
        panel6.setLayout(new BorderLayout());
        panel6.add("East", panel5);
        Panel panel7 = new Panel();
        panel7.setLayout(new BorderLayout(5, 5));
        panel7.add("North", new ManyLineLabel(this.resource.getString(SQLAssistStrings.ChooseTypeOfJoin_Label, new Object[]{this.resource.getGui().getSqlAssistJoinPanel().buildJoinFieldName(this.jobj.getJlpo1(), false), this.resource.getGui().getSqlAssistJoinPanel().buildJoinFieldName(this.jobj.getJlpo2(), false)})));
        panel7.add("Center", panel4);
        panel7.add("South", panel6);
        if (this.resource.getOptions().getDialogBackgroundColor() != null) {
            ((Component)this).setBackground(this.resource.getOptions().getDialogBackgroundColor());
            panel7.setBackground(this.resource.getOptions().getDialogBackgroundColor());
        }
        this.setLayout(new BorderLayout(0, 0));
        this.add("Center", panel7);
        this.add("North", SQLAssistUtils.spacer(10));
        this.add("South", SQLAssistUtils.spacer(10));
        this.add("East", SQLAssistUtils.spacer(10));
        this.add("West", SQLAssistUtils.spacer(10));
        if (!this.resource.getOptions().getSupportLeftOuterJoin() || this.resource.getQuery().getDatabase() != null && !this.resource.getQuery().getDatabase().getSupportsOuterJoins()) {
            this.leftOuterJoinCheckbox.setEnabled(false);
        }
        if (!this.resource.getOptions().getSupportRightOuterJoin() || this.resource.getQuery().getDatabase() != null && !this.resource.getQuery().getDatabase().getSupportsOuterJoins()) {
            this.rightOuterJoinCheckbox.setEnabled(false);
        }
        if (this.jobj.getType() == 1) {
            this.checkboxGroup.setSelectedCheckbox(this.leftOuterJoinCheckbox);
        } else if (this.jobj.getType() == 2) {
            this.checkboxGroup.setSelectedCheckbox(this.rightOuterJoinCheckbox);
        } else {
            this.checkboxGroup.setSelectedCheckbox(this.innerJoinCheckbox);
        }
        this.setResizable(true);
        this.pack();
        Dimension dimension = this.getSize();
        if (dimension.height < 350 || dimension.width < 525) {
            if (dimension.height < 350) {
                dimension.height = 350;
            }
            if (dimension.width < 525) {
                dimension.width = 525;
            }
            ((Component)this).setSize(dimension);
        }
        this.addWindowListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.innerJoinCheckbox.addKeyListener(this);
        this.leftOuterJoinCheckbox.addKeyListener(this);
        this.rightOuterJoinCheckbox.addKeyListener(this);
        this.okButton.addKeyListener(this);
        this.cancelButton.addKeyListener(this);
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    public Button getOkButton() {
        return this.okButton;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.processJoinType();
        }
        if (keyEvent.getKeyCode() == 27 && this.resource.getOptions().getSupportEscapeCancelDialog()) {
            this.processCancelButton();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void processCancelButton() {
        this.dispose();
    }

    private void processJoinType() {
        if (this.checkboxGroup.getSelectedCheckbox() == this.leftOuterJoinCheckbox) {
            this.jobj.setType(1);
        } else if (this.checkboxGroup.getSelectedCheckbox() == this.rightOuterJoinCheckbox) {
            this.jobj.setType(2);
        } else {
            this.jobj.setType(0);
        }
        this.resource.getGui().getSqlAssistJoinPanel().resetJoinType(this.jobj);
    }

    public void setCancelButton(Button button) {
        this.cancelButton = button;
    }

    public void setOkButton(Button button) {
        this.okButton = button;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

