/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist;

import com.ibm.sqlassist.SQLAssistPanel;
import com.ibm.sqlassist.common.ColumnObject;
import com.ibm.sqlassist.common.MCLB;
import com.ibm.sqlassist.common.PanelObject;
import com.ibm.sqlassist.common.SQLAssistStrings;
import com.ibm.sqlassist.common.TableObject;
import com.ibm.webrunner.util.SelectionSorter;
import com.ibm.webrunner.widget.ListboxColumn;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class SQLAssistDataTypeMappingPanel
extends Panel
implements ActionListener {
    private MCLB multiColumnListbox;
    private Button useDefaultsButton;
    private SQLAssistPanel resource;
    private Vector colNames = new Vector();
    private Vector newColTypes = new Vector();
    private boolean firstTime = true;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public SQLAssistDataTypeMappingPanel(SQLAssistPanel sQLAssistPanel) {
        this.resource = sQLAssistPanel;
        this.build();
        this.getProperties();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.useDefaultsButton)) {
            this.multiColumnListbox.removeAllRows();
            this.colNames = new Vector();
            this.newColTypes = new Vector();
            this.populateMultiColumnListbox();
        }
    }

    private void build() {
        this.setLayout(new BorderLayout());
        PanelObject panelObject = new PanelObject(this.resource.getString(SQLAssistStrings.DataTypeMappingPanel_Title));
        PanelObject panelObject2 = new PanelObject(this.resource.getString(SQLAssistStrings.DataTypeMappingPanel_Label));
        this.setMultiColumnListbox(new MCLB(this.resource, true));
        panelObject2.add("Center", this.multiColumnListbox);
        this.multiColumnListbox.addColumn(this.resource.getString(SQLAssistStrings.Field_Text));
        this.multiColumnListbox.addColumn(this.resource.getString(SQLAssistStrings.CurrentDataType_Text));
        this.multiColumnListbox.addColumn(this.resource.getString(SQLAssistStrings.NewDataType_Text));
        ListboxColumn listboxColumn = this.multiColumnListbox.getColumnInfo(0);
        listboxColumn.setWidth(200);
        listboxColumn.setSorter(new SelectionSorter());
        listboxColumn = this.multiColumnListbox.getColumnInfo(1);
        listboxColumn.setWidth(150);
        listboxColumn.setSorter(new SelectionSorter());
        listboxColumn = this.multiColumnListbox.getColumnInfo(2);
        listboxColumn.setWidth(200);
        listboxColumn.setSorter(new SelectionSorter());
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(5, 5));
        panel.add("North", panelObject);
        panel.add("Center", panelObject2);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel2.add("Center", new Label());
        this.useDefaultsButton = new Button(this.resource.getString(SQLAssistStrings.UseDefaults_Button));
        panel2.add("East", this.useDefaultsButton);
        this.useDefaultsButton.addActionListener(this);
        panel.add("South", panel2);
        this.enableButtons(false);
        this.setLayout(new BorderLayout(10, 10));
        this.add("Center", panel);
        this.add("North", new Label());
        this.add("South", this.resource.getGui().buildStatusbarPanel());
        this.add("East", new Label());
        this.add("West", new Label());
    }

    private Choice buildData_TypeChoice(int n) {
        Choice choice = new Choice();
        String[] stringArray = null;
        if (this.resource.getOptions().getApplyDataTypeMappingRules()) {
            stringArray = this.resource.getQuery().getDatabase().getTypeInfo().getMappedTypes(n);
        }
        if (stringArray == null) {
            stringArray = this.resource.getQuery().getDatabase().getTypeInfo().getMappedTypes(1111);
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            choice.add(stringArray[n2]);
            ++n2;
        }
        return choice;
    }

    private void enableButtons(boolean bl) {
        this.useDefaultsButton.setEnabled(bl);
    }

    public MCLB getMultiColumnListbox() {
        return this.multiColumnListbox;
    }

    public synchronized void getProperties() {
        this.firstTime = true;
        int n = Integer.parseInt(this.resource.getProperties().getProperty("901", "0"));
        int n2 = 0;
        while (n2 < n) {
            String string = this.resource.getProperties().getProperty("903_{0}", "", new String[]{"" + n2});
            this.colNames.addElement(this.resource.getProperties().getProperty("902_{0}", "", new String[]{"" + n2}));
            this.newColTypes.addElement(this.resource.getQuery().getDatabase().getTypeInfo().getType_Name(string));
            ++n2;
        }
        this.populateMultiColumnListbox();
        this.firstTime = false;
    }

    private String getTypeInfo_Name(ColumnObject columnObject) {
        return this.resource.getQuery().getDatabase().getTypeInfo().getType_Name(columnObject.getData_Type());
    }

    public Button getUseDefaultsButton() {
        return this.useDefaultsButton;
    }

    public void populateMultiColumnListbox() {
        if (this.resource.getQuery().getDatabase() == null) {
            this.enableButtons(false);
            return;
        }
        this.updateMultiColumnListboxVectors();
        this.multiColumnListbox.removeAllRows();
        this.resource.getGui().setStatus();
        String[] stringArray = this.resource.getQuery().getSelectedFields();
        if (stringArray == null) {
            stringArray = this.resource.getQuery().getAvailableFields();
        }
        if (stringArray == null) {
            this.enableButtons(false);
            return;
        }
        this.multiColumnListbox.setUpdate(false);
        Object[][] objectArray = new Object[stringArray.length][3];
        Object[] objectArray2 = new Object[stringArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            ColumnObject columnObject;
            String string = "";
            String string2 = "";
            string = stringArray[n2].substring(0, stringArray[n2].lastIndexOf("."));
            string2 = stringArray[n2].substring(stringArray[n2].lastIndexOf(".") + 1);
            TableObject tableObject = this.resource.getQuery().getDatabase().getTable(string);
            if (tableObject != null && (columnObject = tableObject.getColumn(string2)) != null) {
                Choice choice = this.buildData_TypeChoice(columnObject.getData_Type());
                int n3 = this.colNames.indexOf(stringArray[n2]);
                if (n3 > -1) {
                    choice.select((String)this.newColTypes.elementAt(n3));
                } else {
                    choice.select(this.resource.getQuery().getDatabase().getTypeInfo().getType_Name(columnObject.getData_Type()));
                }
                objectArray[n][0] = stringArray[n2];
                objectArray[n][1] = this.getTypeInfo_Name(columnObject);
                objectArray[n][2] = choice;
                objectArray2[n] = columnObject;
                this.multiColumnListbox.addRow(objectArray[n], objectArray2[n]);
                ++n;
            }
            ++n2;
        }
        this.multiColumnListbox.setUpdate(true);
        this.enableButtons(true);
    }

    public synchronized void putProperties() {
        String[][] stringArray = this.toArray();
        if (stringArray == null) {
            return;
        }
        this.resource.getProperties().put("901", "" + stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            Object[] objectArray = this.multiColumnListbox.getRow(n);
            if (objectArray != null) {
                this.resource.getProperties().put("902_{0}", stringArray[n][0], new String[]{"" + n});
                this.resource.getProperties().put("903_{0}", stringArray[n][2], new String[]{"" + n});
            }
            ++n;
        }
    }

    public void setMultiColumnListbox(MCLB mCLB) {
        this.multiColumnListbox = mCLB;
    }

    public void setUseDefaultsButton(Button button) {
        this.useDefaultsButton = button;
    }

    public synchronized String[][] toArray() {
        this.populateMultiColumnListbox();
        int n = this.multiColumnListbox.getRowCount();
        if (n == 0) {
            return null;
        }
        String[][] stringArray = new String[n][3];
        int n2 = 0;
        while (n2 < n) {
            Object[] objectArray = this.multiColumnListbox.getRow(n2);
            if (objectArray != null) {
                ColumnObject columnObject = (ColumnObject)this.multiColumnListbox.getRowKey(n2);
                stringArray[n2][0] = (String)objectArray[0];
                stringArray[n2][1] = "" + columnObject.getData_Type();
                stringArray[n2][2] = "" + this.resource.getQuery().getDatabase().getTypeInfo().getData_Type(((Choice)objectArray[2]).getSelectedItem());
            }
            ++n2;
        }
        return stringArray;
    }

    private void updateMultiColumnListboxVectors() {
        int n = 0;
        while (n < this.multiColumnListbox.getRowCount()) {
            Object[] objectArray = this.multiColumnListbox.getRow(n);
            if (objectArray != null) {
                String string = (String)objectArray[0];
                String string2 = ((Choice)objectArray[2]).getSelectedItem();
                int n2 = this.colNames.indexOf(string);
                if (n2 > -1) {
                    this.newColTypes.setElementAt(string2, n2);
                } else {
                    this.colNames.addElement(string);
                    this.newColTypes.addElement(string2);
                }
            }
            ++n;
        }
    }
}

