/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sqlassist;

import com.ibm.sqlassist.SQLAssistPanel;
import com.ibm.sqlassist.SQLAssistValueLookupDialog;
import com.ibm.sqlassist.SQLAssistVariableButton;
import com.ibm.sqlassist.common.ColumnObject;
import com.ibm.sqlassist.common.ColumnTextField;
import com.ibm.sqlassist.common.ConditionMultiColumnListbox;
import com.ibm.sqlassist.common.PanelObject;
import com.ibm.sqlassist.common.SQLAssistStrings;
import com.ibm.sqlassist.common.SQLAssistUtils;
import com.ibm.sqlassist.common.TableObject;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class SQLAssistConditionPanel
extends Panel
implements ItemListener,
ActionListener,
ComponentListener {
    private TableObject currentTable;
    private ColumnObject currentColumn;
    private String currentValueType = "";
    private Choice selectedDatabaseTablesChoice = new Choice();
    private List availableColumnsList = new List(5, false);
    private List operatorList = new List(10, false);
    private int conditionIndex = 0;
    private boolean isValid = false;
    private ConditionMultiColumnListbox valuesMultiColumnListbox;
    private String findType;
    private SQLAssistVariableButton variableButton;
    private Button findOnAnotherColumnButton;
    private Button deleteConditionButton;
    private Button valueLookupButton;
    private Button clearButton;
    private Checkbox enableDistinctTypeSupportCheckbox;
    private SQLAssistPanel resource;
    private CheckboxGroup findCheckboxGroup = new CheckboxGroup();
    private Checkbox findAndCheckbox;
    private Checkbox findOrCheckbox;
    private TextArea descriptionTextArea = new TextArea("", 3, 40, 1);
    private PanelObject part1;
    private int currentType = 0;
    private int lastType = 1111;
    private String lastSelectedDatabaseTablesString = "-";
    private Panel findAndOrPanel;
    private String[][] currentTypeArray;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public SQLAssistConditionPanel(SQLAssistPanel sQLAssistPanel, int n) {
        this.resource = sQLAssistPanel;
        this.conditionIndex = n;
        this.build();
        this.getProperties(this.conditionIndex - 1);
        this.addComponentListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.resource.getGui().setStatus();
        if (actionEvent.getSource().equals(this.findOnAnotherColumnButton)) {
            this.resource.getGui().addAnotherCondition();
            SQLAssistUtils.turnToPage(this.resource.getGui().getNotebook(), 1);
        } else if (actionEvent.getSource().equals(this.valueLookupButton)) {
            this.processValueLookupButton();
        } else if (actionEvent.getSource().equals(this.getVariableButton())) {
            this.processVariableButton();
        } else if (actionEvent.getSource().equals(this.clearButton)) {
            this.processClearButton();
            this.resource.getQuery().eventBuildSQL();
        } else if (actionEvent.getSource().equals(this.deleteConditionButton)) {
            this.resource.getGui().getSqlAssistConditionPanelVector().removeElement(this);
            this.resource.getGui().removeCondition(this.resource.getString(SQLAssistStrings.Condition_nn_Text, new Object[]{"" + this.conditionIndex}));
            this.resource.getQuery().eventBuildSQL();
        }
    }

    private void build() {
        this.valuesMultiColumnListbox = new ConditionMultiColumnListbox(this.resource, this);
        this.findAndCheckbox = new Checkbox(this.resource.getString(SQLAssistStrings.FindFewer_Text), this.findCheckboxGroup, true);
        this.findOrCheckbox = new Checkbox(this.resource.getString(SQLAssistStrings.FindMore_Text), this.findCheckboxGroup, false);
        this.findType = this.resource.getString(SQLAssistStrings.AND_Text);
        this.part1 = new PanelObject(this.buildConditionTitle(), 0);
        if (this.conditionIndex > 1) {
            this.findAndOrPanel = new Panel();
            this.findAndOrPanel.setLayout(new GridLayout(1, 2, 5, 5));
            this.findAndOrPanel.add(this.findAndCheckbox);
            this.findAndOrPanel.add(this.findOrCheckbox);
            this.part1.add("Center", this.findAndOrPanel);
            this.findAndCheckbox.addItemListener(this);
            this.findOrCheckbox.addItemListener(this);
        }
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 3, 5, 5));
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout(5, 5));
        Panel panel3 = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel3.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        Label label = new Label(this.resource.getString(SQLAssistStrings.SelectedDatabaseTables_Label));
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel3.add(label);
        gridBagLayout.setConstraints(this.selectedDatabaseTablesChoice, gridBagConstraints);
        panel3.add(this.selectedDatabaseTablesChoice);
        PanelObject panelObject = new PanelObject(this.resource.getString(SQLAssistStrings.Fields_Label));
        panelObject.add("Center", this.availableColumnsList);
        panel2.add("North", panel3);
        panel2.add("Center", panelObject);
        this.enableDistinctTypeSupportCheckbox = new Checkbox(this.resource.getString(SQLAssistStrings.EnableDistinctTypeSupport));
        if (this.resource.getOptions().getEnableDistinctTypeSupport()) {
            panel2.add("South", this.enableDistinctTypeSupportCheckbox);
        }
        PanelObject panelObject2 = new PanelObject(this.resource.getString(SQLAssistStrings.Operator_Label));
        panelObject2.add("Center", this.operatorList);
        this.operatorList.setEnabled(true);
        PanelObject panelObject3 = new PanelObject(this.resource.getString(SQLAssistStrings.Values_Label));
        panelObject3.add("Center", this.valuesMultiColumnListbox);
        Panel panel4 = new Panel();
        this.valueLookupButton = new Button(this.resource.getString(SQLAssistStrings.Lookup_Button));
        this.clearButton = new Button(this.resource.getString(SQLAssistStrings.Clear_Button));
        this.setVariableButton(new SQLAssistVariableButton(this.resource));
        this.getVariableButton().setEnabled(false);
        this.valueLookupButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        panel4.add(this.valueLookupButton);
        if (this.resource.getOptions().getDisplayVariableButton()) {
            panel4.add(this.getVariableButton());
        } else {
            panel4.add(new Label());
        }
        panel4.add(this.clearButton);
        panelObject3.add("South", panel4);
        panel.add(panel2);
        panel.add(panelObject2);
        panel.add(panelObject3);
        Panel panel5 = new Panel();
        panel5.setLayout(new BorderLayout(5, 5));
        Panel panel6 = new Panel();
        panel6.setLayout(new BorderLayout(5, 5));
        panel6.add("Center", this.descriptionTextArea);
        this.descriptionTextArea.setEditable(false);
        Panel panel7 = new Panel();
        panel7.setLayout(new GridLayout(2, 1, 10, 10));
        this.findOnAnotherColumnButton = new Button(this.resource.getString(SQLAssistStrings.FindAnother_Button));
        this.findOnAnotherColumnButton.setEnabled(false);
        this.deleteConditionButton = new Button(this.resource.getString(SQLAssistStrings.DeleteCondition_Button));
        panel7.add(this.findOnAnotherColumnButton);
        if (this.conditionIndex > 1) {
            panel7.add(this.deleteConditionButton);
        } else {
            panel7.add(new Label());
        }
        panel6.add("East", panel7);
        panel5.add("South", panel6);
        Panel panel8 = new Panel();
        panel8.setLayout(new BorderLayout(5, 5));
        panel8.add("North", this.part1);
        panel8.add("Center", panel);
        panel8.add("South", panel5);
        this.setLayout(new BorderLayout(10, 10));
        this.add("Center", panel8);
        this.add("North", new Label());
        this.add("South", this.resource.getGui().buildStatusbarPanel());
        this.add("East", new Label());
        this.add("West", new Label());
        this.findOrCheckbox.addItemListener(this);
        this.selectedDatabaseTablesChoice.addItemListener(this);
        this.availableColumnsList.addItemListener(this);
        this.operatorList.addItemListener(this);
        this.findOnAnotherColumnButton.addActionListener(this);
        this.valueLookupButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.deleteConditionButton.addActionListener(this);
        this.getVariableButton().addActionListener(this);
        this.populateDescriptionTextArea();
    }

    private String[][] buildCharTypeArray() {
        if (this.resource.getQuery().getDatabase() != null && !this.resource.getQuery().getDatabase().isAS400()) {
            return new String[][]{{this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.exactlyEqualTo_Text), "M", "%COL% = %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.notEqualTo_Text), "1", "%COL% <> %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.after_Text), "1", "%COL% > %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.afterEqualTo_Text), "1", "%COL% >= %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.before_Text), "1", "%COL% < %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.beforeEqualTo_Text), "1", "%COL% <= %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.between_Text), "B", "%COL% between %VAL% and %VAL2%"}, {this.resource.getString(SQLAssistStrings.contain_Text), this.resource.getString(SQLAssistStrings.contain_Text), this.resource.getString(SQLAssistStrings.theCharacters_Text), "M", "%COL% like %%VAL%%"}, {this.resource.getString(SQLAssistStrings.start_Text), this.resource.getString(SQLAssistStrings.start_Text), this.resource.getString(SQLAssistStrings.withTheCharacters_Text), "M", "%COL% like %VAL%%"}, {this.resource.getString(SQLAssistStrings.end_Text), this.resource.getString(SQLAssistStrings.end_Text), this.resource.getString(SQLAssistStrings.withTheCharacters_Text), "M", "%COL% like %%VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.blank_Text), "0", "%COL% is null"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.notBlank_Text), "0", "%COL% is not null"}};
        }
        return new String[][]{{this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.exactlyEqualTo_Text), "M", "%COL% = %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.notEqualTo_Text), "1", "%COL% <> %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.after_Text), "1", "%COL% > %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.afterEqualTo_Text), "1", "%COL% >= %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.before_Text), "1", "%COL% < %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.beforeEqualTo_Text), "1", "%COL% <= %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.between_Text), "B", "%COL% between %VAL% and %VAL2%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.matchingPattern_Text), "M", "%COL% like %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.blank_Text), "0", "%COL% is null"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.notBlank_Text), "0", "%COL% is not null"}};
    }

    private String buildConditionTitle() {
        if (this.conditionIndex > 1) {
            return this.resource.getString(SQLAssistStrings.Condition2_Label, new Object[]{"" + this.conditionIndex});
        }
        return this.resource.getString(SQLAssistStrings.Condition1_Label, new Object[]{"" + this.conditionIndex});
    }

    private String[][] buildDateTypeArray() {
        return new String[][]{{this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.onDates_Text), "M", "%COL% = %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.notOnDate_Text), "1", "%COL% <> %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.afterDates_Text), "1", "%COL% > %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.onAfterDates_Text), "1", "%COL% >= %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.beforeDates_Text), "1", "%COL% < %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.onBeforeDates_Text), "1", "%COL% <= %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.between_Text), "B", "%COL% between %VAL% and %VAL2%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.equalMonth_Text), "M", "MONTH(%COL%) = %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.equalDay_Text), "M", "DAYOFWEEK(%COL%) = %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.equalYear_Text), "M", "YEAR(%COL%) = %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.blank_Text), "0", "%COL% is null"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.notBlank_Text), "0", "%COL% is not null"}};
    }

    private String[][] buildIntTypeArray() {
        return new String[][]{{this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.exactlyEqualTo_Text), "M", "%COL% = %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.notEqualTo_Text), "1", "%COL% <> %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.greaterThan_Text), "1", "%COL% > %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.greaterEqualTo_Text), "1", "%COL% >= %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.lessThan_Text), "1", "%COL% < %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.lessEqualTo_Text), "1", "%COL% <= %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.between_Text), "B", "%COL% between %VAL% and %VAL2%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.blank_Text), "0", "%COL% is null"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.notBlank_Text), "0", "%COL% is not null"}};
    }

    private String[][] buildTimestampTypeArray() {
        return new String[][]{{this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.atTimestamps_Text), "M", "%COL% = %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.notAtTimestamp_Text), "1", "%COL% <> %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.atLaterTimestamp_Text), "1", "%COL% > %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.atSameLaterTimestamp_Text), "1", "%COL% >= %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.atEarlierTimestamp_Text), "1", "%COL% < %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.atSameEarlierTimestamp_Text), "1", "%COL% <= %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.between_Text), "B", "%COL% between %VAL% and %VAL2%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.blank_Text), "0", "%COL% is null"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.notBlank_Text), "0", "%COL% is not null"}};
    }

    private String[][] buildTimeTypeArray() {
        return new String[][]{{this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.atTimes_Text), "M", "%COL% = %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.notAtTime_Text), "1", "%COL% <> %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.atLaterTime_Text), "1", "%COL% > %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.atSameLaterTime_Text), "1", "%COL% >= %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.atEarlierTime_Text), "1", "%COL% < %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.atSameEarlierTime_Text), "1", "%COL% <= %VAL%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.between_Text), "B", "%COL% between %VAL% and %VAL2%"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.blank_Text), "0", "%COL% is null"}, {this.resource.getString(SQLAssistStrings.are_Text), this.resource.getString(SQLAssistStrings.is_Text), this.resource.getString(SQLAssistStrings.notBlank_Text), "0", "%COL% is not null"}};
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.valuesMultiColumnListbox.refreshFonts();
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.valuesMultiColumnListbox.refreshFonts();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.valuesMultiColumnListbox.refreshFonts();
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.valuesMultiColumnListbox.refreshFonts();
    }

    private void determineCurrentTypeArray() {
        if (this.currentColumn == null) {
            this.currentTypeArray = null;
            this.currentType = 1111;
        } else {
            this.currentType = this.currentColumn.getGenericData_Type();
            switch (this.currentType) {
                case 1: {
                    this.currentTypeArray = this.buildCharTypeArray();
                    break;
                }
                case -2: 
                case 2: 
                case 4: {
                    this.currentTypeArray = this.buildIntTypeArray();
                    break;
                }
                case 91: {
                    this.currentTypeArray = this.buildDateTypeArray();
                    break;
                }
                case 92: {
                    this.currentTypeArray = this.buildTimeTypeArray();
                    break;
                }
                case 93: {
                    if (this.resource.getOptions().getSupportTimestamp()) {
                        this.currentTypeArray = this.buildTimestampTypeArray();
                        break;
                    }
                    this.currentTypeArray = null;
                    break;
                }
                default: {
                    this.currentTypeArray = null;
                }
            }
        }
    }

    public List getAvailableColumnsList() {
        return this.availableColumnsList;
    }

    public Button getClearButton() {
        return this.clearButton;
    }

    public int getConditionIndex() {
        return this.conditionIndex;
    }

    public ColumnObject getCurrentColumn() {
        return this.currentColumn;
    }

    public TableObject getCurrentTable() {
        return this.currentTable;
    }

    public String[][] getCurrentTypeArray() {
        return this.currentTypeArray;
    }

    public String getCurrentValueType() {
        return this.currentValueType;
    }

    public Button getDeleteConditionButton() {
        return this.deleteConditionButton;
    }

    public Checkbox getEnableDistinctTypeSupportCheckbox() {
        return this.enableDistinctTypeSupportCheckbox;
    }

    public Button getFindOnAnotherColumnButton() {
        return this.findOnAnotherColumnButton;
    }

    public String getFindType() {
        return this.findType;
    }

    public boolean getIsValid() {
        return this.isValid;
    }

    public List getOperatorList() {
        return this.operatorList;
    }

    public synchronized void getProperties(int n) {
        if (n > Integer.parseInt(this.resource.getProperties().getProperty("201", "0"))) {
            return;
        }
        if (this.resource.getProperties().getProperty("202_{0}", "TRUE", new String[]{"" + n}).equalsIgnoreCase("TRUE")) {
            this.findOrCheckbox.setState(true);
        } else {
            this.findAndCheckbox.setState(true);
        }
        if (this.resource.getProperties().getProperty("209_{0}", "FALSE", new String[]{"" + n}).equalsIgnoreCase("TRUE")) {
            this.enableDistinctTypeSupportCheckbox.setState(true);
        }
        this.selectedDatabaseTablesChoice.select(this.resource.getProperties().getProperty("203_{0}", "", new String[]{"" + n}));
        this.processSelectedDatabaseTablesChoice();
        SQLAssistUtils.select(this.availableColumnsList, this.resource.getProperties().getProperty("204_{0}", "", new String[]{"" + n}));
        this.populateAvailableColumnsList();
        int n2 = Integer.parseInt(this.resource.getProperties().getProperty("205_{0}", "0", new String[]{"" + n}));
        if (this.operatorList.getItemCount() > 0 && n2 > 0) {
            this.operatorList.select(n2);
        }
        this.populateValuesMultiColumnListbox();
        int n3 = Integer.parseInt(this.resource.getProperties().getProperty("206_{0}", "0", new String[]{"" + n}));
        int n4 = 0;
        while (n4 < n3) {
            Object[] objectArray = this.valuesMultiColumnListbox.getRow(n4);
            if (objectArray != null && objectArray[0] != null) {
                ((ColumnTextField)objectArray[0]).setText(this.resource.getProperties().getProperty("207_{0}_{1}", "", new String[]{"" + n, "" + n4}));
                if (this.resource.getProperties().getProperty("208_{0}_{1}", "0", new String[]{"" + n, "" + n4}).equals("1")) {
                    ((ColumnTextField)objectArray[0]).setIsVariable(true);
                }
                if (objectArray.length == 3 && objectArray[2] != null) {
                    ((ColumnTextField)objectArray[2]).setText(this.resource.getProperties().getProperty("207_{0}_{1}", "", new String[]{"" + n, "" + (n4 + this.resource.getOptions().getMaxRows())}));
                    if (this.resource.getProperties().getProperty("208_{0}_{1}", "0", new String[]{"" + n, "" + (n4 + this.resource.getOptions().getMaxRows())}).equals("1")) {
                        ((ColumnTextField)objectArray[2]).setIsVariable(true);
                    }
                }
            }
            ++n4;
        }
        this.valuesMultiColumnListbox.rebuildCondition();
    }

    public Choice getSelectedDatabaseTablesChoice() {
        return this.selectedDatabaseTablesChoice;
    }

    public Button getValueLookupButton() {
        return this.valueLookupButton;
    }

    public ConditionMultiColumnListbox getValuesMultiColumnListbox() {
        return this.valuesMultiColumnListbox;
    }

    public SQLAssistVariableButton getVariableButton() {
        return this.variableButton;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.resource.getGui().setStatus();
        try {
            if (itemEvent.getSource().equals(this.findAndCheckbox) || itemEvent.getSource().equals(this.findOrCheckbox)) {
                this.valuesMultiColumnListbox.rebuildCondition();
                this.resource.getQuery().eventBuildSQL();
            } else if (itemEvent.getSource().equals(this.selectedDatabaseTablesChoice)) {
                this.processSelectedDatabaseTablesChoice();
            } else if (itemEvent.getSource().equals(this.availableColumnsList)) {
                this.currentColumn = this.currentTable.getColumn(this.availableColumnsList.getSelectedItem());
                if (this.currentColumn != null) {
                    this.populateOperatorList();
                }
            } else if (itemEvent.getSource().equals(this.operatorList)) {
                this.getVariableButton().setEnabled(false);
                this.valuesMultiColumnListbox.setCurrentColumnTextField(null);
                this.populateValuesMultiColumnListbox();
                this.populateDescriptionTextArea();
            }
        }
        catch (Exception exception) {}
    }

    private void populateAvailableColumnsList() {
        String string = "";
        if (this.availableColumnsList.getSelectedIndex() > -1) {
            string = this.availableColumnsList.getSelectedItem();
        }
        this.availableColumnsList.removeAll();
        if (this.resource.getQuery().getDatabase() == null || this.selectedDatabaseTablesChoice.getSelectedItem() == null) {
            this.currentTable = null;
            return;
        }
        this.currentTable = this.resource.getQuery().getDatabase().getTable(this.selectedDatabaseTablesChoice.getSelectedItem());
        if (this.currentTable == null) {
            return;
        }
        int n = 0;
        while (n < this.currentTable.getColumns().size()) {
            this.availableColumnsList.addItem(((ColumnObject)this.currentTable.getColumns().elementAt(n)).getName());
            ++n;
        }
        if (this.availableColumnsList.getItemCount() > 0) {
            SQLAssistUtils.select(this.availableColumnsList, string);
            this.currentColumn = this.currentTable.getColumn(this.availableColumnsList.getSelectedItem());
            this.populateOperatorList();
        }
        this.populateDescriptionTextArea();
    }

    public void populateDescriptionTextArea() {
        if (this.resource.getGui().getLastStatusbarMessage().equals("") && this.resource.getGui().currentPage(this.resource.getString(SQLAssistStrings.Condition_nn_Text, new String[]{"" + this.conditionIndex}))) {
            this.resource.getGui().setStatus(this.resource.getQuery().getDatabase().toString(this.currentColumn));
        }
        String string = "";
        this.isValid = false;
        if (this.conditionIndex > 1) {
            string = this.findAndCheckbox.getState() ? String.valueOf(string) + this.resource.getString(SQLAssistStrings.AND_Text) + " " : String.valueOf(string) + this.resource.getString(SQLAssistStrings.OR_Text) + " ";
        }
        if (this.selectedDatabaseTablesChoice.getSelectedItem() == null) {
            this.findOnAnotherColumnButton.setEnabled(false);
            this.descriptionTextArea.setText("");
            this.populateSelectedDatabaseTablesChoice();
            return;
        }
        string = String.valueOf(string) + this.resource.getString(SQLAssistStrings.InTable_Text, new Object[]{this.selectedDatabaseTablesChoice.getSelectedItem()}) + "\n";
        string = this.resource.getQuery().getType() == 3 ? String.valueOf(string) + this.resource.getString(SQLAssistStrings.updateAllRows_Text) : (this.resource.getQuery().getType() == 4 ? String.valueOf(string) + this.resource.getString(SQLAssistStrings.deleteAllRows_Text) : String.valueOf(string) + this.resource.getString(SQLAssistStrings.findAllRows_Text));
        if (this.availableColumnsList.getSelectedIndex() >= 0) {
            string = String.valueOf(string) + " '" + this.availableColumnsList.getSelectedItem() + "' ";
            if (this.resource.getQuery().getType() == 0 || this.resource.getQuery().getType() == 1) {
                string = String.valueOf(string) + this.resource.getString(SQLAssistStrings.that_Text);
            }
        } else {
            this.findOnAnotherColumnButton.setEnabled(false);
            this.descriptionTextArea.setText(String.valueOf(string) + " " + this.resource.getString(SQLAssistStrings.Periods_Char));
            return;
        }
        if (this.operatorList.getSelectedIndex() < 0) {
            this.findOnAnotherColumnButton.setEnabled(false);
            this.descriptionTextArea.setText(String.valueOf(string) + " " + this.resource.getString(SQLAssistStrings.Periods_Char));
            return;
        }
        int n = this.operatorList.getSelectedIndex();
        string = String.valueOf(string) + "\n";
        string = this.resource.getQuery().getType() == 0 || this.resource.getQuery().getType() == 1 ? String.valueOf(string) + this.currentTypeArray[n][0] : String.valueOf(string) + this.currentTypeArray[n][1];
        string = String.valueOf(string) + " " + this.currentTypeArray[n][2];
        String string2 = "";
        String string3 = "";
        int n2 = 0;
        if (!this.currentValueType.equals("0")) {
            int n3 = this.currentValueType.equals("1") ? 1 : this.valuesMultiColumnListbox.getResultsNames().length;
            int n4 = 0;
            while (n4 < n3) {
                boolean bl = false;
                string2 = this.valuesMultiColumnListbox.getResultsNames()[n4][0];
                bl = string2 == null || string2.equals("") ? false : (this.currentValueType.equals("B") ? (string3 = this.valuesMultiColumnListbox.getResultsNames()[n4][1]) != null && !string3.equals("") : true);
                if (bl) {
                    if (++n2 > 1) {
                        string = String.valueOf(string) + " " + this.resource.getString(SQLAssistStrings.or_Text);
                    }
                    string = String.valueOf(string) + " '" + string2 + "'";
                    if (!string3.equals("")) {
                        string = String.valueOf(string) + " " + this.resource.getString(SQLAssistStrings.and_Text) + " '" + string3 + "'";
                    }
                }
                ++n4;
            }
            if (n2 == 0 && !this.currentTypeArray[this.operatorList.getSelectedIndex()][3].equals("0")) {
                this.findOnAnotherColumnButton.setEnabled(false);
                this.descriptionTextArea.setText(String.valueOf(string) + " " + this.resource.getString(SQLAssistStrings.Periods_Char));
                return;
            }
        }
        this.descriptionTextArea.setText(string);
        this.isValid = true;
        this.findType = this.findAndCheckbox.getState() ? this.resource.getString(SQLAssistStrings.AND_Text) : this.resource.getString(SQLAssistStrings.OR_Text);
        this.findOnAnotherColumnButton.setEnabled(true);
        this.resource.getQuery().eventBuildSQL();
    }

    private void populateOperatorList() {
        String string = this.operatorList.getSelectedItem();
        this.determineCurrentTypeArray();
        if (this.currentTypeArray == null) {
            this.operatorList.removeAll();
        } else if (this.currentType != this.lastType) {
            this.processClearButton();
            this.operatorList.removeAll();
            int n = 0;
            while (n < this.currentTypeArray.length) {
                this.operatorList.addItem(String.valueOf(this.currentTypeArray[n][1]) + " " + this.currentTypeArray[n][2]);
                ++n;
            }
            SQLAssistUtils.select(this.operatorList, string);
        }
        this.lastType = this.currentType;
        this.populateValuesMultiColumnListbox();
        if (this.currentColumn != null) {
            this.resource.getGui().setStatus(this.resource.getQuery().getDatabase().toString(this.currentColumn));
        }
    }

    public void populateSelectedDatabaseTablesChoice() {
        if (this.conditionIndex == 1 && this.findAndOrPanel != null) {
            this.findAndOrPanel.setVisible(false);
            this.findAndOrPanel = null;
            this.deleteConditionButton.setVisible(false);
        }
        String string = null;
        if (this.selectedDatabaseTablesChoice != null) {
            string = this.selectedDatabaseTablesChoice.getSelectedItem();
        }
        this.resource.getGui().populateSelectedDatabaseTables(this.selectedDatabaseTablesChoice, true);
        if (this.selectedDatabaseTablesChoice.getItemCount() > 0) {
            if (string != null) {
                this.selectedDatabaseTablesChoice.select(string);
            }
            this.populateAvailableColumnsList();
        }
    }

    private void populateValuesMultiColumnListbox() {
        if (this.currentTypeArray == null || this.operatorList.getSelectedIndex() < 0 || this.selectedDatabaseTablesChoice.getSelectedItem() == null) {
            this.valueLookupButton.setEnabled(false);
            this.clearButton.setEnabled(false);
            this.valuesMultiColumnListbox.removeAllRows();
            return;
        }
        this.valueLookupButton.setEnabled(true);
        String string = this.currentTypeArray[this.operatorList.getSelectedIndex()][3];
        if (string.equals("0")) {
            this.valuesMultiColumnListbox.build(this.currentColumn, 0);
            this.valueLookupButton.setEnabled(false);
            this.clearButton.setEnabled(false);
        } else {
            if (string.equals("1")) {
                this.valuesMultiColumnListbox.build(this.currentColumn, 1);
            } else if (string.equals("M")) {
                this.valuesMultiColumnListbox.build(this.currentColumn, 2);
            } else {
                this.valuesMultiColumnListbox.build(this.currentColumn, 3);
            }
            this.clearButton.setEnabled(true);
        }
        this.currentValueType = string;
    }

    private void processClearButton() {
        this.valuesMultiColumnListbox.removeAll();
        this.valuesMultiColumnListbox.rebuildCondition();
    }

    private void processSelectedDatabaseTablesChoice() {
        if (this.selectedDatabaseTablesChoice.getSelectedItem() != null) {
            if (!this.lastSelectedDatabaseTablesString.equals(this.selectedDatabaseTablesChoice.getSelectedItem())) {
                this.lastSelectedDatabaseTablesString = this.selectedDatabaseTablesChoice.getSelectedItem();
                this.currentTable = this.resource.getQuery().getDatabase().getTable(this.lastSelectedDatabaseTablesString);
                this.currentColumn = null;
                this.populateAvailableColumnsList();
                this.populateOperatorList();
                this.populateDescriptionTextArea();
            }
        } else {
            this.currentTable = null;
            this.currentColumn = null;
        }
    }

    private void processValueLookupButton() {
        SQLAssistValueLookupDialog sQLAssistValueLookupDialog = new SQLAssistValueLookupDialog(this.resource, this);
        ((Component)sQLAssistValueLookupDialog).setVisible(true);
    }

    public void processVariableButton() {
        this.getVariableButton().process(this.getValuesMultiColumnListbox().getCurrentColumnTextField());
    }

    public synchronized void putProperties(int n) {
        this.resource.getProperties().put("202_{0}", "" + this.findOrCheckbox.getState(), new String[]{"" + n});
        this.resource.getProperties().put("209_{0}", "" + this.enableDistinctTypeSupportCheckbox.getState(), new String[]{"" + n});
        this.resource.getProperties().put("203_{0}", "" + this.selectedDatabaseTablesChoice.getSelectedItem(), new String[]{"" + n});
        this.resource.getProperties().put("204_{0}", "" + this.availableColumnsList.getSelectedItem(), new String[]{"" + n});
        this.resource.getProperties().put("205_{0}", "" + this.operatorList.getSelectedIndex(), new String[]{"" + n});
        this.resource.getProperties().put("206_{0}", "" + this.resource.getOptions().getMaxRows() * 2, new String[]{"" + n});
        int n2 = 0;
        while (n2 < this.resource.getOptions().getMaxRows()) {
            ColumnTextField columnTextField;
            ColumnTextField columnTextField2;
            if (n2 < this.valuesMultiColumnListbox.getRowCount()) {
                Object[] objectArray = this.valuesMultiColumnListbox.getRow(n2);
                columnTextField2 = (ColumnTextField)objectArray[0];
                columnTextField = objectArray.length == 3 && objectArray[2] != null ? (ColumnTextField)objectArray[2] : new ColumnTextField(this.resource);
            } else {
                columnTextField2 = new ColumnTextField(this.resource);
                columnTextField = new ColumnTextField(this.resource);
            }
            int n3 = 0;
            int n4 = 0;
            if (columnTextField2 != null && !columnTextField2.getText().equals("")) {
                if (columnTextField2.getIsVariable()) {
                    n3 = 1;
                }
                this.resource.getProperties().put("207_{0}_{1}", columnTextField2.getText(), new String[]{"" + n, "" + n2});
                this.resource.getProperties().put("208_{0}_{1}", "" + n3, new String[]{"" + n, "" + n2});
            }
            if (columnTextField != null && !columnTextField.getText().equals("")) {
                if (columnTextField.getIsVariable()) {
                    n4 = 1;
                }
                this.resource.getProperties().put("207_{0}_{1}", columnTextField.getText(), new String[]{"" + n, "" + (n2 + this.resource.getOptions().getMaxRows())});
                this.resource.getProperties().put("208_{0}_{1}", "" + n4, new String[]{"" + n, "" + (n2 + this.resource.getOptions().getMaxRows())});
            }
            ++n2;
        }
    }

    public void reset() {
        this.isValid = false;
        this.currentTypeArray = null;
        this.currentColumn = null;
        this.availableColumnsList.removeAll();
        this.operatorList.removeAll();
        this.populateOperatorList();
        this.processClearButton();
        this.descriptionTextArea.setText("");
        this.populateSelectedDatabaseTablesChoice();
    }

    public void setAvailableColumnsList(List list) {
        this.availableColumnsList = list;
    }

    public void setClearButton(Button button) {
        this.clearButton = button;
    }

    public void setConditionIndex(int n) {
        this.conditionIndex = n;
    }

    public void setCurrentColumn(ColumnObject columnObject) {
        this.currentColumn = columnObject;
    }

    public void setCurrentTable(TableObject tableObject) {
        this.currentTable = tableObject;
    }

    public void setCurrentTypeArray(String[][] stringArray) {
        this.currentTypeArray = stringArray;
    }

    public void setCurrentValueType(String string) {
        this.currentValueType = string;
    }

    public void setDeleteConditionButton(Button button) {
        this.deleteConditionButton = button;
    }

    public void setEnableDistinctTypeSupportCheckbox(Checkbox checkbox) {
        this.enableDistinctTypeSupportCheckbox = checkbox;
    }

    public void setFindOnAnotherColumnButton(Button button) {
        this.findOnAnotherColumnButton = button;
    }

    public void setFindType(String string) {
        this.findType = string;
    }

    public void setIsValid(boolean bl) {
        this.isValid = bl;
    }

    public void setOperatorList(List list) {
        this.operatorList = list;
    }

    public void setSelectedDatabaseTablesChoice(Choice choice) {
        this.selectedDatabaseTablesChoice = choice;
    }

    public void setValueLookupButton(Button button) {
        this.valueLookupButton = button;
    }

    public void setValuesMultiColumnListbox(ConditionMultiColumnListbox conditionMultiColumnListbox) {
        this.valuesMultiColumnListbox = conditionMultiColumnListbox;
    }

    public void setVariableButton(SQLAssistVariableButton sQLAssistVariableButton) {
        this.variableButton = sQLAssistVariableButton;
    }

    public void updateConditionTitle() {
        this.part1.updateTitle(this.buildConditionTitle());
    }
}

