/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.db.ibeans;

import com.ibm.ivj.db.ibeans.DatabaseInfo;
import com.ibm.ivj.db.ibeans.SPColumnObject;
import com.ibm.sqlassist.common.SQLAssistUtils;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class SPObject {
    private DatabaseInfo databaseInfo;
    private Vector columns = new Vector();
    private String schema;
    private String remarks;
    private String name;
    private int procType = 0;
    private String paramList = null;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999.\nAll Rights Reserved.\nUS Government Users Restricted Rights -\nUse, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp.";

    public SPObject() {
    }

    public SPObject(DatabaseInfo databaseInfo, ResultSet resultSet, String string) throws SQLException {
        this.setDatabaseInfo(databaseInfo);
        this.setSchema(resultSet.getString(2));
        this.setName(resultSet.getString(3));
        this.setRemarks(resultSet.getString(7));
        this.setProcType(resultSet.getShort(8));
        if (this.getRemarks() == null) {
            this.setRemarks("");
        }
        if (this.getSchema() != null) {
            this.setSchema(this.schema.trim());
        }
        if (this.getName() != null) {
            this.setName(this.name.trim());
        }
    }

    public void addColumn(SPColumnObject sPColumnObject) {
        this.columns.addElement(sPColumnObject);
    }

    public SPColumnObject getColumn(String string) {
        int n = 0;
        while (n < this.columns.size()) {
            SPColumnObject sPColumnObject = (SPColumnObject)this.columns.elementAt(n);
            if (sPColumnObject.getName().equals(string)) {
                return sPColumnObject;
            }
            ++n;
        }
        return null;
    }

    public Vector getColumns() {
        return this.columns;
    }

    public DatabaseInfo getDatabaseInfo() {
        return this.databaseInfo;
    }

    public String[] getItemNames() {
        if (this.getColumns() == null || this.getColumns().size() == 0) {
            return null;
        }
        String[] stringArray = new String[this.getColumns().size()];
        int n = 0;
        while (n < this.getColumns().size()) {
            stringArray[n] = ((SPColumnObject)this.getColumns().elementAt(n)).getName();
            ++n;
        }
        return stringArray;
    }

    public String[][] getItems() {
        if (this.getColumns() == null || this.getColumns().size() == 0) {
            return null;
        }
        String[][] stringArray = new String[this.getColumns().size()][2];
        int n = 0;
        while (n < this.getColumns().size()) {
            stringArray[n][0] = ((SPColumnObject)this.getColumns().elementAt(n)).getName();
            stringArray[n][1] = "" + ((SPColumnObject)this.getColumns().elementAt(n)).getData_Type();
            ++n;
        }
        return stringArray;
    }

    public String getName() {
        String string = this.name;
        if (this.schema != null) {
            string = String.valueOf(this.schema) + "." + this.name;
        }
        return string;
    }

    public String getNameQuoted() {
        return SQLAssistUtils.quoteString(this.getName());
    }

    public String getParamList() {
        return this.paramList;
    }

    public int getProcType() {
        return this.procType;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public String getSchema() {
        return this.schema;
    }

    private void processResultSet(ResultSet resultSet) throws Exception {
        while (resultSet.next()) {
            this.addColumn(new SPColumnObject(resultSet));
        }
        resultSet.close();
    }

    public void retrieveColumns() throws Exception {
        boolean bl = false;
        String string = "";
        if (this.schema == null || this.schema.equals("")) {
            if (this.databaseInfo.getDBObject().getLogin() != null) {
                string = this.databaseInfo.getDBObject().getLogin().toUpperCase();
            }
            bl = true;
        } else {
            string = this.schema;
        }
        this.setColumns(new Vector());
        DatabaseMetaData databaseMetaData = this.databaseInfo.getDBObject().getConnection().getMetaData();
        try {
            this.processResultSet(databaseMetaData.getProcedureColumns(null, string, this.name, "%"));
        }
        catch (Exception exception) {
            if (this.columns.size() == 0 && string != null) {
                bl = true;
            }
            throw exception;
        }
        if (this.columns.size() == 0 && bl && string != null) {
            this.processResultSet(databaseMetaData.getProcedureColumns(null, null, this.name, "%"));
        }
        if (this.columns.size() == 0) {
            this.paramList = "()";
        } else {
            this.paramList = "(";
            int n = 0;
            while (n < this.columns.size()) {
                int n2;
                if (n > 0) {
                    this.paramList = String.valueOf(this.paramList) + ", ";
                }
                if ((n2 = ((SPColumnObject)this.columns.elementAt(n)).getColumn_Type()) == 1) {
                    this.paramList = String.valueOf(this.paramList) + "in ";
                } else if (n2 == 4) {
                    this.paramList = String.valueOf(this.paramList) + "out ";
                } else if (n2 == 2) {
                    this.paramList = String.valueOf(this.paramList) + "inout ";
                }
                this.paramList = String.valueOf(this.paramList) + ((SPColumnObject)this.columns.elementAt(n)).getName() + " ";
                this.paramList = String.valueOf(this.paramList) + ((SPColumnObject)this.columns.elementAt(n)).getFormatType_Name();
                ++n;
            }
            this.paramList = String.valueOf(this.paramList) + ")";
        }
    }

    public void setColumns(Vector vector) {
        this.columns = vector;
    }

    public void setDatabaseInfo(DatabaseInfo databaseInfo) {
        this.databaseInfo = databaseInfo;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setProcType(int n) {
        this.procType = n;
    }

    public void setRemarks(String string) {
        this.remarks = string;
    }

    public void setSchema(String string) {
        this.schema = string;
    }
}

