/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.db.ibeans;

import com.ibm.db.LogonDialog;
import com.ibm.db.base.DataException;
import com.ibm.db.base.DatabaseConnectionSpec;
import com.ibm.db.base.UtilitiesBase;
import com.ibm.ivj.db.ibeans.CommonUtil;
import com.ibm.ivj.db.ibeans.IBMIVJDBDialog;
import com.ibm.ivj.db.ibeans.QuerySpecification;
import com.ibm.ivj.db.uibeans.Query;
import com.ibm.sqlassist.SQLAssistFieldsPanel;
import com.ibm.sqlassist.SQLAssistPanel;
import com.ibm.sqlassist.common.DatabaseObject;
import com.ibm.uvm.abt.edit.DialogHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class QueryBuilderDialog
extends Dialog
implements ActionListener,
WindowListener {
    private SQLAssistPanel panel = null;
    private QuerySpecification parentRef = null;
    private boolean forRSet = false;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1998, 1999";

    public QueryBuilderDialog(QuerySpecification querySpecification) {
        super(querySpecification.getParentFrame(), true);
        this.parentRef = querySpecification;
        try {
            this.setLayout(new BorderLayout());
            ((Component)this).setBackground(SystemColor.control);
            this.setForeground(Color.black);
            String string = System.getProperty("os.name");
            if (string.equals("AIX") || string.equals("OS/2")) {
                ((Component)this).setSize(780, 600);
            } else {
                ((Component)this).setSize(730, 600);
            }
            this.setTitle(CommonUtil.getMessage(IBMIVJDBDialog.SQLAssist));
            this.addWindowListener(this);
            DialogHelper.centerWindowOnComponent((Window)this, (Component)((Object)querySpecification));
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, this);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.panel != null && actionEvent.getSource() == this.panel.getGui().getFinishButton()) {
            this.connFinish();
        }
        if (this.panel != null && actionEvent.getSource() == this.panel.getGui().getCancelButton()) {
            this.connDisposeFrame();
        }
    }

    public void connDisposeFrame() {
        try {
            this.parentRef.getBuilderFrame().dispose();
            this.parentRef.setDBObj(this.panel.getQuery().getDatabase());
            this.parentRef.setBuilderFrame(null);
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, this);
        }
    }

    void connFinish() {
        try {
            this.generateSpecMethod();
            if (this.parentRef.getCreateQueryFlag()) {
                String string = this.parentRef.getQueryMethodName();
                this.parentRef.getPanelQuery().getChoice().add(string);
                this.parentRef.getPanelQuery().sortListItems();
                this.parentRef.getPanelQuery().selectListItem(string);
                this.parentRef.getPanelQuery().getButtonEdit().setEnabled(true);
                this.parentRef.getQueryEditor().getQLocator().setSqlName(string);
                this.parentRef.getQueryEditor().getQLocator().setSqlBundleName(this.parentRef.getQuerySpecPath());
            }
            this.parentRef.getQueryEditor().getSupport().firePropertyChange(null, null, null);
        }
        catch (Throwable throwable) {
            CommonUtil.handleException(throwable, this);
            this.connDisposeFrame();
            ((Component)((Object)this.parentRef)).getParent().setEnabled(true);
        }
        this.connDisposeFrame();
        ((Component)((Object)this.parentRef)).getParent().setEnabled(true);
    }

    private boolean createSqlPanel(DatabaseConnectionSpec databaseConnectionSpec) {
        boolean bl = false;
        DatabaseObject databaseObject = this.parentRef.getDBObj();
        this.panel = null;
        this.panel = new SQLAssistPanel();
        if (databaseObject != null) {
            if (databaseObject.getJdbcDriver().equals(databaseConnectionSpec.getDriverName()) && databaseObject.getJdbcServer().equals(databaseConnectionSpec.getDataSourceName())) {
                if (databaseConnectionSpec.getLogonSpec() == null) {
                    if (databaseObject.getLogin() == null && databaseObject.getPassword() == null) {
                        bl = true;
                    }
                } else {
                    if (databaseObject.getLogin().equals(databaseConnectionSpec.getLogonSpec().getId()) && databaseObject.getPassword().equals(databaseConnectionSpec.getLogonSpec().getPassword())) {
                        bl = true;
                    }
                    int n = databaseObject.getLogin().length();
                    int n2 = databaseConnectionSpec.getLogonSpec().getId().length();
                    int n3 = databaseObject.getPassword().length();
                    int n4 = databaseConnectionSpec.getLogonSpec().getPassword().length();
                    if (n == 0 && n2 == 0 && n3 == 0 && n4 == 0) {
                        bl = true;
                    }
                }
            }
            if (bl) {
                this.panel.getQuery().setDatabase(databaseObject);
            }
        }
        if (this.forRSet) {
            this.panel.getGui().getCancelButton().addActionListener(this.parentRef.getSPDialog());
            this.panel.getGui().getFinishButton().addActionListener(this.parentRef.getSPDialog());
        } else {
            this.panel.getGui().getCancelButton().addActionListener(this);
            this.panel.getGui().getFinishButton().addActionListener(this);
        }
        return bl;
    }

    private String generateBuilderInfoBlock(String[][] stringArray) {
        String string = "/*V2.0\n**start of SQL Assist data**\n";
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(stringArray);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            CommonUtil.handleException(iOException, this);
        }
        try {
            string = String.valueOf(string) + UtilitiesBase.encodeData((byte[])UtilitiesBase.zipData(byArray), (int)50);
            string = String.valueOf(string) + "\n" + "**end of SQL Assist data**/" + "\n";
        }
        catch (DataException dataException) {
            CommonUtil.handleException(dataException, this);
        }
        return string;
    }

    private void generateSpecMethod() {
        String[][] stringArray;
        String string;
        String string2 = this.panel.getQuery().buildSQL();
        byte[] byArray = string2.getBytes();
        int n = 0;
        while (n < string2.length()) {
            if (byArray[n] == 13) {
                byArray[n] = 32;
            }
            ++n;
        }
        String string3 = new String(byArray);
        int n2 = -1;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer(string3);
        while ((n2 = string3.indexOf("\"", n2 + 1)) != -1) {
            stringBuffer.insert(n2 + n3, "\\");
            ++n3;
        }
        this.parentRef.getPanelQuery().getTextArea().setText(string3);
        String string4 = this.parentRef.getQueryMethodName();
        String string5 = this.parentRef.getParentRef().getQueryType();
        String string6 = string5.equals("Select") ? "com.ibm.db.StatementMetaData" : "com.ibm.db.SQLStatementMetaData";
        String string7 = "  String name = \"" + this.parentRef.getPanelQuery().getChoiceClass().getSelectedItem() + "." + string4 + "\";\n";
        string7 = String.valueOf(string7) + "  String statement = \"" + stringBuffer + "\";\n\n";
        string7 = String.valueOf(string7) + "  " + CommonUtil.getMethodName(string6) + " aSpec = null;\n";
        string7 = String.valueOf(string7) + "  try{\n";
        string7 = String.valueOf(string7) + "    aSpec = new " + string6 + "();\n";
        string7 = String.valueOf(string7) + "    aSpec.setName(name);\n";
        string7 = String.valueOf(string7) + "    aSpec.setSQL(statement);\n";
        int n4 = 0;
        if (string6.equals("com.ibm.db.StatementMetaData")) {
            int n5;
            int n6 = this.panel.getGui().getSqlAssistTablesPanel().getSelectedDatabaseTablesList().getItemCount();
            string = null;
            int n7 = 0;
            n4 = 0;
            while (n4 < n6) {
                string = this.panel.getGui().getSqlAssistTablesPanel().getSelectedDatabaseTablesList().getItem(n4);
                n5 = this.panel.getGui().getSqlAssistSQLPanel().getSchemaQualifiedNamesCheckbox().getState();
                if (n5 == 0) {
                    n7 = string.indexOf(".");
                    string = string.substring(n7 + 1);
                }
                string = this.removeQuotes(string);
                string7 = String.valueOf(string7) + "    aSpec.addTable(\"" + string + "\");\n";
                ++n4;
            }
            n5 = 0;
            String string8 = null;
            SQLAssistFieldsPanel sQLAssistFieldsPanel = this.panel.getGui().getSqlAssistFieldsPanel();
            if (sQLAssistFieldsPanel != null) {
                int n8;
                int n9 = sQLAssistFieldsPanel.getSelectedList().getItemCount();
                String[][] stringArray2 = this.panel.getQuery().getDataTypeMappings();
                int n10 = stringArray2.length;
                if (n9 > 0) {
                    n4 = 0;
                    while (n4 < n9) {
                        string8 = this.panel.getGui().getSqlAssistFieldsPanel().getSelectedList().getItem(n4);
                        n5 = 0;
                        while (n5 < n10) {
                            if (string8.equals(stringArray2[n5][0])) {
                                n8 = string8.indexOf(".");
                                if ((n8 = (string8 = string8.substring(n8 + 1)).indexOf(".")) == -1) {
                                    string8 = stringArray2[n5][0];
                                }
                                string8 = this.removeQuotes(string8);
                                string7 = String.valueOf(string7) + "    aSpec.addColumn(\"" + string8 + "\", " + new Integer(stringArray2[n5][2]) + "," + new Integer(stringArray2[n5][1]) + ");\n";
                                break;
                            }
                            ++n5;
                        }
                        ++n4;
                    }
                } else {
                    n5 = 0;
                    while (n5 < n10) {
                        string8 = stringArray2[n5][0];
                        n8 = string8.indexOf(".");
                        if ((n8 = (string8 = string8.substring(n8 + 1)).indexOf(".")) == -1) {
                            string8 = stringArray2[n5][0];
                        }
                        string8 = this.removeQuotes(string8);
                        string7 = String.valueOf(string7) + "    aSpec.addColumn(\"" + string8 + "\", " + new Integer(stringArray2[n5][2]) + "," + new Integer(stringArray2[n5][1]) + ");\n";
                        ++n5;
                    }
                }
            }
        }
        if ((stringArray = this.panel.getQuery().getAvailableVariables()) != null) {
            n4 = 0;
            while (n4 < stringArray.length) {
                string7 = String.valueOf(string7) + "    aSpec.addParameter(\"" + stringArray[n4][0].substring(1) + "\", " + new Integer(stringArray[n4][1]) + ", " + new Integer(stringArray[n4][1]) + ");\n";
                ++n4;
            }
        }
        string7 = String.valueOf(string7) + this.generateUserCode();
        string7 = String.valueOf(string7) + "  }\n  catch(java.lang.Throwable e){\n";
        string7 = String.valueOf(string7) + this.generateUserCatchCode();
        string7 = String.valueOf(string7) + "    throw e;\n  }\n";
        string7 = String.valueOf(string7) + "  return aSpec;\n";
        string7 = String.valueOf(string7) + this.generateBuilderInfoBlock(this.panel.getProperties().getStateArray());
        string = this.parentRef.getPanelQuery().getChoiceClass().getSelectedItem();
        CommonUtil.methodCodeGen(string6, string, string4, string7, this);
    }

    private String generateUserCatchCode() {
        String string = "    // user code begin {2}";
        String string2 = this.parentRef.getMdSrcUser2();
        string = string2 != null ? String.valueOf(string) + string2 : String.valueOf(string) + " \n" + "    ";
        string = String.valueOf(string) + "// user code end {2}" + "\n";
        return string;
    }

    private String generateUserCode() {
        String string = "    // user code begin {1}";
        String string2 = this.parentRef.getMdSrcUser1();
        string = string2 != null ? String.valueOf(string) + string2 : String.valueOf(string) + " \n" + "    ";
        string = String.valueOf(string) + "// user code end {1}" + "\n";
        return string;
    }

    public SQLAssistPanel getPanel() {
        return this.panel;
    }

    public void qbuilderMain(Query query, String[][] stringArray, boolean bl, boolean bl2) throws com.ibm.db.DataException {
        this.forRSet = bl;
        if (bl2 && !bl) {
            this.parentRef.getPanelQuery().getLabelEditorMsg().setText(CommonUtil.getMessage(IBMIVJDBDialog.initAssist));
        }
        ((Component)((Object)this.parentRef)).getParent().setCursor(Cursor.getPredefinedCursor(3));
        DatabaseConnectionSpec databaseConnectionSpec = query.getConnectionAlias().getConnectionSpec();
        boolean bl3 = this.createSqlPanel(databaseConnectionSpec);
        if ((!this.parentRef.getCreateQueryFlag() || bl) && stringArray != null) {
            this.panel.getProperties().putStateArray(stringArray);
        }
        if (!bl3) {
            LogonDialog logonDialog;
            if (databaseConnectionSpec.getPromptUID() && !(logonDialog = new LogonDialog((Component)this)).promptAndSetUID(databaseConnectionSpec)) {
                this.parentRef.getPanelQuery().getLabelEditorMsg().setText("");
                ((Component)((Object)this.parentRef)).getParent().setCursor(Cursor.getPredefinedCursor(0));
                this.panel = null;
                return;
            }
            this.panel.getQuery().setDriver(databaseConnectionSpec.getDriverName());
            this.panel.getQuery().setServer(databaseConnectionSpec.getDataSourceName());
        }
        if (databaseConnectionSpec.getLogonSpec() != null) {
            this.panel.getQuery().setLogin(databaseConnectionSpec.getLogonSpec().getId());
            this.panel.getQuery().setPassword(databaseConnectionSpec.getLogonSpec().getPassword());
        }
        this.panel.getOptions().setDisplayWelcomeTab(false);
        this.panel.getOptions().setDisplayFinishTab(false);
        this.panel.getOptions().setDisplayLogonTab(false);
        this.panel.getOptions().setForceLogon(true);
        this.panel.getOptions().setDisplayDataTypeMappingTab(true);
        this.panel.getOptions().setSupportSavingLogonProperties(false);
        this.panel.getOptions().setReferToAsVariable(false);
        this.panel.getOptions().setSchemaQualifiedNames(true);
        this.panel.getOptions().setEnableDistinctTypeSupport(true);
        this.panel.getOptions().setSupportTimestamp(true);
        if (this.parentRef.getParentRef().getQueryType().equals("Select")) {
            this.panel.getOptions().setDisplaySelect(true);
            this.panel.getOptions().setDisplaySelectUnique(true);
            this.panel.getOptions().setDisplayInsert(false);
            this.panel.getOptions().setDisplayUpdate(false);
            this.panel.getOptions().setDisplayDelete(false);
        } else if (this.parentRef.getParentRef().getQueryType().equals("Modify")) {
            this.panel.getOptions().setDisplaySelect(false);
            this.panel.getOptions().setDisplaySelectUnique(false);
            this.panel.getOptions().setDisplayInsert(true);
            this.panel.getOptions().setDisplayUpdate(true);
            this.panel.getOptions().setDisplayDelete(true);
            this.panel.getQuery().setType(2);
        } else {
            this.panel.getOptions().setDisplayStatementType(false);
            this.panel.getOptions().setDisplaySelect(false);
            this.panel.getOptions().setDisplaySelectUnique(false);
            this.panel.getOptions().setDisplayInsert(false);
            this.panel.getOptions().setDisplayUpdate(false);
            this.panel.getOptions().setDisplayDelete(false);
            this.panel.getOptions().setDisplaySQLTab(false);
            this.panel.getOptions().setDisplaySortTab(false);
            this.panel.getOptions().setDisplayConditionsTab(false);
        }
        this.panel.getOptions().setReferToAsOK(false);
        this.panel.getOptions().setVariableCharacters(":");
        this.panel.getOptions().setSupportSchema(true);
        this.panel.getOptions().setVAJavaVM(true);
        if (this.forRSet) {
            this.panel.getOptions().setDisplayJoinsTab(false);
            this.panel.getOptions().setDisplayFinishTab(false);
        }
        this.parentRef.getPanelQuery().getLabelEditorMsg().setText(String.valueOf(CommonUtil.getMessage(IBMIVJDBDialog.connectingDB)) + " \"" + databaseConnectionSpec.getDataSourceName() + "\" ......");
        try {
            this.panel.build();
        }
        catch (Error error) {
            CommonUtil.handleException(error, this);
            throw error;
        }
        if (this.panel.getQuery().getDatabase() == null || this.panel.getQuery().getDatabase().getConnection() == null) {
            this.connDisposeFrame();
            this.panel = null;
            return;
        }
        if (bl2) {
            this.parentRef.getPanelQuery().getLabelEditorMsg().setText(CommonUtil.getMessage(IBMIVJDBDialog.displayAssist));
            try {
                this.add(this.panel);
            }
            catch (Error error) {
                CommonUtil.handleException(error, this);
                throw error;
            }
            ((Component)this).setCursor(Cursor.getPredefinedCursor(0));
            this.show();
        } else {
            this.connDisposeFrame();
        }
    }

    private String removeQuotes(String string) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = string.indexOf("\"");
        if (n2 != -1) {
            do {
                stringBuffer = stringBuffer.append(string.substring(n, n + n2));
            } while ((n2 = string.substring(n += n2 + 1).indexOf("\"")) != -1);
            stringBuffer = stringBuffer.append(string.substring(n));
            return stringBuffer.toString();
        }
        return string;
    }

    public void setPanel(SQLAssistPanel sQLAssistPanel) {
        this.panel = null;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            this.connDisposeFrame();
            ((Component)((Object)this.parentRef)).getParent().setEnabled(true);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

