/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.extend.util;

import com.ibm.extend.util.ItemProcessor;
import java.util.Vector;

public class Item {
    private static String Copyright = "\r\n\r\nLicensed Materials - Property of IBM.\r\n(C) Copyright IBM Corporation 1997.\r\nAll Rights Reserved US Government Users Restricted Rights -\r\nUse, duplication or disclosure\r\nrestricted by GSA ADP Schedule Contract\r\nwith IBM Corp.\r\n\r\n";
    protected Item parent = null;
    protected Item nextSibling = null;
    protected Item previousSibling = null;
    protected Item aChild = null;
    protected Object description;
    protected Object data;
    protected Vector children;
    protected boolean hideChildren;

    public Item() {
        this(null, null);
    }

    public Item(Object desc) {
        this(desc, null);
    }

    public Item(Object desc, Object ref) {
        this.data = ref;
        this.description = desc;
        this.hideChildren = true;
        this.children = new Vector(10, 5);
    }

    public Item addBefore(Item item) {
        this.nextSibling = item;
        this.previousSibling = item.previousSibling;
        this.parent = item.parent;
        item.previousSibling = this;
        if (this.previousSibling != null) {
            this.previousSibling.nextSibling = this;
        }
        this.addAsChild(this.parent);
        return this;
    }

    public Item moveBefore(Item item) {
        this.remove();
        return this.addBefore(item);
    }

    public Item addAfter(Item item) {
        this.previousSibling = item;
        this.nextSibling = item.nextSibling;
        this.parent = item.parent;
        item.nextSibling = this;
        if (this.nextSibling != null) {
            this.nextSibling.previousSibling = this;
        }
        this.addAsChild(this.parent);
        return this;
    }

    public Item moveAfter(Item item) {
        this.remove();
        return this.addAfter(item);
    }

    public Item addFirst(Item item) {
        return this.addBefore(item.getFirst());
    }

    public Item moveFirst(Item item) {
        this.remove();
        return this.addFirst(item);
    }

    public Item addLast(Item item) {
        return this.addAfter(item.getLast());
    }

    public Item moveLast(Item item) {
        this.remove();
        return this.addLast(item);
    }

    public Item replace(Item item) {
        if (item != null) {
            this.nextSibling = item.nextSibling;
            this.previousSibling = item.previousSibling;
            item.nextSibling = null;
            item.previousSibling = null;
            item.remove();
        }
        return this;
    }

    public Item remove() {
        this.removeAsChild();
        if (this.nextSibling != null) {
            this.nextSibling.previousSibling = this.previousSibling;
        }
        if (this.previousSibling != null) {
            this.previousSibling.nextSibling = this.nextSibling;
        }
        this.nextSibling = null;
        this.previousSibling = null;
        return this;
    }

    public Item prune() {
        Item item = this.aChild;
        this.remove();
        if (item != null) {
            item = item.getFirst();
            while (item != null) {
                Item hold = item.nextSibling;
                item.prune();
                item = hold;
            }
        }
        return this;
    }

    public Item addAsChild(Item item) {
        this.parent = item;
        if (this.parent != null) {
            if (this.parent.aChild == null) {
                this.parent.aChild = this;
                this.parent.children.addElement(this);
            } else if (this.getItemPosition(this.parent.aChild) < 0) {
                this.addLast(this.parent.aChild);
                this.parent.children.addElement(this);
            } else {
                if (this.parent.children.indexOf(this) == -1) {
                    this.parent.children.addElement(this);
                }
                this.parent.aChild = this.getFirst();
            }
        }
        return this;
    }

    public Item removeAsChild() {
        if (this.parent != null && this.parent.aChild != null) {
            if (this.parent.aChild.equals(this)) {
                this.parent.aChild = this.previousSibling != null ? this.previousSibling : this.nextSibling;
                this.parent.children.removeElementAt(this.parent.children.indexOf(this));
            } else if (this.getItemPosition(this.parent.aChild) >= 0) {
                this.parent.children.removeElementAt(this.parent.children.indexOf(this));
                this.parent = null;
                this.remove();
            }
        }
        this.parent = null;
        return this;
    }

    public void setDescription(Object desc) {
        this.description = desc;
    }

    public Object getDescription() {
        return this.description;
    }

    public void setData(Object ref) {
        this.data = ref;
    }

    public Object getData() {
        return this.data;
    }

    public void setChildrenVisible(boolean newState) {
        this.hideChildren = !newState;
    }

    public boolean isChildrenVisible() {
        return !this.hideChildren;
    }

    public Item getFirst() {
        Item item = this;
        while (item.previousSibling != null) {
            item = item.previousSibling;
        }
        return item;
    }

    public Item getNext() {
        return this.nextSibling;
    }

    public Item getPrevious() {
        return this.previousSibling;
    }

    public Item getLast() {
        Item item = this;
        while (item.nextSibling != null) {
            item = item.nextSibling;
        }
        return item;
    }

    public Item getItem(int which) {
        Item item = this.getFirst();
        while (which > 0 && item != null) {
            item = item.nextSibling;
            --which;
        }
        if (item == null) {
            throw new IllegalArgumentException("No such item");
        }
        return item;
    }

    public int getItemPosition() {
        int result = 0;
        Item item = this.previousSibling;
        while (item != null) {
            item = item.previousSibling;
            ++result;
        }
        return result;
    }

    public int getItemPosition(Item item) {
        int result = -1;
        Item work = this.getFirst();
        int loop = 0;
        while (loop < this.getItemCount() && result < 0) {
            if (work.equals(item)) {
                result = loop;
            } else {
                work = work.nextSibling;
            }
            ++loop;
        }
        return result;
    }

    public int getItemCount() {
        int count = 0;
        Item item = this.getFirst();
        while (item != null) {
            ++count;
            item = item.nextSibling;
        }
        return count;
    }

    public int getChildCount() {
        int num = 0;
        if (this.aChild != null) {
            num = this.aChild.getItemCount();
        }
        return num;
    }

    public Item getParent() {
        return this.parent;
    }

    public Item getFirstChild() {
        Item result = null;
        if (this.aChild != null) {
            result = this.aChild.getFirst();
        }
        return result;
    }

    public Item getChild(int which) {
        Item result = null;
        if (this.aChild != null) {
            result = this.aChild;
            int i = 1;
            while (i <= which) {
                result = result.nextSibling;
                ++i;
            }
        }
        return result;
    }

    public void traverse(ItemProcessor processor, Object data) {
        this.traverse(processor, data, true);
    }

    public void traverse(ItemProcessor processor, Object data, boolean visitHidden) {
        Item item = this.getFirst();
        int level = 0;
        while (item != null) {
            if (processor.processItem(item, data)) {
                if (item.getChildCount() > 0 && (!item.hideChildren || visitHidden)) {
                    item = item.getFirstChild();
                    ++level;
                    continue;
                }
                if (item.getNext() != null) {
                    item = item.getNext();
                    continue;
                }
                item = item.getParent();
                boolean notDone = item != null && --level >= 0;
                while (notDone) {
                    if (item.getNext() == null) {
                        item = item.getParent();
                        notDone = item != null && --level >= 0;
                        continue;
                    }
                    item = item.getNext();
                    notDone = false;
                }
                if (level >= 0) continue;
                item = null;
                continue;
            }
            item = null;
        }
    }

    public void sort(ItemProcessor comparator) {
        int count = this.getItemCount();
        if (count > 1) {
            Item[] list = this.getItemList();
            this.quickSort(comparator, list, 0, list.length - 1);
            this.rebuildSiblingChain(list);
        }
    }

    private Item[] getItemList() {
        int count = this.getItemCount();
        Item[] list = new Item[count];
        list[0] = this.getFirst();
        int loop = 1;
        while (loop < count) {
            list[loop] = list[loop - 1].nextSibling;
            ++loop;
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    private void quickSort(ItemProcessor cmp, Item[] list, int lowBound, int highBound) {
        block5: {
            low = lowBound;
            high = highBound;
            if (highBound <= lowBound) break block5;
            middleItem = list[(highBound + lowBound) / 2];
            ** GOTO lbl16
            {
                ++low;
                do {
                    if (low < highBound && cmp.compareItems(list[low], middleItem) == -1) continue block0;
                    while (high > lowBound && cmp.compareItems(list[high], middleItem) == 1) {
                        --high;
                    }
                    if (low > high) continue;
                    this.swapItems(list, low, high);
                    ++low;
                    --high;
lbl16:
                    // 3 sources

                } while (low <= high);
            }
            if (lowBound < high) {
                this.quickSort(cmp, list, lowBound, high);
            }
            if (low < highBound) {
                this.quickSort(cmp, list, low, highBound);
            }
        }
    }

    private void swapItems(Item[] list, int first, int second) {
        Item hold = list[first];
        list[first] = list[second];
        list[second] = hold;
    }

    private void rebuildSiblingChain(Item[] list) {
        list[0].previousSibling = null;
        int loop = 1;
        while (loop < list.length) {
            list[loop - 1].nextSibling = list[loop];
            list[loop].previousSibling = list[loop - 1];
            ++loop;
        }
        list[list.length - 1].nextSibling = null;
        int loop2 = 1;
        while (loop2 < list.length) {
            list[loop2] = null;
            ++loop2;
        }
    }
}

