/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eou.toolkit.widget;

import com.ibm.eou.toolkit.filter.TextEditable;
import com.ibm.eou.toolkit.filter.TextEditableEvent;
import com.ibm.eou.toolkit.filter.TextEditableListener;
import com.ibm.eou.toolkit.graphics.VectorUtils;
import com.ibm.eou.toolkit.util.Timer;
import com.ibm.eou.toolkit.util.TimerListener;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;

public class SingleLineTextEditable
extends Canvas
implements TextEditable,
TimerListener,
ClipboardOwner {
    private transient Vector fTEListeners = new Vector(1, 1);
    private char[] fText = new char[32];
    private int fTextLength = 0;
    private int fCaretPosition = 0;
    private int fSelectionAnchor = 0;
    private int fSelectionEnd = 0;
    private int fCursorSize = 0;
    private boolean fValid = true;
    private boolean fEditable = true;
    private boolean fHasFocus = false;
    private boolean fDragging = false;
    private int fPreDragCaretPosition;
    private int fBorderWidth = 2;
    private int fDisplayOffset = 0;
    private int fLeftCaretProximityTrigger = -1;
    private int fRightCaretProximityTrigger = -1;
    private boolean fCaretShown = true;
    private transient Timer fCaretBlinkTimer = new Timer();
    private int fPaintCollectionDepth = 0;
    private boolean fPaintRequested = false;
    private transient Image fBufferI = null;
    private transient Graphics fBufferG = null;

    public SingleLineTextEditable() {
        this.enableEvents(1085L);
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.startBlinking();
    }

    public SingleLineTextEditable(String string) {
        this();
        this.setText(string);
    }

    public void addTextEditableListener(TextEditableListener textEditableListener) {
        if (!this.fTEListeners.contains(textEditableListener)) {
            this.fTEListeners.addElement(textEditableListener);
        }
    }

    public void append(String string) {
        this.append(string, true);
    }

    public void append(String string, boolean bl) {
        this.setText(String.valueOf(this.getText()) + string, bl);
    }

    private void collectPaint(boolean bl) {
        if (this.fPaintCollectionDepth++ == 0) {
            this.fPaintRequested = false;
        }
        this.fPaintRequested = this.fPaintRequested || bl;
    }

    private static String copyright() {
        return "\n\n(c) Copyright IBM Corporation 1999.\n\n";
    }

    private void copyToClipboard() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        String string = this.getText(Math.min(this.fSelectionAnchor, this.fSelectionEnd), Math.max(this.fSelectionAnchor, this.fSelectionEnd));
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, this);
    }

    private void cutToClipboard() {
        this.copyToClipboard();
        this.deleteSelection();
    }

    private void delete(int n, int n2) {
        this.replaceRange("", n, n2, false);
    }

    private void deleteSelection() {
        this.delete(Math.min(this.fSelectionAnchor, this.fSelectionEnd), Math.max(this.fSelectionAnchor, this.fSelectionEnd));
    }

    public void dispose() {
        this.fTEListeners.removeAllElements();
        this.fTEListeners = null;
    }

    private void ensureTextArray(int n) {
        int n2 = this.fText.length;
        while (n2 < n) {
            n2 *= 2;
        }
        if (n2 > this.fText.length) {
            this.fText = new char[n2];
        }
    }

    protected void fireCaretPositionChanged(TextEditableEvent textEditableEvent) {
        Enumeration enumeration = ((Vector)this.fTEListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((TextEditableListener)enumeration.nextElement()).caretPositionChanged(textEditableEvent);
        }
    }

    protected void fireFocusGained(TextEditableEvent textEditableEvent) {
        Enumeration enumeration = ((Vector)this.fTEListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((TextEditableListener)enumeration.nextElement()).focusGained(textEditableEvent);
        }
    }

    protected void fireFocusLost(TextEditableEvent textEditableEvent) {
        if (!textEditableEvent.isTemporary()) {
            this.fireTextValueCompleted(new TextEditableEvent(this, 3005));
        }
        Enumeration enumeration = ((Vector)this.fTEListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((TextEditableListener)enumeration.nextElement()).focusLost(textEditableEvent);
        }
    }

    protected void fireKeyPressed(TextEditableEvent textEditableEvent) {
        Enumeration enumeration = ((Vector)this.fTEListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((TextEditableListener)enumeration.nextElement()).keyPressed(textEditableEvent);
        }
    }

    protected void fireKeyReleased(TextEditableEvent textEditableEvent) {
        Enumeration enumeration = ((Vector)this.fTEListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((TextEditableListener)enumeration.nextElement()).keyReleased(textEditableEvent);
        }
    }

    protected void fireKeyTyped(TextEditableEvent textEditableEvent) {
        Enumeration enumeration = ((Vector)this.fTEListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((TextEditableListener)enumeration.nextElement()).keyTyped(textEditableEvent);
        }
    }

    protected void fireTextValueChanged(TextEditableEvent textEditableEvent) {
        Enumeration enumeration = ((Vector)this.fTEListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((TextEditableListener)enumeration.nextElement()).textValueChanged(textEditableEvent);
        }
    }

    protected void fireTextValueCompleted(TextEditableEvent textEditableEvent) {
        Enumeration enumeration = ((Vector)this.fTEListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((TextEditableListener)enumeration.nextElement()).textValueCompleted(textEditableEvent);
        }
    }

    private void flushBuffer() {
        if (this.fBufferG != null) {
            this.fBufferG.dispose();
        }
        this.fBufferG = null;
        if (this.fBufferI != null) {
            this.fBufferI.flush();
        }
        this.fBufferI = null;
        this.fLeftCaretProximityTrigger = -1;
        this.fRightCaretProximityTrigger = -1;
    }

    public int getCaretPosition() {
        return this.fCaretPosition;
    }

    public Dimension getMinimumSize() {
        return this.getMinimumSize(0);
    }

    public Dimension getMinimumSize(int n) {
        FontMetrics fontMetrics;
        Font font;
        Dimension dimension = new Dimension(2 * this.fBorderWidth + 2, 2 * this.fBorderWidth + 2);
        Toolkit toolkit = this.getToolkit();
        if (toolkit == null) {
            toolkit = Toolkit.getDefaultToolkit();
        }
        if ((font = this.getFont()) != null && (fontMetrics = toolkit.getFontMetrics(font)) != null) {
            dimension.width += fontMetrics.getMaxAdvance() * n;
            dimension.height += fontMetrics.getAscent() + fontMetrics.getDescent();
        }
        return dimension;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize(8);
    }

    public int getSelectionEnd() {
        return this.fSelectionEnd;
    }

    public int getSelectionStart() {
        return this.fSelectionAnchor;
    }

    public String getText() {
        return new String(this.fText, 0, this.fTextLength);
    }

    public String getText(int n, int n2) {
        int n3 = Math.min(this.fTextLength, Math.min(n, n2));
        int n4 = Math.min(this.fTextLength, Math.max(n, n2));
        return new String(this.fText, n3, n4 - n3);
    }

    public boolean getValid() {
        return this.fValid;
    }

    private void handleKeyPressed(int n, int n2, char c) {
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 2) != 0;
        switch (n2) {
            case 37: {
                this.setCaretPosition(this.fCaretPosition - 1, bl);
                break;
            }
            case 39: {
                if (this.fCursorSize > 0 && bl && this.fCaretPosition == this.fSelectionAnchor - this.fCursorSize) {
                    this.select(this.fCaretPosition, this.fSelectionAnchor + 1);
                    break;
                }
                this.setCaretPosition(this.fCaretPosition + 1, bl);
                break;
            }
            case 36: {
                this.setCaretPosition(0, bl);
                break;
            }
            case 35: {
                if (this.fCursorSize > 0 && bl && this.fCaretPosition == this.fSelectionAnchor - this.fCursorSize) {
                    this.select(this.fCaretPosition, this.fTextLength);
                    break;
                }
                this.setCaretPosition(this.fTextLength, bl);
                break;
            }
            case 155: {
                if (bl2) {
                    this.copyToClipboard();
                    break;
                }
                if (bl) {
                    if (!this.fEditable) break;
                    this.pasteFromClipboard();
                    break;
                }
                this.fCursorSize = 1 - this.fCursorSize;
                this.setCaretPosition(this.fCaretPosition, false);
                break;
            }
            case 10: {
                this.fireTextValueCompleted(new TextEditableEvent((TextEditable)this, 3005, new KeyEvent(this, 401, System.currentTimeMillis(), n, n2, c)));
                break;
            }
            case 12: 
            case 127: {
                if (bl) {
                    if (this.fEditable) {
                        this.cutToClipboard();
                        break;
                    }
                    this.copyToClipboard();
                    break;
                }
                if (!this.fEditable) break;
                if (this.fSelectionEnd == this.fSelectionAnchor) {
                    this.delete(this.fCaretPosition, this.fCaretPosition + 1);
                    break;
                }
                this.deleteSelection();
                break;
            }
            case 8: {
                if (!this.fEditable) break;
                if (this.fSelectionEnd == this.fSelectionAnchor) {
                    this.delete(this.fCaretPosition - 1, this.fCaretPosition);
                    break;
                }
                this.deleteSelection();
                break;
            }
            case 27: {
                if (!this.fDragging) break;
                this.setCaretPosition(this.fPreDragCaretPosition);
                this.fDragging = false;
                break;
            }
            case 67: {
                if (!bl2) break;
                this.copyToClipboard();
                break;
            }
            case 86: {
                if (!bl2 || !this.fEditable) break;
                this.pasteFromClipboard();
                break;
            }
            case 88: {
                if (!bl2) break;
                if (this.fEditable) {
                    this.cutToClipboard();
                    break;
                }
                this.copyToClipboard();
            }
        }
    }

    private void handleKeyReleased(int n, int n2, char c) {
    }

    private void handleKeyTyped(int n, int n2, char c) {
        if (this.fEditable && c != '\u0000' && !Character.isISOControl(c)) {
            this.replaceRange("" + c, Math.min(this.fSelectionAnchor, this.fSelectionEnd), Math.max(this.fSelectionAnchor, this.fSelectionEnd), false);
        }
    }

    private void handleMouseDragged(int n, int n2) {
        if (this.fDragging) {
            this.select(this.fSelectionAnchor, this.paintField(false, null, true, n, false, false));
        }
    }

    private void handleMousePressed(int n, int n2) {
        if (!this.fHasFocus) {
            this.requestFocus();
        } else {
            this.fPreDragCaretPosition = this.fCaretPosition;
            this.fDragging = true;
            this.setCaretPosition(this.paintField(false, null, true, n, false, false));
        }
    }

    private void handleMouseReleased(int n, int n2) {
        if (this.fDragging) {
            this.setCaretPosition(this.paintField(false, null, true, n, false, false), true);
            this.fDragging = false;
        }
    }

    public void insert(String string, int n) {
        this.insert(string, n, true);
    }

    public void insert(String string, int n, boolean bl) {
        this.replaceRange(string, n, n, bl);
    }

    public boolean isEditable() {
        return this.fEditable;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void paint(Graphics graphics) {
        if (this.fBufferI == null) {
            Dimension dimension = this.getSize();
            this.fBufferI = this.createImage(dimension.width, dimension.height);
            this.fBufferG = this.fBufferI.getGraphics();
        }
        this.paintField(true, this.fBufferG, false, -1, false, false);
        graphics.drawImage(this.fBufferI, 0, 0, null);
    }

    private int paintField(boolean bl, Graphics graphics, boolean bl2, int n, boolean bl3, boolean bl4) {
        int n2;
        int n3;
        int n4 = -1;
        Dimension dimension = this.getSize();
        Font font = this.getFont();
        FontMetrics fontMetrics = font == null ? null : this.getToolkit().getFontMetrics(font);
        int n5 = fontMetrics == null ? 0 : fontMetrics.getAscent();
        int n6 = n3 = fontMetrics == null ? 0 : fontMetrics.getDescent();
        if (this.fLeftCaretProximityTrigger < 0) {
            this.fLeftCaretProximityTrigger = dimension.width / 4;
        }
        if (this.fRightCaretProximityTrigger < 0) {
            this.fRightCaretProximityTrigger = 3 * dimension.width / 4;
        }
        Color color = this.getBackground();
        Color color2 = this.getForeground();
        Color color3 = Color.red;
        Color color4 = Color.black;
        Color color5 = this.fHasFocus ? new Color(0, 127, 127) : Color.gray;
        Color color6 = this.fHasFocus ? Color.white : color2;
        int n7 = Integer.MIN_VALUE;
        int n8 = Integer.MIN_VALUE;
        int n9 = Integer.MIN_VALUE;
        Graphics graphics2 = null;
        if (bl) {
            graphics.setColor(this.fValid ? color : color3);
            VectorUtils.render3DRect(graphics, 0, 0, dimension.width, dimension.height, false, 0, this.fBorderWidth, 1);
            graphics.setColor(color);
            graphics.fillRect(this.fBorderWidth + 1, this.fBorderWidth + 1, dimension.width - 2 - 2 * this.fBorderWidth, dimension.height - 2 - 2 * this.fBorderWidth);
            graphics2 = graphics.create();
            graphics2.clipRect(this.fBorderWidth + 1, this.fBorderWidth + 1, dimension.width - 2 - 2 * this.fBorderWidth, dimension.height - 2 - 2 * this.fBorderWidth);
            graphics2.setFont(font);
        }
        if (n < (n2 = this.fBorderWidth + 1 - this.fDisplayOffset)) {
            n4 = 0;
        }
        boolean bl5 = false;
        int n10 = this.fBorderWidth + 1 + (dimension.height - 2 - 2 * this.fBorderWidth - n5 - n3) / 2;
        int n11 = 0;
        while (n11 < this.fTextLength + this.fCursorSize) {
            int n12;
            if (n11 == this.fCaretPosition) {
                n7 = n2;
                if (!bl && !bl2 && !bl4) break;
            }
            if (n11 == this.fSelectionAnchor) {
                n8 = n2;
                boolean bl6 = bl5 = !bl5;
            }
            if (n11 == this.fSelectionEnd) {
                n9 = n2;
                boolean bl7 = bl5 = !bl5;
            }
            if (this.fCursorSize > 0 && this.fCaretPosition == this.fTextLength && this.fSelectionAnchor == this.fTextLength) {
                if (n11 == this.fTextLength) {
                    n8 = n2;
                    boolean bl8 = bl5 = !bl5;
                }
                if (n11 == this.fTextLength + this.fCursorSize) {
                    n9 = n2;
                    bl5 = !bl5;
                }
            }
            char c = ' ';
            if (n11 < this.fTextLength) {
                c = this.fText[n11];
            }
            int n13 = n12 = fontMetrics == null ? 0 : fontMetrics.charWidth(c);
            if (bl) {
                if (bl5) {
                    graphics2.setColor(color5);
                    graphics2.fillRect(n2, n10, n12 + 1, n5 + n3);
                    graphics2.setColor(color6);
                } else {
                    graphics2.setColor(color2);
                }
                if (n11 < this.fTextLength) {
                    graphics2.drawChars(this.fText, n11, 1, n2, n10 + n5);
                } else {
                    graphics2.drawChars(new char[]{' '}, 0, 1, n2, n10 + n5);
                }
            }
            if (bl2 && n >= n2) {
                if (n <= n2 + n12 / 2) {
                    n4 = n11;
                } else if (n < n2 + n12) {
                    n4 = n11 + 1;
                }
            }
            n2 += n12;
            ++n11;
        }
        if (n7 == Integer.MIN_VALUE) {
            n7 = n2;
        }
        if (n8 == Integer.MIN_VALUE) {
            n8 = n2;
        }
        if (n9 == Integer.MIN_VALUE) {
            n9 = n2;
        }
        if (n4 < 0) {
            n4 = this.fTextLength;
        }
        if (bl && this.fCaretShown && (this.fCursorSize == 0 || this.fCaretPosition < this.fTextLength && this.fCaretPosition != this.fSelectionAnchor - this.fCursorSize)) {
            graphics2.setColor(color4);
            graphics2.drawLine(n7, n10, n7, n10 + n5 + n3 - 1);
        }
        if (bl3) {
            n4 = n7;
        }
        if (bl4) {
            n4 = n2 + this.fDisplayOffset - this.fBorderWidth - 1;
        }
        return n4;
    }

    private void pasteFromClipboard() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.replaceRange(string, Math.min(this.fSelectionAnchor, this.fSelectionEnd), Math.max(this.fSelectionAnchor, this.fSelectionEnd), false);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {}
        }
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        super.processComponentEvent(componentEvent);
        switch (componentEvent.getID()) {
            case 101: {
                this.flushBuffer();
            }
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        switch (focusEvent.getID()) {
            case 1004: {
                this.fireFocusGained(new TextEditableEvent((TextEditable)this, 3006, focusEvent.isTemporary()));
                this.fHasFocus = true;
                this.fCaretShown = true;
                this.requestPaint();
                break;
            }
            case 1005: {
                this.fireFocusLost(new TextEditableEvent((TextEditable)this, 3006, focusEvent.isTemporary()));
                this.fHasFocus = false;
                this.fCaretShown = false;
                this.requestPaint();
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        switch (keyEvent.getID()) {
            case 400: {
                this.fireKeyTyped(new TextEditableEvent((TextEditable)this, 3002, keyEvent));
                if (keyEvent.isConsumed()) break;
                this.handleKeyTyped(keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
                break;
            }
            case 401: {
                this.fireKeyPressed(new TextEditableEvent((TextEditable)this, 3000, keyEvent));
                if (keyEvent.isConsumed()) break;
                this.handleKeyPressed(keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
                break;
            }
            case 402: {
                this.fireKeyReleased(new TextEditableEvent((TextEditable)this, 3001, keyEvent));
                if (keyEvent.isConsumed()) break;
                this.handleKeyReleased(keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        switch (mouseEvent.getID()) {
            case 501: {
                this.handleMousePressed(mouseEvent.getX(), mouseEvent.getY());
                break;
            }
            case 502: {
                this.handleMouseReleased(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        switch (mouseEvent.getID()) {
            case 506: {
                this.handleMouseDragged(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        this.fTEListeners = new Vector(1, 1);
        this.fCaretBlinkTimer = new Timer();
        this.startBlinking();
        this.fBufferI = null;
        this.fBufferG = null;
    }

    private void releasePaint() {
        if (--this.fPaintCollectionDepth == 0 && this.fPaintRequested) {
            this.repaint();
        }
    }

    public void removeTextEditableListener(TextEditableListener textEditableListener) {
        this.fTEListeners.removeElement(textEditableListener);
    }

    public void replaceRange(String string, int n, int n2) {
        this.replaceRange(string, n, n2, true);
    }

    public void replaceRange(String string, int n, int n2, boolean bl) {
        String string2 = this.getText();
        int n3 = this.fCaretPosition == n ? n2 : this.fCaretPosition;
        this.setText(String.valueOf(string2.substring(0, Math.max(n, 0))) + string + string2.substring(Math.max(Math.min(n2, string2.length()), 0)), n3 >= n2 ? n3 + string.length() + n - n2 : n3, bl);
    }

    private void requestPaint() {
        if (this.fPaintCollectionDepth == 0) {
            this.repaint();
        } else {
            this.fPaintRequested = true;
        }
    }

    private void scrollCaretIntoView() {
        int n = this.paintField(false, null, false, -1, true, false);
        if (n < this.fLeftCaretProximityTrigger) {
            this.scrollTo(this.fDisplayOffset - this.fLeftCaretProximityTrigger + n);
        }
        if (n > this.fRightCaretProximityTrigger) {
            this.scrollTo(this.fDisplayOffset - this.fRightCaretProximityTrigger + n);
        }
    }

    private void scrollTo(int n) {
        Dimension dimension = this.getSize();
        int n2 = this.paintField(false, null, false, -1, false, true);
        this.fDisplayOffset = Math.max(Math.min(n, n2 - dimension.width + 3 + 2 * this.fBorderWidth), 0);
        this.requestPaint();
    }

    public void select(int n, int n2) {
        this.select(n, n2, false);
    }

    private void select(int n, int n2, boolean bl) {
        int n3 = this.fSelectionAnchor;
        int n4 = this.fSelectionEnd;
        int n5 = this.fCaretPosition;
        this.fSelectionAnchor = Math.max(0, Math.min(n, this.fTextLength));
        this.fSelectionEnd = Math.max(0, Math.min(n2, this.fTextLength));
        if (this.fCursorSize > 0 && this.fSelectionAnchor == this.fSelectionEnd - this.fCursorSize) {
            this.fSelectionAnchor = this.fSelectionEnd;
            this.fSelectionEnd = this.fSelectionAnchor - this.fCursorSize;
        }
        if (!bl) {
            this.fCaretPosition = this.fSelectionEnd;
        }
        if (n3 != this.fSelectionAnchor || n4 != this.fSelectionEnd || n5 != this.fCaretPosition) {
            this.scrollCaretIntoView();
            this.requestPaint();
        }
        if (n5 != this.fCaretPosition) {
            this.fireCaretPositionChanged(new TextEditableEvent(this, 3003));
        }
    }

    public void selectAll() {
        this.select(0, Integer.MAX_VALUE);
    }

    public void setCaretPosition(int n) {
        this.setCaretPosition(n, false);
    }

    private void setCaretPosition(int n, boolean bl) {
        n = Math.max(0, Math.min(n, this.fTextLength));
        this.select(bl ? this.fSelectionAnchor : n + this.fCursorSize, n);
    }

    public void setEditable(boolean bl) {
        this.fEditable = bl;
    }

    public void setSelectionEnd(int n) {
        this.select(this.fSelectionAnchor, n);
    }

    public void setSelectionStart(int n) {
        this.select(n, this.fSelectionEnd);
    }

    public void setText(String string) {
        this.setText(string, true);
    }

    private void setText(String string, int n, boolean bl) {
        block4: {
            if (this.getText().equals(string) && n == this.fCaretPosition && this.fSelectionAnchor == this.fSelectionEnd && !bl) break block4;
            try {
                this.collectPaint(true);
                this.fTextLength = string.length();
                this.ensureTextArray(this.fTextLength);
                string.getChars(0, this.fTextLength, this.fText, 0);
                this.setCaretPosition(n);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.releasePaint();
                this.fireTextValueChanged(new TextEditableEvent(this, 3004));
                if (bl) {
                    this.fireTextValueCompleted(new TextEditableEvent(this, 3005));
                }
                throw throwable;
            }
            Object var4_6 = null;
            this.releasePaint();
            this.fireTextValueChanged(new TextEditableEvent(this, 3004));
            if (bl) {
                this.fireTextValueCompleted(new TextEditableEvent(this, 3005));
            }
        }
    }

    public void setText(String string, boolean bl) {
        this.setText(string, this.fCaretPosition, bl);
    }

    public void setValid(boolean bl) {
        this.fValid = bl;
        this.requestPaint();
    }

    private void startBlinking() {
        this.fCaretBlinkTimer.addTimerListener(this);
        this.fCaretBlinkTimer.startTimer(400L, true);
    }

    public void timerExpired(EventObject eventObject) {
        if (eventObject.getSource() == this.fCaretBlinkTimer) {
            boolean bl;
            boolean bl2 = bl = this.fHasFocus && !this.fCaretShown;
            if (this.fCaretShown != bl) {
                this.fCaretShown = bl;
                this.requestPaint();
            }
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

