/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eou.toolkit.info;

import com.ibm.eou.toolkit.filter.TextComponentEditable;
import com.ibm.eou.toolkit.filter.TextEditable;
import com.ibm.eou.toolkit.graphics.FontUtils;
import com.ibm.eou.toolkit.info.InfoTrigger;
import com.ibm.eou.toolkit.widget.SingleLineTextEditable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import java.util.Vector;

class InfoBuiltinPopup
extends Window
implements FocusListener {
    private static Vector sInstances = new Vector(1, 1);
    private InfoTrigger ftrigger = null;
    private transient boolean fFocusRequested = false;
    private transient int fSelectionStart = 0;
    private transient int fSelectionEnd = 0;
    private transient int fCaretPosition = 0;
    private transient Component fComponent = null;
    private transient TextEditable fTextEditable = null;

    public InfoBuiltinPopup(InfoTrigger infoTrigger, Point point) {
        super(InfoBuiltinPopup.getFrame(infoTrigger.getTriggerComponent()));
        sInstances.addElement(this);
        ((Component)this).setFont(new Font("Helvetica", 0, 12));
        this.setForeground(Color.black);
        ((Component)this).setBackground(new Color(255, 255, 223));
        this.showAt(infoTrigger, point);
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.fFocusRequested && this.fTextEditable != null) {
            if (this.fSelectionStart == this.fSelectionEnd) {
                this.fTextEditable.setCaretPosition(this.fCaretPosition);
            } else {
                this.fTextEditable.select(this.fSelectionStart, this.fSelectionEnd);
            }
        }
        this.forgetComponent();
        this.fFocusRequested = false;
    }

    public void focusLost(FocusEvent focusEvent) {
        this.fFocusRequested = true;
        this.fComponent.requestFocus();
    }

    private void forgetComponent() {
        if (this.fComponent != null) {
            this.fComponent.removeFocusListener(this);
            this.fComponent = null;
            this.fTextEditable = null;
        }
    }

    private static Frame getFrame(Component component) {
        Container container = component.getParent();
        if (container == null || container instanceof Frame) {
            return (Frame)container;
        }
        return InfoBuiltinPopup.getFrame(container);
    }

    public static InfoBuiltinPopup getPopupFor(InfoTrigger infoTrigger, boolean bl) {
        Window window;
        Window window2 = null;
        Enumeration enumeration = sInstances.elements();
        while (window2 == null && enumeration.hasMoreElements()) {
            window = (InfoBuiltinPopup)enumeration.nextElement();
            if (window.ftrigger != infoTrigger) continue;
            window2 = window;
        }
        if (window2 == null && bl) {
            window = InfoBuiltinPopup.getFrame(infoTrigger.getTriggerComponent());
            enumeration = sInstances.elements();
            while (window2 == null && enumeration.hasMoreElements()) {
                InfoBuiltinPopup infoBuiltinPopup = (InfoBuiltinPopup)enumeration.nextElement();
                if (infoBuiltinPopup.getParent() != window || infoBuiltinPopup.isVisible()) continue;
                window2 = infoBuiltinPopup;
            }
        }
        return window2;
    }

    public void paint(Graphics graphics) {
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        graphics.setColor(((Component)this).getBackground());
        graphics.fillRect(insets.left + 1, insets.top + 1, dimension.width - insets.left - insets.right - 3, dimension.height - insets.top - insets.bottom - 3);
        graphics.setColor(this.getForeground());
        graphics.drawRect(insets.left, insets.top, dimension.width - insets.left - insets.right - 1, dimension.height - insets.top - insets.bottom - 1);
        FontUtils.renderWrapped(graphics, new Rectangle(insets.left + 4, insets.top + 2, dimension.width - insets.left - insets.right - 8, dimension.height - insets.top - insets.bottom - 4), this.ftrigger.getText(), -1, -2);
        if (!this.fFocusRequested) {
            this.forgetComponent();
        }
    }

    public void showAt(InfoTrigger infoTrigger, Point point) {
        if (this.getPeer() == null) {
            this.addNotify();
        }
        this.ftrigger = infoTrigger;
        try {
            Point point2 = infoTrigger.getTriggerComponent().getLocationOnScreen();
            Dimension dimension = this.getToolkit().getScreenSize();
            FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.getFont());
            this.getSize();
            int n = fontMetrics.stringWidth(infoTrigger.getText());
            Dimension dimension2 = n < dimension.width / 3 ? new Dimension(n, fontMetrics.getHeight() + fontMetrics.getLeading()) : FontUtils.getWrappedSize(infoTrigger.getText(), 2.0, fontMetrics, true);
            Insets insets = this.getInsets();
            dimension2.width += 8 + insets.left + insets.right;
            dimension2.height += 4 + insets.top + insets.bottom;
            point.x += point2.x - 1;
            point.y += point2.y + 18;
            if (point.x + dimension2.width > dimension.width) {
                point.x = dimension.width - dimension2.width;
            }
            if (point.y + dimension2.height > dimension.height) {
                point.y = dimension.height - dimension2.height;
            }
            if (point.x < 0) {
                point.x = 0;
            }
            if (point.y < 0) {
                point.y = 0;
            }
            ((Component)this).setBounds(point.x, point.y, dimension2.width, dimension2.height);
            if (!this.isShowing()) {
                this.forgetComponent();
                this.fComponent = infoTrigger.getTriggerComponent();
                this.fTextEditable = this.fComponent instanceof SingleLineTextEditable ? (TextEditable)((Object)this.fComponent) : (this.fComponent instanceof TextComponent ? (TextEditable)new TextComponentEditable((TextComponent)this.fComponent) : null);
                if (this.fTextEditable != null) {
                    this.fSelectionStart = this.fTextEditable.getSelectionStart();
                    this.fSelectionEnd = this.fTextEditable.getSelectionEnd();
                    this.fCaretPosition = this.fTextEditable.getCaretPosition();
                }
                this.fComponent.addFocusListener(this);
                this.show();
            } else {
                this.repaint();
            }
        }
        catch (IllegalComponentStateException illegalComponentStateException) {}
    }
}

