/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eou.toolkit.filter;

import com.ibm.eou.toolkit.filter.BaseTextFilter;
import com.ibm.eou.toolkit.filter.TextEditable;
import com.ibm.eou.toolkit.filter.TextEditableEvent;
import com.ibm.eou.toolkit.filter.TextFilter;
import com.ibm.eou.toolkit.util.TextUtils;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class NumericTextFilter
extends BaseTextFilter {
    private long fMinimum;
    private long fMaximum;
    private int fMinimumDigits;
    private int fMaximumDigits;
    private int fBase;
    private int fZeroDirection = 0;
    private int fZeroBehavior = 0;
    private int fPadDirection = 0;
    private char fPadChar;
    private boolean fAutoTransferFocus;
    private int fGroupingSize;
    private char fGroupingSeparator;
    private static final int FORMAT = 0;
    private static final int VALIDATE = 1;
    private static final int GET_NO_DIGITS = 2;
    public static final long UNCONSTRAINED_VALUE = Long.MIN_VALUE;
    public static final int UNCONSTRAINED_DIGITS = Integer.MIN_VALUE;
    public static final int NONE = 0;
    public static final int LEADING = 1;
    public static final int TRAILING = 2;
    public static final int STRIP = 3;
    public static final int PAD_ON_VALIDATION = 4;

    public NumericTextFilter() {
        this(Locale.getDefault());
    }

    public NumericTextFilter(char[] cArray, long l, long l2, int n, int n2, int n3, int n4, int n5, int n6, char c, boolean bl, int n7, char c2) {
        this.fMinimum = l;
        this.fMaximum = l2;
        this.fMinimumDigits = n;
        this.fMaximumDigits = n2;
        this.fBase = n3;
        this.fZeroDirection = n4;
        this.fZeroBehavior = n5;
        this.fPadDirection = n6 == 0 ? 1 : n6;
        this.fPadChar = c;
        this.fAutoTransferFocus = bl;
        this.fGroupingSize = n7;
        this.fGroupingSeparator = c2;
        this.setExitCharacters(cArray);
    }

    public NumericTextFilter(DecimalFormat decimalFormat) {
        this(TextFilter.DEFAULT_EXIT_CHARS, Long.MIN_VALUE, Long.MIN_VALUE, ((NumberFormat)decimalFormat).getMinimumIntegerDigits(), ((NumberFormat)decimalFormat).getMaximumIntegerDigits(), 10, 1, 3, 1, decimalFormat.getDecimalFormatSymbols().getZeroDigit(), true, decimalFormat.getGroupingSize(), decimalFormat.getDecimalFormatSymbols().getGroupingSeparator());
    }

    public NumericTextFilter(Locale locale) {
        this((DecimalFormat)NumberFormat.getNumberInstance(locale));
    }

    public boolean allowKeyPressed(TextEditableEvent textEditableEvent) {
        return super.allowKeyPressed(textEditableEvent) && this.handleKey(textEditableEvent);
    }

    public boolean allowKeyTyped(TextEditableEvent textEditableEvent) {
        return super.allowKeyTyped(textEditableEvent) && this.handleKey(textEditableEvent);
    }

    private static String copyright() {
        return "\n\n(c) Copyright IBM Corporation 1999, \n\n";
    }

    private boolean formatText(TextFormatInfo textFormatInfo, int n) {
        String string;
        int n2;
        Object object;
        Object object2;
        int n3 = textFormatInfo.fCaretPosition;
        String string2 = textFormatInfo.fText;
        char c = ((DecimalFormat)NumberFormat.getNumberInstance(this.getLocale())).getDecimalFormatSymbols().getZeroDigit();
        if (n3 > 0 && n3 < string2.length()) {
            object2 = string2.substring(0, n3);
            String string3 = string2.substring(n3);
            String string4 = TextUtils.createFilteredString((String)object2, this.fBase, false, false, null);
            object = TextUtils.createFilteredString(string3, this.fBase, false, false, null);
            n2 = n3 + string4.length() - ((String)object2).length();
            string = String.valueOf(string4) + (String)object;
        } else {
            string = TextUtils.createFilteredString(string2, this.fBase, false, false, null);
            n2 = n3 > 0 ? n3 + string.length() - string2.length() : n3;
        }
        if (n == 1 && (this.fMaximum >= 0L || this.fMinimum >= 0L) && (object2 = (Long)this.getValue()) != null) {
            long l = (Long)object2;
            if (this.fMaximum >= 0L && l > this.fMaximum) {
                string = Long.toString(this.fMaximum, this.fBase);
            } else if (this.fMinimum >= 0L && l < this.fMinimum) {
                string = Long.toString(this.fMinimum, this.fBase);
            }
        }
        if (string.length() > 0) {
            if (this.fZeroBehavior == 3 && this.fZeroDirection == 1) {
                int n4 = TextUtils.indexOfNonZero(string);
                if (n4 != -1) {
                    string = string.substring(n4);
                    n2 = Math.max(0, n2 - n4);
                } else {
                    string = "" + c;
                    n2 = 1;
                }
            } else if (n != 0 && this.fZeroBehavior == 3 && this.fZeroDirection == 2) {
                int n5 = TextUtils.lastIndexOfNonZero(string, string.length());
                if (n5 != -1) {
                    string = string.substring(0, n5 + 1);
                    n2 = string.length();
                } else {
                    string = "";
                    n2 = 0;
                }
            }
            textFormatInfo.fNumberOfDigits = string.length();
        }
        if (this.fMaximumDigits > 0 && string.length() > this.fMaximumDigits) {
            string = string.substring(0, this.fMaximumDigits);
            if (n2 > this.fMaximumDigits) {
                n2 = this.fMaximumDigits;
            }
        }
        if (this.fGroupingSize != 0) {
            int n6 = string.length() % this.fGroupingSize > 0 ? string.length() / this.fGroupingSize : string.length() / this.fGroupingSize - 1;
            int n7 = n6 - (string.length() - n2) / this.fGroupingSize;
            string = TextUtils.createGroupedString(string, this.fGroupingSize, this.fGroupingSeparator, true);
            if (n7 > 0) {
                n2 += n7;
            }
        }
        if (this.fMinimumDigits > 0) {
            char c2;
            boolean bl = n == 1 && this.fZeroBehavior == 4;
            int n8 = bl ? this.fZeroDirection : this.fPadDirection;
            char c3 = c2 = bl ? c : this.fPadChar;
            if (n8 != 0) {
                object = new char[]{this.fGroupingSeparator};
                int n9 = TextUtils.createFilteredString(string, 0, false, false, (char[])object).length();
                if (n8 == 2) {
                    string = TextUtils.createPaddedString(string, this.fMinimumDigits + n9, c2, 't');
                } else {
                    int n10 = string.length();
                    string = TextUtils.createPaddedString(string, this.fMinimumDigits + n9, c2, 'l');
                    if (n8 == 1) {
                        n2 = n2 + string.length() - n10;
                    }
                }
            }
        }
        textFormatInfo.fText = string;
        textFormatInfo.fCaretPosition = n2;
        return true;
    }

    private boolean formatText(boolean bl) {
        TextEditable textEditable = this.getTextEditable();
        String string = textEditable.getText();
        int n = textEditable.getCaretPosition();
        TextFormatInfo textFormatInfo = new TextFormatInfo(this, string, n);
        boolean bl2 = this.formatText(textFormatInfo, bl ? 1 : 0);
        String string2 = textFormatInfo.fText;
        int n2 = textFormatInfo.fCaretPosition;
        if (!string.equals(string2)) {
            textEditable.setText(string2, false);
            if (!bl && n2 >= 0 && n2 <= string2.length() && textEditable.getCaretPosition() == n) {
                textEditable.setCaretPosition(n2);
            }
            this.fireInputFormatted(textEditable.getText(), string);
        }
        if (!bl && this.fAutoTransferFocus && this.fMaximumDigits > 0 && n >= this.fMaximumDigits) {
            textEditable.transferFocus();
        }
        return bl2;
    }

    public boolean getAutoTransferFocus() {
        return this.fAutoTransferFocus;
    }

    public int getBase() {
        return this.fBase;
    }

    public char getGroupingSeparator() {
        return this.fGroupingSeparator;
    }

    public int getGroupingSize() {
        return this.fGroupingSize;
    }

    public long getMaximum() {
        return this.fMaximum;
    }

    public int getMaximumDigits() {
        return this.fMaximumDigits;
    }

    public long getMinimum() {
        return this.fMinimum;
    }

    public int getMinimumDigits() {
        return this.fMinimumDigits;
    }

    private int getNumberOfDigits() {
        TextEditable textEditable = this.getTextEditable();
        String string = textEditable.getText();
        int n = textEditable.getCaretPosition();
        TextFormatInfo textFormatInfo = new TextFormatInfo(this, string, n);
        this.formatText(textFormatInfo, 2);
        return textFormatInfo.fNumberOfDigits;
    }

    public char getPadChar() {
        return this.fPadChar;
    }

    public int getPadDirection() {
        return this.fPadDirection;
    }

    public String getSample() {
        String string = "";
        String string2 = "";
        boolean bl = true;
        int n = 1;
        int n2 = this.fMaximumDigits > 0 ? Math.min(this.fMaximumDigits, 10) : 10;
        while (bl) {
            string2 = String.valueOf(string2) + n++;
            if (n == this.fBase) {
                n = 0;
            }
            boolean bl2 = bl = (this.fMaximum <= 0L || Long.parseLong(string2, this.fBase) < this.fMaximum) && string2.length() <= n2;
            if (!bl) continue;
            string = string2;
        }
        TextFormatInfo textFormatInfo = new TextFormatInfo(this, string, 0);
        this.formatText(textFormatInfo, 1);
        return textFormatInfo.fText;
    }

    public Object getValue() {
        long l = -1L;
        String string = (String)super.getValue();
        if (string != null) {
            String string2 = TextUtils.createFilteredString(string, this.fBase, false, false, null);
            try {
                l = Long.parseLong(string2, this.fBase);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return l < 0L ? null : new Long(l);
    }

    public int getZeroBehavior() {
        return this.fZeroBehavior;
    }

    public int getZeroDirection() {
        return this.fZeroDirection;
    }

    private boolean handleKey(TextEditableEvent textEditableEvent) {
        TextEditable textEditable = this.getTextEditable();
        int n = this.getNumberOfDigits();
        int n2 = textEditable.getCaretPosition();
        String string = textEditable.getText();
        int n3 = string.length();
        int n4 = textEditableEvent.getKeyCode();
        char c = textEditableEvent.getKeyChar();
        boolean bl = true;
        boolean bl2 = bl = Character.isISOControl(c) || Character.digit(c, this.fBase) >= 0;
        if (!bl) {
            textEditableEvent.consume();
        }
        if (textEditable.getSelectionStart() == textEditable.getSelectionEnd()) {
            if (bl && n2 >= textEditable.getText().length() && (n4 == 127 || this.fMaximumDigits != Integer.MIN_VALUE && n >= this.fMaximumDigits && !Character.isISOControl(c))) {
                textEditableEvent.consume();
                bl = false;
            }
            if (bl && (n2 == 0 || n2 > n3) && n4 == 8) {
                textEditableEvent.consume();
                bl = false;
            }
            if (bl && this.fGroupingSize != 0) {
                if (n4 == 127) {
                    if (string.charAt(n2) == this.fGroupingSeparator) {
                        textEditableEvent.consume();
                        textEditable.setCaretPosition(n2 + 1);
                    }
                } else if (n4 == 8 && string.charAt(n2 - 1) == this.fGroupingSeparator) {
                    textEditableEvent.consume();
                    textEditable.setCaretPosition(n2 - 1);
                }
            }
            if (Character.digit(this.fPadChar, this.fBase) < 0) {
                if (n4 == 127 && n2 >= 0 && n2 < n3 && string.charAt(n2) == this.fPadChar) {
                    textEditableEvent.consume();
                    if (n2 < string.length()) {
                        textEditable.setCaretPosition(n2 + 1);
                    }
                } else if (n4 == 8 && n2 - 1 >= 0 && n2 - 1 < n3 && string.charAt(n2 - 1) == this.fPadChar) {
                    textEditableEvent.consume();
                    if (n2 > 0) {
                        textEditable.setCaretPosition(n2 - 1);
                    }
                }
            }
        }
        return bl;
    }

    public void processFocusGained(TextEditableEvent textEditableEvent) {
    }

    public void processFocusLost(TextEditableEvent textEditableEvent) {
    }

    public void processTextValueChanged(TextEditableEvent textEditableEvent) {
        super.processTextValueChanged(textEditableEvent);
        this.formatText(false);
    }

    public boolean processTextValueCompleted(TextEditableEvent textEditableEvent) {
        return this.formatText(true);
    }

    public void setAutoTransferFocus(boolean bl) {
        this.fAutoTransferFocus = bl;
        this.getSupport().firePropertyChange("autoTransferFocus", new Boolean(!this.fAutoTransferFocus), new Boolean(this.fAutoTransferFocus));
    }

    public void setBase(int n) {
        int n2 = this.fBase;
        this.fBase = Math.abs(n);
        this.getSupport().firePropertyChange("base", new Integer(n2), new Integer(this.fBase));
    }

    public void setGroupingSeparator(char c) {
        char c2 = this.fGroupingSeparator;
        this.fGroupingSeparator = c;
        this.getSupport().firePropertyChange("groupingSeparator", new Character(c2), new Character(this.fGroupingSeparator));
    }

    public void setGroupingSize(int n) {
        int n2 = this.fGroupingSize;
        this.fGroupingSize = Math.abs(n);
        this.getSupport().firePropertyChange("groupingSize", new Integer(n2), new Integer(this.fGroupingSize));
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
    }

    public void setMaximum(long l) {
        long l2 = this.fMaximum;
        this.fMaximum = l;
        this.getSupport().firePropertyChange("maximum", new Long(l2), new Long(this.fMaximum));
    }

    public void setMaximumDigits(int n) {
        int n2 = this.fMaximumDigits;
        this.fMaximumDigits = n;
        this.getSupport().firePropertyChange("maximumDigits", new Integer(n2), new Integer(this.fMaximumDigits));
    }

    public void setMinimum(long l) {
        long l2 = this.fMinimum;
        this.fMinimum = l < 0L && l != Long.MIN_VALUE ? Long.MIN_VALUE : l;
        this.getSupport().firePropertyChange("minimum", new Long(l2), new Long(this.fMinimum));
    }

    public void setMinimumDigits(int n) {
        int n2 = this.fMinimumDigits;
        this.fMinimumDigits = n;
        this.getSupport().firePropertyChange("minimumDigits", new Integer(n2), new Integer(this.fMinimumDigits));
    }

    public void setPadChar(char c) {
        char c2 = this.fPadChar;
        this.fPadChar = c;
        this.getSupport().firePropertyChange("padChar", new Character(c2), new Character(this.fPadChar));
    }

    public void setPadDirection(int n) {
        int n2 = this.fPadDirection;
        this.fPadDirection = n == 1 || n == 2 ? n : 1;
        this.getSupport().firePropertyChange("padDirection", new Integer(n2), new Integer(this.fPadDirection));
    }

    public void setValue(Object object) {
        if (object instanceof Number) {
            long l = ((Number)object).longValue();
            object = l >= 0L ? "" + l : "";
        }
        super.setValue(object);
    }

    public void setZeroBehavior(int n) {
        int n2 = this.fZeroBehavior;
        this.fZeroBehavior = n == 0 || n == 3 || n == 4 ? n : 0;
        this.getSupport().firePropertyChange("zeroBehavior", new Integer(n2), new Integer(this.fZeroBehavior));
    }

    public void setZeroDirection(int n) {
        int n2 = this.fZeroDirection;
        this.fZeroDirection = n == 0 || n == 1 || n == 2 ? n : 0;
        this.getSupport().firePropertyChange("zeroStripDirection", new Integer(n2), new Integer(this.fZeroDirection));
    }

    class TextFormatInfo {
        /* synthetic */ NumericTextFilter this$0;
        public String fText;
        public int fCaretPosition;
        public int fNumberOfDigits;

        public TextFormatInfo(NumericTextFilter numericTextFilter, String string, int n) {
            this.this$0 = numericTextFilter;
            this.fText = string;
            this.fCaretPosition = n;
        }
    }
}

