/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eou.toolkit.bean;

import com.ibm.eou.toolkit.filter.TextComponentEditable;
import com.ibm.eou.toolkit.filter.TextFilter;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

public abstract class KeywordOrValuePropertyEditor
extends Panel
implements PropertyEditor {
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Object fValue = null;
    private String[] fKeywords;
    private Object[] fKeyValues;
    private final CheckboxGroup fGroup = new CheckboxGroup();
    private Checkbox[] fCheckboxes;
    Checkbox fValueCB;
    final TextField fTextField = new TextField(8);
    TextFilter fEntryFilter = null;
    public static final int X_MARGIN = 8;
    public static final int Y_MARGIN = 6;

    public KeywordOrValuePropertyEditor(String[] stringArray, Object[] objectArray, String string, TextFilter textFilter) {
        GridBagConstraints gridBagConstraints;
        this.fKeywords = stringArray;
        this.fKeyValues = objectArray;
        this.fEntryFilter = textFilter;
        textFilter.setTextEditable(new TextComponentEditable(this.fTextField));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.fCheckboxes = new Checkbox[stringArray.length];
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(bl ? 6 : 0, 8, 0, 8);
            gridBagConstraints.anchor = 16;
            this.fCheckboxes[n] = new Checkbox(stringArray[n], this.fGroup, false);
            gridBagLayout.setConstraints(this.fCheckboxes[n], gridBagConstraints);
            this.add(this.fCheckboxes[n]);
            Object object = objectArray[n];
            this.fCheckboxes[n].addItemListener(new ItemListener(this, object){
                /* synthetic */ KeywordOrValuePropertyEditor this$0;
                /* synthetic */ Object val$thisKeyValue;

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (((Checkbox)itemEvent.getItemSelectable()).getState()) {
                        this.this$0.fTextField.setEditable(false);
                        this.this$0.setValue(this.val$thisKeyValue);
                    }
                }
                {
                    this.this$0 = keywordOrValuePropertyEditor;
                    this.val$thisKeyValue = object;
                }
            });
            bl = false;
            ++n;
        }
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = stringArray.length;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = new Insets(0, 8, 0, 8);
        this.fValueCB = new Checkbox(string, this.fGroup, false);
        gridBagLayout.setConstraints(this.fValueCB, gridBagConstraints2);
        this.add(this.fValueCB);
        this.fValueCB.addItemListener(new ItemListener(this){
            /* synthetic */ KeywordOrValuePropertyEditor this$0;

            public void itemStateChanged(ItemEvent itemEvent) {
                if (this.this$0.fValueCB.getState()) {
                    this.this$0.fTextField.setEditable(true);
                    this.this$0.fTextField.requestFocus();
                    this.this$0.setValue(this.this$0.fEntryFilter.getValue());
                }
            }
            {
                this.this$0 = keywordOrValuePropertyEditor;
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1 + stringArray.length;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 24, 6, 8);
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(this.fTextField, gridBagConstraints);
        this.add(this.fTextField);
        this.fTextField.setEditable(false);
        this.fTextField.addTextListener(new TextListener(this){
            /* synthetic */ KeywordOrValuePropertyEditor this$0;

            public void textValueChanged(TextEvent textEvent) {
                this.this$0.setValue(this.this$0.fEntryFilter.getValue());
            }
            {
                this.this$0 = keywordOrValuePropertyEditor;
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    private static String copyright() {
        return "\n\n(c) Copyright IBM Corporation 1999 (1997).\n\n";
    }

    private static Component findParentComponentWithTitle(Component component) {
        Component component2 = component;
        if (component != null && !(component instanceof Frame) && !(component instanceof Dialog)) {
            component2 = KeywordOrValuePropertyEditor.findParentComponentWithTitle(component.getParent());
        }
        return component2;
    }

    public String getAsText() {
        if (this.fValue == null) {
            return "";
        }
        int n = this.indexForValue(this.fValue);
        return n == -1 ? "" + this.fValue : this.fKeywords[n];
    }

    public Component getCustomEditor() {
        return this;
    }

    public String getJavaInitializationString() {
        return "" + this.fValue;
    }

    public String[] getTags() {
        return null;
    }

    public Object getValue() {
        return this.fValue;
    }

    private int indexForKeyword(String string) {
        int n = 0;
        while (n < this.fKeywords.length) {
            if (string.equals(this.fKeywords[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int indexForValue(Object object) {
        int n = 0;
        while (n < this.fKeywords.length) {
            if (object.equals(this.fKeyValues[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(this.getAsText(), rectangle.x, rectangle.y + (rectangle.height + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void setAsText(String string) {
        int n = this.indexForKeyword(string);
        if (n == -1) {
            this.fValueCB.setState(true);
            this.fEntryFilter.setValue(string);
        } else {
            this.setValue(this.fKeyValues[n]);
        }
    }

    public void setValue(Object object) {
        if (object != null && !object.equals(this.fValue)) {
            Object object2 = this.fValue;
            this.fValue = object;
            int n = this.indexForValue(this.fValue);
            if (n == -1) {
                this.fValueCB.setState(true);
                this.fEntryFilter.setValue(this.fValue);
            } else {
                this.fCheckboxes[n].setState(true);
            }
            this.support.firePropertyChange("value", object2, this.fValue);
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }
}

