#ifndef MMAKER_H
#define MMAKER_H

#include <fstream.h>
#include <v/vutil.h>        //vGetLocalTime
#include <v/vos.h>		// V OS Dependent Utils
#include <v/vslist.h>

class videCmdWindow;

  class makefileMaker
  {
    public:   //----------------------------------------------public

     makefileMaker();
     ~makefileMaker();

     static const int fieldLen; // standard string buffs length

     void setDefaults();
     void eraseAll();

     BOOL addFile     (char *n);
     void saveMakefile();
     void saveProject (char *n);
     void loadProject (char *n);
     BOOL getSectionEntry(ifstream &prjf, const char* head, char* value);
     BOOL getSectionList(ifstream &prjf, const char* head, const char* term, vSList& sl);

     char *makeName;
     char *homeV;
     char *exeName;
     char *ObjDir;
     char *BinDir;
     char *SrcDir;
     char *cFlags;
     char *Libs;
     char *cc;

     // lists we need
     vSList projOpts;
     vSList incDirs;
     vSList libDirs;
     vSList objFiles;
     vSList defsPool;
     vSList curDefs;
     vSList curOpts;
     vSList rules;
     vSList userTargets;

     protected: //----------------------------------------------protected

     private:   //----------------------------------------------private

     char* stripDir(char* n);
     videCmdWindow* cmdw;
     char* srcN2ObjN(char *);
     void findRule(char *);

  };

#endif
