//===============================================================
// vpen.cxx: vPen class for drawing - Windows
//
// Copyright (C) 1995,1996,1997,1998  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================
#include <v/vos2.h>		// for OS/2 stuff
#include <v/vapp.h>
#include <v/vpen.h>
//=======================>>> vPen::vPen <<<===========================
  vPen::vPen(unsigned int r, unsigned int g, unsigned int b,
	      int width, int style)
  {
      penColor._r = r, penColor._g = g; penColor._b = b;
      penColor._pixel = SETRGB(r,g,b);
      penWidth = width;
      penStyle = style;
  }
//=======================>>> vPen::~vPen <<<===========================
  vPen::~vPen()
  {
  }
//=====================>>> vPen::vPen <<<===========================
  vPen::vPen(const vPen& p)
  {
    penColor = p.penColor;
    penWidth = p.penWidth;
    penStyle = p.penStyle;
  }
//=====================>>> vPen::operator= <<<===========================
  vPen & vPen::operator =(const vPen& p)
  {
    if (this == &p)  // assigning to self
    {
      return *this;
    }
    // now just like a copy constructor
    penColor = p.penColor;
    penWidth = p.penWidth;
    penStyle = p.penStyle;
    return *this;               // allow r to l multiple assignment
  }
//=====================>>> vPen::SetStyle <<<===========================
  void vPen::SetStyle(int style)
  {
    if (style == penStyle)
      return;     // no change
    penStyle = style;
  }
//=====================>>> vPen::SetWidth <<<===========================
  void vPen::SetWidth(int width)
  {
    if (width == penWidth)
      return;    // no change
    penWidth = width;
  }

//=====================>>> vPen::SetColor <<<===========================
  void vPen::SetColor(const vColor& c)
  {
    if (c == penColor)
      return;         // no change
    penColor = c;
  }

//=====================>>> vPen::SetColor <<<===========================
  void vPen::SetColor(unsigned int r, unsigned int g, unsigned int b)
  {
    if (penColor.r() == r && penColor.g() == g && penColor.b() == b)
      return;        // no change
    penColor.Set(r,g,b);
  }

//=====================>>> vPen::GetHPEN <<<===========================
// returns pointer to LINEBUNDLE set with vPen attributes
  PLINEBUNDLE vPen::GetHPEN() VCONST
  {
    // we set both the width and geometric width, but only
    // the geometric width will be used by the primitives
    // and only if linetype is vSolid.
    if (penWidth == 0)  // zero width pen is illegal
      penWidth = 1;

    _lbPen.fxWidth = MAKEFIXED(penWidth, 0);
    _lbPen.lGeomWidth = penWidth;
    _lbPen.lColor = penColor._pixel;
    _lbPen.usMixMode = FM_OVERPAINT;

    switch (penStyle)
    {
      case vSolid:
      	_lbPen.usType = LINETYPE_SOLID;
      	break;
      case vTransparent:
      	_lbPen.usType = LINETYPE_INVISIBLE;
      	break;
      case vDash:
      	_lbPen.usType = LINETYPE_SHORTDASH;
      	break;
      case vDot:
        _lbPen.usType = LINETYPE_DOT;
      	break;
      case vDashDot:
        _lbPen.usType = LINETYPE_DASHDOT;
      	break;
      default:
        _lbPen.usType = LINETYPE_SOLID;
      	break;
    }
    return &_lbPen;			// return a pointer to the linebundle
  }
