//===============================================================
// vfilesel.cpp - vFileSelect class functions - Windows
//
// Copyright (C) 1995,1996,1997,1998  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================
#include <v/vos2.h>		// for OS/2 stuff
#include <v/vfilesel.h>		// our header
#include <v/vapp.h>
#include <v/vbasewin.h>

//===================>>> vFileSelect::vFileSelect <<<=======================
  vFileSelect::vFileSelect(vBaseWindow* bw, VCONST char* title) // constructor
  {
    SysDebug1(Constructor,"vFileSelect::vFileSelect() constructor (%s)\n", title)
    _parentHWND = bw->winHwnd();	// track parent's HWND
    init();
  }
//===================>>> vFileSelect::vFileSelect <<<=======================
  vFileSelect::vFileSelect(vApp* aw, VCONST char* title)
  {
    SysDebug1(Constructor,"vFileSelect::vFileSelect() constructor (%s)\n", title)
    _parentHWND = aw->winHwnd();	// track parent's HWND
    init();
  }
//===================>>> vFileSelect::vFileSelect <<<=======================
  vFileSelect::~vFileSelect(void)
  {
    SysDebug(Destructor,"vFileSelect::~vFileSelect() destructor \n")
  }
//===================>>> vFileSelect::init <<<=======================
  void vFileSelect::init()
  {
    memset(&_fldlg,0,sizeof(FILEDLG));	// zap entire thing
    _fldlg.cbSize = sizeof(FILEDLG);
  }
//======================>>> vFileSelect::FileSelect <<<=======================
  int vFileSelect::FileSelect(const char* prompt, char* filename,
	const int maxlen, char** filter, int& filterIndex)
  {
    //	Show the file selection (open) dialog.
    //	returns 0 on cancel, 1 otherwise
    char *title = NULL;	//AK200398

    memset(&_fldlg,0,sizeof(FILEDLG));	// zap entire thing
    _fldlg.cbSize = sizeof(FILEDLG);

    char fmask[CCHMAXPATH];
    fmask[0] = '\0';

    buildFilter(fmask,filter,filterIndex);	// build a proper filter string
    strncpy(_fldlg.szFullFile, fmask, CCHMAXPATH-1);
    _fldlg.fl = FDS_CENTER | FDS_OPEN_DIALOG;
    if(prompt && *prompt != '\0')  //AK200398
    {
      title = new char [strlen(prompt)+1];
      strcpy(title, prompt);
      _fldlg.pszTitle = title;
    }

    int rc = WinFileDlg (HWND_DESKTOP, _parentHWND, &_fldlg);
    if ( rc && _fldlg.lReturn == DID_OK)
    {
      strncpy(filename, (char*)_fldlg.szFullFile, maxlen);
      filterIndex = 0;           // filter index not supported in OS/2
      if(title)  //AK200398
      {
	delete [] title;
      }
      return 1;
    }
    else
    {
      if(title)   //AK200398
      {
        delete [] title;
      }
      return 0;   // user punted during selection
    }
  }

//======================>>> vFileSelect::FileSelectSave <<<=======================
  int vFileSelect::FileSelectSave(const char* prompt, char* filename,
	const int maxlen, char** filter, int& filterIndex, const int findDir)
  {
    //	Show the file selection (save as) dialog.
    //	returns 0 on cancel, 1 otherwise

    char *title = NULL;	//AK200398

//    memset(&_fldlg,0,sizeof(FILEDLG));	// zap entire thing
    _fldlg.cbSize = sizeof(FILEDLG);

//    char fmask[CCHMAXPATH];
//    fmask[0] = 0;
//    buildFilter(fmask,filter,filterIndex);	// build a proper filter string
//    strcpy(_fldlg.szFullFile, fmask);

    strncpy(_fldlg.szFullFile, filename, CCHMAXPATH-1);

    _fldlg.fl = FDS_CENTER | FDS_SAVEAS_DIALOG | FDS_ENABLEFILELB;

    if(prompt && *prompt != '\0')   //AK200398
    {
      title = new char [strlen(prompt)+1];
      strcpy(title, prompt);
      _fldlg.pszTitle = title;
    }

    int rc = WinFileDlg (HWND_DESKTOP, _parentHWND, &_fldlg);
    if ( rc && _fldlg.lReturn == DID_OK)
    {
      strncpy(filename, (char*)_fldlg.szFullFile, maxlen);
      if (findDir)  // strip off file name
      {
	int len = strlen(filename);
	for (int ix = len-1 ; ix > 0 ; --ix)
	{
	  if (filename[ix] == '\\')
	  {
	    filename[ix] = 0;	// change last \\ to 0
	    break;
	  }
	}
      }
      filterIndex = 0;           // filter index not supported in OS/2

      if(title)  //AK200398
      {
	delete [] title;
      }
      return 1;
    }
    else
    {
      filename[0] = 0;    // user punted during selection
      if(title)  //AK200398
      {
        delete [] title;
      }
      return 0;
    }
  }

//======================>>> vFileSelect::buildFilter <<<=======================
// OS/2 does not support a conventional filter list like the V model
// wants.  Filtering is done primarily on extended attributes of the
// file, rather than file name or extension.  OS/2 does support
// a single filename filter (eg. "*.c;*.cpp") so we can at least
// use the first entry in the filter list array.

void vFileSelect::buildFilter(char* fbuff, char** filter, int& fi)
{
  if (!filter || *filter[0] == 0)	//AK
  {
    strcpy(fbuff,"");           // default is all files
    fi = 0;
  }
  else			        // copy the first line of filter over
  {
    strncpy(fbuff, filter[0], CCHMAXPATH-1);
    fi = 0;
  }
}


