//===============================================================
// vos2.h - Special defs for OS/2 PM version
//
// Copyright (C) 1995,1996  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY.  See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================

#ifndef VOS2_H
#define VOS2_H

// EMX (when OS2EMX_PLAIN_CHAR is defined ) causes BYTE to be char which is a
// big problem for color stuff which use BYTE types alot.  We define our own
// VBYTE type here to avoid this
typedef unsigned char VBYTE;
typedef VBYTE *PVBYTE;

//  RGB color macro
#define SETRGB(r,g,b) ( (ULONG)(  ((VBYTE)(b)) | (((VBYTE)(g))<<8) | ( ((VBYTE)(r))<<16) ))
#define SETRGB2(o,r,g,b) ((ULONG)( ((VBYTE)(b)) | (((VBYTE)(g))<<8) | (((VBYTE)(r))<<16) | (((VBYTE)(o))<<24) ))

// type FIXED Gpi macros
#define DBLTOFX(x) ((FIXED) ((x)*65536))

#define IDI_APPLICATION     32512
#define IDI_HAND            32513
#define IDI_QUESTION        32514
#define IDI_EXCLAMATION     32515
#define IDI_ASTERISK        32516

// some weird stuff missing in EMX, Borland C++, and WATCOM
#if defined (__EMX__)
#define NERR_BASE       2100
#define NERR_BufTooSmall        (NERR_BASE+23)  /* The API return buffer is too small. */
#endif

#if defined (__BORLANDC__)
// this typedef was causing trouble for the vide app because of lowercase
typedef unsigned long bool;
typedef bool *pbool;
#endif

#if defined (__BORLANDC__) || defined (__EMX__) || defined (__WATCOMC__)
#define  NEED_SPBCDATA
#endif

#ifdef NEED_SPBCDATA
// Borland, Watcom, and EMX do not include the spin button control data
// structure.

   /**********************************************************************/
   /* Spin Button control data structure                                  */
   /**********************************************************************/
   typedef struct _SPBCDATA     /* spbcd */
   {
      unsigned int   cbSize;                /* Size of control block             */
      unsigned int   ulTextLimit;           /* Entryfield text limit             */
      int            lLowerLimit;           /* Spin lower limit (numeric only)   */
      int            lUpperLimit;           /* Spin upper limit (numeric only)   */
      unsigned int   idMasterSpb;           /* ID of the servant's master spb    */
      void *         pHWXCtlData;           /* reserved for Pen CtlData (penpm.h)*/
   } SPBCDATA;
   typedef SPBCDATA *PSPBCDATA;
#endif

#ifndef false
#define false   0
#endif
#ifndef true
#define true    1
#endif

#endif

