# EXAMPLE makefile for V IDE application...
#
# creates .exe's under $(BINDIR)
# assumes that vibmcpp or vibmcppd (debug library) already built
# using v.mak or vopengl.mak 
#
# to create debug versions enter: nmake DEBUG=1 /f vide.mak
# to create release versions enter: nmake /f vide.mak

include cfgibm.mkh

# ---------------------------------------------------------------------------
SRCDIR=$(VDIR)\vide
INCDIR=$(VDIR)\vide
BINFILE=$(BINDIR)\vide.exe
RESFILE=$(OBJDIR)\vos2.res
DEFFILE=$(VSRCDIR)\vos2.def

CFLAGS=$(CFLAGS) /DVIDE -I$(VDIR)\texted


OBJFILES= $(OBJDIR)\vstartup.obj \
 $(SRCDIR)\vedcnv.obj \
 $(OBJDIR)\vseeci.obj \
 $(OBJDIR)\videmake.obj \
 $(OBJDIR)\videapp.obj \
 $(OBJDIR)\vrundlg.obj 

OBJFILES2= $(OBJDIR)\videcmdw.obj \
 $(OBJDIR)\mmakerbc.obj \
 $(OBJDIR)\projdlg.obj 



# ---------------------------------------------------------------------------
.PRECIOUS: $(BINFILE)

.cpp.obj :
 $(CC) $(CFLAGS) /I$(VDIR)\texted /C /Fo$@ $<

{$(SRCDIR)}.cpp{$(OBJDIR)}.obj :
 $(CC) $(CFLAGS) /I$(INCDIR) /C /Fo$@ $<

{$(VDIR)\texted}.cpp{$(SRCDIR)}.obj :
 $(CC) $(CFLAGS) /I$(INCDIR) /C /Fo$@ $<

{$(VDIR)\texted}.cpp{$(OBJDIR)}.obj :
 $(CC) $(CFLAGS) /I$(INCDIR) /C /Fo$@ $<

all : $(BINFILE)

dirs:
	@-mkdir $(OBJDIR)
	@-mkdir $(BINDIR)

clean :
	-del $(OBJDIR)\*.*
	-del $(BINDIR)\*.*

$(BINFILE) : $(OBJFILES) $(OBJFILES2) $(RESFILE) $(VLIB)
	-$(CC) /Q /B"$(LFLAGS)" @<<
 /Fe$@
 $(OBJFILES) 
 $(OBJFILES2)
 $(LIBS)
 $(DEFFILE)
<<NOKEEP
     $(RC) $(RFLAGS) $(RESFILE) $@

# ---------------------------------------------------------------------------

# Minimum RESOURCE
$(OBJDIR)\vos2.res :: $(VSRCDIR)\vos2.rc \
        $(VSRCDIR)\vapp.ico \
        $(VSRCDIR)\collate.bmp
	@copy $(VSRCDIR)\vapp.ico .
	@copy $(VSRCDIR)\collate.bmp .
    $(RC) -r $(RFLAGS) $(VSRCDIR)\vos2.rc $@ 
	@-attrib -r .\vapp.ico
	@-attrib -r .\collate.bmp
	-del .\vapp.ico
	-del .\collate.bmp

# APP
$(OBJDIR)\vstartup.obj : $(VSRCDIR)\$$(@B).cpp 

$(OBJDIR)\videapp.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h \
 $(VINCDIR)\v_defs.h $(VINCDIR)\vapp.h 

# Vedcnv needs to be in $(SRCDIR) because of conflicts with standard vedcnv.o
$(SRCDIR)\vedcnv.obj : $(VDIR)\texted\vedcnv.cpp $(VDIR)\texted\vedcnv.h \
 $(VINCDIR)\v_defs.h $(INCDIR)\videcmdw.h 

$(OBJDIR)\vseeci.obj : $(VDIR)\texted\vseeci.cpp $(VDIR)\texted\vseeci.h \
 $(VINCDIR)\v_defs.h 

$(OBJDIR)\videmake.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h \
 $(VINCDIR)\v_defs.h 

$(OBJDIR)\vrundlg.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h \
 $(VINCDIR)\v_defs.h 

$(OBJDIR)\videcmdw.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h \
 $(VINCDIR)\v_defs.h 

$(OBJDIR)\mmakerbc.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\mmaker.h \
 $(INCDIR)\videapp.h  $(INCDIR)\projdlg.h 

$(OBJDIR)\projdlg.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h \
 $(INCDIR)\mmaker.h 
