# EXAMPLE makefile for V Application Generator Demo application...
#
# creates .exe's under $(BINDIR)
# assumes that vibmcpp or vibmcppd (debug library) already built
# using v.mak or vopengl.mak 
#
# to create debug versions enter: nmake /f DEBUG=1 appgen.mak
# to create release versions enter: nmake /f appgen.mak
#

include cfgibm.mkh

# ---------------------------------------------------------------------------
SRCDIR=$(VDIR)\appgen
INCDIR=$(VDIR)\appgen
BINFILE=$(BINDIR)\vgen.exe
RESFILE=$(OBJDIR)\vapp.res
DEFFILE=$(VSRCDIR)\vos2.def

OBJFILES= $(OBJDIR)\vstartup.obj \
 $(OBJDIR)\vgapp.obj \
 $(OBJDIR)\vgcmdw.obj \
 $(OBJDIR)\vgcode.obj \
 $(OBJDIR)\vgmdlg.obj \
 $(OBJDIR)\vgdlmdlg.obj \
 $(OBJDIR)\vgcnv.obj


# ---------------------------------------------------------------------------
.PRECIOUS: $(BINFILE)

.cpp.obj :
 $(CC) $(CFLAGS) /C /Fo$@ $<

{$(SRCDIR)}.cpp{$(OBJDIR)}.obj :
 $(CC) $(CFLAGS) /I$(INCDIR) /C /Fo$@ $<

all : $(BINFILE)

dirs:
	@-mkdir $(OBJDIR)
	@-mkdir $(BINDIR)

clean :
	-del $(OBJDIR)\*.*
	-del $(BINDIR)\*.*

$(BINFILE) : $(OBJFILES) $(RESFILE) $(VLIB)
	-$(LD) $(LFLAGS) @<<
 $(OBJFILES),
 $@,
 NUL,
 $(LIBS),
 $(DEFFILE)
<<NOKEEP
    $(RC) $(RFLAGS) $(RESFILE) $@

# ---------------------------------------------------------------------------

# Minimum RESOURCE
$(OBJDIR)\vapp.res :: $(VSRCDIR)\vos2.rc \
        $(VSRCDIR)\vapp.ico \
        $(VSRCDIR)\collate.bmp
	@copy $(VSRCDIR)\vapp.ico .
	@copy $(VSRCDIR)\collate.bmp .
    $(RC) -r $(RFLAGS) $(VSRCDIR)\vos2.rc $@ 
	@-attrib -r .\vapp.ico
	@-attrib -r .\collate.bmp
	-del .\vapp.ico
	-del .\collate.bmp

# APP
$(OBJDIR)\vstartup.obj : $(VSRCDIR)\$$(@B).cpp 

$(OBJDIR)\vgcnv.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h \
 $(VINCDIR)\v_defs.h $(INCDIR)\vgdefs.h 

$(OBJDIR)\vgcode.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h \
 $(VINCDIR)\v_defs.h $(INCDIR)\vgdefs.h 

$(OBJDIR)\vgmdlg.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h \
 $(VINCDIR)\v_defs.h $(INCDIR)\vgdefs.h 

$(OBJDIR)\vgdlmdlg.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h \
 $(VINCDIR)\v_defs.h $(INCDIR)\vgdefs.h 

$(OBJDIR)\vgcmdw.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h \
 $(VINCDIR)\v_defs.h $(INCDIR)\vgdefs.h 

$(OBJDIR)\vgapp.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h \
 $(VINCDIR)\v_defs.h $(INCDIR)\vgdefs.h $(INCDIR)\vgcmdw.h 
