/*******************************************************************************
  Module : Graph.h
  Contents : Class declarations for classes that display a graph window.
  grphWin is the window itself, GraphPane is the drawing surface.
*******************************************************************************/

#ifndef GRAPH_H
#define GRAPH_H
#include <v/vcanvas.h>

/*******************************************************************************
  Class : GraphPane
  Purpose : Encapsulates the drawing surface of a graph window.
*******************************************************************************/

class GraphPane : public vCanvasPane
{
  //Variables used in computing screen positions of graph elements
      int LeftMargin; //The margins of the graphing box
  int TopMargin;
  int FontHeight;
  int FontWidth;
  int BottomMargin;
  int RightMargin;
  int Height; //The actually size of the graphing window
  int Width;
  double Xextent;  //The maxium domain and range of the graph
  double Yextent;
  double Xint; //How far each x and y step are apart (in pixels)
  double Yint;
  double Mark; //Where the intensity mark is placed
  
  int data1; //The data being plotted
  int data2;
  
  void PlotLine(int); //Function that actually draws the screen
			  
public :
    GraphPane(void);
  
  void Redraw(int,int,int,int); //Called whenever the screen needs updating
  void Resize(int,int); //Handels resizing events
  void SetDataSet(int,int); //Sets which data sets are displayed
  void VScroll(int); //Hscroll controls zoom, Vxxx functions handle
  void HScroll(int); //intensity mark
  void VPage(int,int);
};

class GraphMuPane : public vCanvasPane
{
  //Variables used in computing screen positions of graph elements
      int LeftMargin; //The margins of the graphing box
  int TopMargin;
  int FontHeight;
  int FontWidth;
  int BottomMargin;
  int RightMargin;
  int Height; //The actually size of the graphing window
  int Width;
  double Xextent;  //The maxium domain and range of the graph
  double Yextent;
  double Xint; //How far each x and y step are apart (in pixels)
  double Yint;
  double Mark; //Where the intensity mark is placed
  
  int data1; //The data being plotted
  int data2;
  
  void PlotLine(int); //Function that actually draws the screen
			  
public :
    GraphMuPane(void);
  
  void Redraw(int,int,int,int); //Called whenever the screen needs updating
  void Resize(int,int); //Handels resizing events
  void SetDataSet(int,int); //Sets which data sets are displayed
  void VScroll(int); //Hscroll controls zoom, Vxxx functions handle
  void HScroll(int); //intensity mark
  void VPage(int,int);
};

/*******************************************************************************
  Class: grphWin
  Purpose : grphWin is the window type that holds a graph pane, and handles
  any command orginating in the graph window
*******************************************************************************/

class grphWin : public vCmdWindow
{
  GraphPane* gp; //Pointer to instance of graphing pane (drawing surface)
  vMenuPane* mp; //The menu
  public :
    grphWin(void); //Constructor
  ~grphWin(void); //Destructor
  //Sets which data sets are displayed		      
  void SetDataSet(int,int);
  virtual void CloseWin(void); //Notify robust that the window is closed
};

class grphMuWin : public vCmdWindow
{
  GraphMuPane* gp; //Pointer to instance of graphing pane (drawing surface)
  vMenuPane* mp; //The menu
  public :
    grphMuWin(void); //Constructor
  ~grphMuWin(void); //Destructor
  //Sets which data sets are displayed		      
  void SetDataSet(int,int);
  virtual void CloseWin(void); //Notify robust that the window is closed
};
#endif
