/*NOSHIP*/
/*******************************************************************************
* FILE NAME: ilistbx3.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in both ilistbas.hpp and icombobs.hpp.                                     *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1995       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifdef IC_USE_CB
  #define IC_CLASSNAME IBaseComboBox
#else
  #define IC_CLASSNAME IBaseListBox
#endif

/*------------------------------------------------------------------------------
| IC_CLASSNAME::isHorizontalScroll                                             |
------------------------------------------------------------------------------*/
Boolean IC_CLASSNAME::isHorizontalScroll() const
{
  return( (style() & horizontalScroll.asUnsignedLong()) ? true : false );
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::itemText                                                       |
|                                                                              |
| Get the text of an item.                                                     |
------------------------------------------------------------------------------*/
IString IC_CLASSNAME::itemText ( unsigned long lIndex ) const
{

   IEventResult evt = handle().sendEvent(LM_QUERYITEMTEXTLENGTH,
                                         IEventParameter1(lIndex),
                                         IEventParameter2(0));
   if (evt.asLong() == LIT_ERROR)
      ITHROWLIBRARYERROR1(IC_INVALID_INDEX,
                          IErrorInfo::invalidParameter,
                          IException::recoverable,
                          IString(lIndex));
   unsigned long ulBufSize = evt.asUnsignedLong();
   IString returnString(0, ulBufSize);
   handle().sendEvent(LM_QUERYITEMTEXT,
                      IEventParameter1((unsigned short)lIndex,
                                       (unsigned short)(ulBufSize+1)),
                      IEventParameter2((char*)returnString));
   return returnString;
}


/*------------------------------------------------------------------------------
| IC_CLASSNAME::setItemText                                                    |
|                                                                              |
| Change the text of an item currently in the list.                            |
------------------------------------------------------------------------------*/
IC_CLASSNAME& IC_CLASSNAME::setItemText ( unsigned long lIndex,
                                          const char* pszString
#ifdef IC_USE_CB
                                        , Boolean updateEntryField )
#else
                                         )
#endif
{
#ifndef IC_WIN
   IEventResult evt = handle().sendEvent(LM_SETITEMTEXT,
                              IEventParameter1(lIndex),
                              IEventParameter2((unsigned long)pszString));
   if (!(evt.asUnsignedLong()))
      ITHROWGUIERROR("LM_SETITEMTEXT");

#ifdef IC_USE_CB
   // For comboboxes, if the item being changed is the selected item,
   // then update the entry field string as well with the new text
   if (( updateEntryField ) && ( isSelected(lIndex) ))
     setText( pszString );
#endif

#else
   IEventResult itd = handle().sendEvent(LB_GETITEMDATA,
                              IEventParameter1(lIndex),
                              IEventParameter2(0));
   if (itd.asUnsignedLong() == LIT_ERROR)
      ITHROWSYSTEMERROR(LIT_ERROR, "setItemText", IErrorInfo::accessError,
                        IException::recoverable);
   IEventResult evt = handle().sendEvent(LB_DELETESTRING,
                              IEventParameter1(lIndex),
                              IEventParameter2(0));
   if (evt.asUnsignedLong() == LIT_ERROR)
      ITHROWSYSTEMERROR(LIT_ERROR, "setItemText", IErrorInfo::accessError,
                        IException::recoverable);
   evt = handle().sendEvent( LB_INSERTSTRING,
                             IEventParameter1(lIndex),
                             IEventParameter2((unsigned long)pszString));
   if ( (evt.asUnsignedLong() == LIT_ERROR) ||
        (evt.asUnsignedLong() == LIT_MEMERROR) )
      ITHROWSYSTEMERROR(evt.asUnsignedLong(), "setItemText",
                        IErrorInfo::accessError,
                        IException::recoverable);
   evt = handle().sendEvent( LB_SETITEMDATA,
                             IEventParameter1(lIndex),
                             IEventParameter2(itd));
   if (evt.asUnsignedLong() == LIT_ERROR)
      ITHROWSYSTEMERROR(LIT_ERROR, "setItemText", IErrorInfo::accessError,
                        IException::recoverable);
#endif
   return *this;
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::setItemText                                                    |
|                                                                              |
| Change the text of an item currently in the list.                            |
------------------------------------------------------------------------------*/
IC_CLASSNAME& IC_CLASSNAME::setItemText ( unsigned long lIndex,
                                          const IResourceId& resid
#ifdef IC_USE_CB
                                        , Boolean updateEntryField )
#else
                                         )
#endif
{
  IString newText = resid.resourceLibrary().loadString(resid);

#ifdef IC_USE_CB
  return setItemText( lIndex, (char *)newText, updateEntryField );
#else
  return setItemText( lIndex, (char *)newText );
#endif
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::select                                                         |
|                                                                              |
| Set an item as selected in the list.                                         |
------------------------------------------------------------------------------*/
IC_CLASSNAME& IC_CLASSNAME::select ( unsigned long index, Boolean select )
{
   IEventResult evt = handle().sendEvent(LM_SELECTITEM,
                                         IEventParameter1(index),
                                         IEventParameter2(select));
   if (!(evt.asUnsignedLong()))
      ITHROWGUIERROR("LM_SELECTITEM");
   return *this;
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::deselect                                                       |
------------------------------------------------------------------------------*/
IC_CLASSNAME& IC_CLASSNAME::deselect ( unsigned long index )
{
   select(index, false);
   return *this;
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::isSelected                                                     |
|                                                                              |
| Query whether given item is selected.                                        |
------------------------------------------------------------------------------*/
Boolean IC_CLASSNAME::isSelected ( unsigned long index ) const
{
   IEventResult evt = handle().sendEvent(LM_QUERYSELECTION,
                              IEventParameter1(index - 1),
                              IEventParameter2(0));
   if ((evt.asLong() != LIT_NONE)  &&  (evt.asUnsignedLong() == index))
      return true;
   else
      return false;
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::deselectAll                                                    |
|                                                                              |
| Set all items as unselected.                                                 |
------------------------------------------------------------------------------*/
IC_CLASSNAME& IC_CLASSNAME::deselectAll ( )
{
#ifndef IC_USE_CB
   // Workaround for OS/2 problem with deselecting all items in a listbox for
   // which the LS_EXTENDEDSEL style is set and the LS_MULTIPLESEL style is
   // not set.  By adding the LS_MULTIPLESEL style the deselection will take
   // place.
   if (isExtendedSelect()  &&  !isMultipleSelect())
   {
      enableMultipleSelect();
      deselectAll(); // DEFECT 20918 : recursive call to 
                     //   this method, "else" branch below.
      disableMultipleSelect();
   }
   else
#endif
   {
     IC_CLASSNAME::select( LIT_NONE, false );
   }
   return *this;
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::numberOfSelections                                             |
|                                                                              |
| Return the number of selected items in the list.                             |
------------------------------------------------------------------------------*/
unsigned long IC_CLASSNAME::numberOfSelections ( ) const
{
   unsigned long
     workSelect,
     selCount = 0;
   workSelect = LIT_FIRST;
#ifndef IC_USE_CB
   // For a multiple or extended selection IListBox, iterate through the
   // selected items.
   if ((style() & multipleSelect.asUnsignedLong())  ||
       ((style() & extendedSelect.asUnsignedLong())
            == extendedSelect.asUnsignedLong()) )
   {
      for ( ;
            (workSelect = handle().sendEvent(LM_QUERYSELECTION,
                                             IEventParameter1(workSelect),
                                             IEventParameter2(0)))
                                          != LIT_NONE;
            selCount++ )
      { }
   }
   else
#endif
   {
      IEventResult evt = handle().sendEvent(LM_QUERYSELECTION,
                                            IEventParameter1(workSelect),
                                            IEventParameter2(0));
      if (evt.asLong() != LIT_NONE)
         selCount = 1;
   }
   return selCount;
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::selection                                                      |
|                                                                              |
| Return the index of the first selected item (or LIT_NONE).                   |
------------------------------------------------------------------------------*/
long IC_CLASSNAME::selection ( ) const
{

   IEventResult evt = handle().sendEvent(LM_QUERYSELECTION,
                                         IEventParameter1(LIT_FIRST),
                                         IEventParameter2(0));
   return evt.asLong();
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::setTop                                                         |
|                                                                              |
| Scroll the list so the provided item is at the top.                          |
------------------------------------------------------------------------------*/
IC_CLASSNAME& IC_CLASSNAME::setTop ( unsigned long lIndex )
{
#if ((defined IC_WIN) && (defined IC_USE_CB))
// IC_NOTYET
#else
   handle().sendEvent(LM_SETTOPINDEX,
                      IEventParameter1(lIndex),
                      IEventParameter2(0));
#endif
   return *this;
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::top                                                            |
|                                                                              |
| Return the index of the item currently at the top of the visible list.       |
------------------------------------------------------------------------------*/
unsigned long IC_CLASSNAME::top ( ) const
{
#if ((defined IC_WIN) && (defined IC_USE_CB))
// IC_NOTYET
    return (0);
#else
   IEventResult evt = handle().sendEvent(LM_QUERYTOPINDEX,
                              IEventParameter1(0),
                              IEventParameter2(0));
   if (evt.asLong() == LIT_NONE)
      ITHROWGUIERROR("LM_QUERYTOPINDEX");
   return evt.asUnsignedLong();
#endif
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::setItemHandle                                                  |
|                                                                              |
| Set the handle of an item.                                                   |
------------------------------------------------------------------------------*/
IC_CLASSNAME& IC_CLASSNAME::setItemHandle ( unsigned long lIndex,
                                            unsigned long ulHandle )
{
   IEventResult evt = handle().sendEvent(LM_SETITEMHANDLE,
                                         IEventParameter1(lIndex),
                                         IEventParameter2(ulHandle));
   if (!(evt.asUnsignedLong()))
      ITHROWGUIERROR("LM_SETITEMHANDLE");
   return *this;
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::itemHandle                                                     |
|                                                                              |
| Return an item's handle.                                                     |
------------------------------------------------------------------------------*/
unsigned long IC_CLASSNAME::itemHandle ( unsigned long lIndex ) const
{
   IEventResult evt = handle().sendEvent(LM_QUERYITEMHANDLE,
                                         IEventParameter1(lIndex),
                                         IEventParameter2(0));
   return evt.asUnsignedLong();
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::locateText                                                     |
|                                                                              |
| Return the index of the item which matches the search string.  A search can  |
| be constrained with a case sensitivity flag, a check substring flag, and/or  |
| a starting index.                                                            |
------------------------------------------------------------------------------*/
unsigned long IC_CLASSNAME::locateText ( const char* pszSearchString,
                                         Boolean caseSensitive,
                                         SearchType search,
                                         unsigned long lIndex ) const
{
   unsigned long ulFindOptions = 0;
   if (lIndex == IC_CLASSNAME::first)
      lIndex = LIT_FIRST;
#ifndef IC_WIN
   if (caseSensitive)
      ulFindOptions |= LSS_CASESENSITIVE;
   switch (search)
   {
     case prefix:
          ulFindOptions |= LSS_PREFIX;
          break;
     case substring:
          ulFindOptions |= LSS_SUBSTRING;
          break;
     //Don't have to do anything for exactMatch, since it is the
     //OS/2 default if neither of the above two styles isn't set
   }
#endif
   IEventResult evt =
      handle().sendEvent(LM_SEARCHSTRING,
#ifdef IC_WIN
                         IEventParameter1(lIndex),
#else
                         IEventParameter1((unsigned short)ulFindOptions,
                                          (unsigned short)lIndex),
#endif
                         IEventParameter2((unsigned long)pszSearchString));
   switch (evt.asLong())
   {
#ifndef IC_WIN
      case LIT_ERROR:
         ITHROWGUIERROR("LM_SEARCHSTRING");
         break;
#endif
      case LIT_NONE:
         return IC_CLASSNAME::notFound;
      default:
         break;
   }
   return evt.asUnsignedLong();
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::count                                                          |
|                                                                              |
| Return the number of items in this list.                                     |
------------------------------------------------------------------------------*/
unsigned long IC_CLASSNAME::count ( ) const
{
   IEventResult evt = handle().sendEvent(LM_QUERYITEMCOUNT,
                                         IEventParameter1(0),
                                         IEventParameter2(0));
   return evt.asUnsignedLong();
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::Cursor :: Cursor                                               |
|                                                                              |
| Construct a cursor for the IComboBox or IListBox.                            |
------------------------------------------------------------------------------*/
IC_CLASSNAME::Cursor :: Cursor (
#ifdef IC_USE_CB
                                 const IBaseComboBox& rlb,
#else
                                 const IBaseListBox& rlb,
#endif
                                 Filter type )
  : rlbCl( rlb ),
    cursorTypeCl( type ),
    fCursorData( 0 )
{
  // The cursor is initially invalid until it is positioned.
  invalidate();
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::Cursor :: ~Cursor                                              |
|                                                                              |
| Empty destructor here for page tuning.                                       |
------------------------------------------------------------------------------*/
IC_CLASSNAME::Cursor :: ~Cursor() { }

/*------------------------------------------------------------------------------
| IC_CLASSNAME::Cursor :: setToFirst                                           |
|                                                                              |
| Position cursor to the first item in the list according to cursor type.      |
------------------------------------------------------------------------------*/
Boolean IC_CLASSNAME::Cursor :: setToFirst()
{
  Boolean bSuccess = false;

  if (!rlbCl.isEmpty())
  {
    if(cursorTypeCl==selectedItems)
    {
       IEventResult evt =
          rlbCl.handle().sendEvent(LM_QUERYSELECTION,
                                   IEventParameter1(LIT_FIRST),
                                   IEventParameter2(0));
       if (evt.asLong() != LIT_NONE)
       {
          lClCurrent = evt.asUnsignedLong();
          bSuccess = true;
          sameValidation = rlbCl.needValidation;
       }
    }
    else
    {
       lClCurrent = 0;
       bSuccess = true;
       sameValidation = rlbCl.needValidation;
    }
  }

  return bSuccess;
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::Cursor::setToNext                                              |
|                                                                              |
| Position cursor to the next item in the list according to cursor type.       |
------------------------------------------------------------------------------*/
Boolean IC_CLASSNAME::Cursor :: setToNext()
{
  Boolean bSuccess = false;

  if (isValid()  &&  (lClCurrent < (rlbCl.count() - 1)))
  {
     if (cursorTypeCl==selectedItems)
     {
        IEventResult evt =
           rlbCl.handle().sendEvent(LM_QUERYSELECTION,
                                    IEventParameter1(lClCurrent),
                                    IEventParameter2(0));
        if ((evt.asLong() != LIT_NONE)  &&
            (evt.asUnsignedLong() != lClCurrent))
        {
           lClCurrent = evt.asUnsignedLong();
           bSuccess = true;
        }
     }
     else
     {
        lClCurrent++;
        bSuccess = true;
     }
  }

  if (!bSuccess)
     invalidate();
  return bSuccess;
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::Cursor :: setToPrevious                                        |
|                                                                              |
| Position cursor to previous item in the list according to cursor type.       |
------------------------------------------------------------------------------*/
Boolean IC_CLASSNAME::Cursor :: setToPrevious ( )
{
  Boolean bSuccess = false;

  if (isValid()  &&  (lClCurrent>0))
  {
     if (cursorTypeCl == selectedItems)
     {
        long
          lLast  = -1,
          lFound = -1;
        IC_CLASSNAME::Cursor tempCurs(rlbCl,selectedItems);

        for (tempCurs.setToFirst();
             tempCurs.isValid()  &&  lFound == -1;
             tempCurs.setToNext())
        {
           if (tempCurs.asIndex() == asIndex())
           {
              lFound = lLast;
           }
           lLast = tempCurs.asIndex();
        }

        if (lFound != -1)
        {
           lClCurrent = lFound;
           bSuccess = true;
        }
     }
     else
     {
       lClCurrent--;
       bSuccess = true;
     }
  }

  if (!bSuccess)
     invalidate();
  return bSuccess;
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::Cursor :: setToLast                                            |
|                                                                              |
| Position cursor to the last item in the list according to cursor type.       |
------------------------------------------------------------------------------*/
Boolean IC_CLASSNAME::Cursor :: setToLast ( )
{
  Boolean bSuccess = false;

  if (!rlbCl.isEmpty())
  {
     if (cursorTypeCl == selectedItems)
     {
        long lLast = -1;
        IC_CLASSNAME::Cursor tempCurs(rlbCl,selectedItems);

        for (tempCurs.setToFirst();
             tempCurs.isValid();
             tempCurs.setToNext())
        {
           lLast = tempCurs.asIndex();
        }
        if (lLast != -1)
        {
           lClCurrent = lLast;
           bSuccess = true;
           sameValidation = rlbCl.needValidation;
        }
     }
     else
     {
        lClCurrent = rlbCl.count() - 1;
        bSuccess = true;
        sameValidation = rlbCl.needValidation;
     }
  }

  return bSuccess;
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::Cursor :: setToIndex                                           |
|                                                                              |
| Position cursor to specified index regardless of cursor type.                |
------------------------------------------------------------------------------*/
Boolean IC_CLASSNAME::Cursor :: setToIndex ( unsigned long lIndex )
{
  Boolean bSuccess = false;

  if (lIndex >= 0  &&  lIndex < rlbCl.count())
  {
     lClCurrent = lIndex;
     bSuccess = true;
     sameValidation = rlbCl.needValidation;
  }

  return bSuccess;
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::Cursor :: isValid                                              |
|                                                                              |
| Determine whether the cursor is valid.  The list's validation count must be  |
| equal to the cursor's current validation count.  For a selected item cursor, |
| the item it points to must be also be selected.                              |
------------------------------------------------------------------------------*/
Boolean IC_CLASSNAME::Cursor :: isValid ( ) const
{
  Boolean bValid = false;

  if (lClCurrent >= 0  &&
      lClCurrent < rlbCl.count()  &&
      lClCurrent != LIT_ERROR)
  {
     if (cursorTypeCl == selectedItems)
     {
        IEventResult evt =
           rlbCl.handle().sendEvent(LM_QUERYSELECTION,
                                    IEventParameter1(lClCurrent - 1),
                                    IEventParameter2(0));
        if ((evt.asUnsignedLong() == lClCurrent)  &&
            (sameValidation == rlbCl.needValidation))
           bValid = true;
     }
     else
     {
        if (sameValidation == rlbCl.needValidation)
           bValid = true;
     }
  }

  return bValid;
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::Cursor :: invalidate                                           |
------------------------------------------------------------------------------*/
void IC_CLASSNAME::Cursor :: invalidate ( )
{
  lClCurrent = LIT_ERROR;
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::Cursor :: asIndex                                              |
------------------------------------------------------------------------------*/
unsigned long IC_CLASSNAME::Cursor :: asIndex ( ) const
{
  return lClCurrent;
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::elementAt                                                      |
|                                                                              |
| Return the item string at the cursor's position.                             |
------------------------------------------------------------------------------*/
IString IC_CLASSNAME::elementAt ( const IC_CLASSNAME::Cursor& cursor ) const
{
  IString strRet;

  IASSERTSTATE(cursor.isValid());
  unsigned long ulIndex = cursor.asIndex();
  return itemText(ulIndex);
}

/*------------------------------------------------------------------------------
| IC_CLASSNAME::isEmpty                                                        |
------------------------------------------------------------------------------*/
Boolean IC_CLASSNAME::isEmpty ( ) const
{
  return (count() == 0);
}

unsigned long  IC_CLASSNAME :: changeCount ( ) const
{
  return needValidation;
}

void IC_CLASSNAME :: incrementChangeCount  ( )
{
  needValidation++;
}

